/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.IvParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.pkcs11.P11ECUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11Util;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.SunPKCS11;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.provider.DSAPrivateKey;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.Debug;
import sun.security.util.ECUtil;

final class FIPSKeyImporter {
    private static final Debug debug = Debug.getInstance("sunpkcs11");
    private static P11Key importerKey = null;
    private static final ReentrantLock importerKeyLock = new ReentrantLock();
    private static CK_MECHANISM importerKeyMechanism = null;
    private static Cipher importerCipher = null;
    private static Provider sunECProvider = null;
    private static final ReentrantLock sunECProviderLock = new ReentrantLock();
    private static KeyFactory DHKF = null;
    private static final ReentrantLock DHKFLock = new ReentrantLock();

    FIPSKeyImporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Long importKey(SunPKCS11 sunPKCS11, long hSession, CK_ATTRIBUTE[] attributes) throws PKCS11Exception {
        Token token;
        long keyID;
        block40: {
            keyID = -1L;
            token = sunPKCS11.getToken();
            if (debug != null) {
                debug.println("Private or Secret key will be imported in system FIPS mode.");
            }
            if (importerKey == null) {
                importerKeyLock.lock();
                try {
                    if (importerKey != null) break block40;
                    if (importerKeyMechanism == null) {
                        FIPSKeyImporter.createImporterKey(token);
                    }
                    if (importerKey == null || importerCipher == null) {
                        if (debug == null) throw new PKCS11Exception(5L);
                        debug.println("Importer Key could not be generated.");
                        throw new PKCS11Exception(5L);
                    }
                    if (debug != null) {
                        debug.println("Importer Key successfully generated.");
                    }
                }
                finally {
                    importerKeyLock.unlock();
                }
            }
        }
        long importerKeyID = importerKey.getKeyID();
        try {
            HashMap<Long, CK_ATTRIBUTE> attrsMap;
            long keyType;
            long keyClass;
            byte[] encKeyBytes;
            byte[] keyBytes;
            block45: {
                block43: {
                    BigInteger v;
                    block46: {
                        block44: {
                            keyBytes = null;
                            encKeyBytes = null;
                            keyClass = 0L;
                            keyType = 0L;
                            attrsMap = new HashMap<Long, CK_ATTRIBUTE>();
                            for (CK_ATTRIBUTE attr : attributes) {
                                if (attr.type == 0L) {
                                    keyClass = attr.getLong();
                                } else if (attr.type == 256L) {
                                    keyType = attr.getLong();
                                }
                                attrsMap.put(attr.type, attr);
                            }
                            v = null;
                            if (keyClass != 3L) break block43;
                            if (keyType != 0L) break block44;
                            if (debug != null) {
                                debug.println("Importing an RSA private key...");
                            }
                            BigInteger bigInteger = (v = ((CK_ATTRIBUTE)attrsMap.get(288L)).getBigInteger()) != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(290L)).getBigInteger();
                            BigInteger bigInteger2 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(291L)).getBigInteger();
                            BigInteger bigInteger3 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(292L)).getBigInteger();
                            BigInteger bigInteger4 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(293L)).getBigInteger();
                            BigInteger bigInteger5 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(294L)).getBigInteger();
                            BigInteger bigInteger6 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(295L)).getBigInteger();
                            BigInteger bigInteger7 = v != null ? v : BigInteger.ZERO;
                            v = ((CK_ATTRIBUTE)attrsMap.get(296L)).getBigInteger();
                            keyBytes = RSAPrivateCrtKeyImpl.newKey(RSAUtil.KeyType.RSA, null, bigInteger, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, v != null ? v : BigInteger.ZERO).getEncoded();
                            break block45;
                        }
                        if (keyType != 1L) break block46;
                        if (debug != null) {
                            debug.println("Importing a DSA private key...");
                        }
                        BigInteger bigInteger = (v = ((CK_ATTRIBUTE)attrsMap.get(17L)).getBigInteger()) != null ? v : BigInteger.ZERO;
                        v = ((CK_ATTRIBUTE)attrsMap.get(304L)).getBigInteger();
                        BigInteger bigInteger8 = v != null ? v : BigInteger.ZERO;
                        v = ((CK_ATTRIBUTE)attrsMap.get(305L)).getBigInteger();
                        BigInteger bigInteger9 = v != null ? v : BigInteger.ZERO;
                        v = ((CK_ATTRIBUTE)attrsMap.get(306L)).getBigInteger();
                        keyBytes = new DSAPrivateKey(bigInteger, bigInteger8, bigInteger9, v != null ? v : BigInteger.ZERO).getEncoded();
                        if (token.config.getNssNetscapeDbWorkaround() && attrsMap.get(3584088832L) == null) {
                            attrsMap.put(3584088832L, new CK_ATTRIBUTE(3584088832L, BigInteger.ZERO));
                        }
                        break block45;
                    }
                    if (keyType == 3L) {
                        if (debug != null) {
                            debug.println("Importing an EC private key...");
                        }
                        if (sunECProvider == null) {
                            sunECProviderLock.lock();
                            try {
                                if (sunECProvider == null) {
                                    sunECProvider = Security.getProvider("SunEC");
                                }
                            }
                            finally {
                                sunECProviderLock.unlock();
                            }
                        }
                        keyBytes = P11ECUtil.generateECPrivateKey((v = ((CK_ATTRIBUTE)attrsMap.get(17L)).getBigInteger()) != null ? v : BigInteger.ZERO, ECUtil.getECParameterSpec(sunECProvider, ((CK_ATTRIBUTE)attrsMap.get(384L)).getByteArray())).getEncoded();
                        if (token.config.getNssNetscapeDbWorkaround() && attrsMap.get(3584088832L) == null) {
                            attrsMap.put(3584088832L, new CK_ATTRIBUTE(3584088832L, BigInteger.ZERO));
                        }
                        break block45;
                    } else {
                        if (keyType != 2L) {
                            if (debug == null) throw new PKCS11Exception(5L);
                            debug.println("Unrecognized private key type.");
                            throw new PKCS11Exception(5L);
                        }
                        if (debug != null) {
                            debug.println("Importing a Diffie-Hellman private key...");
                        }
                        if (DHKF == null) {
                            DHKFLock.lock();
                            try {
                                if (DHKF == null) {
                                    DHKF = KeyFactory.getInstance("DH", P11Util.getSunJceProvider());
                                }
                            }
                            finally {
                                DHKFLock.unlock();
                            }
                        }
                        BigInteger bigInteger = (v = ((CK_ATTRIBUTE)attrsMap.get(17L)).getBigInteger()) != null ? v : BigInteger.ZERO;
                        v = ((CK_ATTRIBUTE)attrsMap.get(304L)).getBigInteger();
                        BigInteger bigInteger10 = v != null ? v : BigInteger.ZERO;
                        v = ((CK_ATTRIBUTE)attrsMap.get(306L)).getBigInteger();
                        DHPrivateKeySpec spec = new DHPrivateKeySpec(bigInteger, bigInteger10, v != null ? v : BigInteger.ZERO);
                        keyBytes = DHKF.generatePrivate(spec).getEncoded();
                        if (token.config.getNssNetscapeDbWorkaround() && attrsMap.get(3584088832L) == null) {
                            attrsMap.put(3584088832L, new CK_ATTRIBUTE(3584088832L, BigInteger.ZERO));
                        }
                    }
                    break block45;
                }
                if (keyClass == 4L) {
                    if (debug != null) {
                        debug.println("Importing a secret key...");
                    }
                    keyBytes = ((CK_ATTRIBUTE)attrsMap.get(17L)).getByteArray();
                }
            }
            if (keyBytes == null || keyBytes.length == 0) {
                if (debug == null) throw new PKCS11Exception(5L);
                debug.println("Private or secret key plain bytes could not be obtained. Import failed.");
                throw new PKCS11Exception(5L);
            }
            importerCipher.init(1, (Key)importerKey, new IvParameterSpec((byte[])FIPSKeyImporter.importerKeyMechanism.pParameter), null);
            attributes = new CK_ATTRIBUTE[attrsMap.size()];
            attrsMap.values().toArray(attributes);
            encKeyBytes = importerCipher.doFinal(keyBytes);
            attributes = token.getAttributes("import", keyClass, keyType, attributes);
            keyID = token.p11.C_UnwrapKey(hSession, importerKeyMechanism, importerKeyID, encKeyBytes, attributes);
            if (debug == null) return keyID;
            debug.println("Imported key ID: " + keyID);
            return keyID;
        }
        catch (Throwable t) {
            throw new PKCS11Exception(5L);
        }
        finally {
            importerKey.releaseKeyID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createImporterKey(Token token) {
        if (debug != null) {
            debug.println("Generating Importer Key...");
        }
        byte[] iv = new byte[16];
        JCAUtil.getSecureRandom().nextBytes(iv);
        importerKeyMechanism = new CK_MECHANISM(4229L, iv);
        try {
            CK_ATTRIBUTE[] attributes = token.getAttributes("generate", 4L, 31L, new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(353L, 32L)});
            Session s = null;
            try {
                s = token.getObjSession();
                long keyID = token.p11.C_GenerateKey(s.id(), new CK_MECHANISM(4224L), attributes);
                if (debug != null) {
                    debug.println("Importer Key ID: " + keyID);
                }
                importerKey = (P11Key)((Object)P11Key.secretKey(s, keyID, "AES", 32, null));
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                token.releaseSession(s);
            }
            if (importerKey != null) {
                importerCipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            }
        }
        catch (Throwable t) {
            importerKey = null;
            importerCipher = null;
        }
    }
}

