/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import sun.security.pkcs11.P11ECUtil;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

final class P11ECKeyFactory
extends P11KeyFactory {
    private static Provider sunECprovider;

    private static Provider getSunECProvider() {
        if (sunECprovider == null && (sunECprovider = Security.getProvider("SunEC")) == null) {
            throw new RuntimeException("Cannot load SunEC provider");
        }
        return sunECprovider;
    }

    P11ECKeyFactory(Token token, String algorithm) {
        super(token, algorithm);
    }

    static ECParameterSpec getECParameterSpec(String name) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), name);
    }

    static ECParameterSpec getECParameterSpec(int keySize) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), keySize);
    }

    static ECParameterSpec getECParameterSpec(ECParameterSpec spec) {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), spec);
    }

    static ECParameterSpec decodeParameters(byte[] params) throws IOException {
        return ECUtil.getECParameterSpec(P11ECKeyFactory.getSunECProvider(), params);
    }

    static byte[] encodeParameters(ECParameterSpec params) {
        return ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), params);
    }

    static ECPoint decodePoint(byte[] encoded, EllipticCurve curve) throws IOException {
        return ECUtil.decodePoint(encoded, curve);
    }

    static byte[] getEncodedPublicValue(PublicKey key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECPublicKey ecKey = (ECPublicKey)key;
            ECPoint w = ecKey.getW();
            ECParameterSpec params = ecKey.getParams();
            return ECUtil.encodePoint(w, params.getCurve());
        }
        throw new InvalidKeyException("Key class not yet supported: " + key.getClass().getName());
    }

    @Override
    PublicKey implTranslatePublicKey(PublicKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPublicKey) {
                ECPublicKey ecKey = (ECPublicKey)key;
                return this.generatePublic(ecKey.getW(), ecKey.getParams());
            }
            if ("X.509".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                try {
                    key = P11ECUtil.decodeX509ECPublicKey(encoded);
                }
                catch (InvalidKeySpecException ikse) {
                    throw new InvalidKeyException(ikse);
                }
                return this.implTranslatePublicKey(key);
            }
            throw new InvalidKeyException("PublicKey must be instance of ECPublicKey or have X.509 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC public key", e);
        }
    }

    @Override
    PrivateKey implTranslatePrivateKey(PrivateKey key) throws InvalidKeyException {
        try {
            if (key instanceof ECPrivateKey) {
                ECPrivateKey ecKey = (ECPrivateKey)key;
                return this.generatePrivate(ecKey.getS(), ecKey.getParams());
            }
            if ("PKCS#8".equals(key.getFormat())) {
                byte[] encoded = key.getEncoded();
                try {
                    key = P11ECUtil.decodePKCS8ECPrivateKey(encoded);
                }
                catch (InvalidKeySpecException ikse) {
                    throw new InvalidKeyException(ikse);
                }
                return this.implTranslatePrivateKey(key);
            }
            throw new InvalidKeyException("PrivateKey must be instance of ECPrivateKey or have PKCS#8 encoding");
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("Could not create EC private key", e);
        }
    }

    @Override
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                byte[] encoded = ((X509EncodedKeySpec)keySpec).getEncoded();
                ECPublicKey key = P11ECUtil.decodeX509ECPublicKey(encoded);
                return this.implTranslatePublicKey(key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException("Could not create EC public key", e);
            }
        }
        if (!(keySpec instanceof ECPublicKeySpec)) {
            throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
        }
        try {
            ECPublicKeySpec ec = (ECPublicKeySpec)keySpec;
            return this.generatePublic(ec.getW(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC public key", e);
        }
    }

    @Override
    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                byte[] encoded = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
                ECPrivateKey key = P11ECUtil.decodePKCS8ECPrivateKey(encoded);
                return this.implTranslatePrivateKey(key);
            }
            catch (GeneralSecurityException e) {
                throw new InvalidKeySpecException("Could not create EC private key", e);
            }
        }
        if (!(keySpec instanceof ECPrivateKeySpec)) {
            throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
        }
        try {
            ECPrivateKeySpec ec = (ECPrivateKeySpec)keySpec;
            return this.generatePrivate(ec.getS(), ec.getParams());
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeySpecException("Could not create EC private key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey generatePublic(ECPoint point, ECParameterSpec params) throws PKCS11Exception {
        byte[] encodedParams = ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), params);
        byte[] encodedPoint = ECUtil.encodePoint(point, params.getCurve());
        if (!this.token.config.getUseEcX963Encoding()) {
            try {
                encodedPoint = new DerValue(4, encodedPoint).toByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not DER encode point", e);
            }
        }
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 2L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(385L, encodedPoint), new CK_ATTRIBUTE(384L, encodedParams)};
        attributes = this.token.getAttributes("import", 2L, 3L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PublicKey publicKey = P11Key.publicKey(session, keyID, "EC", params.getCurve().getField().getFieldSize(), attributes);
            return publicKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey generatePrivate(BigInteger s, ECParameterSpec params) throws PKCS11Exception {
        byte[] encodedParams = ECUtil.encodeECParameterSpec(P11ECKeyFactory.getSunECProvider(), params);
        CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 3L), new CK_ATTRIBUTE(17L, s), new CK_ATTRIBUTE(384L, encodedParams)};
        attributes = this.token.getAttributes("import", 3L, 3L, attributes);
        Session session = null;
        try {
            session = this.token.getObjSession();
            long keyID = this.token.p11.C_CreateObject(session.id(), attributes);
            PrivateKey privateKey = P11Key.privateKey(session, keyID, "EC", params.getCurve().getField().getFieldSize(), attributes);
            return privateKey;
        }
        finally {
            this.token.releaseSession(session);
        }
    }

    @Override
    <T extends KeySpec> T implGetPublicKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (keySpec.isAssignableFrom(ECPublicKeySpec.class)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(385L), new CK_ATTRIBUTE(384L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
                ECParameterSpec params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
                ECPoint point = !this.token.config.getUseEcX963Encoding() ? P11ECKeyFactory.decodePoint(new DerValue(attributes[0].getByteArray()).getOctetString(), params.getCurve()) : P11ECKeyFactory.decodePoint(attributes[0].getByteArray(), params.getCurve());
                KeySpec keySpec2 = (KeySpec)keySpec.cast(new ECPublicKeySpec(point, params));
                return (T)keySpec2;
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("Could not parse key", e);
            }
            finally {
                key.releaseKeyID();
            }
        }
        throw new InvalidKeySpecException("Only ECPublicKeySpec and X509EncodedKeySpec supported for EC public keys");
    }

    @Override
    <T extends KeySpec> T implGetPrivateKeySpec(P11Key key, Class<T> keySpec, Session[] session) throws PKCS11Exception, InvalidKeySpecException {
        if (keySpec.isAssignableFrom(ECPrivateKeySpec.class)) {
            session[0] = this.token.getObjSession();
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(384L)};
            long keyID = key.getKeyID();
            try {
                this.token.p11.C_GetAttributeValue(session[0].id(), keyID, attributes);
                ECParameterSpec params = P11ECKeyFactory.decodeParameters(attributes[1].getByteArray());
                KeySpec keySpec2 = (KeySpec)keySpec.cast(new ECPrivateKeySpec(attributes[0].getBigInteger(), params));
                return (T)keySpec2;
            }
            catch (IOException e) {
                throw new InvalidKeySpecException("Could not parse key", e);
            }
            finally {
                key.releaseKeyID();
            }
        }
        throw new InvalidKeySpecException("Only ECPrivateKeySpec and PKCS8EncodedKeySpec supported for EC private keys");
    }

    @Override
    KeyFactory implGetSoftwareFactory() throws GeneralSecurityException {
        return KeyFactory.getInstance("EC", P11ECKeyFactory.getSunECProvider());
    }
}

