/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11.wrapper;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import sun.security.pkcs11.wrapper.CK_DATE;

public class Functions {
    private static final Map<Integer, String> mechNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> mechIds = new HashMap<String, Integer>();
    private static final Map<String, Long> hashMechIds = new HashMap<String, Long>();
    private static final Map<Integer, String> keyNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> keyIds = new HashMap<String, Integer>();
    private static final Map<Integer, String> attributeNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> attributeIds = new HashMap<String, Integer>();
    private static final Map<Integer, String> objectClassNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> objectClassIds = new HashMap<String, Integer>();
    private static final Map<Integer, String> mgfNames = new HashMap<Integer, String>();
    private static final Map<String, Integer> mgfIds = new HashMap<String, Integer>();
    private static final char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private static final Flags slotInfoFlags = new Flags(new long[]{1L, 2L, 4L}, new String[]{"CKF_TOKEN_PRESENT", "CKF_REMOVABLE_DEVICE", "CKF_HW_SLOT"});
    private static final Flags tokenInfoFlags = new Flags(new long[]{1L, 2L, 4L, 8L, 32L, 64L, 256L, 512L, 1024L, 2048L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L}, new String[]{"CKF_RNG", "CKF_WRITE_PROTECTED", "CKF_LOGIN_REQUIRED", "CKF_USER_PIN_INITIALIZED", "CKF_RESTORE_KEY_NOT_NEEDED", "CKF_CLOCK_ON_TOKEN", "CKF_PROTECTED_AUTHENTICATION_PATH", "CKF_DUAL_CRYPTO_OPERATIONS", "CKF_TOKEN_INITIALIZED", "CKF_SECONDARY_AUTHENTICATION", "CKF_USER_PIN_COUNT_LOW", "CKF_USER_PIN_FINAL_TRY", "CKF_USER_PIN_LOCKED", "CKF_USER_PIN_TO_BE_CHANGED", "CKF_SO_PIN_COUNT_LOW", "CKF_SO_PIN_FINAL_TRY", "CKF_SO_PIN_LOCKED", "CKF_SO_PIN_TO_BE_CHANGED"});
    private static final Flags sessionInfoFlags = new Flags(new long[]{2L, 4L}, new String[]{"CKF_RW_SESSION", "CKF_SERIAL_SESSION"});
    private static final Flags mechanismInfoFlags = new Flags(new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x400000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x80000000L}, new String[]{"CKF_HW", "CKF_MESSAGE_ENCRYPT", "CKF_MESSAGE_DECRYPT", "CKF_MESSAGE_SIGN", "CKF_MESSAGE_VERIFY", "CKF_MULTI_MESSAGE", "CKF_FIND_OBJECTS", "CKF_ENCRYPT", "CKF_DECRYPT", "CKF_DIGEST", "CKF_SIGN", "CKF_SIGN_RECOVER", "CKF_VERIFY", "CKF_VERIFY_RECOVER", "CKF_GENERATE", "CKF_GENERATE_KEY_PAIR", "CKF_WRAP", "CKF_UNWRAP", "CKF_DERIVE", "CKF_EC_F_P", "CKF_EC_F_2M", "CKF_EC_ECPARAMETERS", "CKF_EC_OID", "CKF_EC_UNCOMPRESS", "CKF_EC_COMPRESS", "CKF_EC_CURVENAME", "CKF_EXTENSION"});

    public static String toFullHexString(long value) {
        long currentValue = value;
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int j = 0; j < 16; ++j) {
            int currentDigit = (int)currentValue & 0xF;
            stringBuffer.append(HEX_DIGITS[currentDigit]);
            currentValue >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toFullHexString(int value) {
        int currentValue = value;
        StringBuffer stringBuffer = new StringBuffer(8);
        for (int i = 0; i < 8; ++i) {
            int currentDigit = currentValue & 0xF;
            stringBuffer.append(HEX_DIGITS[currentDigit]);
            currentValue >>>= 4;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHexString(long value) {
        return Long.toHexString(value);
    }

    public static String toHexString(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(2 * value.length);
        for (int i = 0; i < value.length; ++i) {
            int single = value[i] & 0xFF;
            if (single < 16) {
                buffer.append('0');
            }
            buffer.append(Integer.toString(single, 16));
        }
        return buffer.toString();
    }

    public static String toBinaryString(long value) {
        return Long.toString(value, 2);
    }

    public static String toBinaryString(byte[] value) {
        BigInteger helpBigInteger = new BigInteger(1, value);
        return helpBigInteger.toString(2);
    }

    public static String slotInfoFlagsToString(long flags) {
        return slotInfoFlags.toString(flags);
    }

    public static String tokenInfoFlagsToString(long flags) {
        return tokenInfoFlags.toString(flags);
    }

    public static String sessionInfoFlagsToString(long flags) {
        return sessionInfoFlags.toString(flags);
    }

    public static String sessionStateToString(long state) {
        String name = state == 0L ? "CKS_RO_PUBLIC_SESSION" : (state == 1L ? "CKS_RO_USER_FUNCTIONS" : (state == 2L ? "CKS_RW_PUBLIC_SESSION" : (state == 3L ? "CKS_RW_USER_FUNCTIONS" : (state == 4L ? "CKS_RW_SO_FUNCTIONS" : "ERROR: unknown session state 0x" + Functions.toFullHexString(state)))));
        return name;
    }

    public static String mechanismInfoFlagsToString(long flags) {
        return mechanismInfoFlags.toString(flags);
    }

    private static String getName(Map<Integer, String> nameMap, long id) {
        String name = null;
        if (id >>> 32 == 0L) {
            name = nameMap.get((int)id);
        }
        if (name == null) {
            name = (id & 0x80000000L) != 0L ? "(Vendor-Specific) 0x" + Functions.toFullHexString(id) : "(Unknown) 0x" + Functions.toFullHexString(id);
        }
        return name;
    }

    public static long getId(Map<String, Integer> idMap, String name) {
        Integer mech = idMap.get(name);
        if (mech == null) {
            throw new IllegalArgumentException("Unknown name " + name);
        }
        return (long)mech.intValue() & 0xFFFFFFFFL;
    }

    public static String getMechanismName(long id) {
        return Functions.getName(mechNames, id);
    }

    public static long getMechanismId(String name) {
        return Functions.getId(mechIds, name);
    }

    public static String getKeyName(long id) {
        return Functions.getName(keyNames, id);
    }

    public static long getKeyId(String name) {
        return Functions.getId(keyIds, name);
    }

    public static String getAttributeName(long id) {
        return Functions.getName(attributeNames, id);
    }

    public static long getAttributeId(String name) {
        return Functions.getId(attributeIds, name);
    }

    public static String getObjectClassName(long id) {
        return Functions.getName(objectClassNames, id);
    }

    public static long getObjectClassId(String name) {
        return Functions.getId(objectClassIds, name);
    }

    public static long getHashMechId(String name) {
        return hashMechIds.get(name);
    }

    public static String getMGFName(long id) {
        return Functions.getName(mgfNames, id);
    }

    public static long getMGFId(String name) {
        return Functions.getId(mgfIds, name);
    }

    private static boolean equals(char[] array1, char[] array2) {
        return Arrays.equals(array1, array2);
    }

    public static boolean equals(CK_DATE date1, CK_DATE date2) {
        boolean equal = false;
        equal = date1 == date2 ? true : (date1 != null && date2 != null ? Functions.equals(date1.year, date2.year) && Functions.equals(date1.month, date2.month) && Functions.equals(date1.day, date2.day) : false);
        return equal;
    }

    public static int hashCode(byte[] array) {
        int hash = 0;
        if (array != null) {
            for (int i = 0; i < 4 && i < array.length; ++i) {
                hash ^= (0xFF & array[i]) << (i % 4 << 3);
            }
        }
        return hash;
    }

    public static int hashCode(char[] array) {
        int hash = 0;
        if (array != null) {
            for (int i = 0; i < 4 && i < array.length; ++i) {
                hash ^= (0xFFFF & array[i]) << (i % 2 << 4);
            }
        }
        return hash;
    }

    public static int hashCode(CK_DATE date) {
        int hash = 0;
        if (date != null) {
            if (date.year.length == 4) {
                hash ^= (0xFFFF & date.year[0]) << 16;
                hash ^= 0xFFFF & date.year[1];
                hash ^= (0xFFFF & date.year[2]) << 16;
                hash ^= 0xFFFF & date.year[3];
            }
            if (date.month.length == 2) {
                hash ^= (0xFFFF & date.month[0]) << 16;
                hash ^= 0xFFFF & date.month[1];
            }
            if (date.day.length == 2) {
                hash ^= (0xFFFF & date.day[0]) << 16;
                hash ^= 0xFFFF & date.day[1];
            }
        }
        return hash;
    }

    private static void addMapping(Map<Integer, String> nameMap, Map<String, Integer> idMap, long id, String name) {
        if (id >>> 32 != 0L) {
            throw new AssertionError((Object)("Id has high bits set: " + id + ", " + name));
        }
        Integer intId = (int)id;
        if (nameMap.put(intId, name) != null) {
            throw new AssertionError((Object)("Duplicate id: " + id + ", " + name));
        }
        if (idMap.put(name, intId) != null) {
            throw new AssertionError((Object)("Duplicate name: " + id + ", " + name));
        }
    }

    private static void addMech(long id, String name) {
        Functions.addMapping(mechNames, mechIds, id, name);
    }

    private static void addKeyType(long id, String name) {
        Functions.addMapping(keyNames, keyIds, id, name);
    }

    private static void addAttribute(long id, String name) {
        Functions.addMapping(attributeNames, attributeIds, id, name);
    }

    private static void addObjectClass(long id, String name) {
        Functions.addMapping(objectClassNames, objectClassIds, id, name);
    }

    private static void addHashMech(long id, String ... names) {
        for (String n : names) {
            hashMechIds.put(n, id);
        }
    }

    private static void addMGF(long id, String name) {
        Functions.addMapping(mgfNames, mgfIds, id, name);
    }

    static {
        Functions.addMech(0L, "CKM_RSA_PKCS_KEY_PAIR_GEN");
        Functions.addMech(1L, "CKM_RSA_PKCS");
        Functions.addMech(2L, "CKM_RSA_9796");
        Functions.addMech(3L, "CKM_RSA_X_509");
        Functions.addMech(4L, "CKM_MD2_RSA_PKCS");
        Functions.addMech(5L, "CKM_MD5_RSA_PKCS");
        Functions.addMech(6L, "CKM_SHA1_RSA_PKCS");
        Functions.addMech(7L, "CKM_RIPEMD128_RSA_PKCS");
        Functions.addMech(8L, "CKM_RIPEMD160_RSA_PKCS");
        Functions.addMech(9L, "CKM_RSA_PKCS_OAEP");
        Functions.addMech(10L, "CKM_RSA_X9_31_KEY_PAIR_GEN");
        Functions.addMech(11L, "CKM_RSA_X9_31");
        Functions.addMech(12L, "CKM_SHA1_RSA_X9_31");
        Functions.addMech(13L, "CKM_RSA_PKCS_PSS");
        Functions.addMech(14L, "CKM_SHA1_RSA_PKCS_PSS");
        Functions.addMech(16L, "CKM_DSA_KEY_PAIR_GEN");
        Functions.addMech(17L, "CKM_DSA");
        Functions.addMech(18L, "CKM_DSA_SHA1");
        Functions.addMech(19L, "CKM_DSA_SHA224");
        Functions.addMech(20L, "CKM_DSA_SHA256");
        Functions.addMech(21L, "CKM_DSA_SHA384");
        Functions.addMech(22L, "CKM_DSA_SHA512");
        Functions.addMech(24L, "CKM_DSA_SHA3_224");
        Functions.addMech(25L, "CKM_DSA_SHA3_256");
        Functions.addMech(26L, "CKM_DSA_SHA3_384");
        Functions.addMech(27L, "CKM_DSA_SHA3_512");
        Functions.addMech(32L, "CKM_DH_PKCS_KEY_PAIR_GEN");
        Functions.addMech(33L, "CKM_DH_PKCS_DERIVE");
        Functions.addMech(48L, "CKM_X9_42_DH_KEY_PAIR_GEN");
        Functions.addMech(49L, "CKM_X9_42_DH_DERIVE");
        Functions.addMech(50L, "CKM_X9_42_DH_HYBRID_DERIVE");
        Functions.addMech(51L, "CKM_X9_42_MQV_DERIVE");
        Functions.addMech(64L, "CKM_SHA256_RSA_PKCS");
        Functions.addMech(65L, "CKM_SHA384_RSA_PKCS");
        Functions.addMech(66L, "CKM_SHA512_RSA_PKCS");
        Functions.addMech(67L, "CKM_SHA256_RSA_PKCS_PSS");
        Functions.addMech(68L, "CKM_SHA384_RSA_PKCS_PSS");
        Functions.addMech(69L, "CKM_SHA512_RSA_PKCS_PSS");
        Functions.addMech(70L, "CKM_SHA224_RSA_PKCS");
        Functions.addMech(71L, "CKM_SHA224_RSA_PKCS_PSS");
        Functions.addMech(72L, "CKM_SHA512_224");
        Functions.addMech(73L, "CKM_SHA512_224_HMAC");
        Functions.addMech(74L, "CKM_SHA512_224_HMAC_GENERAL");
        Functions.addMech(75L, "CKM_SHA512_224_KEY_DERIVATION");
        Functions.addMech(76L, "CKM_SHA512_256");
        Functions.addMech(77L, "CKM_SHA512_256_HMAC");
        Functions.addMech(78L, "CKM_SHA512_256_HMAC_GENERAL");
        Functions.addMech(79L, "CKM_SHA512_256_KEY_DERIVATION");
        Functions.addMech(80L, "CKM_SHA512_T");
        Functions.addMech(81L, "CKM_SHA512_T_HMAC");
        Functions.addMech(82L, "CKM_SHA512_T_HMAC_GENERAL");
        Functions.addMech(83L, "CKM_SHA512_T_KEY_DERIVATION");
        Functions.addMech(96L, "CKM_SHA3_256_RSA_PKCS");
        Functions.addMech(97L, "CKM_SHA3_384_RSA_PKCS");
        Functions.addMech(98L, "CKM_SHA3_512_RSA_PKCS");
        Functions.addMech(99L, "CKM_SHA3_256_RSA_PKCS_PSS");
        Functions.addMech(100L, "CKM_SHA3_384_RSA_PKCS_PSS");
        Functions.addMech(101L, "CKM_SHA3_512_RSA_PKCS_PSS");
        Functions.addMech(102L, "CKM_SHA3_224_RSA_PKCS");
        Functions.addMech(103L, "CKM_SHA3_224_RSA_PKCS_PSS");
        Functions.addMech(256L, "CKM_RC2_KEY_GEN");
        Functions.addMech(257L, "CKM_RC2_ECB");
        Functions.addMech(258L, "CKM_RC2_CBC");
        Functions.addMech(259L, "CKM_RC2_MAC");
        Functions.addMech(260L, "CKM_RC2_MAC_GENERAL");
        Functions.addMech(261L, "CKM_RC2_CBC_PAD");
        Functions.addMech(272L, "CKM_RC4_KEY_GEN");
        Functions.addMech(273L, "CKM_RC4");
        Functions.addMech(288L, "CKM_DES_KEY_GEN");
        Functions.addMech(289L, "CKM_DES_ECB");
        Functions.addMech(290L, "CKM_DES_CBC");
        Functions.addMech(291L, "CKM_DES_MAC");
        Functions.addMech(292L, "CKM_DES_MAC_GENERAL");
        Functions.addMech(293L, "CKM_DES_CBC_PAD");
        Functions.addMech(304L, "CKM_DES2_KEY_GEN");
        Functions.addMech(305L, "CKM_DES3_KEY_GEN");
        Functions.addMech(306L, "CKM_DES3_ECB");
        Functions.addMech(307L, "CKM_DES3_CBC");
        Functions.addMech(308L, "CKM_DES3_MAC");
        Functions.addMech(309L, "CKM_DES3_MAC_GENERAL");
        Functions.addMech(310L, "CKM_DES3_CBC_PAD");
        Functions.addMech(311L, "CKM_DES3_CMAC_GENERAL");
        Functions.addMech(312L, "CKM_DES3_CMAC");
        Functions.addMech(320L, "CKM_CDMF_KEY_GEN");
        Functions.addMech(321L, "CKM_CDMF_ECB");
        Functions.addMech(322L, "CKM_CDMF_CBC");
        Functions.addMech(323L, "CKM_CDMF_MAC");
        Functions.addMech(324L, "CKM_CDMF_MAC_GENERAL");
        Functions.addMech(325L, "CKM_CDMF_CBC_PAD");
        Functions.addMech(336L, "CKM_DES_OFB64");
        Functions.addMech(337L, "CKM_DES_OFB8");
        Functions.addMech(338L, "CKM_DES_CFB64");
        Functions.addMech(339L, "CKM_DES_CFB8");
        Functions.addMech(512L, "CKM_MD2");
        Functions.addMech(513L, "CKM_MD2_HMAC");
        Functions.addMech(514L, "CKM_MD2_HMAC_GENERAL");
        Functions.addMech(528L, "CKM_MD5");
        Functions.addMech(529L, "CKM_MD5_HMAC");
        Functions.addMech(530L, "CKM_MD5_HMAC_GENERAL");
        Functions.addMech(544L, "CKM_SHA_1");
        Functions.addMech(545L, "CKM_SHA_1_HMAC");
        Functions.addMech(546L, "CKM_SHA_1_HMAC_GENERAL");
        Functions.addMech(560L, "CKM_RIPEMD128");
        Functions.addMech(561L, "CKM_RIPEMD128_HMAC");
        Functions.addMech(562L, "CKM_RIPEMD128_HMAC_GENERAL");
        Functions.addMech(576L, "CKM_RIPEMD160");
        Functions.addMech(577L, "CKM_RIPEMD160_HMAC");
        Functions.addMech(578L, "CKM_RIPEMD160_HMAC_GENERAL");
        Functions.addMech(592L, "CKM_SHA256");
        Functions.addMech(593L, "CKM_SHA256_HMAC");
        Functions.addMech(594L, "CKM_SHA256_HMAC_GENERAL");
        Functions.addMech(597L, "CKM_SHA224");
        Functions.addMech(598L, "CKM_SHA224_HMAC");
        Functions.addMech(599L, "CKM_SHA224_HMAC_GENERAL");
        Functions.addMech(608L, "CKM_SHA384");
        Functions.addMech(609L, "CKM_SHA384_HMAC");
        Functions.addMech(610L, "CKM_SHA384_HMAC_GENERAL");
        Functions.addMech(624L, "CKM_SHA512");
        Functions.addMech(625L, "CKM_SHA512_HMAC");
        Functions.addMech(626L, "CKM_SHA512_HMAC_GENERAL");
        Functions.addMech(640L, "CKM_SECURID_KEY_GEN");
        Functions.addMech(642L, "CKM_SECURID");
        Functions.addMech(656L, "CKM_HOTP_KEY_GEN");
        Functions.addMech(657L, "CKM_HOTP");
        Functions.addMech(672L, "CKM_ACTI");
        Functions.addMech(673L, "CKM_ACTI_KEY_GEN");
        Functions.addMech(688L, "CKM_SHA3_256");
        Functions.addMech(689L, "CKM_SHA3_256_HMAC");
        Functions.addMech(690L, "CKM_SHA3_256_HMAC_GENERAL");
        Functions.addMech(691L, "CKM_SHA3_256_KEY_GEN");
        Functions.addMech(693L, "CKM_SHA3_224");
        Functions.addMech(694L, "CKM_SHA3_224_HMAC");
        Functions.addMech(695L, "CKM_SHA3_224_HMAC_GENERAL");
        Functions.addMech(696L, "CKM_SHA3_224_KEY_GEN");
        Functions.addMech(704L, "CKM_SHA3_384");
        Functions.addMech(705L, "CKM_SHA3_384_HMAC");
        Functions.addMech(706L, "CKM_SHA3_384_HMAC_GENERAL");
        Functions.addMech(707L, "CKM_SHA3_384_KEY_GEN");
        Functions.addMech(720L, "CKM_SHA3_512");
        Functions.addMech(721L, "CKM_SHA3_512_HMAC");
        Functions.addMech(722L, "CKM_SHA3_512_HMAC_GENERAL");
        Functions.addMech(723L, "CKM_SHA3_512_KEY_GEN");
        Functions.addMech(768L, "CKM_CAST_KEY_GEN");
        Functions.addMech(769L, "CKM_CAST_ECB");
        Functions.addMech(770L, "CKM_CAST_CBC");
        Functions.addMech(771L, "CKM_CAST_MAC");
        Functions.addMech(772L, "CKM_CAST_MAC_GENERAL");
        Functions.addMech(773L, "CKM_CAST_CBC_PAD");
        Functions.addMech(784L, "CKM_CAST3_KEY_GEN");
        Functions.addMech(785L, "CKM_CAST3_ECB");
        Functions.addMech(786L, "CKM_CAST3_CBC");
        Functions.addMech(787L, "CKM_CAST3_MAC");
        Functions.addMech(788L, "CKM_CAST3_MAC_GENERAL");
        Functions.addMech(789L, "CKM_CAST3_CBC_PAD");
        Functions.addMech(800L, "CKM_CAST128_KEY_GEN");
        Functions.addMech(801L, "CKM_CAST128_ECB");
        Functions.addMech(802L, "CKM_CAST128_CBC");
        Functions.addMech(803L, "CKM_CAST128_MAC");
        Functions.addMech(804L, "CKM_CAST128_MAC_GENERAL");
        Functions.addMech(805L, "CKM_CAST128_CBC_PAD");
        Functions.addMech(816L, "CKM_RC5_KEY_GEN");
        Functions.addMech(817L, "CKM_RC5_ECB");
        Functions.addMech(818L, "CKM_RC5_CBC");
        Functions.addMech(819L, "CKM_RC5_MAC");
        Functions.addMech(820L, "CKM_RC5_MAC_GENERAL");
        Functions.addMech(821L, "CKM_RC5_CBC_PAD");
        Functions.addMech(832L, "CKM_IDEA_KEY_GEN");
        Functions.addMech(833L, "CKM_IDEA_ECB");
        Functions.addMech(834L, "CKM_IDEA_CBC");
        Functions.addMech(835L, "CKM_IDEA_MAC");
        Functions.addMech(836L, "CKM_IDEA_MAC_GENERAL");
        Functions.addMech(837L, "CKM_IDEA_CBC_PAD");
        Functions.addMech(848L, "CKM_GENERIC_SECRET_KEY_GEN");
        Functions.addMech(864L, "CKM_CONCATENATE_BASE_AND_KEY");
        Functions.addMech(866L, "CKM_CONCATENATE_BASE_AND_DATA");
        Functions.addMech(867L, "CKM_CONCATENATE_DATA_AND_BASE");
        Functions.addMech(868L, "CKM_XOR_BASE_AND_DATA");
        Functions.addMech(869L, "CKM_EXTRACT_KEY_FROM_KEY");
        Functions.addMech(880L, "CKM_SSL3_PRE_MASTER_KEY_GEN");
        Functions.addMech(881L, "CKM_SSL3_MASTER_KEY_DERIVE");
        Functions.addMech(882L, "CKM_SSL3_KEY_AND_MAC_DERIVE");
        Functions.addMech(883L, "CKM_SSL3_MASTER_KEY_DERIVE_DH");
        Functions.addMech(884L, "CKM_TLS_PRE_MASTER_KEY_GEN");
        Functions.addMech(885L, "CKM_TLS_MASTER_KEY_DERIVE");
        Functions.addMech(886L, "CKM_TLS_KEY_AND_MAC_DERIVE");
        Functions.addMech(887L, "CKM_TLS_MASTER_KEY_DERIVE_DH");
        Functions.addMech(888L, "CKM_TLS_PRF");
        Functions.addMech(896L, "CKM_SSL3_MD5_MAC");
        Functions.addMech(897L, "CKM_SSL3_SHA1_MAC");
        Functions.addMech(912L, "CKM_MD5_KEY_DERIVATION");
        Functions.addMech(913L, "CKM_MD2_KEY_DERIVATION");
        Functions.addMech(914L, "CKM_SHA1_KEY_DERIVATION");
        Functions.addMech(915L, "CKM_SHA256_KEY_DERIVATION");
        Functions.addMech(916L, "CKM_SHA384_KEY_DERIVATION");
        Functions.addMech(917L, "CKM_SHA512_KEY_DERIVATION");
        Functions.addMech(918L, "CKM_SHA224_KEY_DERIVATION");
        Functions.addMech(919L, "CKM_SHA3_256_KEY_DERIVATION");
        Functions.addMech(920L, "CKM_SHA3_224_KEY_DERIVATION");
        Functions.addMech(921L, "CKM_SHA3_384_KEY_DERIVATION");
        Functions.addMech(922L, "CKM_SHA3_512_KEY_DERIVATION");
        Functions.addMech(923L, "CKM_SHAKE_128_KEY_DERIVATION");
        Functions.addMech(924L, "CKM_SHAKE_256_KEY_DERIVATION");
        Functions.addMech(928L, "CKM_PBE_MD2_DES_CBC");
        Functions.addMech(929L, "CKM_PBE_MD5_DES_CBC");
        Functions.addMech(930L, "CKM_PBE_MD5_CAST_CBC");
        Functions.addMech(931L, "CKM_PBE_MD5_CAST3_CBC");
        Functions.addMech(932L, "CKM_PBE_MD5_CAST128_CBC");
        Functions.addMech(933L, "CKM_PBE_SHA1_CAST128_CBC");
        Functions.addMech(934L, "CKM_PBE_SHA1_RC4_128");
        Functions.addMech(935L, "CKM_PBE_SHA1_RC4_40");
        Functions.addMech(936L, "CKM_PBE_SHA1_DES3_EDE_CBC");
        Functions.addMech(937L, "CKM_PBE_SHA1_DES2_EDE_CBC");
        Functions.addMech(938L, "CKM_PBE_SHA1_RC2_128_CBC");
        Functions.addMech(939L, "CKM_PBE_SHA1_RC2_40_CBC");
        Functions.addMech(944L, "CKM_PKCS5_PBKD2");
        Functions.addMech(960L, "CKM_PBA_SHA1_WITH_SHA1_HMAC");
        Functions.addMech(976L, "CKM_WTLS_PRE_MASTER_KEY_GEN");
        Functions.addMech(977L, "CKM_WTLS_MASTER_KEY_DERIVE");
        Functions.addMech(978L, "CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC");
        Functions.addMech(979L, "CKM_WTLS_PRF");
        Functions.addMech(980L, "CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE");
        Functions.addMech(981L, "CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE");
        Functions.addMech(982L, "CKM_TLS10_MAC_SERVER");
        Functions.addMech(983L, "CKM_TLS10_MAC_CLIENT");
        Functions.addMech(984L, "CKM_TLS12_MAC");
        Functions.addMech(985L, "CKM_TLS12_KDF");
        Functions.addMech(992L, "CKM_TLS12_MASTER_KEY_DERIVE");
        Functions.addMech(993L, "CKM_TLS12_KEY_AND_MAC_DERIVE");
        Functions.addMech(994L, "CKM_TLS12_MASTER_KEY_DERIVE_DH");
        Functions.addMech(995L, "CKM_TLS12_KEY_SAFE_DERIVE");
        Functions.addMech(996L, "CKM_TLS_MAC");
        Functions.addMech(997L, "CKM_TLS_KDF");
        Functions.addMech(1024L, "CKM_KEY_WRAP_LYNKS");
        Functions.addMech(1025L, "CKM_KEY_WRAP_SET_OAEP");
        Functions.addMech(1280L, "CKM_CMS_SIG");
        Functions.addMech(1296L, "CKM_KIP_DERIVE");
        Functions.addMech(1297L, "CKM_KIP_WRAP");
        Functions.addMech(1298L, "CKM_KIP_MAC");
        Functions.addMech(1360L, "CKM_CAMELLIA_KEY_GEN");
        Functions.addMech(1361L, "CKM_CAMELLIA_ECB");
        Functions.addMech(1362L, "CKM_CAMELLIA_CBC");
        Functions.addMech(1363L, "CKM_CAMELLIA_MAC");
        Functions.addMech(1364L, "CKM_CAMELLIA_MAC_GENERAL");
        Functions.addMech(1365L, "CKM_CAMELLIA_CBC_PAD");
        Functions.addMech(1366L, "CKM_CAMELLIA_ECB_ENCRYPT_DATA");
        Functions.addMech(1367L, "CKM_CAMELLIA_CBC_ENCRYPT_DATA");
        Functions.addMech(1368L, "CKM_CAMELLIA_CTR");
        Functions.addMech(1376L, "CKM_ARIA_KEY_GEN");
        Functions.addMech(1377L, "CKM_ARIA_ECB");
        Functions.addMech(1378L, "CKM_ARIA_CBC");
        Functions.addMech(1379L, "CKM_ARIA_MAC");
        Functions.addMech(1380L, "CKM_ARIA_MAC_GENERAL");
        Functions.addMech(1381L, "CKM_ARIA_CBC_PAD");
        Functions.addMech(1382L, "CKM_ARIA_ECB_ENCRYPT_DATA");
        Functions.addMech(1383L, "CKM_ARIA_CBC_ENCRYPT_DATA");
        Functions.addMech(1616L, "CKM_SEED_KEY_GEN");
        Functions.addMech(1617L, "CKM_SEED_ECB");
        Functions.addMech(1618L, "CKM_SEED_CBC");
        Functions.addMech(1619L, "CKM_SEED_MAC");
        Functions.addMech(1620L, "CKM_SEED_MAC_GENERAL");
        Functions.addMech(1621L, "CKM_SEED_CBC_PAD");
        Functions.addMech(1622L, "CKM_SEED_ECB_ENCRYPT_DATA");
        Functions.addMech(1623L, "CKM_SEED_CBC_ENCRYPT_DATA");
        Functions.addMech(4096L, "CKM_SKIPJACK_KEY_GEN");
        Functions.addMech(4097L, "CKM_SKIPJACK_ECB64");
        Functions.addMech(4098L, "CKM_SKIPJACK_CBC64");
        Functions.addMech(4099L, "CKM_SKIPJACK_OFB64");
        Functions.addMech(4100L, "CKM_SKIPJACK_CFB64");
        Functions.addMech(4101L, "CKM_SKIPJACK_CFB32");
        Functions.addMech(4102L, "CKM_SKIPJACK_CFB16");
        Functions.addMech(4103L, "CKM_SKIPJACK_CFB8");
        Functions.addMech(4104L, "CKM_SKIPJACK_WRAP");
        Functions.addMech(4105L, "CKM_SKIPJACK_PRIVATE_WRAP");
        Functions.addMech(4106L, "CKM_SKIPJACK_RELAYX");
        Functions.addMech(4112L, "CKM_KEA_KEY_PAIR_GEN");
        Functions.addMech(4113L, "CKM_KEA_KEY_DERIVE");
        Functions.addMech(4128L, "CKM_FORTEZZA_TIMESTAMP");
        Functions.addMech(4144L, "CKM_BATON_KEY_GEN");
        Functions.addMech(4145L, "CKM_BATON_ECB128");
        Functions.addMech(4146L, "CKM_BATON_ECB96");
        Functions.addMech(4147L, "CKM_BATON_CBC128");
        Functions.addMech(4148L, "CKM_BATON_COUNTER");
        Functions.addMech(4149L, "CKM_BATON_SHUFFLE");
        Functions.addMech(4150L, "CKM_BATON_WRAP");
        Functions.addMech(4160L, "CKM_EC_KEY_PAIR_GEN");
        Functions.addMech(5131L, "CKM_EC_KEY_PAIR_GEN_W_EXTRA_BITS");
        Functions.addMech(4161L, "CKM_ECDSA");
        Functions.addMech(4162L, "CKM_ECDSA_SHA1");
        Functions.addMech(4163L, "CKM_ECDSA_SHA224");
        Functions.addMech(4164L, "CKM_ECDSA_SHA256");
        Functions.addMech(4165L, "CKM_ECDSA_SHA384");
        Functions.addMech(4166L, "CKM_ECDSA_SHA512");
        Functions.addMech(4167L, "CKM_ECDSA_SHA3_224");
        Functions.addMech(4168L, "CKM_ECDSA_SHA3_256");
        Functions.addMech(4169L, "CKM_ECDSA_SHA3_384");
        Functions.addMech(4170L, "CKM_ECDSA_SHA3_512");
        Functions.addMech(4176L, "CKM_ECDH1_DERIVE");
        Functions.addMech(4177L, "CKM_ECDH1_COFACTOR_DERIVE");
        Functions.addMech(4178L, "CKM_ECMQV_DERIVE");
        Functions.addMech(4179L, "CKM_ECDH_AES_KEY_WRAP");
        Functions.addMech(4180L, "CKM_RSA_AES_KEY_WRAP");
        Functions.addMech(4181L, "CKM_EC_EDWARDS_KEY_PAIR_GEN");
        Functions.addMech(4182L, "CKM_EC_MONTGOMERY_KEY_PAIR_GEN");
        Functions.addMech(4183L, "CKM_EDDSA");
        Functions.addMech(4192L, "CKM_JUNIPER_KEY_GEN");
        Functions.addMech(4193L, "CKM_JUNIPER_ECB128");
        Functions.addMech(4194L, "CKM_JUNIPER_CBC128");
        Functions.addMech(4195L, "CKM_JUNIPER_COUNTER");
        Functions.addMech(4196L, "CKM_JUNIPER_SHUFFLE");
        Functions.addMech(4197L, "CKM_JUNIPER_WRAP");
        Functions.addMech(4208L, "CKM_FASTHASH");
        Functions.addMech(4209L, "CKM_AES_XTS");
        Functions.addMech(4210L, "CKM_AES_XTS_KEY_GEN");
        Functions.addMech(4224L, "CKM_AES_KEY_GEN");
        Functions.addMech(4225L, "CKM_AES_ECB");
        Functions.addMech(4226L, "CKM_AES_CBC");
        Functions.addMech(4227L, "CKM_AES_MAC");
        Functions.addMech(4228L, "CKM_AES_MAC_GENERAL");
        Functions.addMech(4229L, "CKM_AES_CBC_PAD");
        Functions.addMech(4230L, "CKM_AES_CTR");
        Functions.addMech(4231L, "CKM_AES_GCM");
        Functions.addMech(4232L, "CKM_AES_CCM");
        Functions.addMech(4233L, "CKM_AES_CTS");
        Functions.addMech(4234L, "CKM_AES_CMAC");
        Functions.addMech(4235L, "CKM_AES_CMAC_GENERAL");
        Functions.addMech(4236L, "CKM_AES_XCBC_MAC");
        Functions.addMech(4237L, "CKM_AES_XCBC_MAC_96");
        Functions.addMech(4238L, "CKM_AES_GMAC");
        Functions.addMech(4240L, "CKM_BLOWFISH_KEY_GEN");
        Functions.addMech(4241L, "CKM_BLOWFISH_CBC");
        Functions.addMech(4242L, "CKM_TWOFISH_KEY_GEN");
        Functions.addMech(4243L, "CKM_TWOFISH_CBC");
        Functions.addMech(4244L, "CKM_BLOWFISH_CBC_PAD");
        Functions.addMech(4245L, "CKM_TWOFISH_CBC_PAD");
        Functions.addMech(4352L, "CKM_DES_ECB_ENCRYPT_DATA");
        Functions.addMech(4353L, "CKM_DES_CBC_ENCRYPT_DATA");
        Functions.addMech(4354L, "CKM_DES3_ECB_ENCRYPT_DATA");
        Functions.addMech(4355L, "CKM_DES3_CBC_ENCRYPT_DATA");
        Functions.addMech(4356L, "CKM_AES_ECB_ENCRYPT_DATA");
        Functions.addMech(4357L, "CKM_AES_CBC_ENCRYPT_DATA");
        Functions.addMech(4608L, "CKM_GOSTR3410_KEY_PAIR_GEN");
        Functions.addMech(4609L, "CKM_GOSTR3410");
        Functions.addMech(4610L, "CKM_GOSTR3410_WITH_GOSTR3411");
        Functions.addMech(4611L, "CKM_GOSTR3410_KEY_WRAP");
        Functions.addMech(4612L, "CKM_GOSTR3410_DERIVE");
        Functions.addMech(4624L, "CKM_GOSTR3411");
        Functions.addMech(4625L, "CKM_GOSTR3411_HMAC");
        Functions.addMech(4640L, "CKM_GOST28147_KEY_GEN");
        Functions.addMech(4641L, "CKM_GOST28147_ECB");
        Functions.addMech(4642L, "CKM_GOST28147");
        Functions.addMech(4643L, "CKM_GOST28147_MAC");
        Functions.addMech(4644L, "CKM_GOST28147_KEY_WRAP");
        Functions.addMech(4645L, "CKM_CHACHA20_KEY_GEN");
        Functions.addMech(4646L, "CKM_CHACHA20");
        Functions.addMech(4647L, "CKM_POLY1305_KEY_GEN");
        Functions.addMech(4648L, "CKM_POLY1305");
        Functions.addMech(8192L, "CKM_DSA_PARAMETER_GEN");
        Functions.addMech(8193L, "CKM_DH_PKCS_PARAMETER_GEN");
        Functions.addMech(8194L, "CKM_X9_42_DH_PARAMETER_GEN");
        Functions.addMech(8195L, "CKM_DSA_PROBABLISTIC_PARAMETER_GEN");
        Functions.addMech(8196L, "CKM_DSA_SHAWE_TAYLOR_PARAMETER_GEN");
        Functions.addMech(8197L, "CKM_DSA_FIPS_G_GEN");
        Functions.addMech(8452L, "CKM_AES_OFB");
        Functions.addMech(8453L, "CKM_AES_CFB64");
        Functions.addMech(8454L, "CKM_AES_CFB8");
        Functions.addMech(8455L, "CKM_AES_CFB128");
        Functions.addMech(8456L, "CKM_AES_CFB1");
        Functions.addMech(8457L, "CKM_AES_KEY_WRAP");
        Functions.addMech(8458L, "CKM_AES_KEY_WRAP_PAD");
        Functions.addMech(8459L, "CKM_AES_KEY_WRAP_KWP");
        Functions.addMech(16385L, "CKM_RSA_PKCS_TPM_1_1");
        Functions.addMech(16386L, "CKM_RSA_PKCS_OAEP_TPM_1_1");
        Functions.addMech(16387L, "CKM_SHA_1_KEY_GEN");
        Functions.addMech(16388L, "CKM_SHA224_KEY_GEN");
        Functions.addMech(16389L, "CKM_SHA256_KEY_GEN");
        Functions.addMech(16390L, "CKM_SHA384_KEY_GEN");
        Functions.addMech(16391L, "CKM_SHA512_KEY_GEN");
        Functions.addMech(16392L, "CKM_SHA512_224_KEY_GEN");
        Functions.addMech(16393L, "CKM_SHA512_256_KEY_GEN");
        Functions.addMech(16394L, "CKM_SHA512_T_KEY_GEN");
        Functions.addMech(16395L, "CKM_NULL");
        Functions.addMech(16396L, "CKM_BLAKE2B_160");
        Functions.addMech(16397L, "CKM_BLAKE2B_160_HMAC");
        Functions.addMech(16398L, "CKM_BLAKE2B_160_HMAC_GENERAL");
        Functions.addMech(16399L, "CKM_BLAKE2B_160_KEY_DERIVE");
        Functions.addMech(16400L, "CKM_BLAKE2B_160_KEY_GEN");
        Functions.addMech(16401L, "CKM_BLAKE2B_256");
        Functions.addMech(16402L, "CKM_BLAKE2B_256_HMAC");
        Functions.addMech(16403L, "CKM_BLAKE2B_256_HMAC_GENERAL");
        Functions.addMech(16404L, "CKM_BLAKE2B_256_KEY_DERIVE");
        Functions.addMech(16405L, "CKM_BLAKE2B_256_KEY_GEN");
        Functions.addMech(16406L, "CKM_BLAKE2B_384");
        Functions.addMech(16407L, "CKM_BLAKE2B_384_HMAC");
        Functions.addMech(16408L, "CKM_BLAKE2B_384_HMAC_GENERAL");
        Functions.addMech(16409L, "CKM_BLAKE2B_384_KEY_DERIVE");
        Functions.addMech(16410L, "CKM_BLAKE2B_384_KEY_GEN");
        Functions.addMech(16411L, "CKM_BLAKE2B_512");
        Functions.addMech(16412L, "CKM_BLAKE2B_512_HMAC");
        Functions.addMech(16413L, "CKM_BLAKE2B_512_HMAC_GENERAL");
        Functions.addMech(16414L, "CKM_BLAKE2B_512_KEY_DERIVE");
        Functions.addMech(16415L, "CKM_BLAKE2B_512_KEY_GEN");
        Functions.addMech(16416L, "CKM_SALSA20");
        Functions.addMech(16417L, "CKM_CHACHA20_POLY1305");
        Functions.addMech(16418L, "CKM_SALSA20_POLY1305");
        Functions.addMech(16419L, "CKM_X3DH_INITIALIZE");
        Functions.addMech(16420L, "CKM_X3DH_RESPOND");
        Functions.addMech(16421L, "CKM_X2RATCHET_INITIALIZE");
        Functions.addMech(16422L, "CKM_X2RATCHET_RESPOND");
        Functions.addMech(16423L, "CKM_X2RATCHET_ENCRYPT");
        Functions.addMech(16424L, "CKM_X2RATCHET_DECRYPT");
        Functions.addMech(16425L, "CKM_XEDDSA");
        Functions.addMech(16426L, "CKM_HKDF_DERIVE");
        Functions.addMech(16427L, "CKM_HKDF_DATA");
        Functions.addMech(16428L, "CKM_HKDF_KEY_GEN");
        Functions.addMech(16429L, "CKM_SALSA20_KEY_GEN");
        Functions.addMech(940L, "CKM_SP800_108_COUNTER_KDF");
        Functions.addMech(941L, "CKM_SP800_108_FEEDBACK_KDF");
        Functions.addMech(942L, "CKM_SP800_108_DOUBLE_PIPELINE_KDF");
        Functions.addMech(0x80000000L, "CKM_VENDOR_DEFINED");
        Functions.addMech(2147484531L, "CKM_NSS_TLS_PRF_GENERAL");
        Functions.addMech(2147483424L, "SecureRandom");
        Functions.addMech(2147483425L, "KeyStore");
        Functions.addHashMech(544L, "SHA-1", "SHA", "SHA1");
        Functions.addHashMech(597L, "SHA-224", "SHA224");
        Functions.addHashMech(592L, "SHA-256", "SHA256");
        Functions.addHashMech(608L, "SHA-384", "SHA384");
        Functions.addHashMech(624L, "SHA-512", "SHA512");
        Functions.addHashMech(72L, "SHA-512/224", "SHA512/224");
        Functions.addHashMech(76L, "SHA-512/256", "SHA512/256");
        Functions.addHashMech(693L, "SHA3-224");
        Functions.addHashMech(688L, "SHA3-256");
        Functions.addHashMech(704L, "SHA3-384");
        Functions.addHashMech(720L, "SHA3-512");
        Functions.addKeyType(0L, "CKK_RSA");
        Functions.addKeyType(1L, "CKK_DSA");
        Functions.addKeyType(2L, "CKK_DH");
        Functions.addKeyType(3L, "CKK_EC");
        Functions.addKeyType(4L, "CKK_X9_42_DH");
        Functions.addKeyType(5L, "CKK_KEA");
        Functions.addKeyType(16L, "CKK_GENERIC_SECRET");
        Functions.addKeyType(17L, "CKK_RC2");
        Functions.addKeyType(18L, "CKK_RC4");
        Functions.addKeyType(19L, "CKK_DES");
        Functions.addKeyType(20L, "CKK_DES2");
        Functions.addKeyType(21L, "CKK_DES3");
        Functions.addKeyType(22L, "CKK_CAST");
        Functions.addKeyType(23L, "CKK_CAST3");
        Functions.addKeyType(24L, "CKK_CAST128");
        Functions.addKeyType(25L, "CKK_RC5");
        Functions.addKeyType(26L, "CKK_IDEA");
        Functions.addKeyType(27L, "CKK_SKIPJACK");
        Functions.addKeyType(28L, "CKK_BATON");
        Functions.addKeyType(29L, "CKK_JUNIPER");
        Functions.addKeyType(30L, "CKK_CDMF");
        Functions.addKeyType(31L, "CKK_AES");
        Functions.addKeyType(32L, "CKK_BLOWFISH");
        Functions.addKeyType(33L, "CKK_TWOFISH");
        Functions.addKeyType(34L, "CKK_SECURID");
        Functions.addKeyType(35L, "CKK_HOTP");
        Functions.addKeyType(36L, "CKK_ACTI");
        Functions.addKeyType(37L, "CKK_CAMELLIA");
        Functions.addKeyType(38L, "CKK_ARIA");
        Functions.addKeyType(39L, "CKK_MD5_HMAC");
        Functions.addKeyType(40L, "CKK_SHA_1_HMAC");
        Functions.addKeyType(41L, "CKK_RIPEMD128_HMAC");
        Functions.addKeyType(42L, "CKK_RIPEMD160_HMAC");
        Functions.addKeyType(43L, "CKK_SHA256_HMAC");
        Functions.addKeyType(44L, "CKK_SHA384_HMAC");
        Functions.addKeyType(45L, "CKK_SHA512_HMAC");
        Functions.addKeyType(46L, "CKK_SHA224_HMAC");
        Functions.addKeyType(47L, "CKK_SEED");
        Functions.addKeyType(48L, "CKK_GOSTR3410");
        Functions.addKeyType(49L, "CKK_GOSTR3411");
        Functions.addKeyType(50L, "CKK_GOST28147");
        Functions.addKeyType(51L, "CKK_CHACHA20");
        Functions.addKeyType(52L, "CKK_POLY1305");
        Functions.addKeyType(53L, "CKK_AES_XTS");
        Functions.addKeyType(54L, "CKK_SHA3_224_HMAC");
        Functions.addKeyType(55L, "CKK_SHA3_256_HMAC");
        Functions.addKeyType(56L, "CKK_SHA3_384_HMAC");
        Functions.addKeyType(57L, "CKK_SHA3_512_HMAC");
        Functions.addKeyType(58L, "CKK_BLAKE2B_160_HMAC");
        Functions.addKeyType(59L, "CKK_BLAKE2B_256_HMAC");
        Functions.addKeyType(60L, "CKK_BLAKE2B_384_HMAC");
        Functions.addKeyType(61L, "CKK_BLAKE2B_512_HMAC");
        Functions.addKeyType(62L, "CKK_SALSA20");
        Functions.addKeyType(63L, "CKK_X2RATCHET");
        Functions.addKeyType(64L, "CKK_EC_EDWARDS");
        Functions.addKeyType(65L, "CKK_EC_MONTGOMERY");
        Functions.addKeyType(66L, "CKK_HKDF");
        Functions.addKeyType(67L, "CKK_SHA512_224_HMAC");
        Functions.addKeyType(68L, "CKK_SHA512_256_HMAC");
        Functions.addKeyType(69L, "CKK_SHA512_T_HMAC");
        Functions.addKeyType(0x80000000L, "CKK_VENDOR_DEFINED");
        Functions.addKeyType(0x7FFFFF22L, "*");
        Functions.addAttribute(0L, "CKA_CLASS");
        Functions.addAttribute(1L, "CKA_TOKEN");
        Functions.addAttribute(2L, "CKA_PRIVATE");
        Functions.addAttribute(3L, "CKA_LABEL");
        Functions.addAttribute(4L, "CKA_UNIQUE_ID");
        Functions.addAttribute(16L, "CKA_APPLICATION");
        Functions.addAttribute(17L, "CKA_VALUE");
        Functions.addAttribute(18L, "CKA_OBJECT_ID");
        Functions.addAttribute(128L, "CKA_CERTIFICATE_TYPE");
        Functions.addAttribute(129L, "CKA_ISSUER");
        Functions.addAttribute(130L, "CKA_SERIAL_NUMBER");
        Functions.addAttribute(131L, "CKA_AC_ISSUER");
        Functions.addAttribute(132L, "CKA_OWNER");
        Functions.addAttribute(133L, "CKA_ATTR_TYPES");
        Functions.addAttribute(134L, "CKA_TRUSTED");
        Functions.addAttribute(135L, "CKA_CERTIFICATE_CATEGORY");
        Functions.addAttribute(136L, "CKA_JAVA_MIDP_SECURITY_DOMAIN");
        Functions.addAttribute(137L, "CKA_URL");
        Functions.addAttribute(138L, "CKA_HASH_OF_SUBJECT_PUBLIC_KEY");
        Functions.addAttribute(139L, "CKA_HASH_OF_ISSUER_PUBLIC_KEY");
        Functions.addAttribute(140L, "CKA_NAME_HASH_ALGORITHM");
        Functions.addAttribute(144L, "CKA_CHECK_VALUE");
        Functions.addAttribute(256L, "CKA_KEY_TYPE");
        Functions.addAttribute(257L, "CKA_SUBJECT");
        Functions.addAttribute(258L, "CKA_ID");
        Functions.addAttribute(259L, "CKA_SENSITIVE");
        Functions.addAttribute(260L, "CKA_ENCRYPT");
        Functions.addAttribute(261L, "CKA_DECRYPT");
        Functions.addAttribute(262L, "CKA_WRAP");
        Functions.addAttribute(263L, "CKA_UNWRAP");
        Functions.addAttribute(264L, "CKA_SIGN");
        Functions.addAttribute(265L, "CKA_SIGN_RECOVER");
        Functions.addAttribute(266L, "CKA_VERIFY");
        Functions.addAttribute(267L, "CKA_VERIFY_RECOVER");
        Functions.addAttribute(268L, "CKA_DERIVE");
        Functions.addAttribute(272L, "CKA_START_DATE");
        Functions.addAttribute(273L, "CKA_END_DATE");
        Functions.addAttribute(288L, "CKA_MODULUS");
        Functions.addAttribute(289L, "CKA_MODULUS_BITS");
        Functions.addAttribute(290L, "CKA_PUBLIC_EXPONENT");
        Functions.addAttribute(291L, "CKA_PRIVATE_EXPONENT");
        Functions.addAttribute(292L, "CKA_PRIME_1");
        Functions.addAttribute(293L, "CKA_PRIME_2");
        Functions.addAttribute(294L, "CKA_EXPONENT_1");
        Functions.addAttribute(295L, "CKA_EXPONENT_2");
        Functions.addAttribute(296L, "CKA_COEFFICIENT");
        Functions.addAttribute(297L, "CKA_PUBLIC_KEY_INFO");
        Functions.addAttribute(304L, "CKA_PRIME");
        Functions.addAttribute(305L, "CKA_SUBPRIME");
        Functions.addAttribute(306L, "CKA_BASE");
        Functions.addAttribute(307L, "CKA_PRIME_BITS");
        Functions.addAttribute(308L, "CKA_SUB_PRIME_BITS");
        Functions.addAttribute(352L, "CKA_VALUE_BITS");
        Functions.addAttribute(353L, "CKA_VALUE_LEN");
        Functions.addAttribute(354L, "CKA_EXTRACTABLE");
        Functions.addAttribute(355L, "CKA_LOCAL");
        Functions.addAttribute(356L, "CKA_NEVER_EXTRACTABLE");
        Functions.addAttribute(357L, "CKA_ALWAYS_SENSITIVE");
        Functions.addAttribute(358L, "CKA_KEY_GEN_MECHANISM");
        Functions.addAttribute(368L, "CKA_MODIFIABLE");
        Functions.addAttribute(369L, "CKA_COPYABLE");
        Functions.addAttribute(370L, "CKA_DESTROYABLE");
        Functions.addAttribute(384L, "CKA_EC_PARAMS");
        Functions.addAttribute(385L, "CKA_EC_POINT");
        Functions.addAttribute(512L, "CKA_SECONDARY_AUTH");
        Functions.addAttribute(513L, "CKA_AUTH_PIN_FLAGS");
        Functions.addAttribute(514L, "CKA_ALWAYS_AUTHENTICATE");
        Functions.addAttribute(528L, "CKA_WRAP_WITH_TRUSTED");
        Functions.addAttribute(1073742353L, "CKA_WRAP_TEMPLATE");
        Functions.addAttribute(1073742354L, "CKA_UNWRAP_TEMPLATE");
        Functions.addAttribute(1073742355L, "CKA_DERIVE_TEMPLATE");
        Functions.addAttribute(544L, "CKA_OTP_FORMAT");
        Functions.addAttribute(545L, "CKA_OTP_LENGTH");
        Functions.addAttribute(546L, "CKA_OTP_TIME_INTERVAL");
        Functions.addAttribute(547L, "CKA_OTP_USER_FRIENDLY_MODE");
        Functions.addAttribute(548L, "CKA_OTP_CHALLENGE_REQUIREMENT");
        Functions.addAttribute(549L, "CKA_OTP_TIME_REQUIREMENT");
        Functions.addAttribute(550L, "CKA_OTP_COUNTER_REQUIREMENT");
        Functions.addAttribute(551L, "CKA_OTP_PIN_REQUIREMENT");
        Functions.addAttribute(558L, "CKA_OTP_COUNTER");
        Functions.addAttribute(559L, "CKA_OTP_TIME");
        Functions.addAttribute(554L, "CKA_OTP_USER_IDENTIFIER");
        Functions.addAttribute(555L, "CKA_OTP_SERVICE_IDENTIFIER");
        Functions.addAttribute(556L, "CKA_OTP_SERVICE_LOGO");
        Functions.addAttribute(557L, "CKA_OTP_SERVICE_LOGO_TYPE");
        Functions.addAttribute(592L, "CKA_GOSTR3410_PARAMS");
        Functions.addAttribute(593L, "CKA_GOSTR3411_PARAMS");
        Functions.addAttribute(594L, "CKA_GOST28147_PARAMS");
        Functions.addAttribute(768L, "CKA_HW_FEATURE_TYPE");
        Functions.addAttribute(769L, "CKA_RESET_ON_INIT");
        Functions.addAttribute(770L, "CKA_HAS_RESET");
        Functions.addAttribute(1024L, "CKA_PIXEL_X");
        Functions.addAttribute(1025L, "CKA_PIXEL_Y");
        Functions.addAttribute(1026L, "CKA_RESOLUTION");
        Functions.addAttribute(1027L, "CKA_CHAR_ROWS");
        Functions.addAttribute(1028L, "CKA_CHAR_COLUMNS");
        Functions.addAttribute(1029L, "CKA_COLOR");
        Functions.addAttribute(1030L, "CKA_BITS_PER_PIXEL");
        Functions.addAttribute(1152L, "CKA_CHAR_SETS");
        Functions.addAttribute(1153L, "CKA_ENCODING_METHODS");
        Functions.addAttribute(1154L, "CKA_MIME_TYPES");
        Functions.addAttribute(1280L, "CKA_MECHANISM_TYPE");
        Functions.addAttribute(1281L, "CKA_REQUIRED_CMS_ATTRIBUTES");
        Functions.addAttribute(1282L, "CKA_DEFAULT_CMS_ATTRIBUTES");
        Functions.addAttribute(1283L, "CKA_SUPPORTED_CMS_ATTRIBUTES");
        Functions.addAttribute(0x40000600L, "CKA_ALLOWED_MECHANISMS");
        Functions.addAttribute(1537L, "CKA_PROFILE_ID");
        Functions.addAttribute(1538L, "CKA_X2RATCHET_BAG");
        Functions.addAttribute(1539L, "CKA_X2RATCHET_BAGSIZE");
        Functions.addAttribute(1540L, "CKA_X2RATCHET_BOBS1STMSG");
        Functions.addAttribute(1541L, "CKA_X2RATCHET_CKR");
        Functions.addAttribute(1542L, "CKA_X2RATCHET_CKS");
        Functions.addAttribute(1543L, "CKA_X2RATCHET_DHP");
        Functions.addAttribute(1544L, "CKA_X2RATCHET_DHR");
        Functions.addAttribute(1545L, "CKA_X2RATCHET_DHS");
        Functions.addAttribute(1546L, "CKA_X2RATCHET_HKR");
        Functions.addAttribute(1547L, "CKA_X2RATCHET_HKS");
        Functions.addAttribute(1548L, "CKA_X2RATCHET_ISALICE");
        Functions.addAttribute(1549L, "CKA_X2RATCHET_NHKR");
        Functions.addAttribute(1550L, "CKA_X2RATCHET_NHKS");
        Functions.addAttribute(1551L, "CKA_X2RATCHET_NR");
        Functions.addAttribute(1552L, "CKA_X2RATCHET_NS");
        Functions.addAttribute(1553L, "CKA_X2RATCHET_PNS");
        Functions.addAttribute(1554L, "CKA_X2RATCHET_RK");
        Functions.addAttribute(0x80000000L, "CKA_VENDOR_DEFINED");
        Functions.addAttribute(3584088832L, "CKA_NETSCAPE_DB");
        Functions.addAttribute(3461571416L, "CKA_NETSCAPE_TRUST_SERVER_AUTH");
        Functions.addAttribute(3461571417L, "CKA_NETSCAPE_TRUST_CLIENT_AUTH");
        Functions.addAttribute(3461571418L, "CKA_NETSCAPE_TRUST_CODE_SIGNING");
        Functions.addAttribute(3461571419L, "CKA_NETSCAPE_TRUST_EMAIL_PROTECTION");
        Functions.addAttribute(3461571508L, "CKA_NETSCAPE_CERT_SHA1_HASH");
        Functions.addAttribute(3461571509L, "CKA_NETSCAPE_CERT_MD5_HASH");
        Functions.addObjectClass(0L, "CKO_DATA");
        Functions.addObjectClass(1L, "CKO_CERTIFICATE");
        Functions.addObjectClass(2L, "CKO_PUBLIC_KEY");
        Functions.addObjectClass(3L, "CKO_PRIVATE_KEY");
        Functions.addObjectClass(4L, "CKO_SECRET_KEY");
        Functions.addObjectClass(5L, "CKO_HW_FEATURE");
        Functions.addObjectClass(6L, "CKO_DOMAIN_PARAMETERS");
        Functions.addObjectClass(7L, "CKO_MECHANISM");
        Functions.addObjectClass(8L, "CKO_OTP_KEY");
        Functions.addObjectClass(9L, "CKO_PROFILE");
        Functions.addObjectClass(0x80000000L, "CKO_VENDOR_DEFINED");
        Functions.addObjectClass(2147483427L, "*");
        Functions.addMGF(1L, "CKG_MGF1_SHA1");
        Functions.addMGF(2L, "CKG_MGF1_SHA256");
        Functions.addMGF(3L, "CKG_MGF1_SHA384");
        Functions.addMGF(4L, "CKG_MGF1_SHA512");
        Functions.addMGF(5L, "CKG_MGF1_SHA224");
        Functions.addMGF(6L, "CKG_MGF1_SHA3_224");
        Functions.addMGF(7L, "CKG_MGF1_SHA3_256");
        Functions.addMGF(8L, "CKG_MGF1_SHA3_384");
        Functions.addMGF(9L, "CKG_MGF1_SHA3_512");
    }

    private static class Flags {
        private final long[] flagIds;
        private final String[] flagNames;

        Flags(long[] flagIds, String[] flagNames) {
            if (flagIds.length != flagNames.length) {
                throw new AssertionError((Object)"Array lengths do not match");
            }
            this.flagIds = flagIds;
            this.flagNames = flagNames;
        }

        String toString(long val) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (int i = 0; i < this.flagIds.length; ++i) {
                if ((val & this.flagIds[i]) == 0L) continue;
                if (!first) {
                    sb.append(" | ");
                }
                sb.append(this.flagNames[i]);
                first = false;
            }
            return sb.toString();
        }
    }
}

