/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import jdk.internal.org.objectweb.asm.ClassReader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.commons.Method;
import jdk.internal.org.objectweb.asm.tree.AnnotationNode;
import jdk.internal.org.objectweb.asm.tree.ClassNode;
import jdk.internal.org.objectweb.asm.tree.FieldNode;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import jdk.jfr.Enabled;
import jdk.jfr.Event;
import jdk.jfr.Name;
import jdk.jfr.Registered;
import jdk.jfr.SettingControl;
import jdk.jfr.SettingDefinition;
import jdk.jfr.internal.ASMToolkit;
import jdk.jfr.internal.EventHandlerCreator;
import jdk.jfr.internal.EventHandlerProxyCreator;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

public final class EventInstrumentation {
    public static final String FIELD_EVENT_THREAD = "eventThread";
    public static final String FIELD_STACK_TRACE = "stackTrace";
    public static final String FIELD_DURATION = "duration";
    static final String FIELD_EVENT_HANDLER = "eventHandler";
    static final String FIELD_START_TIME = "startTime";
    private static final Class<? extends EventHandler> eventHandlerProxy = EventHandlerProxyCreator.proxyClass;
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_NAME = jdk.internal.org.objectweb.asm.Type.getType(Name.class);
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_REGISTERED = jdk.internal.org.objectweb.asm.Type.getType(Registered.class);
    private static final jdk.internal.org.objectweb.asm.Type ANNOTATION_TYPE_ENABLED = jdk.internal.org.objectweb.asm.Type.getType(Enabled.class);
    private static final jdk.internal.org.objectweb.asm.Type TYPE_EVENT_HANDLER = jdk.internal.org.objectweb.asm.Type.getType(eventHandlerProxy);
    private static final jdk.internal.org.objectweb.asm.Type TYPE_SETTING_CONTROL = jdk.internal.org.objectweb.asm.Type.getType(SettingControl.class);
    private static final Method METHOD_COMMIT = new Method("commit", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_BEGIN = new Method("begin", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_END = new Method("end", jdk.internal.org.objectweb.asm.Type.VOID_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_IS_ENABLED = new Method("isEnabled", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_TIME_STAMP = new Method("timestamp", jdk.internal.org.objectweb.asm.Type.LONG_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_EVENT_SHOULD_COMMIT = new Method("shouldCommit", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[0]);
    private static final Method METHOD_EVENT_HANDLER_SHOULD_COMMIT = new Method("shouldCommit", jdk.internal.org.objectweb.asm.Type.BOOLEAN_TYPE, new jdk.internal.org.objectweb.asm.Type[]{jdk.internal.org.objectweb.asm.Type.LONG_TYPE});
    private static final Method METHOD_DURATION = new Method("duration", jdk.internal.org.objectweb.asm.Type.LONG_TYPE, new jdk.internal.org.objectweb.asm.Type[]{jdk.internal.org.objectweb.asm.Type.LONG_TYPE});
    private final ClassNode classNode;
    private final List<SettingInfo> settingInfos;
    private final List<FieldInfo> fieldInfos;
    private final Method writeMethod;
    private final String eventHandlerXInternalName;
    private final String eventName;
    private boolean guardHandlerReference;
    private Class<?> superClass;

    EventInstrumentation(Class<?> superClass, byte[] bytes, long id) {
        this.superClass = superClass;
        this.classNode = this.createClassNode(bytes);
        this.settingInfos = EventInstrumentation.buildSettingInfos(superClass, this.classNode);
        this.fieldInfos = EventInstrumentation.buildFieldInfos(superClass, this.classNode);
        this.writeMethod = EventInstrumentation.makeWriteMethod(this.fieldInfos);
        this.eventHandlerXInternalName = ASMToolkit.getInternalName(EventHandlerCreator.makeEventHandlerName(id));
        String n = (String)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_NAME.getDescriptor(), String.class);
        this.eventName = n == null ? this.classNode.name.replace("/", ".") : n;
    }

    public String getClassName() {
        return this.classNode.name.replace("/", ".");
    }

    private ClassNode createClassNode(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(classNode, 0);
        return classNode;
    }

    boolean isRegistered() {
        Registered r;
        Boolean result = (Boolean)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_REGISTERED.getDescriptor(), Boolean.class);
        if (result != null) {
            return result;
        }
        if (this.superClass != null && (r = this.superClass.getAnnotation(Registered.class)) != null) {
            return r.value();
        }
        return true;
    }

    boolean isEnabled() {
        Enabled e;
        Boolean result = (Boolean)EventInstrumentation.annotationValue(this.classNode, ANNOTATION_TYPE_ENABLED.getDescriptor(), Boolean.class);
        if (result != null) {
            return result;
        }
        if (this.superClass != null && (e = this.superClass.getAnnotation(Enabled.class)) != null) {
            return e.value();
        }
        return true;
    }

    private static <T> T annotationValue(ClassNode classNode, String typeDescriptor, Class<?> type) {
        if (classNode.visibleAnnotations != null) {
            for (AnnotationNode a : classNode.visibleAnnotations) {
                String keyName;
                List<Object> values;
                if (!typeDescriptor.equals(a.desc) || (values = a.values) == null || values.size() != 2) continue;
                Object key = values.get(0);
                Object value = values.get(1);
                if (!(key instanceof String) || value == null || type != value.getClass() || !"value".equals(keyName = (String)key)) continue;
                return (T)value;
            }
        }
        return null;
    }

    private static List<SettingInfo> buildSettingInfos(Class<?> superClass, ClassNode classNode) {
        SettingInfo si;
        int index;
        String fieldName;
        jdk.internal.org.objectweb.asm.Type paramType;
        HashSet<String> methodSet = new HashSet<String>();
        ArrayList<SettingInfo> settingInfos = new ArrayList<SettingInfo>();
        String settingDescriptor = jdk.internal.org.objectweb.asm.Type.getType(SettingDefinition.class).getDescriptor();
        for (MethodNode m : classNode.methods) {
            if (m.visibleAnnotations == null) continue;
            for (AnnotationNode an : m.visibleAnnotations) {
                jdk.internal.org.objectweb.asm.Type[] args;
                jdk.internal.org.objectweb.asm.Type returnType;
                if (!settingDescriptor.equals(an.desc) || !(returnType = jdk.internal.org.objectweb.asm.Type.getReturnType(m.desc)).equals(jdk.internal.org.objectweb.asm.Type.getType(Boolean.TYPE)) || (args = jdk.internal.org.objectweb.asm.Type.getArgumentTypes(m.desc)).length != 1) continue;
                paramType = args[0];
                fieldName = "setting" + settingInfos.size();
                index = settingInfos.size();
                si = new SettingInfo(fieldName, index);
                si.methodName = m.name;
                si.settingDescriptor = paramType.getDescriptor();
                si.internalSettingName = paramType.getInternalName();
                methodSet.add(m.name);
                settingInfos.add(si);
            }
        }
        for (Class<?> c = superClass; c != Event.class; c = c.getSuperclass()) {
            for (java.lang.reflect.Method method : c.getDeclaredMethods()) {
                if (methodSet.contains(method.getName()) || Modifier.isPrivate(method.getModifiers()) || !method.getReturnType().equals(Boolean.TYPE) || method.getParameterCount() != 1) continue;
                Parameter param = method.getParameters()[0];
                paramType = jdk.internal.org.objectweb.asm.Type.getType(param.getType());
                fieldName = "setting" + settingInfos.size();
                index = settingInfos.size();
                si = new SettingInfo(fieldName, index);
                si.methodName = method.getName();
                si.settingDescriptor = paramType.getDescriptor();
                si.internalSettingName = paramType.getInternalName();
                methodSet.add(method.getName());
                settingInfos.add(si);
            }
        }
        return settingInfos;
    }

    private static List<FieldInfo> buildFieldInfos(Class<?> superClass, ClassNode classNode) {
        HashSet<String> fieldSet = new HashSet<String>();
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>(classNode.fields.size());
        fieldInfos.add(new FieldInfo(FIELD_START_TIME, jdk.internal.org.objectweb.asm.Type.LONG_TYPE.getDescriptor(), classNode.name));
        fieldInfos.add(new FieldInfo(FIELD_DURATION, jdk.internal.org.objectweb.asm.Type.LONG_TYPE.getDescriptor(), classNode.name));
        for (FieldNode field : classNode.fields) {
            String className = jdk.internal.org.objectweb.asm.Type.getType(field.desc).getClassName();
            if (fieldSet.contains(field.name) || !EventInstrumentation.isValidField(field.access, className)) continue;
            FieldInfo fi = new FieldInfo(field.name, field.desc, classNode.name);
            fieldInfos.add(fi);
            fieldSet.add(field.name);
        }
        for (Class<?> c = superClass; c != Event.class; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                String fieldName;
                if (Modifier.isPrivate(field.getModifiers()) || !EventInstrumentation.isValidField(field.getModifiers(), field.getType().getName()) || fieldSet.contains(fieldName = field.getName())) continue;
                jdk.internal.org.objectweb.asm.Type fieldType = jdk.internal.org.objectweb.asm.Type.getType(field.getType());
                String internalClassName = ASMToolkit.getInternalName(c.getName());
                fieldInfos.add(new FieldInfo(fieldName, fieldType.getDescriptor(), internalClassName));
                fieldSet.add(fieldName);
            }
        }
        return fieldInfos;
    }

    public static boolean isValidField(int access, String className) {
        if (Modifier.isTransient(access) || Modifier.isStatic(access)) {
            return false;
        }
        return Type.isValidJavaFieldType(className);
    }

    public byte[] buildInstrumented() {
        this.makeInstrumented();
        return this.toByteArray();
    }

    private byte[] toByteArray() {
        ClassWriter cw = new ClassWriter(2);
        this.classNode.accept(cw);
        cw.visitEnd();
        byte[] result = cw.toByteArray();
        Utils.writeGeneratedASM(this.classNode.name, result);
        return result;
    }

    public byte[] builUninstrumented() {
        this.makeUninstrumented();
        return this.toByteArray();
    }

    private void makeInstrumented() {
        this.updateMethod(METHOD_IS_ENABLED, methodVisitor -> {
            Label nullLabel = new Label();
            if (this.guardHandlerReference) {
                methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, TYPE_EVENT_HANDLER.getDescriptor());
                methodVisitor.visitJumpInsn(198, nullLabel);
            }
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, TYPE_EVENT_HANDLER.getDescriptor());
            ASMToolkit.invokeVirtual(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_IS_ENABLED);
            methodVisitor.visitInsn(172);
            if (this.guardHandlerReference) {
                methodVisitor.visitLabel(nullLabel);
                methodVisitor.visitFrame(3, 0, null, 0, null);
                methodVisitor.visitInsn(3);
                methodVisitor.visitInsn(172);
            }
        });
        this.updateMethod(METHOD_BEGIN, methodVisitor -> {
            methodVisitor.visitIntInsn(25, 0);
            ASMToolkit.invokeStatic(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(177);
        });
        this.updateMethod(METHOD_END, methodVisitor -> {
            methodVisitor.visitIntInsn(25, 0);
            methodVisitor.visitIntInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            ASMToolkit.invokeStatic(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_DURATION);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(0, 0);
        });
        this.updateMethod(METHOD_COMMIT, methodVisitor -> {
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.getInternalClassName(), METHOD_IS_ENABLED.getName(), METHOD_IS_ENABLED.getDescriptor(), false);
            Label l0 = new Label();
            methodVisitor.visitJumpInsn(154, l0);
            methodVisitor.visitInsn(177);
            methodVisitor.visitLabel(l0);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(148);
            Label durationalEvent = new Label();
            methodVisitor.visitJumpInsn(154, durationalEvent);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), false);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_START_TIME, "J");
            Label commit = new Label();
            methodVisitor.visitJumpInsn(167, commit);
            methodVisitor.visitLabel(durationalEvent);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitInsn(9);
            methodVisitor.visitInsn(148);
            methodVisitor.visitJumpInsn(154, commit);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(184, TYPE_EVENT_HANDLER.getInternalName(), METHOD_TIME_STAMP.getName(), METHOD_TIME_STAMP.getDescriptor(), false);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_START_TIME, "J");
            methodVisitor.visitInsn(101);
            methodVisitor.visitFieldInsn(181, this.getInternalClassName(), FIELD_DURATION, "J");
            methodVisitor.visitLabel(commit);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitMethodInsn(182, this.getInternalClassName(), METHOD_EVENT_SHOULD_COMMIT.getName(), METHOD_EVENT_SHOULD_COMMIT.getDescriptor(), false);
            Label end = new Label();
            methodVisitor.visitJumpInsn(153, end);
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(eventHandlerProxy));
            methodVisitor.visitTypeInsn(192, this.eventHandlerXInternalName);
            for (FieldInfo fi : this.fieldInfos) {
                methodVisitor.visitVarInsn(25, 0);
                methodVisitor.visitFieldInsn(180, fi.internalClassName, fi.fieldName, fi.fieldDescriptor);
            }
            methodVisitor.visitMethodInsn(182, this.eventHandlerXInternalName, this.writeMethod.getName(), this.writeMethod.getDescriptor(), false);
            methodVisitor.visitLabel(end);
            methodVisitor.visitFrame(3, 0, null, 0, null);
            methodVisitor.visitInsn(177);
            methodVisitor.visitEnd();
        });
        this.updateMethod(METHOD_EVENT_SHOULD_COMMIT, methodVisitor -> {
            Label fail = new Label();
            methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(eventHandlerProxy));
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitFieldInsn(180, this.getInternalClassName(), FIELD_DURATION, "J");
            ASMToolkit.invokeVirtual(methodVisitor, TYPE_EVENT_HANDLER.getInternalName(), METHOD_EVENT_HANDLER_SHOULD_COMMIT);
            methodVisitor.visitJumpInsn(153, fail);
            for (SettingInfo si : this.settingInfos) {
                methodVisitor.visitIntInsn(25, 0);
                methodVisitor.visitFieldInsn(178, this.getInternalClassName(), FIELD_EVENT_HANDLER, jdk.internal.org.objectweb.asm.Type.getDescriptor(eventHandlerProxy));
                methodVisitor.visitTypeInsn(192, this.eventHandlerXInternalName);
                methodVisitor.visitFieldInsn(180, this.eventHandlerXInternalName, si.fieldName, TYPE_SETTING_CONTROL.getDescriptor());
                methodVisitor.visitTypeInsn(192, si.internalSettingName);
                methodVisitor.visitMethodInsn(182, this.getInternalClassName(), si.methodName, "(" + si.settingDescriptor + ")Z", false);
                methodVisitor.visitJumpInsn(153, fail);
            }
            methodVisitor.visitInsn(4);
            methodVisitor.visitInsn(172);
            methodVisitor.visitLabel(fail);
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        });
    }

    private void makeUninstrumented() {
        this.updateExistingWithReturnFalse(METHOD_EVENT_SHOULD_COMMIT);
        this.updateExistingWithReturnFalse(METHOD_IS_ENABLED);
        this.updateExistingWithEmptyVoidMethod(METHOD_COMMIT);
        this.updateExistingWithEmptyVoidMethod(METHOD_BEGIN);
        this.updateExistingWithEmptyVoidMethod(METHOD_END);
    }

    private final void updateExistingWithEmptyVoidMethod(Method voidMethod) {
        this.updateMethod(voidMethod, methodVisitor -> methodVisitor.visitInsn(177));
    }

    private final void updateExistingWithReturnFalse(Method voidMethod) {
        this.updateMethod(voidMethod, methodVisitor -> {
            methodVisitor.visitInsn(3);
            methodVisitor.visitInsn(172);
        });
    }

    private MethodNode getMethodNode(Method method) {
        for (MethodNode m : this.classNode.methods) {
            if (!m.name.equals(method.getName()) || !m.desc.equals(method.getDescriptor())) continue;
            return m;
        }
        return null;
    }

    private final void updateMethod(Method method, Consumer<MethodVisitor> code) {
        MethodNode old = this.getMethodNode(method);
        int index = this.classNode.methods.indexOf(old);
        this.classNode.methods.remove(old);
        MethodVisitor mv = this.classNode.visitMethod(old.access, old.name, old.desc, null, null);
        mv.visitCode();
        code.accept(mv);
        mv.visitMaxs(0, 0);
        MethodNode newMethod = this.getMethodNode(method);
        this.classNode.methods.remove(newMethod);
        this.classNode.methods.add(index, newMethod);
    }

    public static Method makeWriteMethod(List<FieldInfo> fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (FieldInfo v : fields) {
            sb.append(v.fieldDescriptor);
        }
        sb.append(")V");
        return new Method("write", sb.toString());
    }

    private String getInternalClassName() {
        return this.classNode.name;
    }

    public List<SettingInfo> getSettingInfos() {
        return this.settingInfos;
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setGuardHandler(boolean guardHandlerReference) {
        this.guardHandlerReference = guardHandlerReference;
    }

    static final class FieldInfo {
        private static final jdk.internal.org.objectweb.asm.Type STRING = jdk.internal.org.objectweb.asm.Type.getType(String.class);
        final String fieldName;
        final String fieldDescriptor;
        final String internalClassName;

        public FieldInfo(String fieldName, String fieldDescriptor, String internalClassName) {
            this.fieldName = fieldName;
            this.fieldDescriptor = fieldDescriptor;
            this.internalClassName = internalClassName;
        }

        public boolean isString() {
            return STRING.getDescriptor().equals(this.fieldDescriptor);
        }
    }

    static final class SettingInfo {
        private String methodName;
        private String internalSettingName;
        private String settingDescriptor;
        final String fieldName;
        final int index;
        SettingControl settingControl;

        public SettingInfo(String fieldName, int index) {
            this.fieldName = fieldName;
            this.index = index;
        }
    }
}

