/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import jdk.jfr.internal.Bits;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.StringPool;
import sun.misc.Unsafe;

public final class EventWriter {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final JVM jvm = JVM.getJVM();
    private long startPosition;
    private long startPositionAddress;
    private long currentPosition;
    private long maxPosition;
    private final long threadID;
    private PlatformEventType eventType;
    private int maxEventSize;
    private boolean started;
    private boolean valid;
    private boolean flushOnEnd;
    boolean notified;

    public static EventWriter getEventWriter() {
        EventWriter ew = (EventWriter)JVM.getEventWriter();
        return ew != null ? ew : JVM.newEventWriter();
    }

    public void putBoolean(boolean i) {
        if (this.isValidForSize(1)) {
            this.currentPosition += (long)Bits.putBoolean(this.currentPosition, i);
        }
    }

    public void putByte(byte i) {
        if (this.isValidForSize(1)) {
            unsafe.putByte(this.currentPosition, i);
            ++this.currentPosition;
        }
    }

    public void putChar(char v) {
        if (this.isValidForSize(3)) {
            this.putUncheckedLong(v);
        }
    }

    private void putUncheckedChar(char v) {
        this.putUncheckedLong(v);
    }

    public void putShort(short v) {
        if (this.isValidForSize(3)) {
            this.putUncheckedLong(v & 0xFFFF);
        }
    }

    public void putInt(int v) {
        if (this.isValidForSize(5)) {
            this.putUncheckedLong((long)v & 0xFFFFFFFFL);
        }
    }

    private void putUncheckedInt(int v) {
        this.putUncheckedLong((long)v & 0xFFFFFFFFL);
    }

    public void putFloat(float i) {
        if (this.isValidForSize(4)) {
            this.currentPosition += (long)Bits.putFloat(this.currentPosition, i);
        }
    }

    public void putLong(long v) {
        if (this.isValidForSize(9)) {
            this.putUncheckedLong(v);
        }
    }

    public void putDouble(double i) {
        if (this.isValidForSize(8)) {
            this.currentPosition += (long)Bits.putDouble(this.currentPosition, i);
        }
    }

    public void putString(String s, StringPool pool) {
        long l;
        if (s == null) {
            this.putByte((byte)0);
            return;
        }
        int length = s.length();
        if (length == 0) {
            this.putByte((byte)1);
            return;
        }
        if (length > 16 && length < 128 && (l = StringPool.addString(s)) > 0L) {
            this.putByte((byte)2);
            this.putLong(l);
            return;
        }
        this.putStringValue(s);
    }

    private void putStringValue(String s) {
        int length = s.length();
        if (this.isValidForSize(6 + 3 * length)) {
            this.putUncheckedByte((byte)4);
            this.putUncheckedInt(length);
            for (int i = 0; i < length; ++i) {
                this.putUncheckedChar(s.charAt(i));
            }
        }
    }

    public void putEventThread() {
        this.putLong(this.threadID);
    }

    public void putThread(Thread athread) {
        if (athread == null) {
            this.putLong(0L);
        } else {
            this.putLong(jvm.getThreadId(athread));
        }
    }

    public void putClass(Class<?> aClass) {
        if (aClass == null) {
            this.putLong(0L);
        } else {
            this.putLong(JVM.getClassIdNonIntrinsic(aClass));
        }
    }

    public void putStackTrace() {
        if (this.eventType.getStackTraceEnabled()) {
            this.putLong(jvm.getStackTraceId(this.eventType.getStackTraceOffset()));
        } else {
            this.putLong(0L);
        }
    }

    private void reserveEventSizeField() {
        if (this.isValidForSize(4)) {
            this.currentPosition += 4L;
        }
    }

    private void reset() {
        this.currentPosition = this.startPosition;
        if (this.flushOnEnd) {
            this.flushOnEnd = this.flush();
        }
        this.valid = true;
        this.started = false;
    }

    private boolean isValidForSize(int requestedSize) {
        if (!this.valid) {
            return false;
        }
        if (this.currentPosition + (long)requestedSize > this.maxPosition) {
            this.flushOnEnd = this.flush(this.usedSize(), requestedSize);
            if (this.currentPosition + (long)requestedSize > this.maxPosition) {
                Logger.log(LogTag.JFR_SYSTEM, LogLevel.WARN, () -> "Unable to commit. Requested size " + requestedSize + " too large");
                this.valid = false;
                return false;
            }
        }
        return true;
    }

    private boolean isNotified() {
        return this.notified;
    }

    private void resetNotified() {
        this.notified = false;
    }

    private int usedSize() {
        return (int)(this.currentPosition - this.startPosition);
    }

    private boolean flush() {
        return this.flush(this.usedSize(), 0);
    }

    private boolean flush(int usedSize, int requestedSize) {
        return JVM.flush(this, usedSize, requestedSize);
    }

    public boolean beginEvent(PlatformEventType eventType) {
        if (this.started) {
            return false;
        }
        this.started = true;
        this.eventType = eventType;
        this.reserveEventSizeField();
        this.putLong(eventType.getId());
        return true;
    }

    public boolean endEvent() {
        if (!this.valid) {
            this.reset();
            return true;
        }
        int eventSize = this.usedSize();
        if (eventSize > this.maxEventSize) {
            this.reset();
            return true;
        }
        Bits.putInt(this.startPosition, EventWriter.makePaddedInt(eventSize));
        if (this.isNotified()) {
            this.resetNotified();
            this.reset();
            return false;
        }
        this.startPosition = this.currentPosition;
        unsafe.putAddress(this.startPositionAddress, this.startPosition);
        if (this.flushOnEnd) {
            this.flushOnEnd = this.flush();
        }
        this.started = false;
        return true;
    }

    private EventWriter(long startPos, long maxPos, long startPosAddress, long threadID, boolean valid) {
        this.startPosition = this.currentPosition = startPos;
        this.maxPosition = maxPos;
        this.startPositionAddress = startPosAddress;
        this.threadID = threadID;
        this.started = false;
        this.flushOnEnd = false;
        this.valid = valid;
        this.notified = false;
        this.maxEventSize = 0xFFFFFFF;
    }

    private static int makePaddedInt(int v) {
        long b1 = (v >>> 0 & 0x7F | 0x80) << 24;
        long b2 = (v >>> 7 & 0x7F | 0x80) << 16;
        long b3 = (v >>> 14 & 0x7F | 0x80) << 8;
        long b4 = (v >>> 21 & 0x7F) << 0;
        return (int)(b1 + b2 + b3 + b4);
    }

    private void putUncheckedLong(long v) {
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        if (((v >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.putUncheckedByte((byte)v);
            return;
        }
        this.putUncheckedByte((byte)(v | 0x80L));
        this.putUncheckedByte((byte)(v >>> 7));
    }

    private void putUncheckedByte(byte i) {
        unsafe.putByte(this.currentPosition, i);
        ++this.currentPosition;
    }
}

