/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.OldObjectSample;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;
import jdk.jfr.internal.jfc.JFC;

final class DCmdStart
extends AbstractDCmd {
    DCmdStart() {
    }

    public String execute(String name, String[] settings, Long delay, Long duration, Boolean disk, String path, Long maxAge, Long maxSize, Boolean dumpOnExit, Boolean pathToGcRoots) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdStart: name=" + name + ", settings=" + (settings != null ? Arrays.asList(settings) : "(none)") + ", delay=" + delay + ", duration=" + duration + ", disk=" + disk + ", filename=" + path + ", maxage=" + maxAge + ", maxsize=" + maxSize + ", dumponexit =" + dumpOnExit + ", path-to-gc-roots=" + pathToGcRoots);
        }
        if (name != null) {
            try {
                Integer.parseInt(name);
                throw new DCmdException("Name of recording can't be numeric", new Object[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (duration == null && Boolean.FALSE.equals(dumpOnExit) && path != null) {
            throw new DCmdException("Filename can only be set for a time bound recording or if dumponexit=true. Set duration/dumponexit or omit filename.", new Object[0]);
        }
        if (settings.length == 1 && settings[0].length() == 0) {
            throw new DCmdException("No settings specified. Use settings=none to start without any settings", new Object[0]);
        }
        HashMap<String, String> s = new HashMap<String, String>();
        for (String configName : settings) {
            try {
                s.putAll(JFC.createKnown(configName).getSettings());
            }
            catch (FileNotFoundException e) {
                throw new DCmdException("Could not find settings file'" + configName + "'", new Object[]{e});
            }
            catch (IOException | ParseException e) {
                throw new DCmdException("Could not parse settings file '" + settings[0] + "'", new Object[]{e});
            }
        }
        OldObjectSample.updateSettingPathToGcRoots(s, pathToGcRoots);
        if (duration != null && duration < 1000000000L) {
            throw new DCmdException("Could not start recording, duration must be at least 1 second.", new Object[0]);
        }
        if (delay != null && delay < 1000000000L) {
            throw new DCmdException("Could not start recording, delay must be at least 1 second.", new Object[0]);
        }
        if (!FlightRecorder.isInitialized() && delay == null) {
            this.initializeWithForcedInstrumentation(s);
        }
        Recording recording = new Recording();
        if (name != null) {
            recording.setName(name);
        }
        if (disk != null) {
            recording.setToDisk(disk);
        }
        recording.setSettings(s);
        SecuritySupport.SafePath safePath = null;
        if (path != null) {
            try {
                Path p;
                if (dumpOnExit == null) {
                    dumpOnExit = Boolean.TRUE;
                }
                if (Files.isDirectory(p = Paths.get(path, new String[0]), new LinkOption[0]) && Boolean.TRUE.equals(dumpOnExit)) {
                    PrivateAccess.getInstance().getPlatformRecording(recording).setDumpOnExitDirectory(new SecuritySupport.SafePath(p));
                } else {
                    safePath = this.resolvePath(recording, path);
                    recording.setDestination(safePath.toPath());
                }
            }
            catch (IOException | InvalidPathException e) {
                recording.close();
                throw new DCmdException("Could not start recording, not able to write to file %s. %s ", path, e.getMessage());
            }
        }
        if (maxAge != null) {
            recording.setMaxAge(Duration.ofNanos(maxAge));
        }
        if (maxSize != null) {
            recording.setMaxSize(maxSize);
        }
        if (duration != null) {
            recording.setDuration(Duration.ofNanos(duration));
        }
        if (dumpOnExit != null) {
            recording.setDumpOnExit(dumpOnExit);
        }
        if (delay != null) {
            Duration dDelay = Duration.ofNanos(delay);
            recording.scheduleStart(dDelay);
            this.print("Recording " + recording.getId() + " scheduled to start in ");
            this.printTimespan(dDelay, " ");
            this.print(".");
        } else {
            recording.start();
            this.print("Started recording " + recording.getId() + ".");
        }
        if (recording.isToDisk() && duration == null && maxAge == null && maxSize == null) {
            this.print(" No limit specified, using maxsize=250MB as default.");
            recording.setMaxSize(0xFA00000L);
        }
        if (safePath != null && duration != null) {
            this.println(" The result will be written to:", new Object[0]);
            this.println();
            this.printPath(safePath);
        } else {
            this.println();
            this.println();
            String cmd = duration == null ? "dump" : "stop";
            String fileOption = path == null ? "filename=FILEPATH " : "";
            String recordingspecifier = "name=" + recording.getId();
            if (name != null) {
                recordingspecifier = "name=" + DCmdStart.quoteIfNeeded(name);
            }
            this.print("Use jcmd " + this.getPid() + " JFR." + cmd + " " + recordingspecifier + " " + fileOption + "to copy recording data to file.");
            this.println();
        }
        return this.getResult();
    }

    private void initializeWithForcedInstrumentation(Map<String, String> settings) {
        if (!this.hasJDKEvents(settings)) {
            return;
        }
        JVM jvm = JVM.getJVM();
        try {
            jvm.setForceInstrumentation(true);
            FlightRecorder.getFlightRecorder();
        }
        finally {
            jvm.setForceInstrumentation(false);
        }
    }

    private boolean hasJDKEvents(Map<String, String> settings) {
        String[] eventNames = new String[]{"FileRead", "FileWrite", "SocketRead", "SocketWrite", "JavaErrorThrow", "JavaExceptionThrow", "FileForce"};
        for (String eventName : eventNames) {
            if (!"true".equals(settings.get("jdk." + eventName + "#enabled"))) continue;
            return true;
        }
        return false;
    }
}

