/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Help
extends Command {
    Help() {
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("[<command>]");
    }

    @Override
    protected List<String> getAliases() {
        return Arrays.asList("--help", "-h", "-?");
    }

    @Override
    public void displayOptionUsage(PrintStream stream) {
        this.println("  <command>   The name of the command to get help for");
    }

    @Override
    public String getDescription() {
        return "Display all available commands, or help about a specific command";
    }

    @Override
    public void execute(Deque<String> options) throws UserSyntaxException, UserDataException {
        if (options.isEmpty()) {
            Command.displayHelp();
            return;
        }
        this.ensureMaxArgumentCount(options, 1);
        String commandName = options.remove();
        Command c = Command.valueOf(commandName);
        if (c == null) {
            throw new UserDataException("unknown command '" + commandName + "'");
        }
        this.println(c.getTitle());
        this.println();
        c.displayUsage(System.out);
    }
}

