/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.PropMap;
import com.sun.java.util.jar.pack.UnpackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

class NativeUnpack {
    private long unpackerPtr;
    private BufferedInputStream in;
    private int _verbose;
    private long _byteCount;
    private int _segCount;
    private int _fileCount;
    private long _estByteLimit;
    private int _estSegLimit;
    private int _estFileLimit;
    private int _prevPercent = -1;
    private final CRC32 _crc32 = new CRC32();
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private byte[] _buf = new byte[16384];
    private List<byte[]> _extra_buf = new LinkedList<byte[]>();
    private byte[] _current_buf;
    private int _current_buf_pos;
    private UnpackerImpl _p200;
    private PropMap _props;

    private static synchronized native void initIDs();

    private synchronized native long start(ByteBuffer var1, long var2);

    private synchronized native boolean getNextFile(Object[] var1);

    private synchronized native ByteBuffer getUnusedInput();

    synchronized native long finish();

    protected synchronized native boolean setOption(String var1, String var2);

    protected synchronized native String getOption(String var1);

    NativeUnpack(UnpackerImpl p200) {
        this._p200 = p200;
        this._props = p200.props;
        p200._nunp = this;
    }

    private static Object currentInstance() {
        UnpackerImpl p200 = (UnpackerImpl)Utils.getTLGlobals();
        return p200 == null ? null : p200._nunp;
    }

    private synchronized long getUnpackerPtr() {
        return this.unpackerPtr;
    }

    private long readInputFn(ByteBuffer pbuf, long minlen) throws IOException {
        if (this.in == null) {
            return 0L;
        }
        long maxlen = pbuf.capacity() - pbuf.position();
        assert (minlen <= maxlen);
        long numread = 0L;
        int steps = 0;
        while (numread < minlen) {
            int nr;
            ++steps;
            int readlen = this._buf.length;
            if ((long)readlen > maxlen - numread) {
                readlen = (int)(maxlen - numread);
            }
            if ((nr = this.in.read(this._buf, 0, readlen)) <= 0) break;
            assert ((numread += (long)nr) <= maxlen);
            pbuf.put(this._buf, 0, nr);
        }
        if (this._verbose > 1) {
            Utils.log.fine("readInputFn(" + minlen + "," + maxlen + ") => " + numread + " steps=" + steps);
        }
        this._estByteLimit = maxlen > 100L ? this._byteCount + maxlen : (this._byteCount + numread) * 20L;
        this._byteCount += numread;
        this.updateProgress();
        return numread;
    }

    private void updateProgress() {
        double READ_WT = 0.33;
        double WRITE_WT = 0.67;
        double readProgress = this._segCount;
        if (this._estByteLimit > 0L && this._byteCount > 0L) {
            readProgress += (double)this._byteCount / (double)this._estByteLimit;
        }
        double writeProgress = this._fileCount;
        double scaledProgress = 0.33 * readProgress / (double)Math.max(this._estSegLimit, 1) + 0.67 * writeProgress / (double)Math.max(this._estFileLimit, 1);
        int percent = (int)Math.round(100.0 * scaledProgress);
        if (percent > 100) {
            percent = 100;
        }
        if (percent > this._prevPercent) {
            this._prevPercent = percent;
            this._props.setInteger("unpack.progress", percent);
            if (this._verbose > 0) {
                Utils.log.info("progress = " + percent);
            }
        }
    }

    private void copyInOption(String opt) {
        boolean set;
        String val = this._props.getProperty(opt);
        if (this._verbose > 0) {
            Utils.log.info("set " + opt + "=" + val);
        }
        if (val != null && !(set = this.setOption(opt, val))) {
            Utils.log.warning("Invalid option " + opt + "=" + val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(InputStream inRaw, JarOutputStream jstream, ByteBuffer presetInput) throws IOException {
        BufferedInputStream in0;
        this.in = in0 = new BufferedInputStream(inRaw);
        this._verbose = this._props.getInteger("com.sun.java.util.jar.pack.verbose");
        int modtime = "keep".equals(this._props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "0")) ? 0 : this._props.getTime("com.sun.java.util.jar.pack.unpack.modification.time");
        this.copyInOption("com.sun.java.util.jar.pack.verbose");
        this.copyInOption("unpack.deflate.hint");
        if (modtime == 0) {
            this.copyInOption("com.sun.java.util.jar.pack.unpack.modification.time");
        }
        this.updateProgress();
        while (true) {
            long consumed;
            long counts = this.start(presetInput, 0L);
            try {
                this._estByteLimit = 0L;
                this._byteCount = 0L;
                ++this._segCount;
                int nextSeg = (int)(counts >>> 32);
                int nextFile = (int)(counts >>> 0);
                this._estSegLimit = this._segCount + nextSeg;
                double filesAfterThisSeg = this._fileCount + nextFile;
                this._estFileLimit = (int)(filesAfterThisSeg * (double)this._estSegLimit / (double)this._segCount);
                int[] intParts = new int[]{0, 0, 0, 0};
                Object[] parts = new Object[]{intParts, null, null, null};
                while (this.getNextFile(parts)) {
                    String name = (String)parts[1];
                    long size = ((long)intParts[0] << 32) + ((long)intParts[1] << 32 >>> 32);
                    long mtime = modtime != 0 ? (long)modtime : (long)intParts[2];
                    boolean deflateHint = intParts[3] != 0;
                    ByteBuffer data0 = (ByteBuffer)parts[2];
                    ByteBuffer data1 = (ByteBuffer)parts[3];
                    this.writeEntry(jstream, name, mtime, size, deflateHint, data0, data1);
                    ++this._fileCount;
                    this.updateProgress();
                }
                presetInput = this.getUnusedInput();
            }
            finally {
                consumed = this.finish();
            }
            if (this._verbose > 0) {
                Utils.log.info("bytes consumed = " + consumed);
            }
            if (presetInput == null && !Utils.isPackMagic(Utils.readMagic(in0))) break;
            if (this._verbose <= 0 || presetInput == null) continue;
            Utils.log.info("unused input = " + presetInput);
        }
    }

    void run(InputStream in, JarOutputStream jstream) throws IOException {
        this.run(in, jstream, null);
    }

    void run(File inFile, JarOutputStream jstream) throws IOException {
        ByteBuffer mappedFile = null;
        try (FileInputStream fis = new FileInputStream(inFile);){
            this.run(fis, jstream, mappedFile);
        }
    }

    private void writeEntry(JarOutputStream j, String name, long mtime, long lsize, boolean deflateHint, ByteBuffer data0, ByteBuffer data1) throws IOException {
        if (lsize < 0L || lsize > Integer.MAX_VALUE) {
            throw new IOException("file too large: " + lsize);
        }
        int size = (int)lsize;
        if (this._verbose > 1) {
            Utils.log.fine("Writing entry: " + name + " size=" + size + (deflateHint ? " deflated" : ""));
        }
        ZipEntry z = new ZipEntry(name);
        z.setTime(mtime * 1000L);
        z.setSize(size);
        if (size == 0) {
            z.setMethod(0);
            z.setCompressedSize(size);
            z.setCrc(0L);
            j.putNextEntry(z);
        } else if (!deflateHint) {
            z.setMethod(0);
            z.setCompressedSize(size);
            this.writeEntryData(j, z, data0, data1, size, true);
        } else {
            z.setMethod(8);
            this.writeEntryData(j, z, data0, data1, size, false);
        }
        j.closeEntry();
        if (this._verbose > 0) {
            Utils.log.info("Writing " + Utils.zeString(z));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEntryData(JarOutputStream j, ZipEntry z, ByteBuffer data0, ByteBuffer data1, int size, boolean computeCrc32) throws IOException {
        this.prepareReadBuffers(size);
        try {
            int inBytes = size;
            inBytes -= this.readDataByteBuffer(data0);
            inBytes -= this.readDataByteBuffer(data1);
            inBytes -= this.readDataInputStream(inBytes);
            if ((long)inBytes != 0L) {
                throw new IOException("invalid size: " + size);
            }
            if (computeCrc32) {
                this._crc32.reset();
                this.processReadData((buff, offset, len) -> this._crc32.update(buff, offset, len));
                z.setCrc(this._crc32.getValue());
            }
            j.putNextEntry(z);
            this.processReadData((buff, offset, len) -> j.write(buff, offset, len));
        }
        finally {
            this.resetReadBuffers();
        }
    }

    private void prepareReadBuffers(int size) {
        if (this._buf.length < size && this._buf.length < 0x100000) {
            long newIdealSize;
            for (newIdealSize = (long)this._buf.length; newIdealSize < (long)size && newIdealSize < 0x100000L; newIdealSize <<= 1) {
            }
            int newSize = (int)Long.min(newIdealSize, 0x100000L);
            this._buf = new byte[newSize];
        }
        this.resetReadBuffers();
    }

    private void resetReadBuffers() {
        this._extra_buf.clear();
        this._current_buf = this._buf;
        this._current_buf_pos = 0;
    }

    private int readDataByteBuffer(ByteBuffer data) throws IOException {
        if (data == null) {
            return 0;
        }
        return this.readData(data.remaining(), (buff, offset, len) -> {
            data.get(buff, offset, len);
            return len;
        });
    }

    private int readDataInputStream(int inBytes) throws IOException {
        return this.readData(inBytes, (buff, offset, len) -> this.in.read(buff, offset, len));
    }

    private int readData(int bytesToRead, ReadDataCB readDataCb) throws IOException {
        int bytesRemaining;
        int bytesRead;
        for (bytesRemaining = bytesToRead; bytesRemaining > 0; bytesRemaining -= bytesRead) {
            int current_buffer_space;
            int nextRead;
            if (this._current_buf_pos == this._current_buf.length) {
                byte[] newBuff = new byte[Integer.min(bytesRemaining, 0x100000)];
                this._extra_buf.add(newBuff);
                this._current_buf = newBuff;
                this._current_buf_pos = 0;
            }
            if ((bytesRead = readDataCb.read(this._current_buf, this._current_buf_pos, nextRead = Integer.min(current_buffer_space = this._current_buf.length - this._current_buf_pos, bytesRemaining))) <= 0) {
                throw new IOException("EOF at end of archive");
            }
            this._current_buf_pos += bytesRead;
        }
        return bytesToRead - bytesRemaining;
    }

    private void processReadData(ProcessDataCB processDataCB) throws IOException {
        processDataCB.apply(this._buf, 0, this._buf == this._current_buf ? this._current_buf_pos : this._buf.length);
        for (byte[] buff : this._extra_buf) {
            processDataCB.apply(buff, 0, buff.length);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("unpack");
                return null;
            }
        });
        NativeUnpack.initIDs();
    }

    private static interface ProcessDataCB {
        public void apply(byte[] var1, int var2, int var3) throws IOException;
    }

    private static interface ReadDataCB {
        public int read(byte[] var1, int var2, int var3) throws IOException;
    }
}

