/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.ClassReader;
import com.sun.java.util.jar.pack.Constants;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageWriter;
import com.sun.java.util.jar.pack.TLGlobals;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Pack200;

public class PackerImpl
extends TLGlobals
implements Pack200.Packer {
    @Override
    public SortedMap<String, String> properties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pack(JarFile in, OutputStream out) throws IOException {
        assert (Utils.currentInstance.get() == null);
        boolean needUTC = !this.props.getBoolean("com.sun.java.util.jar.pack.default.timezone");
        try {
            Utils.currentInstance.set(this);
            if (needUTC) {
                Utils.changeDefaultTimeZoneToUtc();
            }
            if ("0".equals(this.props.getProperty("pack.effort"))) {
                Utils.copyJarFile(in, out);
            } else {
                new DoPack().run(in, out);
            }
        }
        finally {
            Utils.currentInstance.set(null);
            if (needUTC) {
                Utils.restoreDefaultTimeZone();
            }
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void pack(JarInputStream in, OutputStream out) throws IOException {
        assert (Utils.currentInstance.get() == null);
        boolean needUTC = !this.props.getBoolean("com.sun.java.util.jar.pack.default.timezone");
        try {
            Utils.currentInstance.set(this);
            if (needUTC) {
                Utils.changeDefaultTimeZoneToUtc();
            }
            if ("0".equals(this.props.getProperty("pack.effort"))) {
                Utils.copyJarFile(in, out);
            } else {
                new DoPack().run(in, out);
            }
        }
        finally {
            Utils.currentInstance.set(null);
            if (needUTC) {
                Utils.restoreDefaultTimeZone();
            }
            in.close();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.props.addListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.props.removeListener(listener);
    }

    private class DoPack {
        final int verbose;
        final Package pkg;
        final String unknownAttrCommand;
        final String classFormatCommand;
        final Map<Attribute.Layout, Attribute> attrDefs;
        final Map<Attribute.Layout, String> attrCommands;
        final boolean keepFileOrder;
        final boolean keepClassOrder;
        final boolean keepModtime;
        final boolean latestModtime;
        final boolean keepDeflateHint;
        long totalOutputSize;
        int segmentCount;
        long segmentTotalSize;
        long segmentSize;
        final long segmentLimit;
        final List<String> passFiles;
        private int nread;

        private DoPack() {
            int opt;
            boolean deflate_hint;
            int modtime;
            this.verbose = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.verbose");
            PackerImpl.this.props.setInteger("pack.progress", 0);
            if (this.verbose > 0) {
                Utils.log.info(PackerImpl.this.props.toString());
            }
            this.pkg = new Package(Package.Version.makeVersion(PackerImpl.this.props, "min.class"), Package.Version.makeVersion(PackerImpl.this.props, "max.class"), Package.Version.makeVersion(PackerImpl.this.props, "package"));
            String uaMode = PackerImpl.this.props.getProperty("pack.unknown.attribute", "pass");
            if (!("strip".equals(uaMode) || "pass".equals(uaMode) || "error".equals(uaMode))) {
                throw new RuntimeException("Bad option: pack.unknown.attribute = " + uaMode);
            }
            this.unknownAttrCommand = uaMode.intern();
            String fmtMode = PackerImpl.this.props.getProperty("com.sun.java.util.jar.pack.class.format.error", "pass");
            if (!"pass".equals(fmtMode) && !"error".equals(fmtMode)) {
                throw new RuntimeException("Bad option: com.sun.java.util.jar.pack.class.format.error = " + fmtMode);
            }
            this.classFormatCommand = fmtMode.intern();
            HashMap<Attribute.Layout, Attribute> lattrDefs = new HashMap<Attribute.Layout, Attribute>();
            HashMap<Attribute.Layout, String> lattrCommands = new HashMap<Attribute.Layout, String>();
            String[] keys = new String[]{"pack.class.attribute.", "pack.field.attribute.", "pack.method.attribute.", "pack.code.attribute."};
            int[] ctypes = new int[]{0, 1, 2, 3};
            for (int i = 0; i < ctypes.length; ++i) {
                String pfx = keys[i];
                SortedMap<String, String> map = PackerImpl.this.props.prefixMap(pfx);
                for (String key : map.keySet()) {
                    assert (key.startsWith(pfx));
                    String name = key.substring(pfx.length());
                    String layout = PackerImpl.this.props.getProperty(key);
                    Attribute.Layout lkey = Attribute.keyForLookup(ctypes[i], name);
                    if ("strip".equals(layout) || "pass".equals(layout) || "error".equals(layout)) {
                        lattrCommands.put(lkey, layout.intern());
                        continue;
                    }
                    Attribute.define(lattrDefs, ctypes[i], name, layout);
                    if (this.verbose > 1) {
                        Utils.log.fine("Added layout for " + Constants.ATTR_CONTEXT_NAME[i] + " attribute " + name + " = " + layout);
                    }
                    assert (lattrDefs.containsKey(lkey));
                }
            }
            this.attrDefs = lattrDefs.isEmpty() ? null : lattrDefs;
            this.attrCommands = lattrCommands.isEmpty() ? null : lattrCommands;
            this.keepFileOrder = PackerImpl.this.props.getBoolean("pack.keep.file.order");
            this.keepClassOrder = PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.keep.class.order");
            this.keepModtime = "keep".equals(PackerImpl.this.props.getProperty("pack.modification.time"));
            this.latestModtime = "latest".equals(PackerImpl.this.props.getProperty("pack.modification.time"));
            this.keepDeflateHint = "keep".equals(PackerImpl.this.props.getProperty("pack.deflate.hint"));
            if (!this.keepModtime && !this.latestModtime && (modtime = PackerImpl.this.props.getTime("pack.modification.time")) != 0) {
                this.pkg.default_modtime = modtime;
            }
            if (!this.keepDeflateHint && (deflate_hint = PackerImpl.this.props.getBoolean("pack.deflate.hint"))) {
                this.pkg.default_options |= 0x20;
            }
            this.totalOutputSize = 0L;
            this.segmentCount = 0;
            this.segmentTotalSize = 0L;
            this.segmentSize = 0L;
            long limit = PackerImpl.this.props.getProperty("pack.segment.limit", "").equals("") ? -1L : PackerImpl.this.props.getLong("pack.segment.limit");
            limit = Math.min(Integer.MAX_VALUE, limit);
            if ((limit = Math.max(-1L, limit)) == -1L) {
                limit = Long.MAX_VALUE;
            }
            this.segmentLimit = limit;
            this.passFiles = PackerImpl.this.props.getProperties("pack.pass.file.");
            ListIterator<String> i = this.passFiles.listIterator();
            while (i.hasNext()) {
                String file = i.next();
                if (file == null) {
                    i.remove();
                    continue;
                }
                if ((file = Utils.getJarEntryName(file)).endsWith("/")) {
                    file = file.substring(0, file.length() - 1);
                }
                i.set(file);
            }
            if (this.verbose > 0) {
                Utils.log.info("passFiles = " + this.passFiles);
            }
            if ((opt = PackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.archive.options")) != 0) {
                this.pkg.default_options |= opt;
            }
            this.nread = 0;
        }

        boolean isClassFile(String name) {
            if (!name.endsWith(".class")) {
                return false;
            }
            String prefix = name;
            while (true) {
                if (this.passFiles.contains(prefix)) {
                    return false;
                }
                int chop = prefix.lastIndexOf(47);
                if (chop < 0) break;
                prefix = prefix.substring(0, chop);
            }
            return true;
        }

        boolean isMetaInfFile(String name) {
            return name.startsWith("/META-INF") || name.startsWith("META-INF");
        }

        private void makeNextPackage() {
            this.pkg.reset();
        }

        private void noteRead(InFile f) {
            ++this.nread;
            if (this.verbose > 2) {
                Utils.log.fine("...read " + f.name);
            }
            if (this.verbose > 0 && this.nread % 1000 == 0) {
                Utils.log.info("Have read " + this.nread + " files...");
            }
        }

        void run(JarInputStream in, OutputStream out) throws IOException {
            JarEntry je;
            if (in.getManifest() != null) {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                in.getManifest().write(tmp);
                ByteArrayInputStream tmpIn = new ByteArrayInputStream(tmp.toByteArray());
                this.pkg.addFile(this.readFile("META-INF/MANIFEST.MF", tmpIn));
            }
            while ((je = in.getNextJarEntry()) != null) {
                long inflen;
                InFile inFile = new InFile(je);
                String name = inFile.name;
                Package.File bits = this.readFile(name, in);
                Package.File file = null;
                long l = inflen = this.isMetaInfFile(name) ? 0L : inFile.getInputLength();
                if ((this.segmentSize += inflen) > this.segmentLimit) {
                    this.segmentSize -= inflen;
                    int nextCount = -1;
                    this.flushPartial(out, nextCount);
                }
                if (this.verbose > 1) {
                    Utils.log.fine("Reading " + name);
                }
                assert (je.isDirectory() == name.endsWith("/"));
                if (this.isClassFile(name)) {
                    file = this.readClass(name, bits.getInputStream());
                }
                if (file == null) {
                    file = bits;
                    this.pkg.addFile(file);
                }
                inFile.copyTo(file);
                this.noteRead(inFile);
            }
            this.flushAll(out);
        }

        void run(JarFile in, OutputStream out) throws IOException {
            List<InFile> inFiles = this.scanJar(in);
            if (this.verbose > 0) {
                Utils.log.info("Reading " + inFiles.size() + " files...");
            }
            int numDone = 0;
            for (InFile inFile : inFiles) {
                long inflen;
                String name = inFile.name;
                long l = inflen = this.isMetaInfFile(name) ? 0L : inFile.getInputLength();
                if ((this.segmentSize += inflen) > this.segmentLimit) {
                    this.segmentSize -= inflen;
                    float filesDone = numDone + 1;
                    float segsDone = this.segmentCount + 1;
                    float filesToDo = (float)inFiles.size() - filesDone;
                    float segsToDo = filesToDo * (segsDone / filesDone);
                    if (this.verbose > 1) {
                        Utils.log.fine("Estimated segments to do: " + segsToDo);
                    }
                    this.flushPartial(out, (int)Math.ceil(segsToDo));
                }
                InputStream strm = inFile.getInputStream();
                if (this.verbose > 1) {
                    Utils.log.fine("Reading " + name);
                }
                Package.File file = null;
                if (this.isClassFile(name) && (file = this.readClass(name, strm)) == null) {
                    strm.close();
                    strm = inFile.getInputStream();
                }
                if (file == null) {
                    file = this.readFile(name, strm);
                    this.pkg.addFile(file);
                }
                inFile.copyTo(file);
                strm.close();
                this.noteRead(inFile);
                ++numDone;
            }
            this.flushAll(out);
        }

        Package.File readClass(String fname, InputStream in) throws IOException {
            Package package_ = this.pkg;
            package_.getClass();
            Package.Class cls = package_.new Package.Class(fname);
            in = new BufferedInputStream(in);
            ClassReader reader = new ClassReader(cls, in);
            reader.setAttrDefs(this.attrDefs);
            reader.setAttrCommands(this.attrCommands);
            reader.unknownAttrCommand = this.unknownAttrCommand;
            try {
                reader.read();
            }
            catch (IOException ioe) {
                String message = "Passing class file uncompressed due to";
                if (ioe instanceof Attribute.FormatException) {
                    Attribute.FormatException ee = (Attribute.FormatException)ioe;
                    if (ee.layout.equals("pass")) {
                        Utils.log.info(ee.toString());
                        Utils.log.warning(message + " unrecognized attribute: " + fname);
                        return null;
                    }
                } else if (ioe instanceof ClassReader.ClassFormatException) {
                    ClassReader.ClassFormatException ce = (ClassReader.ClassFormatException)ioe;
                    if (this.classFormatCommand.equals("pass")) {
                        Utils.log.info(ce.toString());
                        Utils.log.warning(message + " unknown class format: " + fname);
                        return null;
                    }
                }
                throw ioe;
            }
            this.pkg.addClass(cls);
            return cls.file;
        }

        Package.File readFile(String fname, InputStream in) throws IOException {
            Package package_ = this.pkg;
            package_.getClass();
            Package.File file = package_.new Package.File(fname);
            file.readFrom(in);
            if (file.isDirectory() && file.getFileLength() != 0L) {
                throw new IllegalArgumentException("Non-empty directory: " + file.getFileName());
            }
            return file;
        }

        void flushPartial(OutputStream out, int nextCount) throws IOException {
            if (this.pkg.files.isEmpty() && this.pkg.classes.isEmpty()) {
                return;
            }
            this.flushPackage(out, Math.max(1, nextCount));
            PackerImpl.this.props.setInteger("pack.progress", 25);
            this.makeNextPackage();
            ++this.segmentCount;
            this.segmentTotalSize += this.segmentSize;
            this.segmentSize = 0L;
        }

        void flushAll(OutputStream out) throws IOException {
            PackerImpl.this.props.setInteger("pack.progress", 50);
            this.flushPackage(out, 0);
            out.flush();
            PackerImpl.this.props.setInteger("pack.progress", 100);
            ++this.segmentCount;
            this.segmentTotalSize += this.segmentSize;
            this.segmentSize = 0L;
            if (this.verbose > 0 && this.segmentCount > 1) {
                Utils.log.info("Transmitted " + this.segmentTotalSize + " input bytes in " + this.segmentCount + " segments totaling " + this.totalOutputSize + " bytes");
            }
        }

        void flushPackage(OutputStream out, int nextCount) throws IOException {
            int nfiles = this.pkg.files.size();
            if (!this.keepFileOrder) {
                if (this.verbose > 1) {
                    Utils.log.fine("Reordering files.");
                }
                boolean stripDirectories = true;
                this.pkg.reorderFiles(this.keepClassOrder, stripDirectories);
            } else {
                assert (this.pkg.files.containsAll(this.pkg.getClassStubs()));
                ArrayList<Package.File> res = this.pkg.files;
                if ($assertionsDisabled || !(res = new ArrayList<Package.File>(this.pkg.files)).retainAll(this.pkg.getClassStubs())) {
                    // empty if block
                }
                assert (res.equals(this.pkg.getClassStubs()));
            }
            this.pkg.trimStubs();
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.debug")) {
                this.pkg.stripAttributeKind("Debug");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.compile")) {
                this.pkg.stripAttributeKind("Compile");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.constants")) {
                this.pkg.stripAttributeKind("Constant");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.exceptions")) {
                this.pkg.stripAttributeKind("Exceptions");
            }
            if (PackerImpl.this.props.getBoolean("com.sun.java.util.jar.pack.strip.innerclasses")) {
                this.pkg.stripAttributeKind("InnerClasses");
            }
            PackageWriter pw = new PackageWriter(this.pkg, out);
            pw.archiveNextCount = nextCount;
            pw.write();
            out.flush();
            if (this.verbose > 0) {
                long outSize = pw.archiveSize0 + pw.archiveSize1;
                this.totalOutputSize += outSize;
                long inSize = this.segmentSize;
                Utils.log.info("Transmitted " + nfiles + " files of " + inSize + " input bytes in a segment of " + outSize + " bytes");
            }
        }

        List<InFile> scanJar(JarFile jf) throws IOException {
            ArrayList<InFile> inFiles = new ArrayList<InFile>();
            try {
                for (JarEntry je : Collections.list(jf.entries())) {
                    InFile inFile = new InFile(jf, je);
                    assert (je.isDirectory() == inFile.name.endsWith("/"));
                    inFiles.add(inFile);
                }
            }
            catch (IllegalStateException ise) {
                throw new IOException(ise.getLocalizedMessage(), ise);
            }
            return inFiles;
        }

        final class InFile {
            final String name;
            final JarFile jf;
            final JarEntry je;
            final File f;
            int modtime = 0;
            int options;

            InFile(String name) {
                this.name = Utils.getJarEntryName(name);
                this.f = new File(name);
                this.jf = null;
                this.je = null;
                int timeSecs = this.getModtime(this.f.lastModified());
                if (DoPack.this.keepModtime && timeSecs != 0) {
                    this.modtime = timeSecs;
                } else if (DoPack.this.latestModtime && timeSecs > DoPack.this.pkg.default_modtime) {
                    DoPack.this.pkg.default_modtime = timeSecs;
                }
            }

            InFile(JarFile jf, JarEntry je) {
                this.name = Utils.getJarEntryName(je.getName());
                this.f = null;
                this.jf = jf;
                this.je = je;
                int timeSecs = this.getModtime(je.getTime());
                if (DoPack.this.keepModtime && timeSecs != 0) {
                    this.modtime = timeSecs;
                } else if (DoPack.this.latestModtime && timeSecs > DoPack.this.pkg.default_modtime) {
                    DoPack.this.pkg.default_modtime = timeSecs;
                }
                if (DoPack.this.keepDeflateHint && je.getMethod() == 8) {
                    this.options |= 1;
                }
            }

            InFile(JarEntry je) {
                this(null, je);
            }

            long getInputLength() {
                long len;
                long l = len = this.je != null ? this.je.getSize() : this.f.length();
                assert (len >= 0L) : this + ".len=" + len;
                return Math.max(0L, len) + (long)this.name.length() + 5L;
            }

            int getModtime(long timeMillis) {
                long seconds = (timeMillis + 500L) / 1000L;
                if ((long)((int)seconds) == seconds) {
                    return (int)seconds;
                }
                Utils.log.warning("overflow in modtime for " + this.f);
                return 0;
            }

            void copyTo(Package.File file) {
                if (this.modtime != 0) {
                    file.modtime = this.modtime;
                }
                file.options |= this.options;
            }

            InputStream getInputStream() throws IOException {
                if (this.jf != null) {
                    return this.jf.getInputStream(this.je);
                }
                return new FileInputStream(this.f);
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

