/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.DefaultMXBeanMappingFactory;
import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.MXBeanMapping;
import com.sun.jmx.mbeanserver.MXBeanMappingFactory;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import sun.reflect.misc.MethodUtil;

final class ConvertingMethod {
    private static final String[] noStrings = new String[0];
    private final Method method;
    private final MXBeanMapping returnMapping;
    private final MXBeanMapping[] paramMappings;
    private final boolean paramConversionIsIdentity;

    static ConvertingMethod from(Method m) {
        try {
            return new ConvertingMethod(m);
        }
        catch (OpenDataException ode) {
            String msg = "Method " + m.getDeclaringClass().getName() + "." + m.getName() + " has parameter or return type that cannot be translated into an open type";
            throw new IllegalArgumentException(msg, ode);
        }
    }

    Method getMethod() {
        return this.method;
    }

    Descriptor getDescriptor() {
        return Introspector.descriptorForElement(this.method);
    }

    Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    String getName() {
        return this.method.getName();
    }

    OpenType<?> getOpenReturnType() {
        return this.returnMapping.getOpenType();
    }

    OpenType<?>[] getOpenParameterTypes() {
        OpenType[] types = new OpenType[this.paramMappings.length];
        for (int i = 0; i < this.paramMappings.length; ++i) {
            types[i] = this.paramMappings[i].getOpenType();
        }
        return types;
    }

    void checkCallFromOpen() {
        try {
            for (MXBeanMapping paramConverter : this.paramMappings) {
                paramConverter.checkReconstructible();
            }
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    void checkCallToOpen() {
        try {
            this.returnMapping.checkReconstructible();
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    String[] getOpenSignature() {
        if (this.paramMappings.length == 0) {
            return noStrings;
        }
        String[] sig = new String[this.paramMappings.length];
        for (int i = 0; i < this.paramMappings.length; ++i) {
            sig[i] = this.paramMappings[i].getOpenClass().getName();
        }
        return sig;
    }

    final Object toOpenReturnValue(MXBeanLookup lookup, Object ret) throws OpenDataException {
        return this.returnMapping.toOpenValue(ret);
    }

    final Object fromOpenReturnValue(MXBeanLookup lookup, Object ret) throws InvalidObjectException {
        return this.returnMapping.fromOpenValue(ret);
    }

    final Object[] toOpenParameters(MXBeanLookup lookup, Object[] params) throws OpenDataException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] oparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            oparams[i] = this.paramMappings[i].toOpenValue(params[i]);
        }
        return oparams;
    }

    final Object[] fromOpenParameters(Object[] params) throws InvalidObjectException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] jparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            jparams[i] = this.paramMappings[i].fromOpenValue(params[i]);
        }
        return jparams;
    }

    final Object toOpenParameter(MXBeanLookup lookup, Object param, int paramNo) throws OpenDataException {
        return this.paramMappings[paramNo].toOpenValue(param);
    }

    final Object fromOpenParameter(MXBeanLookup lookup, Object param, int paramNo) throws InvalidObjectException {
        return this.paramMappings[paramNo].fromOpenValue(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invokeWithOpenReturn(MXBeanLookup lookup, Object obj, Object[] params) throws MBeanException, IllegalAccessException, InvocationTargetException {
        MXBeanLookup old = MXBeanLookup.getLookup();
        try {
            MXBeanLookup.setLookup(lookup);
            Object object = this.invokeWithOpenReturn(obj, params);
            return object;
        }
        finally {
            MXBeanLookup.setLookup(old);
        }
    }

    private Object invokeWithOpenReturn(Object obj, Object[] params) throws MBeanException, IllegalAccessException, InvocationTargetException {
        Object[] javaParams;
        try {
            javaParams = this.fromOpenParameters(params);
        }
        catch (InvalidObjectException e) {
            String msg = this.methodName() + ": cannot convert parameters from open values: " + e;
            throw new MBeanException(e, msg);
        }
        Object javaReturn = MethodUtil.invoke(this.method, obj, javaParams);
        try {
            return this.returnMapping.toOpenValue(javaReturn);
        }
        catch (OpenDataException e) {
            String msg = this.methodName() + ": cannot convert return value to open value: " + e;
            throw new MBeanException(e, msg);
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass() + "." + this.method.getName();
    }

    private ConvertingMethod(Method m) throws OpenDataException {
        this.method = m;
        MXBeanMappingFactory mappingFactory = MXBeanMappingFactory.DEFAULT;
        this.returnMapping = mappingFactory.mappingForType(m.getGenericReturnType(), mappingFactory);
        Type[] params = m.getGenericParameterTypes();
        this.paramMappings = new MXBeanMapping[params.length];
        boolean identity = true;
        for (int i = 0; i < params.length; ++i) {
            this.paramMappings[i] = mappingFactory.mappingForType(params[i], mappingFactory);
            identity &= DefaultMXBeanMappingFactory.isIdentity(this.paramMappings[i]);
        }
        this.paramConversionIsIdentity = identity;
    }
}

