/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.ntlm;

import com.sun.security.ntlm.NTLM;
import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Version;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;

public final class Client
extends NTLM {
    private final String hostname;
    private final String username;
    private String domain;
    private byte[] pw1;
    private byte[] pw2;

    public Client(String version, String hostname, String username, String domain, char[] password) throws NTLMException {
        super(version);
        if (username == null || password == null) {
            throw new NTLMException(6, "username/password cannot be null");
        }
        this.hostname = hostname;
        this.username = username;
        this.domain = domain == null ? "" : domain;
        this.pw1 = Client.getP1(password);
        this.pw2 = Client.getP2(password);
        this.debug("NTLM Client: (h,u,t,version(v)) = (%s,%s,%s,%s(%s))\n", new Object[]{hostname, username, domain, version, this.v.toString()});
    }

    public byte[] type1() {
        NTLM.Writer p = new NTLM.Writer(1, 32);
        int flags = 33287;
        if (this.v != Version.NTLM) {
            flags |= 0x80000;
        }
        p.writeInt(12, flags);
        this.debug("NTLM Client: Type 1 created\n", new Object[0]);
        this.debug(p.getBytes());
        return p.getBytes();
    }

    public byte[] type3(byte[] type2, byte[] nonce) throws NTLMException {
        if (type2 == null || this.v != Version.NTLM && nonce == null || nonce != null && nonce.length != 8) {
            throw new NTLMException(6, "type2 cannot be null, and nonce must be 8-byte long");
        }
        this.debug("NTLM Client: Type 2 received\n", new Object[0]);
        this.debug(type2);
        NTLM.Reader r = new NTLM.Reader(type2);
        byte[] challenge = r.readBytes(24, 8);
        int inputFlags = r.readInt(20);
        boolean unicode = (inputFlags & 1) == 1;
        int flags = 0x88200 | inputFlags & 3;
        NTLM.Writer p = new NTLM.Writer(3, 64);
        byte[] lm = null;
        byte[] ntlm = null;
        p.writeSecurityBuffer(28, this.domain, unicode);
        p.writeSecurityBuffer(36, this.username, unicode);
        p.writeSecurityBuffer(44, this.hostname, unicode);
        if (this.v == Version.NTLM) {
            byte[] lmhash = this.calcLMHash(this.pw1);
            byte[] nthash = this.calcNTHash(this.pw2);
            if (this.writeLM) {
                lm = this.calcResponse(lmhash, challenge);
            }
            if (this.writeNTLM) {
                ntlm = this.calcResponse(nthash, challenge);
            }
        } else if (this.v == Version.NTLM2) {
            byte[] nthash = this.calcNTHash(this.pw2);
            lm = Client.ntlm2LM(nonce);
            ntlm = this.ntlm2NTLM(nthash, nonce, challenge);
        } else {
            byte[] nthash = this.calcNTHash(this.pw2);
            if (this.writeLM) {
                lm = this.calcV2(nthash, this.username.toUpperCase(Locale.US) + this.domain, nonce, challenge);
            }
            if (this.writeNTLM) {
                byte[] alist = (inputFlags & 0x800000) != 0 ? r.readSecurityBuffer(40) : new byte[]{};
                byte[] blob = new byte[32 + alist.length];
                System.arraycopy(new byte[]{1, 1, 0, 0, 0, 0, 0, 0}, 0, blob, 0, 8);
                byte[] time = BigInteger.valueOf(new Date().getTime()).add(new BigInteger("11644473600000")).multiply(BigInteger.valueOf(10000L)).toByteArray();
                for (int i = 0; i < time.length; ++i) {
                    blob[8 + time.length - i - 1] = time[i];
                }
                System.arraycopy(nonce, 0, blob, 16, 8);
                System.arraycopy(new byte[]{0, 0, 0, 0}, 0, blob, 24, 4);
                System.arraycopy(alist, 0, blob, 28, alist.length);
                System.arraycopy(new byte[]{0, 0, 0, 0}, 0, blob, 28 + alist.length, 4);
                ntlm = this.calcV2(nthash, this.username.toUpperCase(Locale.US) + this.domain, blob, challenge);
            }
        }
        p.writeSecurityBuffer(12, lm);
        p.writeSecurityBuffer(20, ntlm);
        p.writeSecurityBuffer(52, new byte[0]);
        p.writeInt(60, flags);
        this.debug("NTLM Client: Type 3 created\n", new Object[0]);
        this.debug(p.getBytes());
        return p.getBytes();
    }

    public String getDomain() {
        return this.domain;
    }

    public void dispose() {
        Arrays.fill(this.pw1, (byte)0);
        Arrays.fill(this.pw2, (byte)0);
    }
}

