/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.reflect.CallerSensitive;
import sun.reflect.ConstantPool;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.TypeAnnotationParser;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.ClassRepository;
import sun.reflect.generics.repository.ConstructorRepository;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.ClassScope;
import sun.reflect.misc.ReflectUtil;
import sun.security.util.SecurityConstants;

public final class Class<T>
implements Serializable,
GenericDeclaration,
Type,
AnnotatedElement {
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static final int SYNTHETIC = 4096;
    private volatile transient Constructor<T> cachedConstructor;
    private volatile transient Class<?> newInstanceCallerCache;
    private transient String name;
    private final ClassLoader classLoader;
    private static ProtectionDomain allPermDomain;
    private static boolean useCaches;
    private volatile transient SoftReference<ReflectionData<T>> reflectionData;
    private volatile transient int classRedefinedCount = 0;
    private volatile transient ClassRepository genericInfo;
    private static final long serialVersionUID = 3206093459760846163L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static ReflectionFactory reflectionFactory;
    private static boolean initted;
    private volatile transient T[] enumConstants = null;
    private volatile transient Map<String, T> enumConstantDirectory = null;
    private volatile transient AnnotationData annotationData;
    private volatile transient AnnotationType annotationType;
    transient ClassValue.ClassValueMap classValueMap;

    private static native void registerNatives();

    private Class(ClassLoader loader) {
        this.classLoader = loader;
    }

    public String toString() {
        return (this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")) + this.getName();
    }

    public String toGenericString() {
        if (this.isPrimitive()) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        int modifiers = this.getModifiers() & Modifier.classModifiers();
        if (modifiers != 0) {
            sb.append(Modifier.toString(modifiers));
            sb.append(' ');
        }
        if (this.isAnnotation()) {
            sb.append('@');
        }
        if (this.isInterface()) {
            sb.append("interface");
        } else if (this.isEnum()) {
            sb.append("enum");
        } else {
            sb.append("class");
        }
        sb.append(' ');
        sb.append(this.getName());
        TypeVariable<Class<T>>[] typeparms = this.getTypeParameters();
        if (typeparms.length > 0) {
            boolean first = true;
            sb.append('<');
            for (TypeVariable<Class<T>> typeparm : typeparms) {
                if (!first) {
                    sb.append(',');
                }
                sb.append(typeparm.getTypeName());
                first = false;
            }
            sb.append('>');
        }
        return sb.toString();
    }

    @CallerSensitive
    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class<?> caller = Reflection.getCallerClass();
        return Class.forName0(className, true, ClassLoader.getClassLoader(caller), caller);
    }

    @CallerSensitive
    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> caller = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader ccl;
            caller = Reflection.getCallerClass();
            if (VM.isSystemDomainLoader(loader) && !VM.isSystemDomainLoader(ccl = ClassLoader.getClassLoader(caller))) {
                sm.checkPermission(SecurityConstants.GET_CLASSLOADER_PERMISSION);
            }
        }
        return Class.forName0(name, initialize, loader, caller);
    }

    private static native Class<?> forName0(String var0, boolean var1, ClassLoader var2, Class<?> var3) throws ClassNotFoundException;

    @CallerSensitive
    public T newInstance() throws InstantiationException, IllegalAccessException {
        Class<?> caller;
        Constructor<T> tmpConstructor;
        int modifiers;
        if (System.getSecurityManager() != null) {
            this.checkMemberAccess(0, Reflection.getCallerClass(), false);
        }
        if (this.cachedConstructor == null) {
            if (this == Class.class) {
                throw new IllegalAccessException("Can not call newInstance() on the Class for java.lang.Class");
            }
            try {
                Class[] empty = new Class[]{};
                final Constructor<T> c = this.getConstructor0(empty, 1);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        c.setAccessible(true);
                        return null;
                    }
                });
                this.cachedConstructor = c;
            }
            catch (NoSuchMethodException e) {
                throw (InstantiationException)new InstantiationException(this.getName()).initCause(e);
            }
        }
        if (!Reflection.quickCheckMemberAccess(this, modifiers = (tmpConstructor = this.cachedConstructor).getModifiers()) && this.newInstanceCallerCache != (caller = Reflection.getCallerClass())) {
            Reflection.ensureMemberAccess(caller, this, null, modifiers);
            this.newInstanceCallerCache = caller;
        }
        try {
            return tmpConstructor.newInstance(null);
        }
        catch (InvocationTargetException e) {
            Unsafe.getUnsafe().throwException(e.getTargetException());
            return null;
        }
    }

    public native boolean isInstance(Object var1);

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInterface();

    public native boolean isArray();

    public native boolean isPrimitive();

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            this.name = name = this.getName0();
        }
        return name;
    }

    private native String getName0();

    @CallerSensitive
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return null;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ClassLoader.checkClassLoaderPermission(cl, Reflection.getCallerClass());
        }
        return cl;
    }

    ClassLoader getClassLoader0() {
        return this.classLoader;
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        ClassRepository info = this.getGenericInfo();
        if (info != null) {
            return info.getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public native Class<? super T> getSuperclass();

    public Type getGenericSuperclass() {
        ClassRepository info = this.getGenericInfo();
        if (info == null) {
            return this.getSuperclass();
        }
        if (this.isInterface()) {
            return null;
        }
        return info.getSuperclass();
    }

    public Package getPackage() {
        return Package.getPackage(this);
    }

    public Class<?>[] getInterfaces() {
        ReflectionData<T> rd = this.reflectionData();
        if (rd == null) {
            return this.getInterfaces0();
        }
        Class<?>[] interfaces = rd.interfaces;
        if (interfaces == null) {
            rd.interfaces = interfaces = this.getInterfaces0();
        }
        return (Class[])interfaces.clone();
    }

    private native Class<?>[] getInterfaces0();

    public Type[] getGenericInterfaces() {
        ClassRepository info = this.getGenericInfo();
        return info == null ? this.getInterfaces() : info.getSuperInterfaces();
    }

    public native Class<?> getComponentType();

    public native int getModifiers();

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    @CallerSensitive
    public Method getEnclosingMethod() throws SecurityException {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isMethod()) {
            return null;
        }
        MethodRepository typeInfo = MethodRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Class<?> returnType = Class.toClass(typeInfo.getReturnType());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Class[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        Class<?> enclosingCandidate = enclosingInfo.getEnclosingClass();
        super.checkMemberAccess(1, Reflection.getCallerClass(), true);
        for (Method m : enclosingCandidate.getDeclaredMethods()) {
            Class<?>[] candidateParamClasses;
            if (!m.getName().equals(enclosingInfo.getName()) || (candidateParamClasses = m.getParameterTypes()).length != parameterClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < candidateParamClasses.length; ++i) {
                if (candidateParamClasses[i].equals(parameterClasses[i])) continue;
                matches = false;
                break;
            }
            if (!matches || !m.getReturnType().equals(returnType)) continue;
            return m;
        }
        throw new InternalError("Enclosing method not found");
    }

    private native Object[] getEnclosingMethod0();

    private EnclosingMethodInfo getEnclosingMethodInfo() {
        Object[] enclosingInfo = this.getEnclosingMethod0();
        if (enclosingInfo == null) {
            return null;
        }
        return new EnclosingMethodInfo(enclosingInfo);
    }

    private static Class<?> toClass(Type o) {
        if (o instanceof GenericArrayType) {
            return Array.newInstance(Class.toClass(((GenericArrayType)o).getGenericComponentType()), 0).getClass();
        }
        return (Class)o;
    }

    @CallerSensitive
    public Constructor<?> getEnclosingConstructor() throws SecurityException {
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            return null;
        }
        if (!enclosingInfo.isConstructor()) {
            return null;
        }
        ConstructorRepository typeInfo = ConstructorRepository.make(enclosingInfo.getDescriptor(), this.getFactory());
        Type[] parameterTypes = typeInfo.getParameterTypes();
        Class[] parameterClasses = new Class[parameterTypes.length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = Class.toClass(parameterTypes[i]);
        }
        Class<?> enclosingCandidate = enclosingInfo.getEnclosingClass();
        super.checkMemberAccess(1, Reflection.getCallerClass(), true);
        for (Constructor<?> c : enclosingCandidate.getDeclaredConstructors()) {
            Class<?>[] candidateParamClasses = c.getParameterTypes();
            if (candidateParamClasses.length != parameterClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < candidateParamClasses.length; ++i) {
                if (candidateParamClasses[i].equals(parameterClasses[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return c;
        }
        throw new InternalError("Enclosing constructor not found");
    }

    @CallerSensitive
    public Class<?> getDeclaringClass() throws SecurityException {
        Class<?> candidate = this.getDeclaringClass0();
        if (candidate != null) {
            super.checkPackageAccess(ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return candidate;
    }

    private native Class<?> getDeclaringClass0();

    @CallerSensitive
    public Class<?> getEnclosingClass() throws SecurityException {
        Class<?> enclosingCandidate;
        EnclosingMethodInfo enclosingInfo = this.getEnclosingMethodInfo();
        if (enclosingInfo == null) {
            enclosingCandidate = this.getDeclaringClass();
        } else {
            Class<?> enclosingClass = enclosingInfo.getEnclosingClass();
            if (enclosingClass == this || enclosingClass == null) {
                throw new InternalError("Malformed enclosing method information");
            }
            enclosingCandidate = enclosingClass;
        }
        if (enclosingCandidate != null) {
            super.checkPackageAccess(ClassLoader.getClassLoader(Reflection.getCallerClass()), true);
        }
        return enclosingCandidate;
    }

    public String getSimpleName() {
        int index;
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String simpleName = this.getSimpleBinaryName();
        if (simpleName == null) {
            simpleName = this.getName();
            return simpleName.substring(simpleName.lastIndexOf(".") + 1);
        }
        int length = simpleName.length();
        if (length < 1 || simpleName.charAt(0) != '$') {
            throw new InternalError("Malformed class name");
        }
        for (index = 1; index < length && Class.isAsciiDigit(simpleName.charAt(index)); ++index) {
        }
        return simpleName.substring(index);
    }

    @Override
    public String getTypeName() {
        if (this.isArray()) {
            try {
                Class<?> cl = this;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.getName();
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public String getCanonicalName() {
        if (this.isArray()) {
            String canonicalName = this.getComponentType().getCanonicalName();
            if (canonicalName != null) {
                return canonicalName + "[]";
            }
            return null;
        }
        if (this.isLocalOrAnonymousClass()) {
            return null;
        }
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return this.getName();
        }
        String enclosingName = enclosingClass.getCanonicalName();
        if (enclosingName == null) {
            return null;
        }
        return enclosingName + "." + this.getSimpleName();
    }

    public boolean isAnonymousClass() {
        return "".equals(this.getSimpleName());
    }

    public boolean isLocalClass() {
        return this.isLocalOrAnonymousClass() && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getSimpleBinaryName() != null && !this.isLocalOrAnonymousClass();
    }

    private String getSimpleBinaryName() {
        Class<?> enclosingClass = this.getEnclosingClass();
        if (enclosingClass == null) {
            return null;
        }
        try {
            return this.getName().substring(enclosingClass.getName().length());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InternalError("Malformed class name", ex);
        }
    }

    private boolean isLocalOrAnonymousClass() {
        return this.getEnclosingMethodInfo() != null;
    }

    @CallerSensitive
    public Class<?>[] getClasses() {
        this.checkMemberAccess(0, Reflection.getCallerClass(), false);
        return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class<?>[] run() {
                ArrayList list = new ArrayList();
                for (Class currentClass = Class.this; currentClass != null; currentClass = currentClass.getSuperclass()) {
                    Class<?>[] members = currentClass.getDeclaredClasses();
                    for (int i = 0; i < members.length; ++i) {
                        if (!Modifier.isPublic(members[i].getModifiers())) continue;
                        list.add(members[i]);
                    }
                }
                return list.toArray(new Class[0]);
            }
        });
    }

    @CallerSensitive
    public Field[] getFields() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyFields(this.privateGetPublicFields(null));
    }

    @CallerSensitive
    public Method[] getMethods() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyMethods(this.privateGetPublicMethods());
    }

    @CallerSensitive
    public Constructor<?>[] getConstructors() throws SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return Class.copyConstructors(this.privateGetDeclaredConstructors(true));
    }

    @CallerSensitive
    public Field getField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        Field field = this.getField0(name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        return field;
    }

    @CallerSensitive
    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        Method method = this.getMethod0(name, parameterTypes, true);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + name + Class.argumentTypesToString(parameterTypes));
        }
        return method;
    }

    @CallerSensitive
    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(0, Reflection.getCallerClass(), true);
        return this.getConstructor0(parameterTypes, 0);
    }

    @CallerSensitive
    public Class<?>[] getDeclaredClasses() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), false);
        return this.getDeclaredClasses0();
    }

    @CallerSensitive
    public Field[] getDeclaredFields() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyFields(this.privateGetDeclaredFields(false));
    }

    @CallerSensitive
    public Method[] getDeclaredMethods() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyMethods(this.privateGetDeclaredMethods(false));
    }

    @CallerSensitive
    public Constructor<?>[] getDeclaredConstructors() throws SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return Class.copyConstructors(this.privateGetDeclaredConstructors(false));
    }

    @CallerSensitive
    public Field getDeclaredField(String name) throws NoSuchFieldException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        Field field = Class.searchFields(this.privateGetDeclaredFields(false), name);
        if (field == null) {
            throw new NoSuchFieldException(name);
        }
        return field;
    }

    @CallerSensitive
    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        Method method = Class.searchMethods(this.privateGetDeclaredMethods(false), name, parameterTypes);
        if (method == null) {
            throw new NoSuchMethodException(this.getName() + "." + name + Class.argumentTypesToString(parameterTypes));
        }
        return method;
    }

    @CallerSensitive
    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        this.checkMemberAccess(1, Reflection.getCallerClass(), true);
        return this.getConstructor0(parameterTypes, 1);
    }

    public InputStream getResourceAsStream(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return cl.getResourceAsStream(name);
    }

    public URL getResource(String name) {
        name = this.resolveName(name);
        ClassLoader cl = this.getClassLoader0();
        if (cl == null) {
            return ClassLoader.getSystemResource(name);
        }
        return cl.getResource(name);
    }

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain pd;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_PD_PERMISSION);
        }
        if ((pd = this.getProtectionDomain0()) == null) {
            if (allPermDomain == null) {
                Permissions perms = new Permissions();
                perms.add(SecurityConstants.ALL_PERMISSION);
                allPermDomain = new ProtectionDomain(null, perms);
            }
            pd = allPermDomain;
        }
        return pd;
    }

    private native ProtectionDomain getProtectionDomain0();

    static native Class<?> getPrimitiveClass(String var0);

    private void checkMemberAccess(int which, Class<?> caller, boolean checkProxyInterfaces) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            ClassLoader ccl = ClassLoader.getClassLoader(caller);
            ClassLoader cl = this.getClassLoader0();
            if (which != 0 && ccl != cl) {
                s.checkPermission(SecurityConstants.CHECK_MEMBER_ACCESS_PERMISSION);
            }
            this.checkPackageAccess(ccl, checkProxyInterfaces);
        }
    }

    private void checkPackageAccess(ClassLoader ccl, boolean checkProxyInterfaces) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            String name;
            int i;
            ClassLoader cl = this.getClassLoader0();
            if (ReflectUtil.needsPackageAccessCheck(ccl, cl) && (i = (name = this.getName()).lastIndexOf(46)) != -1) {
                String pkg = name.substring(0, i);
                if (!Proxy.isProxyClass(this) || ReflectUtil.isNonPublicProxyClass(this)) {
                    s.checkPackageAccess(pkg);
                }
            }
            if (checkProxyInterfaces && Proxy.isProxyClass(this)) {
                ReflectUtil.checkProxyPackageAccess(ccl, this.getInterfaces());
            }
        }
    }

    private String resolveName(String name) {
        if (name == null) {
            return name;
        }
        if (!name.startsWith("/")) {
            Class<?> c = this;
            while (c.isArray()) {
                c = c.getComponentType();
            }
            String baseName = c.getName();
            int index = baseName.lastIndexOf(46);
            if (index != -1) {
                name = baseName.substring(0, index).replace('.', '/') + "/" + name;
            }
        } else {
            name = name.substring(1);
        }
        return name;
    }

    private ReflectionData<T> reflectionData() {
        ReflectionData<T> rd;
        SoftReference<ReflectionData<T>> reflectionData = this.reflectionData;
        int classRedefinedCount = this.classRedefinedCount;
        if (useCaches && reflectionData != null && (rd = reflectionData.get()) != null && rd.redefinedCount == classRedefinedCount) {
            return rd;
        }
        return this.newReflectionData(reflectionData, classRedefinedCount);
    }

    private ReflectionData<T> newReflectionData(SoftReference<ReflectionData<T>> oldReflectionData, int classRedefinedCount) {
        ReflectionData rd;
        if (!useCaches) {
            return null;
        }
        do {
            if (Atomic.casReflectionData(this, oldReflectionData, new SoftReference(rd = new ReflectionData(classRedefinedCount)))) {
                return rd;
            }
            oldReflectionData = this.reflectionData;
            classRedefinedCount = this.classRedefinedCount;
        } while (oldReflectionData == null || (rd = oldReflectionData.get()) == null || rd.redefinedCount != classRedefinedCount);
        return rd;
    }

    private native String getGenericSignature0();

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, ClassScope.make(this));
    }

    private ClassRepository getGenericInfo() {
        ClassRepository genericInfo = this.genericInfo;
        if (genericInfo == null) {
            String signature = this.getGenericSignature0();
            genericInfo = signature == null ? ClassRepository.NONE : ClassRepository.make(signature, this.getFactory());
            this.genericInfo = genericInfo;
        }
        return genericInfo != ClassRepository.NONE ? genericInfo : null;
    }

    native byte[] getRawAnnotations();

    native byte[] getRawTypeAnnotations();

    static byte[] getExecutableTypeAnnotationBytes(Executable ex) {
        return Class.getReflectionFactory().getExecutableTypeAnnotationBytes(ex);
    }

    native ConstantPool getConstantPool();

    private Field[] privateGetDeclaredFields(boolean publicOnly) {
        Field[] res;
        Class.checkInitted();
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Field[] fieldArray = res = publicOnly ? rd.declaredPublicFields : rd.declaredFields;
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterFields(this, this.getDeclaredFields0(publicOnly));
        if (rd != null) {
            if (publicOnly) {
                rd.declaredPublicFields = res;
            } else {
                rd.declaredFields = res;
            }
        }
        return res;
    }

    private Field[] privateGetPublicFields(Set<Class<?>> traversedInterfaces) {
        Class<T> c;
        Field[] res;
        Class.checkInitted();
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null && (res = rd.publicFields) != null) {
            return res;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        if (traversedInterfaces == null) {
            traversedInterfaces = new HashSet();
        }
        Field[] tmp = this.privateGetDeclaredFields(true);
        Class.addAll(fields, tmp);
        for (Class<?> c2 : this.getInterfaces()) {
            if (traversedInterfaces.contains(c2)) continue;
            traversedInterfaces.add(c2);
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null) {
            Class.addAll(fields, super.privateGetPublicFields(traversedInterfaces));
        }
        res = new Field[fields.size()];
        fields.toArray(res);
        if (rd != null) {
            rd.publicFields = res;
        }
        return res;
    }

    private static void addAll(Collection<Field> c, Field[] o) {
        for (int i = 0; i < o.length; ++i) {
            c.add(o[i]);
        }
    }

    private Constructor<T>[] privateGetDeclaredConstructors(boolean publicOnly) {
        Constructor<T>[] res;
        Class.checkInitted();
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Constructor<T>[] constructorArray = res = publicOnly ? rd.publicConstructors : rd.declaredConstructors;
            if (res != null) {
                return res;
            }
        }
        if (this.isInterface()) {
            Constructor[] temporaryRes = new Constructor[]{};
            res = temporaryRes;
        } else {
            res = this.getDeclaredConstructors0(publicOnly);
        }
        if (rd != null) {
            if (publicOnly) {
                rd.publicConstructors = res;
            } else {
                rd.declaredConstructors = res;
            }
        }
        return res;
    }

    private Method[] privateGetDeclaredMethods(boolean publicOnly) {
        Method[] res;
        Class.checkInitted();
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null) {
            Method[] methodArray = res = publicOnly ? rd.declaredPublicMethods : rd.declaredMethods;
            if (res != null) {
                return res;
            }
        }
        res = Reflection.filterMethods(this, this.getDeclaredMethods0(publicOnly));
        if (rd != null) {
            if (publicOnly) {
                rd.declaredPublicMethods = res;
            } else {
                rd.declaredMethods = res;
            }
        }
        return res;
    }

    private Method[] privateGetPublicMethods() {
        Class<T> c;
        Method[] res;
        Class.checkInitted();
        ReflectionData<T> rd = this.reflectionData();
        if (rd != null && (res = rd.publicMethods) != null) {
            return res;
        }
        MethodArray methods = new MethodArray();
        Method[] tmp = this.privateGetDeclaredMethods(true);
        methods.addAll(tmp);
        MethodArray inheritedMethods = new MethodArray();
        for (Class<?> i : this.getInterfaces()) {
            inheritedMethods.addInterfaceMethods(super.privateGetPublicMethods());
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null) {
            MethodArray supers = new MethodArray();
            supers.addAll(super.privateGetPublicMethods());
            for (int i = 0; i < supers.length(); ++i) {
                Method m = supers.get(i);
                if (m == null || Modifier.isAbstract(m.getModifiers()) || m.isDefault()) continue;
                inheritedMethods.removeByNameAndDescriptor(m);
            }
            supers.addAll(inheritedMethods);
            inheritedMethods = supers;
        }
        for (int i = 0; i < methods.length(); ++i) {
            Method m = methods.get(i);
            inheritedMethods.removeByNameAndDescriptor(m);
        }
        methods.addAllIfNotPresent(inheritedMethods);
        methods.removeLessSpecifics();
        methods.compactAndTrim();
        res = methods.getArray();
        if (rd != null) {
            rd.publicMethods = res;
        }
        return res;
    }

    private static Field searchFields(Field[] fields, String name) {
        String internedName = name.intern();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName() != internedName) continue;
            return Class.getReflectionFactory().copyField(fields[i]);
        }
        return null;
    }

    private Field getField0(String name) throws NoSuchFieldException {
        Class<T> c;
        Field res = Class.searchFields(this.privateGetDeclaredFields(true), name);
        if (res != null) {
            return res;
        }
        Class<?>[] interfaces = this.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c2 = interfaces[i];
            res = super.getField0(name);
            if (res == null) continue;
            return res;
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null && (res = super.getField0(name)) != null) {
            return res;
        }
        return null;
    }

    private static Method searchMethods(Method[] methods, String name, Class<?>[] parameterTypes) {
        Method res = null;
        String internedName = name.intern();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (m.getName() != internedName || !Class.arrayContentsEq(parameterTypes, m.getParameterTypes()) || res != null && !res.getReturnType().isAssignableFrom(m.getReturnType())) continue;
            res = m;
        }
        return res == null ? res : Class.getReflectionFactory().copyMethod(res);
    }

    private Method getMethod0(String name, Class<?>[] parameterTypes, boolean includeStaticMethods) {
        MethodArray interfaceCandidates = new MethodArray(2);
        Method res = this.privateGetMethodRecursive(name, parameterTypes, includeStaticMethods, interfaceCandidates);
        if (res != null) {
            return res;
        }
        interfaceCandidates.removeLessSpecifics();
        return interfaceCandidates.getFirst();
    }

    private Method privateGetMethodRecursive(String name, Class<?>[] parameterTypes, boolean includeStaticMethods, MethodArray allInterfaceCandidates) {
        Class<?>[] interfaces;
        Class<T> c;
        Method res = Class.searchMethods(this.privateGetDeclaredMethods(true), name, parameterTypes);
        if (res != null && (includeStaticMethods || !Modifier.isStatic(res.getModifiers()))) {
            return res;
        }
        if (!this.isInterface() && (c = this.getSuperclass()) != null && (res = super.getMethod0(name, parameterTypes, true)) != null) {
            return res;
        }
        for (Class<?> c2 : interfaces = this.getInterfaces()) {
            res = super.getMethod0(name, parameterTypes, false);
            if (res == null) continue;
            allInterfaceCandidates.add(res);
        }
        return null;
    }

    private Constructor<T> getConstructor0(Class<?>[] parameterTypes, int which) throws NoSuchMethodException {
        Constructor<T>[] constructors;
        for (Constructor<T> constructor : constructors = this.privateGetDeclaredConstructors(which == 0)) {
            if (!Class.arrayContentsEq(parameterTypes, constructor.getParameterTypes())) continue;
            return Class.getReflectionFactory().copyConstructor(constructor);
        }
        throw new NoSuchMethodException(this.getName() + ".<init>" + Class.argumentTypesToString(parameterTypes));
    }

    private static boolean arrayContentsEq(Object[] a1, Object[] a2) {
        if (a1 == null) {
            return a2 == null || a2.length == 0;
        }
        if (a2 == null) {
            return a1.length == 0;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    private static Field[] copyFields(Field[] arg) {
        Field[] out = new Field[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyField(arg[i]);
        }
        return out;
    }

    private static Method[] copyMethods(Method[] arg) {
        Method[] out = new Method[arg.length];
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < arg.length; ++i) {
            out[i] = fact.copyMethod(arg[i]);
        }
        return out;
    }

    private static <U> Constructor<U>[] copyConstructors(Constructor<U>[] arg) {
        Constructor[] out = (Constructor[])arg.clone();
        ReflectionFactory fact = Class.getReflectionFactory();
        for (int i = 0; i < out.length; ++i) {
            out[i] = fact.copyConstructor(out[i]);
        }
        return out;
    }

    private native Field[] getDeclaredFields0(boolean var1);

    private native Method[] getDeclaredMethods0(boolean var1);

    private native Constructor<T>[] getDeclaredConstructors0(boolean var1);

    private native Class<?>[] getDeclaredClasses0();

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        ClassLoader loader = this.getClassLoader();
        if (loader == null) {
            return Class.desiredAssertionStatus0(this);
        }
        Object object = loader.assertionLock;
        synchronized (object) {
            if (loader.classAssertionStatus != null) {
                return loader.desiredAssertionStatus(this.getName());
            }
        }
        return Class.desiredAssertionStatus0(this);
    }

    private static native boolean desiredAssertionStatus0(Class<?> var0);

    public boolean isEnum() {
        return (this.getModifiers() & 0x4000) != 0 && this.getSuperclass() == Enum.class;
    }

    private static ReflectionFactory getReflectionFactory() {
        if (reflectionFactory == null) {
            reflectionFactory = AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
        }
        return reflectionFactory;
    }

    private static void checkInitted() {
        if (initted) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                if (System.out == null) {
                    return null;
                }
                String val = System.getProperty("sun.reflect.noCaches");
                if (val != null && val.equals("true")) {
                    useCaches = false;
                }
                initted = true;
                return null;
            }
        });
    }

    public T[] getEnumConstants() {
        T[] values = this.getEnumConstantsShared();
        return values != null ? (Object[])values.clone() : null;
    }

    T[] getEnumConstantsShared() {
        if (this.enumConstants == null) {
            if (!this.isEnum()) {
                return null;
            }
            try {
                final Method values = this.getMethod("values", new Class[0]);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        values.setAccessible(true);
                        return null;
                    }
                });
                Object[] temporaryConstants = (Object[])values.invoke(null, new Object[0]);
                this.enumConstants = temporaryConstants;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                return null;
            }
        }
        return this.enumConstants;
    }

    Map<String, T> enumConstantDirectory() {
        if (this.enumConstantDirectory == null) {
            T[] universe = this.getEnumConstantsShared();
            if (universe == null) {
                throw new IllegalArgumentException(this.getName() + " is not an enum type");
            }
            HashMap<String, T> m = new HashMap<String, T>(2 * universe.length);
            for (T constant : universe) {
                m.put(((Enum)constant).name(), constant);
            }
            this.enumConstantDirectory = m;
        }
        return this.enumConstantDirectory;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException(this.cannotCastMsg(obj));
        }
        return (T)obj;
    }

    private String cannotCastMsg(Object obj) {
        return "Cannot cast " + obj.getClass().getName() + " to " + this.getName();
    }

    public <U> Class<? extends U> asSubclass(Class<U> clazz) {
        if (clazz.isAssignableFrom(this)) {
            return this;
        }
        throw new ClassCastException(this.toString());
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (A)this.annotationData().annotations.get(annotationClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return GenericDeclaration.super.isAnnotationPresent(annotationClass);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        AnnotationData annotationData = this.annotationData();
        return AnnotationSupport.getAssociatedAnnotations(annotationData.declaredAnnotations, (Class)this, annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return AnnotationParser.toArray(this.annotationData().annotations);
    }

    public <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return (A)this.annotationData().declaredAnnotations.get(annotationClass);
    }

    public <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent(this.annotationData().declaredAnnotations, annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return AnnotationParser.toArray(this.annotationData().declaredAnnotations);
    }

    private AnnotationData annotationData() {
        int classRedefinedCount;
        AnnotationData newAnnotationData;
        AnnotationData annotationData;
        do {
            annotationData = this.annotationData;
            classRedefinedCount = this.classRedefinedCount;
            if (annotationData == null || annotationData.redefinedCount != classRedefinedCount) continue;
            return annotationData;
        } while (!Atomic.casAnnotationData(this, annotationData, newAnnotationData = this.createAnnotationData(classRedefinedCount)));
        return newAnnotationData;
    }

    private AnnotationData createAnnotationData(int classRedefinedCount) {
        Map<Class<? extends Annotation>, Annotation> declaredAnnotations = AnnotationParser.parseAnnotations(this.getRawAnnotations(), this.getConstantPool(), this);
        Class<T> superClass = this.getSuperclass();
        Map<Class<? extends Annotation>, Annotation> annotations = null;
        if (superClass != null) {
            Map<Class<? extends Annotation>, Annotation> superAnnotations = super.annotationData().annotations;
            for (Map.Entry<Class<? extends Annotation>, Annotation> e : superAnnotations.entrySet()) {
                Class<? extends Annotation> annotationClass = e.getKey();
                if (!AnnotationType.getInstance(annotationClass).isInherited()) continue;
                if (annotations == null) {
                    annotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>((Math.max(declaredAnnotations.size(), Math.min(12, declaredAnnotations.size() + superAnnotations.size())) * 4 + 2) / 3);
                }
                annotations.put(annotationClass, e.getValue());
            }
        }
        if (annotations == null) {
            annotations = declaredAnnotations;
        } else {
            annotations.putAll(declaredAnnotations);
        }
        return new AnnotationData(annotations, declaredAnnotations, classRedefinedCount);
    }

    boolean casAnnotationType(AnnotationType oldType, AnnotationType newType) {
        return Atomic.casAnnotationType(this, oldType, newType);
    }

    AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    Map<Class<? extends Annotation>, Annotation> getDeclaredAnnotationMap() {
        return this.annotationData().declaredAnnotations;
    }

    public AnnotatedType getAnnotatedSuperclass() {
        if (this == Object.class || this.isInterface() || this.isArray() || this.isPrimitive() || this == Void.TYPE) {
            return null;
        }
        return TypeAnnotationParser.buildAnnotatedSuperclass(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    public AnnotatedType[] getAnnotatedInterfaces() {
        return TypeAnnotationParser.buildAnnotatedInterfaces(this.getRawTypeAnnotations(), this.getConstantPool(), this);
    }

    static {
        Class.registerNatives();
        useCaches = true;
        serialPersistentFields = new ObjectStreamField[0];
        initted = false;
    }

    private static class AnnotationData {
        final Map<Class<? extends Annotation>, Annotation> annotations;
        final Map<Class<? extends Annotation>, Annotation> declaredAnnotations;
        final int redefinedCount;

        AnnotationData(Map<Class<? extends Annotation>, Annotation> annotations, Map<Class<? extends Annotation>, Annotation> declaredAnnotations, int redefinedCount) {
            this.annotations = annotations;
            this.declaredAnnotations = declaredAnnotations;
            this.redefinedCount = redefinedCount;
        }
    }

    static class MethodArray {
        private Method[] methods;
        private int length;
        private int defaults;

        MethodArray() {
            this(20);
        }

        MethodArray(int initialSize) {
            if (initialSize < 2) {
                throw new IllegalArgumentException("Size should be 2 or more");
            }
            this.methods = new Method[initialSize];
            this.length = 0;
            this.defaults = 0;
        }

        boolean hasDefaults() {
            return this.defaults != 0;
        }

        void add(Method m) {
            if (this.length == this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, 2 * this.methods.length);
            }
            this.methods[this.length++] = m;
            if (m != null && m.isDefault()) {
                ++this.defaults;
            }
        }

        void addAll(Method[] ma) {
            for (int i = 0; i < ma.length; ++i) {
                this.add(ma[i]);
            }
        }

        void addAll(MethodArray ma) {
            for (int i = 0; i < ma.length(); ++i) {
                this.add(ma.get(i));
            }
        }

        void addIfNotPresent(Method newMethod) {
            for (int i = 0; i < this.length; ++i) {
                Method m = this.methods[i];
                if (m != newMethod && (m == null || !m.equals(newMethod))) continue;
                return;
            }
            this.add(newMethod);
        }

        void addAllIfNotPresent(MethodArray newMethods) {
            for (int i = 0; i < newMethods.length(); ++i) {
                Method m = newMethods.get(i);
                if (m == null) continue;
                this.addIfNotPresent(m);
            }
        }

        void addInterfaceMethods(Method[] methods) {
            for (Method candidate : methods) {
                if (Modifier.isStatic(candidate.getModifiers())) continue;
                this.add(candidate);
            }
        }

        int length() {
            return this.length;
        }

        Method get(int i) {
            return this.methods[i];
        }

        Method getFirst() {
            for (Method m : this.methods) {
                if (m == null) continue;
                return m;
            }
            return null;
        }

        void removeByNameAndDescriptor(Method toRemove) {
            for (int i = 0; i < this.length; ++i) {
                Method m = this.methods[i];
                if (m == null || !this.matchesNameAndDescriptor(m, toRemove)) continue;
                this.remove(i);
            }
        }

        private void remove(int i) {
            if (this.methods[i] != null && this.methods[i].isDefault()) {
                --this.defaults;
            }
            this.methods[i] = null;
        }

        private boolean matchesNameAndDescriptor(Method m1, Method m2) {
            return m1.getReturnType() == m2.getReturnType() && m1.getName() == m2.getName() && Class.arrayContentsEq(m1.getParameterTypes(), m2.getParameterTypes());
        }

        void compactAndTrim() {
            int newPos = 0;
            for (int pos = 0; pos < this.length; ++pos) {
                Method m = this.methods[pos];
                if (m == null) continue;
                if (pos != newPos) {
                    this.methods[newPos] = m;
                }
                ++newPos;
            }
            if (newPos != this.methods.length) {
                this.methods = Arrays.copyOf(this.methods, newPos);
            }
        }

        void removeLessSpecifics() {
            if (!this.hasDefaults()) {
                return;
            }
            for (int i = 0; i < this.length; ++i) {
                Method m = this.get(i);
                if (m == null || !m.isDefault()) continue;
                for (int j = 0; j < this.length; ++j) {
                    Method candidate;
                    if (i == j || (candidate = this.get(j)) == null || !this.matchesNameAndDescriptor(m, candidate) || !MethodArray.hasMoreSpecificClass(m, candidate)) continue;
                    this.remove(j);
                }
            }
        }

        Method[] getArray() {
            return this.methods;
        }

        static boolean hasMoreSpecificClass(Method m1, Method m2) {
            Class<?> m2Class;
            Class<?> m1Class = m1.getDeclaringClass();
            return m1Class != (m2Class = m2.getDeclaringClass()) && m2Class.isAssignableFrom(m1Class);
        }
    }

    private static class ReflectionData<T> {
        volatile Field[] declaredFields;
        volatile Field[] publicFields;
        volatile Method[] declaredMethods;
        volatile Method[] publicMethods;
        volatile Constructor<T>[] declaredConstructors;
        volatile Constructor<T>[] publicConstructors;
        volatile Field[] declaredPublicFields;
        volatile Method[] declaredPublicMethods;
        volatile Class<?>[] interfaces;
        final int redefinedCount;

        ReflectionData(int redefinedCount) {
            this.redefinedCount = redefinedCount;
        }
    }

    private static class Atomic {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private static final long reflectionDataOffset;
        private static final long annotationTypeOffset;
        private static final long annotationDataOffset;

        private Atomic() {
        }

        private static long objectFieldOffset(Field[] fields, String fieldName) {
            Field field = Class.searchFields(fields, fieldName);
            if (field == null) {
                throw new Error("No " + fieldName + " field found in java.lang.Class");
            }
            return unsafe.objectFieldOffset(field);
        }

        static <T> boolean casReflectionData(Class<?> clazz, SoftReference<ReflectionData<T>> oldData, SoftReference<ReflectionData<T>> newData) {
            return unsafe.compareAndSwapObject(clazz, reflectionDataOffset, oldData, newData);
        }

        static <T> boolean casAnnotationType(Class<?> clazz, AnnotationType oldType, AnnotationType newType) {
            return unsafe.compareAndSwapObject(clazz, annotationTypeOffset, oldType, newType);
        }

        static <T> boolean casAnnotationData(Class<?> clazz, AnnotationData oldData, AnnotationData newData) {
            return unsafe.compareAndSwapObject(clazz, annotationDataOffset, oldData, newData);
        }

        static {
            Field[] fields = ((Class)Class.class).getDeclaredFields0(false);
            reflectionDataOffset = Atomic.objectFieldOffset(fields, "reflectionData");
            annotationTypeOffset = Atomic.objectFieldOffset(fields, "annotationType");
            annotationDataOffset = Atomic.objectFieldOffset(fields, "annotationData");
        }
    }

    private static final class EnclosingMethodInfo {
        private Class<?> enclosingClass;
        private String name;
        private String descriptor;

        private EnclosingMethodInfo(Object[] enclosingInfo) {
            if (enclosingInfo.length != 3) {
                throw new InternalError("Malformed enclosing method information");
            }
            try {
                this.enclosingClass = (Class)enclosingInfo[0];
                assert (this.enclosingClass != null);
                this.name = (String)enclosingInfo[1];
                this.descriptor = (String)enclosingInfo[2];
                assert (this.name != null && this.descriptor != null || this.name == this.descriptor);
            }
            catch (ClassCastException cce) {
                throw new InternalError("Invalid type in enclosing method information", cce);
            }
        }

        boolean isPartial() {
            return this.enclosingClass == null || this.name == null || this.descriptor == null;
        }

        boolean isConstructor() {
            return !this.isPartial() && "<init>".equals(this.name);
        }

        boolean isMethod() {
            return !this.isPartial() && !this.isConstructor() && !"<clinit>".equals(this.name);
        }

        Class<?> getEnclosingClass() {
            return this.enclosingClass;
        }

        String getName() {
            return this.name;
        }

        String getDescriptor() {
            return this.descriptor;
        }
    }
}

