/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.security.AlgorithmConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public class SSLParameters {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String identificationAlgorithm;
    private AlgorithmConstraints algorithmConstraints;
    private Map<Integer, SNIServerName> sniNames = null;
    private Map<Integer, SNIMatcher> sniMatchers = null;
    private boolean preferLocalCipherSuites;
    private String[] applicationProtocols = new String[0];

    public SSLParameters() {
    }

    public SSLParameters(String[] cipherSuites) {
        this.setCipherSuites(cipherSuites);
    }

    public SSLParameters(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    private static String[] clone(String[] s) {
        return s == null ? null : (String[])s.clone();
    }

    public String[] getCipherSuites() {
        return SSLParameters.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = SSLParameters.clone(cipherSuites);
    }

    public String[] getProtocols() {
        return SSLParameters.clone(this.protocols);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = SSLParameters.clone(protocols);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean needClientAuth) {
        this.wantClientAuth = false;
        this.needClientAuth = needClientAuth;
    }

    public AlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(AlgorithmConstraints constraints) {
        this.algorithmConstraints = constraints;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.identificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String algorithm) {
        this.identificationAlgorithm = algorithm;
    }

    public final void setServerNames(List<SNIServerName> serverNames) {
        if (serverNames != null) {
            if (!serverNames.isEmpty()) {
                this.sniNames = new LinkedHashMap<Integer, SNIServerName>(serverNames.size());
                for (SNIServerName serverName : serverNames) {
                    if (this.sniNames.put(serverName.getType(), serverName) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + serverName.getType());
                }
            } else {
                this.sniNames = Collections.emptyMap();
            }
        } else {
            this.sniNames = null;
        }
    }

    public final List<SNIServerName> getServerNames() {
        if (this.sniNames != null) {
            if (!this.sniNames.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<SNIServerName>(this.sniNames.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setSNIMatchers(Collection<SNIMatcher> matchers) {
        if (matchers != null) {
            if (!matchers.isEmpty()) {
                this.sniMatchers = new HashMap<Integer, SNIMatcher>(matchers.size());
                for (SNIMatcher matcher : matchers) {
                    if (this.sniMatchers.put(matcher.getType(), matcher) == null) continue;
                    throw new IllegalArgumentException("Duplicated server name of type " + matcher.getType());
                }
            } else {
                this.sniMatchers = Collections.emptyMap();
            }
        } else {
            this.sniMatchers = null;
        }
    }

    public final Collection<SNIMatcher> getSNIMatchers() {
        if (this.sniMatchers != null) {
            if (!this.sniMatchers.isEmpty()) {
                return Collections.unmodifiableList(new ArrayList<SNIMatcher>(this.sniMatchers.values()));
            }
            return Collections.emptyList();
        }
        return null;
    }

    public final void setUseCipherSuitesOrder(boolean honorOrder) {
        this.preferLocalCipherSuites = honorOrder;
    }

    public final boolean getUseCipherSuitesOrder() {
        return this.preferLocalCipherSuites;
    }

    public String[] getApplicationProtocols() {
        return (String[])this.applicationProtocols.clone();
    }

    public void setApplicationProtocols(String[] protocols) {
        String[] tempProtocols;
        if (protocols == null) {
            throw new IllegalArgumentException("protocols was null");
        }
        for (String p : tempProtocols = (String[])protocols.clone()) {
            if (p != null && !p.equals("")) continue;
            throw new IllegalArgumentException("An element of protocols was null/empty");
        }
        this.applicationProtocols = tempProtocols;
    }
}

