/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.security.AccessController;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.ReentrantContextProvider;
import sun.java2d.ReentrantContextProviderCLQ;
import sun.java2d.ReentrantContextProviderTL;
import sun.java2d.marlin.FloatMath;
import sun.java2d.marlin.MarlinCache;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinProperties;
import sun.java2d.marlin.MarlinTileGenerator;
import sun.java2d.marlin.MarlinUtils;
import sun.java2d.marlin.Renderer;
import sun.java2d.marlin.RendererContext;
import sun.java2d.marlin.TransformingPathConsumer2D;
import sun.java2d.marlin.Version;
import sun.java2d.pipe.AATileGenerator;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderingEngine;
import sun.security.action.GetPropertyAction;

public class MarlinRenderingEngine
extends RenderingEngine
implements MarlinConst {
    private static final float MIN_PEN_SIZE;
    private static final boolean useThreadLocal;
    static final int REF_TYPE;
    private static final ReentrantContextProvider<RendererContext> rdrCtxProvider;
    private static boolean settingsLogged;

    public MarlinRenderingEngine() {
        MarlinRenderingEngine.logSettings(MarlinRenderingEngine.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape createStrokedShape(Shape src, float width, int caps, int join, float miterlimit, float[] dashes, float dashphase) {
        RendererContext rdrCtx = MarlinRenderingEngine.getRendererContext();
        try {
            Path2D.Float p2d = rdrCtx.p2d == null ? (rdrCtx.p2d = new Path2D.Float(1, 4096)) : rdrCtx.p2d;
            p2d.reset();
            this.strokeTo(rdrCtx, src, null, width, NormMode.OFF, caps, join, miterlimit, dashes, dashphase, rdrCtx.transformerPC2D.wrapPath2d(p2d));
            Path2D.Float float_ = new Path2D.Float(p2d);
            return float_;
        }
        finally {
            MarlinRenderingEngine.returnRendererContext(rdrCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void strokeTo(Shape src, AffineTransform at, BasicStroke bs, boolean thin, boolean normalize, boolean antialias, PathConsumer2D consumer) {
        NormMode norm = normalize ? (antialias ? NormMode.ON_WITH_AA : NormMode.ON_NO_AA) : NormMode.OFF;
        RendererContext rdrCtx = MarlinRenderingEngine.getRendererContext();
        try {
            this.strokeTo(rdrCtx, src, at, bs, thin, norm, antialias, consumer);
        }
        finally {
            MarlinRenderingEngine.returnRendererContext(rdrCtx);
        }
    }

    final void strokeTo(RendererContext rdrCtx, Shape src, AffineTransform at, BasicStroke bs, boolean thin, NormMode normalize, boolean antialias, PathConsumer2D pc2d) {
        float lw = thin ? (antialias ? this.userSpaceLineWidth(at, MIN_PEN_SIZE) : this.userSpaceLineWidth(at, 1.0f)) : bs.getLineWidth();
        this.strokeTo(rdrCtx, src, at, lw, normalize, bs.getEndCap(), bs.getLineJoin(), bs.getMiterLimit(), bs.getDashArray(), bs.getDashPhase(), pc2d);
    }

    private final float userSpaceLineWidth(AffineTransform at, float lw) {
        float widthScale;
        if (at == null) {
            widthScale = 1.0f;
        } else if ((at.getType() & 0x24) != 0) {
            widthScale = (float)Math.sqrt(at.getDeterminant());
        } else {
            double A = at.getScaleX();
            double C = at.getShearX();
            double B = at.getShearY();
            double D = at.getScaleY();
            double EA = A * A + B * B;
            double EB = 2.0 * (A * C + B * D);
            double EC2 = C * C + D * D;
            double hypot = Math.sqrt(EB * EB + (EA - EC2) * (EA - EC2));
            double widthsquared = (EA + EC2 + hypot) / 2.0;
            widthScale = (float)Math.sqrt(widthsquared);
        }
        return lw / widthScale;
    }

    final void strokeTo(RendererContext rdrCtx, Shape src, AffineTransform at, float width, NormMode normalize, int caps, int join, float miterlimit, float[] dashes, float dashphase, PathConsumer2D pc2d) {
        PathIterator pi;
        AffineTransform strokerat = null;
        AffineTransform outat = null;
        int dashLen = -1;
        boolean recycleDashes = false;
        if (at != null && !at.isIdentity()) {
            double a = at.getScaleX();
            double b = at.getShearX();
            double c = at.getShearY();
            double d = at.getScaleY();
            double det = a * d - c * b;
            if (Math.abs(det) <= (double)2.8E-45f) {
                pc2d.moveTo(0.0f, 0.0f);
                pc2d.pathDone();
                return;
            }
            if (MarlinRenderingEngine.nearZero(a * b + c * d) && MarlinRenderingEngine.nearZero(a * a + c * c - (b * b + d * d))) {
                float scale = (float)Math.sqrt(a * a + c * c);
                if (dashes != null) {
                    float[] newDashes;
                    recycleDashes = true;
                    dashLen = dashes.length;
                    if (dashLen <= 256) {
                        newDashes = rdrCtx.dasher.dashes_initial;
                    } else {
                        if (doStats) {
                            RendererContext.stats.stat_array_dasher_dasher.add(dashLen);
                        }
                        newDashes = rdrCtx.getDirtyFloatArray(dashLen);
                    }
                    System.arraycopy(dashes, 0, newDashes, 0, dashLen);
                    dashes = newDashes;
                    for (int i = 0; i < dashLen; ++i) {
                        dashes[i] = scale * dashes[i];
                    }
                    dashphase = scale * dashphase;
                }
                width = scale * width;
                pi = this.getNormalizingPathIterator(rdrCtx, normalize, src.getPathIterator(at));
            } else if (normalize != NormMode.OFF) {
                strokerat = at;
                pi = this.getNormalizingPathIterator(rdrCtx, normalize, src.getPathIterator(at));
            } else {
                outat = at;
                pi = src.getPathIterator(null);
            }
        } else {
            pi = this.getNormalizingPathIterator(rdrCtx, normalize, src.getPathIterator(null));
        }
        if (useSimplifier) {
            pc2d = rdrCtx.simplifier.init(pc2d);
        }
        TransformingPathConsumer2D transformerPC2D = rdrCtx.transformerPC2D;
        pc2d = transformerPC2D.transformConsumer(pc2d, outat);
        pc2d = transformerPC2D.deltaTransformConsumer(pc2d, strokerat);
        pc2d = rdrCtx.stroker.init(pc2d, width, caps, join, miterlimit);
        if (dashes != null) {
            if (!recycleDashes) {
                dashLen = dashes.length;
            }
            pc2d = rdrCtx.dasher.init(pc2d, dashes, dashLen, dashphase, recycleDashes);
        }
        pc2d = transformerPC2D.inverseDeltaTransformConsumer(pc2d, strokerat);
        MarlinRenderingEngine.pathTo(rdrCtx, pi, pc2d);
    }

    private static boolean nearZero(double num) {
        return Math.abs(num) < 2.0 * Math.ulp(num);
    }

    PathIterator getNormalizingPathIterator(RendererContext rdrCtx, NormMode mode, PathIterator src) {
        switch (mode) {
            case ON_WITH_AA: {
                return rdrCtx.nPCPathIterator.init(src);
            }
            case ON_NO_AA: {
                return rdrCtx.nPQPathIterator.init(src);
            }
            case OFF: {
                return src;
            }
        }
        throw new InternalError("Unrecognized normalization mode");
    }

    private static void pathTo(RendererContext rdrCtx, PathIterator pi, PathConsumer2D pc2d) {
        rdrCtx.dirty = true;
        float[] coords = rdrCtx.float6;
        MarlinRenderingEngine.pathToLoop(coords, pi, pc2d);
        rdrCtx.dirty = false;
    }

    private static void pathToLoop(float[] coords, PathIterator pi, PathConsumer2D pc2d) {
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    pc2d.moveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    pc2d.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    pc2d.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    pc2d.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    pc2d.closePath();
                    break;
                }
            }
            pi.next();
        }
        pc2d.pathDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AATileGenerator getAATileGenerator(Shape s, AffineTransform at, Region clip, BasicStroke bs, boolean thin, boolean normalize, int[] bbox) {
        MarlinTileGenerator ptg = null;
        Renderer r = null;
        RendererContext rdrCtx = MarlinRenderingEngine.getRendererContext();
        try {
            NormMode norm;
            AffineTransform _at = at != null && !at.isIdentity() ? at : null;
            NormMode normMode = norm = normalize ? NormMode.ON_WITH_AA : NormMode.OFF;
            if (bs == null) {
                PathIterator pi = this.getNormalizingPathIterator(rdrCtx, norm, s.getPathIterator(_at));
                r = rdrCtx.renderer.init(clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), pi.getWindingRule());
                MarlinRenderingEngine.pathTo(rdrCtx, pi, r);
            } else {
                r = rdrCtx.renderer.init(clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), 1);
                this.strokeTo(rdrCtx, s, _at, bs, thin, norm, true, r);
            }
            if (r.endRendering()) {
                ptg = rdrCtx.ptg.init();
                ptg.getBbox(bbox);
                r = null;
            }
        }
        finally {
            if (r != null) {
                r.dispose();
                MarlinRenderingEngine.returnRendererContext(rdrCtx);
            }
        }
        return ptg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AATileGenerator getAATileGenerator(double x, double y, double dx1, double dy1, double dx2, double dy2, double lw1, double lw2, Region clip, int[] bbox) {
        double ldy2;
        double ldx2;
        double ldy1;
        double ldx1;
        boolean innerpgram;
        boolean bl = innerpgram = lw1 > 0.0 && lw2 > 0.0;
        if (innerpgram) {
            ldx1 = dx1 * lw1;
            ldy1 = dy1 * lw1;
            ldx2 = dx2 * lw2;
            ldy2 = dy2 * lw2;
            x -= (ldx1 + ldx2) / 2.0;
            y -= (ldy1 + ldy2) / 2.0;
            dx1 += ldx1;
            dy1 += ldy1;
            dx2 += ldx2;
            dy2 += ldy2;
            if (lw1 > 1.0 && lw2 > 1.0) {
                innerpgram = false;
            }
        } else {
            ldy2 = 0.0;
            ldx2 = 0.0;
            ldy1 = 0.0;
            ldx1 = 0.0;
        }
        MarlinTileGenerator ptg = null;
        Renderer r = null;
        RendererContext rdrCtx = MarlinRenderingEngine.getRendererContext();
        try {
            r = rdrCtx.renderer.init(clip.getLoX(), clip.getLoY(), clip.getWidth(), clip.getHeight(), 0);
            r.moveTo((float)x, (float)y);
            r.lineTo((float)(x + dx1), (float)(y + dy1));
            r.lineTo((float)(x + dx1 + dx2), (float)(y + dy1 + dy2));
            r.lineTo((float)(x + dx2), (float)(y + dy2));
            r.closePath();
            if (innerpgram) {
                r.moveTo((float)(x += ldx1 + ldx2), (float)(y += ldy1 + ldy2));
                r.lineTo((float)(x + (dx1 -= 2.0 * ldx1)), (float)(y + (dy1 -= 2.0 * ldy1)));
                r.lineTo((float)(x + dx1 + (dx2 -= 2.0 * ldx2)), (float)(y + dy1 + (dy2 -= 2.0 * ldy2)));
                r.lineTo((float)(x + dx2), (float)(y + dy2));
                r.closePath();
            }
            r.pathDone();
            if (r.endRendering()) {
                ptg = rdrCtx.ptg.init();
                ptg.getBbox(bbox);
                r = null;
            }
        }
        finally {
            if (r != null) {
                r.dispose();
                MarlinRenderingEngine.returnRendererContext(rdrCtx);
            }
        }
        return ptg;
    }

    @Override
    public float getMinimumAAPenSize() {
        return MIN_PEN_SIZE;
    }

    private static void logSettings(String reClass) {
        String refType;
        if (settingsLogged) {
            return;
        }
        settingsLogged = true;
        switch (REF_TYPE) {
            default: {
                refType = "hard";
                break;
            }
            case 1: {
                refType = "soft";
                break;
            }
            case 2: {
                refType = "weak";
            }
        }
        MarlinUtils.logInfo("===============================================================================");
        MarlinUtils.logInfo("Marlin software rasterizer           = ENABLED");
        MarlinUtils.logInfo("Version                              = [" + Version.getVersion() + "]");
        MarlinUtils.logInfo("sun.java2d.renderer                  = " + reClass);
        MarlinUtils.logInfo("sun.java2d.renderer.useThreadLocal   = " + useThreadLocal);
        MarlinUtils.logInfo("sun.java2d.renderer.useRef           = " + refType);
        MarlinUtils.logInfo("sun.java2d.renderer.pixelsize        = " + MarlinConst.INITIAL_PIXEL_DIM);
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_X  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_X);
        MarlinUtils.logInfo("sun.java2d.renderer.subPixel_log2_Y  = " + MarlinConst.SUBPIXEL_LG_POSITIONS_Y);
        MarlinUtils.logInfo("sun.java2d.renderer.tileSize_log2    = " + MarlinConst.TILE_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.blockSize_log2   = " + MarlinConst.BLOCK_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.blockSize_log2   = " + MarlinConst.BLOCK_SIZE_LG);
        MarlinUtils.logInfo("sun.java2d.renderer.forceRLE         = " + MarlinProperties.isForceRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.forceNoRLE       = " + MarlinProperties.isForceNoRLE());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags     = " + MarlinProperties.isUseTileFlags());
        MarlinUtils.logInfo("sun.java2d.renderer.useTileFlags.useHeuristics = " + MarlinProperties.isUseTileFlagsWithHeuristics());
        MarlinUtils.logInfo("sun.java2d.renderer.rleMinWidth      = " + MarlinCache.RLE_MIN_WIDTH);
        MarlinUtils.logInfo("sun.java2d.renderer.useSimplifier    = " + MarlinConst.useSimplifier);
        MarlinUtils.logInfo("sun.java2d.renderer.doStats          = " + MarlinConst.doStats);
        MarlinUtils.logInfo("sun.java2d.renderer.doMonitors       = false");
        MarlinUtils.logInfo("sun.java2d.renderer.doChecks         = " + MarlinConst.doChecks);
        MarlinUtils.logInfo("sun.java2d.renderer.useLogger        = " + MarlinConst.useLogger);
        MarlinUtils.logInfo("sun.java2d.renderer.logCreateContext = " + MarlinConst.logCreateContext);
        MarlinUtils.logInfo("sun.java2d.renderer.logUnsafeMalloc  = " + MarlinConst.logUnsafeMalloc);
        MarlinUtils.logInfo("Renderer settings:");
        MarlinUtils.logInfo("CUB_COUNT_LG = 2");
        MarlinUtils.logInfo("CUB_DEC_BND  = " + Renderer.CUB_DEC_BND);
        MarlinUtils.logInfo("CUB_INC_BND  = " + Renderer.CUB_INC_BND);
        MarlinUtils.logInfo("QUAD_DEC_BND = " + Renderer.QUAD_DEC_BND);
        MarlinUtils.logInfo("===============================================================================");
    }

    static RendererContext getRendererContext() {
        RendererContext rdrCtx = rdrCtxProvider.acquire();
        return rdrCtx;
    }

    static void returnRendererContext(RendererContext rdrCtx) {
        rdrCtx.dispose();
        rdrCtxProvider.release(rdrCtx);
    }

    static {
        String refType;
        MIN_PEN_SIZE = 1.0f / NORM_SUBPIXELS;
        useThreadLocal = MarlinProperties.isUseThreadLocal();
        switch (refType = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.renderer.useRef", "soft"))) {
            default: {
                REF_TYPE = 1;
                break;
            }
            case "weak": {
                REF_TYPE = 2;
                break;
            }
            case "hard": {
                REF_TYPE = 0;
            }
        }
        rdrCtxProvider = useThreadLocal ? new ReentrantContextProviderTL<RendererContext>(REF_TYPE){

            @Override
            protected RendererContext newContext() {
                return RendererContext.createContext();
            }
        } : new ReentrantContextProviderCLQ<RendererContext>(REF_TYPE){

            @Override
            protected RendererContext newContext() {
                return RendererContext.createContext();
            }
        };
        settingsLogged = !enableLogs;
    }

    static abstract class NormalizingPathIterator
    implements PathIterator {
        private PathIterator src;
        private float curx_adjust;
        private float cury_adjust;
        private float movx_adjust;
        private float movy_adjust;
        private final float[] tmp;

        NormalizingPathIterator(float[] tmp) {
            this.tmp = tmp;
        }

        final NormalizingPathIterator init(PathIterator src) {
            this.src = src;
            return this;
        }

        final void dispose() {
            this.src = null;
        }

        @Override
        public final int currentSegment(float[] coords) {
            float y_adjust;
            float x_adjust;
            int lastCoord;
            int type = this.src.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    lastCoord = 0;
                    break;
                }
                case 2: {
                    lastCoord = 2;
                    break;
                }
                case 3: {
                    lastCoord = 4;
                    break;
                }
                case 4: {
                    this.curx_adjust = this.movx_adjust;
                    this.cury_adjust = this.movy_adjust;
                    return type;
                }
                default: {
                    throw new InternalError("Unrecognized curve type");
                }
            }
            float coord = coords[lastCoord];
            coords[lastCoord] = x_adjust = this.normCoord(coord);
            x_adjust -= coord;
            coord = coords[lastCoord + 1];
            coords[lastCoord + 1] = y_adjust = this.normCoord(coord);
            y_adjust -= coord;
            switch (type) {
                case 0: {
                    this.movx_adjust = x_adjust;
                    this.movy_adjust = y_adjust;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    coords[0] = coords[0] + (this.curx_adjust + x_adjust) / 2.0f;
                    coords[1] = coords[1] + (this.cury_adjust + y_adjust) / 2.0f;
                    break;
                }
                case 3: {
                    coords[0] = coords[0] + this.curx_adjust;
                    coords[1] = coords[1] + this.cury_adjust;
                    coords[2] = coords[2] + x_adjust;
                    coords[3] = coords[3] + y_adjust;
                    break;
                }
            }
            this.curx_adjust = x_adjust;
            this.cury_adjust = y_adjust;
            return type;
        }

        abstract float normCoord(float var1);

        @Override
        public final int currentSegment(double[] coords) {
            float[] _tmp = this.tmp;
            int type = this.currentSegment(_tmp);
            for (int i = 0; i < 6; ++i) {
                coords[i] = _tmp[i];
            }
            return type;
        }

        @Override
        public final int getWindingRule() {
            return this.src.getWindingRule();
        }

        @Override
        public final boolean isDone() {
            if (this.src.isDone()) {
                this.dispose();
                return true;
            }
            return false;
        }

        @Override
        public final void next() {
            this.src.next();
        }

        static final class NearestPixelQuarter
        extends NormalizingPathIterator {
            NearestPixelQuarter(float[] tmp) {
                super(tmp);
            }

            @Override
            float normCoord(float coord) {
                return FloatMath.floor_f(coord + 0.25f) + 0.25f;
            }
        }

        static final class NearestPixelCenter
        extends NormalizingPathIterator {
            NearestPixelCenter(float[] tmp) {
                super(tmp);
            }

            @Override
            float normCoord(float coord) {
                return FloatMath.floor_f(coord) + 0.5f;
            }
        }
    }

    private static enum NormMode {
        ON_WITH_AA,
        ON_NO_AA,
        OFF;

    }
}

