/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedElement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class TypeAnnotation {
    private final TypeAnnotationTargetInfo targetInfo;
    private final LocationInfo loc;
    private final Annotation annotation;
    private final AnnotatedElement baseDeclaration;

    public TypeAnnotation(TypeAnnotationTargetInfo targetInfo, LocationInfo loc, Annotation annotation, AnnotatedElement baseDeclaration) {
        this.targetInfo = targetInfo;
        this.loc = loc;
        this.annotation = annotation;
        this.baseDeclaration = baseDeclaration;
    }

    public TypeAnnotationTargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public AnnotatedElement getBaseDeclaration() {
        return this.baseDeclaration;
    }

    public LocationInfo getLocationInfo() {
        return this.loc;
    }

    public static List<TypeAnnotation> filter(TypeAnnotation[] typeAnnotations, TypeAnnotationTarget predicate) {
        ArrayList<TypeAnnotation> typeAnnos = new ArrayList<TypeAnnotation>(typeAnnotations.length);
        for (TypeAnnotation t : typeAnnotations) {
            if (t.getTargetInfo().getTarget() != predicate) continue;
            typeAnnos.add(t);
        }
        typeAnnos.trimToSize();
        return typeAnnos;
    }

    public String toString() {
        return this.annotation.toString() + " with Targetnfo: " + this.targetInfo.toString() + " on base declaration: " + this.baseDeclaration.toString();
    }

    public static final class LocationInfo {
        private final int depth;
        private final Location[] locations;
        public static final LocationInfo BASE_LOCATION = new LocationInfo();

        private LocationInfo() {
            this(0, new Location[0]);
        }

        private LocationInfo(int depth, Location[] locations) {
            this.depth = depth;
            this.locations = locations;
        }

        public static LocationInfo parseLocationInfo(ByteBuffer buf) {
            int depth = buf.get() & 0xFF;
            if (depth == 0) {
                return BASE_LOCATION;
            }
            Location[] locations = new Location[depth];
            for (int i = 0; i < depth; ++i) {
                byte tag = buf.get();
                short index = (short)(buf.get() & 0xFF);
                if (tag != 0 && !(tag == 1 | tag == 2) && tag != 3) {
                    throw new AnnotationFormatError("Bad Location encoding in Type Annotation");
                }
                if (tag != 3 && index != 0) {
                    throw new AnnotationFormatError("Bad Location encoding in Type Annotation");
                }
                locations[i] = new Location(tag, index);
            }
            return new LocationInfo(depth, locations);
        }

        public LocationInfo pushArray() {
            return this.pushLocation((byte)0, (short)0);
        }

        public LocationInfo pushInner() {
            return this.pushLocation((byte)1, (short)0);
        }

        public LocationInfo pushWildcard() {
            return this.pushLocation((byte)2, (short)0);
        }

        public LocationInfo pushTypeArg(short index) {
            return this.pushLocation((byte)3, index);
        }

        public LocationInfo pushLocation(byte tag, short index) {
            int newDepth = this.depth + 1;
            Location[] res = new Location[newDepth];
            System.arraycopy(this.locations, 0, res, 0, this.depth);
            res[newDepth - 1] = new Location(tag, (short)(index & 0xFF));
            return new LocationInfo(newDepth, res);
        }

        public TypeAnnotation[] filter(TypeAnnotation[] ta) {
            ArrayList<TypeAnnotation> l = new ArrayList<TypeAnnotation>(ta.length);
            for (TypeAnnotation t : ta) {
                if (!this.isSameLocationInfo(t.getLocationInfo())) continue;
                l.add(t);
            }
            return l.toArray(new TypeAnnotation[0]);
        }

        boolean isSameLocationInfo(LocationInfo other) {
            if (this.depth != other.depth) {
                return false;
            }
            for (int i = 0; i < this.depth; ++i) {
                if (this.locations[i].isSameLocation(other.locations[i])) continue;
                return false;
            }
            return true;
        }

        public static final class Location {
            public final byte tag;
            public final short index;

            boolean isSameLocation(Location other) {
                return this.tag == other.tag && this.index == other.index;
            }

            public Location(byte tag, short index) {
                this.tag = tag;
                this.index = index;
            }
        }
    }

    public static final class TypeAnnotationTargetInfo {
        private final TypeAnnotationTarget target;
        private final int count;
        private final int secondaryIndex;
        private static final int UNUSED_INDEX = -2;

        public TypeAnnotationTargetInfo(TypeAnnotationTarget target) {
            this(target, -2, -2);
        }

        public TypeAnnotationTargetInfo(TypeAnnotationTarget target, int count) {
            this(target, count, -2);
        }

        public TypeAnnotationTargetInfo(TypeAnnotationTarget target, int count, int secondaryIndex) {
            this.target = target;
            this.count = count;
            this.secondaryIndex = secondaryIndex;
        }

        public TypeAnnotationTarget getTarget() {
            return this.target;
        }

        public int getCount() {
            return this.count;
        }

        public int getSecondaryIndex() {
            return this.secondaryIndex;
        }

        public String toString() {
            return "" + (Object)((Object)this.target) + ": " + this.count + ", " + this.secondaryIndex;
        }
    }

    public static enum TypeAnnotationTarget {
        CLASS_TYPE_PARAMETER,
        METHOD_TYPE_PARAMETER,
        CLASS_EXTENDS,
        CLASS_IMPLEMENTS,
        CLASS_TYPE_PARAMETER_BOUND,
        METHOD_TYPE_PARAMETER_BOUND,
        FIELD,
        METHOD_RETURN,
        METHOD_RECEIVER,
        METHOD_FORMAL_PARAMETER,
        THROWS;

    }
}

