/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.SecurityProviderConstants;
import sun.security.x509.AlgorithmId;

public abstract class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger publicExponent;
    private int keySize;
    private final RSAUtil.KeyType type;
    private AlgorithmId rsaId;
    private SecureRandom random;

    RSAKeyPairGenerator(RSAUtil.KeyType type, int defKeySize) {
        this.type = type;
        this.initialize(defKeySize, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        try {
            this.initialize(new RSAKeyGenParameterSpec(keySize, RSAKeyGenParameterSpec.F4), random);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new InvalidParameterException(iape.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)params;
        int tmpKeySize = rsaSpec.getKeysize();
        BigInteger tmpPublicExponent = rsaSpec.getPublicExponent();
        AlgorithmParameterSpec tmpParams = rsaSpec.getKeyParams();
        if (tmpPublicExponent == null) {
            tmpPublicExponent = RSAKeyGenParameterSpec.F4;
        } else {
            if (tmpPublicExponent.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be 3 or larger");
            }
            if (tmpPublicExponent.bitLength() > tmpKeySize) {
                throw new InvalidAlgorithmParameterException("Public exponent must be smaller than key size");
            }
        }
        try {
            RSAKeyFactory.checkKeyLengths(tmpKeySize, tmpPublicExponent, 512, 65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        try {
            this.rsaId = RSAUtil.createAlgorithmId(this.type, tmpParams);
        }
        catch (ProviderException e) {
            throw new InvalidAlgorithmParameterException("Invalid key parameters", e);
        }
        this.keySize = tmpKeySize;
        this.publicExponent = tmpPublicExponent;
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger n;
        BigInteger q;
        BigInteger q1;
        BigInteger p;
        BigInteger p1;
        BigInteger phi;
        int lp = this.keySize + 1 >> 1;
        int lq = this.keySize - lp;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        BigInteger e = this.publicExponent;
        do {
            p = BigInteger.probablePrime(lp, this.random);
            do {
                if (p.compareTo(q = BigInteger.probablePrime(lq, this.random)) >= 0) continue;
                BigInteger tmp = p;
                p = q;
                q = tmp;
            } while ((n = p.multiply(q)).bitLength() < this.keySize);
        } while (!e.gcd(phi = (p1 = p.subtract(BigInteger.ONE)).multiply(q1 = q.subtract(BigInteger.ONE))).equals(BigInteger.ONE));
        BigInteger d = e.modInverse(phi);
        BigInteger pe = d.mod(p1);
        BigInteger qe = d.mod(q1);
        BigInteger coeff = q.modInverse(p);
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(this.rsaId, n, e);
            RSAPrivateCrtKeyImpl privateKey = new RSAPrivateCrtKeyImpl(this.rsaId, n, e, d, p, q, pe, qe, coeff);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static final class PSS
    extends RSAKeyPairGenerator {
        public PSS() {
            super(RSAUtil.KeyType.PSS, SecurityProviderConstants.DEF_RSASSA_PSS_KEY_SIZE);
        }
    }

    public static final class Legacy
    extends RSAKeyPairGenerator {
        public Legacy() {
            super(RSAUtil.KeyType.RSA, SecurityProviderConstants.DEF_RSA_KEY_SIZE);
        }
    }
}

