/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.security.AccessController;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.cldr.CLDRLocaleProviderAdapter;
import sun.util.locale.provider.FallbackLocaleProviderAdapter;
import sun.util.locale.provider.HostLocaleProviderAdapter;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.JRELocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.LocaleServiceProviderPool;
import sun.util.locale.provider.SPILocaleProviderAdapter;
import sun.util.spi.CalendarProvider;

public abstract class LocaleProviderAdapter {
    private static final List<Type> adapterPreference;
    private static LocaleProviderAdapter jreLocaleProviderAdapter;
    private static LocaleProviderAdapter spiLocaleProviderAdapter;
    private static LocaleProviderAdapter cldrLocaleProviderAdapter;
    private static LocaleProviderAdapter hostLocaleProviderAdapter;
    private static LocaleProviderAdapter fallbackLocaleProviderAdapter;
    static Type defaultLocaleProviderAdapter;
    private static ConcurrentMap<Class<? extends LocaleServiceProvider>, ConcurrentMap<Locale, LocaleProviderAdapter>> adapterCache;

    public static LocaleProviderAdapter forType(Type type) {
        switch (type) {
            case JRE: {
                return jreLocaleProviderAdapter;
            }
            case CLDR: {
                return cldrLocaleProviderAdapter;
            }
            case SPI: {
                return spiLocaleProviderAdapter;
            }
            case HOST: {
                return hostLocaleProviderAdapter;
            }
            case FALLBACK: {
                return fallbackLocaleProviderAdapter;
            }
        }
        throw new InternalError("unknown locale data adapter type");
    }

    public static LocaleProviderAdapter forJRE() {
        return jreLocaleProviderAdapter;
    }

    public static LocaleProviderAdapter getResourceBundleBased() {
        for (Type type : LocaleProviderAdapter.getAdapterPreference()) {
            if (type != Type.JRE && type != Type.CLDR && type != Type.FALLBACK) continue;
            return LocaleProviderAdapter.forType(type);
        }
        throw new InternalError();
    }

    public static List<Type> getAdapterPreference() {
        return adapterPreference;
    }

    public static LocaleProviderAdapter getAdapter(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        LocaleProviderAdapter adapter;
        ConcurrentHashMap<Locale, LocaleProviderAdapter> adapterMap = (ConcurrentHashMap<Locale, LocaleProviderAdapter>)adapterCache.get(providerClass);
        if (adapterMap != null) {
            adapter = (LocaleProviderAdapter)adapterMap.get(locale);
            if (adapter != null) {
                return adapter;
            }
        } else {
            adapterMap = new ConcurrentHashMap<Locale, LocaleProviderAdapter>();
            adapterCache.putIfAbsent(providerClass, adapterMap);
        }
        if ((adapter = LocaleProviderAdapter.findAdapter(providerClass, locale)) != null) {
            adapterMap.putIfAbsent(locale, adapter);
            return adapter;
        }
        List<Locale> lookupLocales = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT).getCandidateLocales("", locale);
        for (Locale loc : lookupLocales) {
            if (loc.equals(locale) || (adapter = LocaleProviderAdapter.findAdapter(providerClass, loc)) == null) continue;
            adapterMap.putIfAbsent(locale, adapter);
            return adapter;
        }
        adapterMap.putIfAbsent(locale, fallbackLocaleProviderAdapter);
        return fallbackLocaleProviderAdapter;
    }

    private static LocaleProviderAdapter findAdapter(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        for (Type type : LocaleProviderAdapter.getAdapterPreference()) {
            LocaleProviderAdapter adapter = LocaleProviderAdapter.forType(type);
            LocaleServiceProvider provider = adapter.getLocaleServiceProvider(providerClass);
            if (provider == null || !provider.isSupportedLocale(locale)) continue;
            return adapter;
        }
        return null;
    }

    public static boolean isSupportedLocale(Locale locale, Type type, Set<String> langtags) {
        assert (type == Type.JRE || type == Type.CLDR || type == Type.FALLBACK);
        if (Locale.ROOT.equals(locale)) {
            return true;
        }
        if (type == Type.FALLBACK) {
            return false;
        }
        if (langtags.contains((locale = locale.stripExtensions()).toLanguageTag())) {
            return true;
        }
        if (type == Type.JRE) {
            String oldname = locale.toString().replace('_', '-');
            return langtags.contains(oldname) || "ja-JP-JP".equals(oldname) || "th-TH-TH".equals(oldname) || "no-NO-NY".equals(oldname);
        }
        return false;
    }

    public static Locale[] toLocaleArray(Set<String> tags) {
        Locale[] locs = new Locale[tags.size() + 1];
        int index = 0;
        locs[index++] = Locale.ROOT;
        Iterator<String> iterator = tags.iterator();
        block8: while (iterator.hasNext()) {
            String tag;
            switch (tag = iterator.next()) {
                case "ja-JP-JP": {
                    locs[index++] = JRELocaleConstants.JA_JP_JP;
                    continue block8;
                }
                case "th-TH-TH": {
                    locs[index++] = JRELocaleConstants.TH_TH_TH;
                    continue block8;
                }
            }
            locs[index++] = Locale.forLanguageTag(tag);
        }
        return locs;
    }

    public abstract Type getAdapterType();

    public abstract <P extends LocaleServiceProvider> P getLocaleServiceProvider(Class<P> var1);

    public abstract BreakIteratorProvider getBreakIteratorProvider();

    public abstract CollatorProvider getCollatorProvider();

    public abstract DateFormatProvider getDateFormatProvider();

    public abstract DateFormatSymbolsProvider getDateFormatSymbolsProvider();

    public abstract DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider();

    public abstract NumberFormatProvider getNumberFormatProvider();

    public abstract CurrencyNameProvider getCurrencyNameProvider();

    public abstract LocaleNameProvider getLocaleNameProvider();

    public abstract TimeZoneNameProvider getTimeZoneNameProvider();

    public abstract CalendarDataProvider getCalendarDataProvider();

    public abstract CalendarNameProvider getCalendarNameProvider();

    public abstract CalendarProvider getCalendarProvider();

    public abstract LocaleResources getLocaleResources(Locale var1);

    public abstract Locale[] getAvailableLocales();

    static {
        jreLocaleProviderAdapter = new JRELocaleProviderAdapter();
        spiLocaleProviderAdapter = new SPILocaleProviderAdapter();
        cldrLocaleProviderAdapter = null;
        hostLocaleProviderAdapter = null;
        fallbackLocaleProviderAdapter = null;
        defaultLocaleProviderAdapter = null;
        adapterCache = new ConcurrentHashMap<Class<? extends LocaleServiceProvider>, ConcurrentMap<Locale, LocaleProviderAdapter>>();
        String order = AccessController.doPrivileged(new GetPropertyAction("java.locale.providers"));
        ArrayList<Type> typeList = new ArrayList<Type>();
        if (order != null && order.length() != 0) {
            String[] types;
            for (String type : types = order.split(",")) {
                try {
                    Type aType = Type.valueOf(type.trim().toUpperCase(Locale.ROOT));
                    switch (aType) {
                        case CLDR: {
                            if (cldrLocaleProviderAdapter != null) break;
                            cldrLocaleProviderAdapter = new CLDRLocaleProviderAdapter();
                            break;
                        }
                        case HOST: {
                            if (hostLocaleProviderAdapter != null) break;
                            hostLocaleProviderAdapter = new HostLocaleProviderAdapter();
                        }
                    }
                    if (typeList.contains((Object)aType)) continue;
                    typeList.add(aType);
                }
                catch (IllegalArgumentException | UnsupportedOperationException e) {
                    LocaleServiceProviderPool.config(LocaleProviderAdapter.class, e.toString());
                }
            }
        }
        if (!typeList.isEmpty()) {
            if (!typeList.contains((Object)Type.JRE)) {
                fallbackLocaleProviderAdapter = new FallbackLocaleProviderAdapter();
                typeList.add(Type.FALLBACK);
                defaultLocaleProviderAdapter = Type.FALLBACK;
            } else {
                defaultLocaleProviderAdapter = Type.JRE;
            }
        } else {
            typeList.add(Type.JRE);
            typeList.add(Type.SPI);
            defaultLocaleProviderAdapter = Type.JRE;
        }
        adapterPreference = Collections.unmodifiableList(typeList);
    }

    public static enum Type {
        JRE("sun.util.resources", "sun.text.resources"),
        CLDR("sun.util.resources.cldr", "sun.text.resources.cldr"),
        SPI,
        HOST,
        FALLBACK("sun.util.resources", "sun.text.resources");

        private final String UTIL_RESOURCES_PACKAGE;
        private final String TEXT_RESOURCES_PACKAGE;

        private Type() {
            this(null, null);
        }

        private Type(String util, String text) {
            this.UTIL_RESOURCES_PACKAGE = util;
            this.TEXT_RESOURCES_PACKAGE = text;
        }

        public String getUtilResourcesPackage() {
            return this.UTIL_RESOURCES_PACKAGE;
        }

        public String getTextResourcesPackage() {
            return this.TEXT_RESOURCES_PACKAGE;
        }
    }
}

