/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ClientHello;
import sun.security.ssl.JsseJce;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.ServerHello;

abstract class HelloCookieManager {
    HelloCookieManager() {
    }

    abstract byte[] createCookie(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2) throws IOException;

    abstract boolean isCookieValid(ServerHandshakeContext var1, ClientHello.ClientHelloMessage var2, byte[] var3) throws IOException;

    private static final class T13HelloCookieManager
    extends HelloCookieManager {
        final SecureRandom secureRandom;
        private int cookieVersion;
        private final byte[] cookieSecret;
        private final byte[] legacySecret;

        T13HelloCookieManager(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
            this.cookieVersion = secureRandom.nextInt();
            this.cookieSecret = new byte[64];
            this.legacySecret = new byte[64];
            secureRandom.nextBytes(this.cookieSecret);
            System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        byte[] createCookie(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello) throws IOException {
            byte[] secret;
            int version;
            T13HelloCookieManager t13HelloCookieManager = this;
            synchronized (t13HelloCookieManager) {
                version = this.cookieVersion;
                secret = this.cookieSecret;
                if ((this.cookieVersion & 0xFFFFFF) == 0) {
                    System.arraycopy(this.cookieSecret, 0, this.legacySecret, 0, 64);
                    this.secureRandom.nextBytes(this.cookieSecret);
                }
                ++this.cookieVersion;
            }
            MessageDigest md = JsseJce.getMessageDigest(context.negotiatedCipherSuite.hashAlg.name);
            byte[] headerBytes = clientHello.getHeaderBytes();
            md.update(headerBytes);
            byte[] headerCookie = md.digest(secret);
            context.handshakeHash.update();
            byte[] clientHelloHash = context.handshakeHash.digest();
            byte[] prefix = new byte[]{(byte)(context.negotiatedCipherSuite.id >> 8 & 0xFF), (byte)(context.negotiatedCipherSuite.id & 0xFF), (byte)(version >> 24 & 0xFF)};
            byte[] cookie = Arrays.copyOf(prefix, prefix.length + headerCookie.length + clientHelloHash.length);
            System.arraycopy(headerCookie, 0, cookie, prefix.length, headerCookie.length);
            System.arraycopy(clientHelloHash, 0, cookie, prefix.length + headerCookie.length, clientHelloHash.length);
            return cookie;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isCookieValid(ServerHandshakeContext context, ClientHello.ClientHelloMessage clientHello, byte[] cookie) throws IOException {
            byte[] secret;
            if (cookie == null || cookie.length <= 32) {
                return false;
            }
            int csId = (cookie[0] & 0xFF) << 8 | cookie[1] & 0xFF;
            CipherSuite cs = CipherSuite.valueOf(csId);
            if (cs == null || cs.hashAlg == null || cs.hashAlg.hashLength == 0) {
                return false;
            }
            int hashLen = cs.hashAlg.hashLength;
            if (cookie.length != 3 + hashLen * 2) {
                return false;
            }
            byte[] prevHeadCookie = Arrays.copyOfRange(cookie, 3, 3 + hashLen);
            byte[] prevClientHelloHash = Arrays.copyOfRange(cookie, 3 + hashLen, cookie.length);
            T13HelloCookieManager t13HelloCookieManager = this;
            synchronized (t13HelloCookieManager) {
                secret = (byte)(this.cookieVersion >> 24 & 0xFF) == cookie[2] ? this.cookieSecret : this.legacySecret;
            }
            MessageDigest md = JsseJce.getMessageDigest(cs.hashAlg.name);
            byte[] headerBytes = clientHello.getHeaderBytes();
            md.update(headerBytes);
            byte[] headerCookie = md.digest(secret);
            if (!MessageDigest.isEqual(headerCookie, prevHeadCookie)) {
                return false;
            }
            byte[] hrrMessage = ServerHello.hrrReproducer.produce(context, clientHello);
            context.handshakeHash.push(hrrMessage);
            byte[] hashedClientHello = new byte[4 + hashLen];
            hashedClientHello[0] = SSLHandshake.MESSAGE_HASH.id;
            hashedClientHello[1] = 0;
            hashedClientHello[2] = 0;
            hashedClientHello[3] = (byte)(hashLen & 0xFF);
            System.arraycopy(prevClientHelloHash, 0, hashedClientHello, 4, hashLen);
            context.handshakeHash.push(hashedClientHello);
            return true;
        }
    }

    static class Builder {
        final SecureRandom secureRandom;
        private volatile T13HelloCookieManager t13HelloCookieManager;

        Builder(SecureRandom secureRandom) {
            this.secureRandom = secureRandom;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        HelloCookieManager valueOf(ProtocolVersion protocolVersion) {
            if (protocolVersion.useTLS13PlusSpec()) {
                if (this.t13HelloCookieManager != null) {
                    return this.t13HelloCookieManager;
                }
                Builder builder = this;
                synchronized (builder) {
                    if (this.t13HelloCookieManager == null) {
                        this.t13HelloCookieManager = new T13HelloCookieManager(this.secureRandom);
                    }
                }
                return this.t13HelloCookieManager;
            }
            return null;
        }
    }
}

