/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.io.InvalidObjectException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.security.action.GetPropertyAction;

public final class IORCheckImpl {
    private static final Set<String> stubsToCheck;

    private static Set<String> getStubsToCheck(boolean checkLocalStubs, boolean checkRemoteStubs) {
        if (!checkLocalStubs && !checkRemoteStubs) {
            return Collections.emptySet();
        }
        ArrayList<String> stubs = new ArrayList<String>();
        if (checkLocalStubs) {
            stubs.addAll(IORCheckImpl.getLocalStubs());
        }
        if (checkRemoteStubs) {
            stubs.addAll(IORCheckImpl.getRemoteStubs());
        }
        return Collections.unmodifiableSet(new HashSet(stubs));
    }

    private static List<String> getLocalStubs() {
        String[] localStubs = new String[]{"org.omg.DynamicAny._DynAnyFactoryStub", "org.omg.DynamicAny._DynAnyStub", "org.omg.DynamicAny._DynArrayStub", "org.omg.DynamicAny._DynEnumStub", "org.omg.DynamicAny._DynFixedStub", "org.omg.DynamicAny._DynSequenceStub", "org.omg.DynamicAny._DynStructStub", "org.omg.DynamicAny._DynUnionStub", "org.omg.DynamicAny._DynValueStub"};
        return Arrays.asList(localStubs);
    }

    private static List<String> getRemoteStubs() {
        String[] remoteStubs = new String[]{"com.sun.corba.se.spi.activation._ActivatorStub", "com.sun.corba.se.spi.activation._InitialNameServiceStub", "com.sun.corba.se.spi.activation._LocatorStub", "com.sun.corba.se.spi.activation._RepositoryStub", "com.sun.corba.se.spi.activation._ServerManagerStub", "com.sun.corba.se.spi.activation._ServerStub", "org.omg.CosNaming._BindingIteratorStub", "org.omg.CosNaming._NamingContextExtStub", "org.omg.CosNaming._NamingContextStub", "org.omg.PortableServer._ServantActivatorStub", "org.omg.PortableServer._ServantLocatorStub"};
        return Arrays.asList(remoteStubs);
    }

    public static void check(String str, String stubClassName) throws InvalidObjectException {
        if (stubsToCheck.contains(stubClassName) && !str.startsWith("IOR:")) {
            throw new InvalidObjectException("IOR: expected");
        }
    }

    private static boolean getBooleanProperty(String property, boolean defaultValue) {
        String value = AccessController.doPrivileged(new GetPropertyAction(property, String.valueOf(defaultValue)));
        return "true".equalsIgnoreCase(value);
    }

    static {
        boolean checkLocalStubs = !IORCheckImpl.getBooleanProperty("org.omg.DynamicAny.disableIORCheck", IORCheckImpl.getBooleanProperty("com.sun.CORBA.ORBAllowDeserializeObject", false));
        boolean checkRemoteStubs = IORCheckImpl.getBooleanProperty("org.omg.CORBA.IDL.Stubs.enableIORCheck", false);
        stubsToCheck = IORCheckImpl.getStubsToCheck(checkLocalStubs, checkRemoteStubs);
    }
}

