/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.rmi;

import com.sun.jndi.rmi.registry.RegistryContext;
import com.sun.jndi.toolkit.url.GenericURLContext;
import com.sun.jndi.toolkit.url.Uri;
import java.net.URI;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Locale;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.spi.ResolveResult;
import sun.security.action.GetPropertyAction;

public class rmiURLContext
extends GenericURLContext {
    private static final String PARSE_MODE_PROP = "com.sun.jndi.rmiURLParsing";
    private static final Uri.ParseMode DEFAULT_PARSE_MODE = Uri.ParseMode.COMPAT;
    public static final Uri.ParseMode PARSE_MODE;

    public rmiURLContext(Hashtable<?, ?> env) {
        super(env);
    }

    @Override
    protected ResolveResult getRootURLContext(String url, Hashtable<?, ?> env) throws NamingException {
        Parser parser = new Parser(url);
        parser.parse();
        String host = parser.host;
        int port = parser.port;
        String objName = parser.objName;
        CompositeName remaining = new CompositeName();
        if (objName != null) {
            remaining.add(objName);
        }
        RegistryContext regCtx = new RegistryContext(host, port, env);
        return new ResolveResult((Object)regCtx, remaining);
    }

    static {
        GetPropertyAction action = new GetPropertyAction(PARSE_MODE_PROP, DEFAULT_PARSE_MODE.toString());
        Uri.ParseMode parseMode = DEFAULT_PARSE_MODE;
        try {
            String mode = AccessController.doPrivileged(action);
            parseMode = Uri.ParseMode.valueOf(mode.toUpperCase(Locale.ROOT));
        }
        catch (Throwable t) {
            parseMode = DEFAULT_PARSE_MODE;
        }
        finally {
            PARSE_MODE = parseMode;
        }
    }

    public static class Parser {
        final String url;
        final Uri.ParseMode mode;
        String host = null;
        int port = -1;
        String objName = null;

        public Parser(String url) {
            this(url, PARSE_MODE);
        }

        public Parser(String url, Uri.ParseMode mode) {
            this.url = url;
            this.mode = mode;
        }

        public String url() {
            return this.url;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String objName() {
            return this.objName;
        }

        public Uri.ParseMode mode() {
            return this.mode;
        }

        public void parse() throws NamingException {
            if (!this.url.startsWith("rmi:")) {
                throw new IllegalArgumentException("rmiURLContext: name is not an RMI URL: " + this.url);
            }
            switch (this.mode) {
                case STRICT: {
                    this.parseStrict();
                    break;
                }
                case COMPAT: {
                    this.parseCompat();
                    break;
                }
                case LEGACY: {
                    this.parseLegacy();
                }
            }
        }

        private void parseStrict() throws NamingException {
            int fmark;
            assert (this.url.startsWith("rmi:"));
            if (this.url.equals("rmi:") || this.url.equals("rmi://")) {
                return;
            }
            int i = 4;
            if (this.url.startsWith("//", i)) {
                i += 2;
                try {
                    URI uri = URI.create(this.url);
                    this.host = uri.getHost();
                    this.port = uri.getPort();
                    String auth = uri.getRawAuthority();
                    String hostport = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                    if (!hostport.equals(auth)) {
                        boolean failed = true;
                        if (hostport.equals("") && auth.startsWith(":")) {
                            try {
                                this.port = Integer.parseInt(auth.substring(1));
                                failed = false;
                            }
                            catch (NumberFormatException x) {
                                failed = true;
                            }
                        }
                        if (failed) {
                            throw this.newNamingException(new IllegalArgumentException("invalid authority: " + auth));
                        }
                    }
                    i += auth.length();
                }
                catch (IllegalArgumentException iae) {
                    throw this.newNamingException(iae);
                }
            }
            if ((fmark = this.url.indexOf(35, i)) > -1 && !this.acceptsFragment()) {
                throw this.newNamingException(new IllegalArgumentException("URI fragments not supported: " + this.url));
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", i)) {
                ++i;
            }
            if (i < this.url.length()) {
                this.objName = this.url.substring(i);
            }
        }

        private void parseCompat() throws NamingException {
            int enda;
            assert (this.url.startsWith("rmi:"));
            int i = 4;
            boolean hasAuthority = this.url.startsWith("//", i);
            if (hasAuthority) {
                i += 2;
            }
            int slash = this.url.indexOf(47, i);
            int qmark = this.url.indexOf(63, i);
            int fmark = this.url.indexOf(35, i);
            if (fmark > -1 && qmark > fmark) {
                qmark = -1;
            }
            if (fmark > -1 && slash > fmark) {
                slash = -1;
            }
            if (qmark > -1 && slash > qmark) {
                slash = -1;
            }
            int n = slash > -1 ? slash : (qmark > -1 ? qmark : (enda = fmark > -1 ? fmark : this.url.length()));
            if (fmark > -1 && !this.acceptsFragment()) {
                throw this.newNamingException(new IllegalArgumentException("URI fragments not supported: " + this.url));
            }
            if (hasAuthority && enda > i) {
                if (this.url.startsWith(":", i)) {
                    this.host = "";
                    if (enda > ++i) {
                        this.port = Integer.parseInt(this.url.substring(i, enda));
                    }
                } else {
                    try {
                        URI uri = URI.create(this.url.substring(0, enda));
                        this.host = uri.getHost();
                        this.port = uri.getPort();
                        String hostport = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                        if (!hostport.equals(uri.getRawAuthority())) {
                            throw this.newNamingException(new IllegalArgumentException("invalid authority: " + uri.getRawAuthority()));
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        throw this.newNamingException(iae);
                    }
                }
                i = enda;
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", i)) {
                ++i;
            }
            if (i < this.url.length()) {
                this.objName = this.url.substring(i);
            }
        }

        private void parseLegacy() {
            assert (this.url.startsWith("rmi:"));
            int i = 4;
            if (this.url.startsWith("//", i)) {
                int slash = this.url.indexOf(47, i += 2);
                if (slash < 0) {
                    slash = this.url.length();
                }
                if (this.url.startsWith("[", i)) {
                    int brac = this.url.indexOf(93, i + 1);
                    if (brac < 0 || brac > slash) {
                        throw new IllegalArgumentException("rmiURLContext: name is an Invalid URL: " + this.url);
                    }
                    this.host = this.url.substring(i, brac + 1);
                    i = brac + 1;
                } else {
                    int hostEnd;
                    int colon = this.url.indexOf(58, i);
                    int n = hostEnd = colon < 0 || colon > slash ? slash : colon;
                    if (i < hostEnd) {
                        this.host = this.url.substring(i, hostEnd);
                    }
                    i = hostEnd;
                }
                if (i + 1 < slash) {
                    if (this.url.startsWith(":", i)) {
                        this.port = Integer.parseInt(this.url.substring(++i, slash));
                    } else {
                        throw new IllegalArgumentException("rmiURLContext: name is an Invalid URL: " + this.url);
                    }
                }
                i = slash;
            }
            if ("".equals(this.host)) {
                this.host = null;
            }
            if (this.url.startsWith("/", i)) {
                ++i;
            }
            if (i < this.url.length()) {
                this.objName = this.url.substring(i);
            }
        }

        NamingException newNamingException(Throwable cause) {
            InvalidNameException ne = new InvalidNameException(cause.getMessage());
            ne.initCause(cause);
            return ne;
        }

        protected boolean acceptsFragment() {
            return true;
        }
    }
}

