/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.UIResource;
import javax.swing.text.AbstractDocument;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.NumberFormatter;
import javax.swing.text.TextAction;

public class JFormattedTextField
extends JTextField {
    private static final String uiClassID = "FormattedTextFieldUI";
    private static final Action[] defaultActions = new Action[]{new CommitAction(), new CancelAction()};
    public static final int COMMIT = 0;
    public static final int COMMIT_OR_REVERT = 1;
    public static final int REVERT = 2;
    public static final int PERSIST = 3;
    private AbstractFormatterFactory factory;
    private AbstractFormatter format;
    private Object value;
    private boolean editValid;
    private int focusLostBehavior;
    private boolean edited;
    private DocumentListener documentListener;
    private Object mask;
    private ActionMap textFormatterActionMap;
    private boolean composedTextExists = false;
    private FocusLostHandler focusLostHandler;

    public JFormattedTextField() {
        this.enableEvents(4L);
        this.setFocusLostBehavior(1);
    }

    public JFormattedTextField(Object value) {
        this();
        this.setValue(value);
    }

    public JFormattedTextField(Format format) {
        this();
        this.setFormatterFactory(this.getDefaultFormatterFactory(format));
    }

    public JFormattedTextField(AbstractFormatter formatter) {
        this(new DefaultFormatterFactory(formatter));
    }

    public JFormattedTextField(AbstractFormatterFactory factory) {
        this();
        this.setFormatterFactory(factory);
    }

    public JFormattedTextField(AbstractFormatterFactory factory, Object currentValue) {
        this(currentValue);
        this.setFormatterFactory(factory);
    }

    public void setFocusLostBehavior(int behavior) {
        if (behavior != 0 && behavior != 1 && behavior != 3 && behavior != 2) {
            throw new IllegalArgumentException("setFocusLostBehavior must be one of: JFormattedTextField.COMMIT, JFormattedTextField.COMMIT_OR_REVERT, JFormattedTextField.PERSIST or JFormattedTextField.REVERT");
        }
        this.focusLostBehavior = behavior;
    }

    public int getFocusLostBehavior() {
        return this.focusLostBehavior;
    }

    public void setFormatterFactory(AbstractFormatterFactory tf) {
        AbstractFormatterFactory oldFactory = this.factory;
        this.factory = tf;
        this.firePropertyChange("formatterFactory", oldFactory, tf);
        this.setValue(this.getValue(), true, false);
    }

    public AbstractFormatterFactory getFormatterFactory() {
        return this.factory;
    }

    protected void setFormatter(AbstractFormatter format) {
        AbstractFormatter oldFormat = this.format;
        if (oldFormat != null) {
            oldFormat.uninstall();
        }
        this.setEditValid(true);
        this.format = format;
        if (format != null) {
            format.install(this);
        }
        this.setEdited(false);
        this.firePropertyChange("textFormatter", oldFormat, format);
    }

    public AbstractFormatter getFormatter() {
        return this.format;
    }

    public void setValue(Object value) {
        if (value != null && this.getFormatterFactory() == null) {
            this.setFormatterFactory(this.getDefaultFormatterFactory(value));
        }
        this.setValue(value, true, true);
    }

    public Object getValue() {
        return this.value;
    }

    public void commitEdit() throws ParseException {
        AbstractFormatter format = this.getFormatter();
        if (format != null) {
            this.setValue(format.stringToValue(this.getText()), false, true);
        }
    }

    private void setEditValid(boolean isValid) {
        if (isValid != this.editValid) {
            this.editValid = isValid;
            this.firePropertyChange("editValid", (Object)(!isValid ? 1 : 0), (Object)isValid);
        }
    }

    public boolean isEditValid() {
        return this.editValid;
    }

    protected void invalidEdit() {
        UIManager.getLookAndFeel().provideErrorFeedback(this);
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        AttributedCharacterIterator text = e.getText();
        int commitCount = e.getCommittedCharacterCount();
        if (text != null) {
            int begin = text.getBeginIndex();
            int end = text.getEndIndex();
            this.composedTextExists = end - begin > commitCount;
        } else {
            this.composedTextExists = false;
        }
        super.processInputMethodEvent(e);
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.isTemporary()) {
            return;
        }
        if (this.isEdited() && e.getID() == 1005) {
            InputContext ic = this.getInputContext();
            if (this.focusLostHandler == null) {
                this.focusLostHandler = new FocusLostHandler();
            }
            if (ic != null && this.composedTextExists) {
                ic.endComposition();
                EventQueue.invokeLater(this.focusLostHandler);
            } else {
                this.focusLostHandler.run();
            }
        } else if (!this.isEdited()) {
            this.setValue(this.getValue(), true, true);
        }
    }

    @Override
    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void setDocument(Document doc) {
        if (this.documentListener != null && this.getDocument() != null) {
            this.getDocument().removeDocumentListener(this.documentListener);
        }
        super.setDocument(doc);
        if (this.documentListener == null) {
            this.documentListener = new DocumentHandler();
        }
        doc.addDocumentListener(this.documentListener);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void setFormatterActions(Action[] actions) {
        if (actions == null) {
            if (this.textFormatterActionMap != null) {
                this.textFormatterActionMap.clear();
            }
        } else {
            if (this.textFormatterActionMap == null) {
                ActionMap map = this.getActionMap();
                this.textFormatterActionMap = new ActionMap();
                while (map != null) {
                    ActionMap parent = map.getParent();
                    if (parent instanceof UIResource || parent == null) {
                        map.setParent(this.textFormatterActionMap);
                        this.textFormatterActionMap.setParent(parent);
                        break;
                    }
                    map = parent;
                }
            }
            for (int counter = actions.length - 1; counter >= 0; --counter) {
                Object key = actions[counter].getValue("Name");
                if (key == null) continue;
                this.textFormatterActionMap.put(key, actions[counter]);
            }
        }
    }

    private void setValue(Object value, boolean createFormat, boolean firePC) {
        Object oldValue = this.value;
        this.value = value;
        if (createFormat) {
            AbstractFormatterFactory factory = this.getFormatterFactory();
            AbstractFormatter atf = factory != null ? factory.getFormatter(this) : null;
            this.setFormatter(atf);
        } else {
            this.setEditValid(true);
        }
        this.setEdited(false);
        if (firePC) {
            this.firePropertyChange("value", oldValue, value);
        }
    }

    private void setEdited(boolean edited) {
        this.edited = edited;
    }

    private boolean isEdited() {
        return this.edited;
    }

    private AbstractFormatterFactory getDefaultFormatterFactory(Object type) {
        if (type instanceof DateFormat) {
            return new DefaultFormatterFactory(new DateFormatter((DateFormat)type));
        }
        if (type instanceof NumberFormat) {
            return new DefaultFormatterFactory(new NumberFormatter((NumberFormat)type));
        }
        if (type instanceof Format) {
            return new DefaultFormatterFactory(new InternationalFormatter((Format)type));
        }
        if (type instanceof Date) {
            return new DefaultFormatterFactory(new DateFormatter());
        }
        if (type instanceof Number) {
            NumberFormatter displayFormatter = new NumberFormatter();
            displayFormatter.setValueClass(type.getClass());
            NumberFormatter editFormatter = new NumberFormatter(new DecimalFormat("#.#"));
            editFormatter.setValueClass(type.getClass());
            return new DefaultFormatterFactory(displayFormatter, displayFormatter, editFormatter);
        }
        return new DefaultFormatterFactory(new DefaultFormatter());
    }

    private class DocumentHandler
    implements DocumentListener,
    Serializable {
        private DocumentHandler() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JFormattedTextField.this.setEdited(true);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JFormattedTextField.this.setEdited(true);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private static class CancelAction
    extends TextAction {
        public CancelAction() {
            super("reset-field-edit");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof JFormattedTextField) {
                JFormattedTextField ftf = (JFormattedTextField)target;
                ftf.setValue(ftf.getValue());
            }
        }

        @Override
        public boolean isEnabled() {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof JFormattedTextField) {
                JFormattedTextField ftf = (JFormattedTextField)target;
                return ftf.isEdited();
            }
            return super.isEnabled();
        }
    }

    static class CommitAction
    extends JTextField.NotifyAction {
        CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)target).commitEdit();
                }
                catch (ParseException pe) {
                    ((JFormattedTextField)target).invalidEdit();
                    return;
                }
            }
            super.actionPerformed(e);
        }

        @Override
        public boolean isEnabled() {
            JTextComponent target = this.getFocusedComponent();
            if (target instanceof JFormattedTextField) {
                JFormattedTextField ftf = (JFormattedTextField)target;
                return ftf.isEdited();
            }
            return super.isEnabled();
        }
    }

    public static abstract class AbstractFormatter
    implements Serializable {
        private JFormattedTextField ftf;

        public void install(JFormattedTextField ftf) {
            if (this.ftf != null) {
                this.uninstall();
            }
            this.ftf = ftf;
            if (ftf != null) {
                try {
                    ftf.setText(this.valueToString(ftf.getValue()));
                }
                catch (ParseException pe) {
                    ftf.setText("");
                    this.setEditValid(false);
                }
                this.installDocumentFilter(this.getDocumentFilter());
                ftf.setNavigationFilter(this.getNavigationFilter());
                ftf.setFormatterActions(this.getActions());
            }
        }

        public void uninstall() {
            if (this.ftf != null) {
                this.installDocumentFilter(null);
                this.ftf.setNavigationFilter(null);
                this.ftf.setFormatterActions(null);
            }
        }

        public abstract Object stringToValue(String var1) throws ParseException;

        public abstract String valueToString(Object var1) throws ParseException;

        protected JFormattedTextField getFormattedTextField() {
            return this.ftf;
        }

        protected void invalidEdit() {
            JFormattedTextField ftf = this.getFormattedTextField();
            if (ftf != null) {
                ftf.invalidEdit();
            }
        }

        protected void setEditValid(boolean valid) {
            JFormattedTextField ftf = this.getFormattedTextField();
            if (ftf != null) {
                ftf.setEditValid(valid);
            }
        }

        protected Action[] getActions() {
            return null;
        }

        protected DocumentFilter getDocumentFilter() {
            return null;
        }

        protected NavigationFilter getNavigationFilter() {
            return null;
        }

        protected Object clone() throws CloneNotSupportedException {
            AbstractFormatter formatter = (AbstractFormatter)super.clone();
            formatter.ftf = null;
            return formatter;
        }

        private void installDocumentFilter(DocumentFilter filter) {
            JFormattedTextField ftf = this.getFormattedTextField();
            if (ftf != null) {
                Document doc = ftf.getDocument();
                if (doc instanceof AbstractDocument) {
                    ((AbstractDocument)doc).setDocumentFilter(filter);
                }
                doc.putProperty(DocumentFilter.class, null);
            }
        }
    }

    public static abstract class AbstractFormatterFactory {
        public abstract AbstractFormatter getFormatter(JFormattedTextField var1);
    }

    private class FocusLostHandler
    implements Runnable,
    Serializable {
        private FocusLostHandler() {
        }

        @Override
        public void run() {
            int fb = JFormattedTextField.this.getFocusLostBehavior();
            if (fb == 0 || fb == 1) {
                try {
                    JFormattedTextField.this.commitEdit();
                    JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true, true);
                }
                catch (ParseException pe) {
                    if (fb == 1) {
                        JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true, true);
                    }
                }
            } else if (fb == 2) {
                JFormattedTextField.this.setValue(JFormattedTextField.this.getValue(), true, true);
            }
        }
    }
}

