/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.ConstructorProperties;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import sun.awt.AWTAccessor;
import sun.swing.SwingUtilities2;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "TreeUI";
    protected transient TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    protected boolean rootVisible;
    protected transient TreeCellRenderer cellRenderer;
    protected int rowHeight;
    private boolean rowHeightSet = false;
    private transient Hashtable<TreePath, Boolean> expandedState;
    protected boolean showsRootHandles;
    private boolean showsRootHandlesSet = false;
    protected transient TreeSelectionRedirector selectionRedirector;
    protected transient TreeCellEditor cellEditor;
    protected boolean editable;
    protected boolean largeModel;
    protected int visibleRowCount;
    protected boolean invokesStopCellEditing;
    protected boolean scrollsOnExpand;
    private boolean scrollsOnExpandSet = false;
    protected int toggleClickCount = 2;
    protected transient TreeModelListener treeModelListener;
    private transient Stack<Stack<TreePath>> expandedStack;
    private TreePath leadPath;
    private TreePath anchorPath;
    private boolean expandsSelectedPaths;
    private boolean settingUI;
    private boolean dragEnabled;
    private DropMode dropMode = DropMode.USE_SELECTION;
    private transient DropLocation dropLocation;
    private int expandRow = -1;
    private TreeTimer dropTimer;
    private transient TreeExpansionListener uiTreeExpansionListener;
    private static int TEMP_STACK_SIZE = 11;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode parent = new DefaultMutableTreeNode("colors");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("blue"));
        parent.add(new DefaultMutableTreeNode("violet"));
        parent.add(new DefaultMutableTreeNode("red"));
        parent.add(new DefaultMutableTreeNode("yellow"));
        parent = new DefaultMutableTreeNode("sports");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("basketball"));
        parent.add(new DefaultMutableTreeNode("soccer"));
        parent.add(new DefaultMutableTreeNode("football"));
        parent.add(new DefaultMutableTreeNode("hockey"));
        parent = new DefaultMutableTreeNode("food");
        root.add(parent);
        parent.add(new DefaultMutableTreeNode("hot dogs"));
        parent.add(new DefaultMutableTreeNode("pizza"));
        parent.add(new DefaultMutableTreeNode("ravioli"));
        parent.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(root);
    }

    protected static TreeModel createTreeModel(Object value) {
        DefaultMutableTreeNode root;
        if (value instanceof Object[] || value instanceof Hashtable || value instanceof Vector) {
            root = new DefaultMutableTreeNode("root");
            DynamicUtilTreeNode.createChildren(root, value);
        } else {
            root = new DynamicUtilTreeNode((Object)"root", value);
        }
        return new DefaultTreeModel(root, false);
    }

    public JTree() {
        this(JTree.getDefaultTreeModel());
    }

    public JTree(Object[] value) {
        this(JTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(Vector<?> value) {
        this(JTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(Hashtable<?, ?> value) {
        this(JTree.createTreeModel(value));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.expandRoot();
    }

    public JTree(TreeNode root) {
        this(root, false);
    }

    public JTree(TreeNode root, boolean asksAllowsChildren) {
        this(new DefaultTreeModel(root, asksAllowsChildren));
    }

    @ConstructorProperties(value={"model"})
    public JTree(TreeModel newModel) {
        this.expandedStack = new Stack();
        this.expandedState = new Hashtable();
        this.setLayout(null);
        this.rowHeight = 16;
        this.visibleRowCount = 20;
        this.rootVisible = true;
        this.selectionModel = new DefaultTreeSelectionModel();
        this.cellRenderer = null;
        this.scrollsOnExpand = true;
        this.setOpaque(true);
        this.expandsSelectedPaths = true;
        this.updateUI();
        this.setModel(newModel);
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI ui) {
        if (this.ui != ui) {
            this.settingUI = true;
            this.uiTreeExpansionListener = null;
            try {
                super.setUI(ui);
            }
            finally {
                this.settingUI = false;
            }
        }
    }

    @Override
    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        SwingUtilities.updateRendererOrEditorUI(this.getCellRenderer());
        SwingUtilities.updateRendererOrEditorUI(this.getCellEditor());
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer x) {
        TreeCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = x;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, this.cellRenderer);
        this.invalidate();
    }

    public void setEditable(boolean flag) {
        boolean oldValue = this.editable;
        this.editable = flag;
        this.firePropertyChange(EDITABLE_PROPERTY, oldValue, flag);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", oldValue ? AccessibleState.EDITABLE : null, flag ? AccessibleState.EDITABLE : null);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setCellEditor(TreeCellEditor cellEditor) {
        TreeCellEditor oldEditor = this.cellEditor;
        this.cellEditor = cellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, oldEditor, cellEditor);
        this.invalidate();
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel newModel) {
        this.clearSelection();
        TreeModel oldModel = this.treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.accessibleContext != null) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
            if (newModel != null) {
                newModel.addTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
        }
        this.treeModel = newModel;
        this.clearToggledPaths();
        if (this.treeModel != null) {
            Object treeRoot;
            if (this.treeModelListener == null) {
                this.treeModelListener = this.createTreeModelListener();
            }
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
            if ((treeRoot = this.treeModel.getRoot()) != null && !this.treeModel.isLeaf(treeRoot)) {
                this.expandedState.put(new TreePath(treeRoot), Boolean.TRUE);
            }
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, oldModel, this.treeModel);
        this.invalidate();
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean rootVisible) {
        boolean oldValue = this.rootVisible;
        this.rootVisible = rootVisible;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, oldValue, this.rootVisible);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void setShowsRootHandles(boolean newValue) {
        boolean oldValue = this.showsRootHandles;
        TreeModel model = this.getModel();
        this.showsRootHandles = newValue;
        this.showsRootHandlesSet = true;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, oldValue, this.showsRootHandles);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
        this.invalidate();
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setRowHeight(int rowHeight) {
        int oldValue = this.rowHeight;
        this.rowHeight = rowHeight;
        this.rowHeightSet = true;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, oldValue, this.rowHeight);
        this.invalidate();
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public void setLargeModel(boolean newValue) {
        boolean oldValue = this.largeModel;
        this.largeModel = newValue;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, oldValue, newValue);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setInvokesStopCellEditing(boolean newValue) {
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = newValue;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, oldValue, newValue);
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setScrollsOnExpand(boolean newValue) {
        boolean oldValue = this.scrollsOnExpand;
        this.scrollsOnExpand = newValue;
        this.scrollsOnExpandSet = true;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, oldValue, newValue);
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setToggleClickCount(int clickCount) {
        int oldCount = this.toggleClickCount;
        this.toggleClickCount = clickCount;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, oldCount, clickCount);
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public void setExpandsSelectedPaths(boolean newValue) {
        boolean oldValue = this.expandsSelectedPaths;
        this.expandsSelectedPaths = newValue;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, oldValue, newValue);
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public void setDragEnabled(boolean b) {
        if (b && GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.dragEnabled = b;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public final void setDropMode(DropMode dropMode) {
        if (dropMode != null) {
            switch (dropMode) {
                case USE_SELECTION: 
                case ON: 
                case INSERT: 
                case ON_OR_INSERT: {
                    this.dropMode = dropMode;
                    return;
                }
            }
        }
        throw new IllegalArgumentException((Object)((Object)dropMode) + ": Unsupported drop mode for tree");
    }

    public final DropMode getDropMode() {
        return this.dropMode;
    }

    @Override
    DropLocation dropLocationForPoint(Point p) {
        DropLocation location = null;
        int row = this.getClosestRowForLocation(p.x, p.y);
        Rectangle bounds = this.getRowBounds(row);
        TreeModel model = this.getModel();
        Object root = model == null ? null : model.getRoot();
        TreePath rootPath = root == null ? null : new TreePath(root);
        boolean outside = row == -1 || p.y < bounds.y || p.y >= bounds.y + bounds.height;
        switch (this.dropMode) {
            case USE_SELECTION: 
            case ON: {
                if (outside) {
                    location = new DropLocation(p, null, -1);
                    break;
                }
                location = new DropLocation(p, this.getPathForRow(row), -1);
                break;
            }
            case INSERT: 
            case ON_OR_INSERT: {
                TreePath parent;
                TreePath child;
                if (row == -1) {
                    if (root != null && !model.isLeaf(root) && this.isExpanded(rootPath)) {
                        location = new DropLocation(p, rootPath, 0);
                        break;
                    }
                    location = new DropLocation(p, null, -1);
                    break;
                }
                boolean checkOn = this.dropMode == DropMode.ON_OR_INSERT || !model.isLeaf(this.getPathForRow(row).getLastPathComponent());
                SwingUtilities2.Section section = SwingUtilities2.liesInVertical(bounds, p, checkOn);
                if (section == SwingUtilities2.Section.LEADING) {
                    child = this.getPathForRow(row);
                    parent = child.getParentPath();
                } else if (section == SwingUtilities2.Section.TRAILING) {
                    int index = row + 1;
                    if (index >= this.getRowCount()) {
                        if (model.isLeaf(root) || !this.isExpanded(rootPath)) {
                            location = new DropLocation(p, null, -1);
                            break;
                        }
                        TreePath parent2 = rootPath;
                        index = model.getChildCount(root);
                        location = new DropLocation(p, parent2, index);
                        break;
                    }
                    child = this.getPathForRow(index);
                    parent = child.getParentPath();
                } else {
                    assert (checkOn);
                    location = new DropLocation(p, this.getPathForRow(row), -1);
                    break;
                }
                if (parent != null) {
                    location = new DropLocation(p, parent, model.getIndexOfChild(parent.getLastPathComponent(), child.getLastPathComponent()));
                    break;
                }
                if (checkOn || !model.isLeaf(root)) {
                    location = new DropLocation(p, rootPath, -1);
                    break;
                }
                location = new DropLocation(p, null, -1);
                break;
            }
            default: {
                assert (false) : "Unexpected drop mode";
                break;
            }
        }
        if (outside || row != this.expandRow) {
            this.cancelDropTimer();
        }
        if (!outside && row != this.expandRow && this.isCollapsed(row)) {
            this.expandRow = row;
            this.startDropTimer();
        }
        return location;
    }

    @Override
    Object setDropLocation(TransferHandler.DropLocation location, Object state, boolean forDrop) {
        TreePath[][] retVal = null;
        DropLocation treeLocation = (DropLocation)location;
        if (this.dropMode == DropMode.USE_SELECTION) {
            if (treeLocation == null) {
                if (!forDrop && state != null) {
                    this.setSelectionPaths(((TreePath[][])state)[0]);
                    this.setAnchorSelectionPath(((TreePath[][])state)[1][0]);
                    this.setLeadSelectionPath(((TreePath[][])state)[1][1]);
                }
            } else {
                if (this.dropLocation == null) {
                    TreePath[] paths = this.getSelectionPaths();
                    if (paths == null) {
                        paths = new TreePath[]{};
                    }
                    retVal = new TreePath[][]{paths, {this.getAnchorSelectionPath(), this.getLeadSelectionPath()}};
                } else {
                    retVal = state;
                }
                this.setSelectionPath(treeLocation.getPath());
            }
        }
        DropLocation old = this.dropLocation;
        this.dropLocation = treeLocation;
        this.firePropertyChange("dropLocation", old, this.dropLocation);
        return retVal;
    }

    @Override
    void dndDone() {
        this.cancelDropTimer();
        this.dropTimer = null;
    }

    public final DropLocation getDropLocation() {
        return this.dropLocation;
    }

    private void startDropTimer() {
        if (this.dropTimer == null) {
            this.dropTimer = new TreeTimer();
        }
        this.dropTimer.start();
    }

    private void cancelDropTimer() {
        if (this.dropTimer != null && this.dropTimer.isRunning()) {
            this.expandRow = -1;
            this.dropTimer.stop();
        }
    }

    public boolean isPathEditable(TreePath path) {
        return this.isEditable();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip = null;
        if (event != null) {
            TreePath path;
            Object lastPath;
            Component rComponent;
            Point p = event.getPoint();
            int selRow = this.getRowForLocation(p.x, p.y);
            TreeCellRenderer r = this.getCellRenderer();
            if (selRow != -1 && r != null && (rComponent = r.getTreeCellRendererComponent(this, lastPath = (path = this.getPathForRow(selRow)).getLastPathComponent(), this.isRowSelected(selRow), this.isExpanded(selRow), this.getModel().isLeaf(lastPath), selRow, true)) instanceof JComponent) {
                Rectangle pathBounds = this.getPathBounds(path);
                p.translate(-pathBounds.x, -pathBounds.y);
                MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), 0);
                AWTAccessor.MouseEventAccessor meAccessor = AWTAccessor.getMouseEventAccessor();
                meAccessor.setCausedByTouchEvent(newEvent, meAccessor.isCausedByTouchEvent(event));
                tip = ((JComponent)rComponent).getToolTipText(newEvent);
            }
        }
        if (tip == null) {
            tip = this.getToolTipText();
        }
        return tip;
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String sValue;
        if (value != null && (sValue = value.toString()) != null) {
            return sValue;
        }
        return "";
    }

    public int getRowCount() {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getRowCount(this);
        }
        return 0;
    }

    public void setSelectionPath(TreePath path) {
        this.getSelectionModel().setSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().setSelectionPaths(paths);
    }

    public void setLeadSelectionPath(TreePath newPath) {
        TreePath oldValue = this.leadPath;
        this.leadPath = newPath;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, oldValue, newPath);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireActiveDescendantPropertyChange(oldValue, newPath);
        }
    }

    public void setAnchorSelectionPath(TreePath newPath) {
        TreePath oldValue = this.anchorPath;
        this.anchorPath = newPath;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, oldValue, newPath);
    }

    public void setSelectionRow(int row) {
        int[] rows = new int[]{row};
        this.setSelectionRows(rows);
    }

    public void setSelectionRows(int[] rows) {
        TreeUI ui = this.getUI();
        if (ui != null && rows != null) {
            int numRows = rows.length;
            TreePath[] paths = new TreePath[numRows];
            for (int counter = 0; counter < numRows; ++counter) {
                paths[counter] = ui.getPathForRow(this, rows[counter]);
            }
            this.setSelectionPaths(paths);
        }
    }

    public void addSelectionPath(TreePath path) {
        this.getSelectionModel().addSelectionPath(path);
    }

    public void addSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().addSelectionPaths(paths);
    }

    public void addSelectionRow(int row) {
        int[] rows = new int[]{row};
        this.addSelectionRows(rows);
    }

    public void addSelectionRows(int[] rows) {
        TreeUI ui = this.getUI();
        if (ui != null && rows != null) {
            int numRows = rows.length;
            TreePath[] paths = new TreePath[numRows];
            for (int counter = 0; counter < numRows; ++counter) {
                paths[counter] = ui.getPathForRow(this, rows[counter]);
            }
            this.addSelectionPaths(paths);
        }
    }

    public Object getLastSelectedPathComponent() {
        TreePath selPath = this.getSelectionModel().getSelectionPath();
        if (selPath != null) {
            return selPath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorPath;
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        return selectionPaths != null && selectionPaths.length > 0 ? selectionPaths : null;
    }

    public int[] getSelectionRows() {
        return this.getSelectionModel().getSelectionRows();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public int getMinSelectionRow() {
        return this.getSelectionModel().getMinSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.getSelectionModel().getMaxSelectionRow();
    }

    public int getLeadSelectionRow() {
        TreePath leadPath = this.getLeadSelectionPath();
        if (leadPath != null) {
            return this.getRowForPath(leadPath);
        }
        return -1;
    }

    public boolean isPathSelected(TreePath path) {
        return this.getSelectionModel().isPathSelected(path);
    }

    public boolean isRowSelected(int row) {
        return this.getSelectionModel().isRowSelected(row);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
        if (!this.isExpanded(parent)) {
            return null;
        }
        Enumeration<TreePath> toggledPaths = this.expandedState.keys();
        Vector<TreePath> elements = null;
        if (toggledPaths != null) {
            while (toggledPaths.hasMoreElements()) {
                TreePath path = toggledPaths.nextElement();
                Boolean value = this.expandedState.get(path);
                if (path == parent || value == null || !value.booleanValue() || !parent.isDescendant(path) || !this.isVisible(path)) continue;
                if (elements == null) {
                    elements = new Vector<TreePath>();
                }
                elements.addElement(path);
            }
        }
        if (elements == null) {
            Set empty = Collections.emptySet();
            return Collections.enumeration(empty);
        }
        return elements.elements();
    }

    public boolean hasBeenExpanded(TreePath path) {
        return path != null && this.expandedState.get(path) != null;
    }

    public boolean isExpanded(TreePath path) {
        if (path == null) {
            return false;
        }
        do {
            Boolean value;
            if ((value = this.expandedState.get(path)) != null && value.booleanValue()) continue;
            return false;
        } while ((path = path.getParentPath()) != null);
        return true;
    }

    public boolean isExpanded(int row) {
        TreePath path;
        TreeUI tree = this.getUI();
        if (tree != null && (path = tree.getPathForRow(this, row)) != null) {
            Boolean value = this.expandedState.get(path);
            return value != null && value != false;
        }
        return false;
    }

    public boolean isCollapsed(TreePath path) {
        return !this.isExpanded(path);
    }

    public boolean isCollapsed(int row) {
        return !this.isExpanded(row);
    }

    public void makeVisible(TreePath path) {
        TreePath parentPath;
        if (path != null && (parentPath = path.getParentPath()) != null) {
            this.expandPath(parentPath);
        }
    }

    public boolean isVisible(TreePath path) {
        if (path != null) {
            TreePath parentPath = path.getParentPath();
            if (parentPath != null) {
                return this.isExpanded(parentPath);
            }
            return true;
        }
        return false;
    }

    public Rectangle getPathBounds(TreePath path) {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getPathBounds(this, path);
        }
        return null;
    }

    public Rectangle getRowBounds(int row) {
        return this.getPathBounds(this.getPathForRow(row));
    }

    public void scrollPathToVisible(TreePath path) {
        if (path != null) {
            this.makeVisible(path);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                this.scrollRectToVisible(bounds);
                if (this.accessibleContext != null) {
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void scrollRowToVisible(int row) {
        this.scrollPathToVisible(this.getPathForRow(row));
    }

    public TreePath getPathForRow(int row) {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getPathForRow(this, row);
        }
        return null;
    }

    public int getRowForPath(TreePath path) {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getRowForPath(this, path);
        }
        return -1;
    }

    public void expandPath(TreePath path) {
        TreeModel model = this.getModel();
        if (path != null && model != null && !model.isLeaf(path.getLastPathComponent())) {
            this.setExpandedState(path, true);
        }
    }

    public void expandRow(int row) {
        this.expandPath(this.getPathForRow(row));
    }

    public void collapsePath(TreePath path) {
        this.setExpandedState(path, false);
    }

    public void collapseRow(int row) {
        this.collapsePath(this.getPathForRow(row));
    }

    public TreePath getPathForLocation(int x, int y) {
        Rectangle pathBounds;
        TreePath closestPath = this.getClosestPathForLocation(x, y);
        if (closestPath != null && (pathBounds = this.getPathBounds(closestPath)) != null && x >= pathBounds.x && x < pathBounds.x + pathBounds.width && y >= pathBounds.y && y < pathBounds.y + pathBounds.height) {
            return closestPath;
        }
        return null;
    }

    public int getRowForLocation(int x, int y) {
        return this.getRowForPath(this.getPathForLocation(x, y));
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getClosestPathForLocation(this, x, y);
        }
        return null;
    }

    public int getClosestRowForLocation(int x, int y) {
        return this.getRowForPath(this.getClosestPathForLocation(x, y));
    }

    public boolean isEditing() {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        TreeUI tree = this.getUI();
        if (tree != null) {
            tree.cancelEditing(this);
        }
    }

    public void startEditingAtPath(TreePath path) {
        TreeUI tree = this.getUI();
        if (tree != null) {
            tree.startEditingAtPath(this, path);
        }
    }

    public TreePath getEditingPath() {
        TreeUI tree = this.getUI();
        if (tree != null) {
            return tree.getEditingPath(this);
        }
        return null;
    }

    public void setSelectionModel(TreeSelectionModel selectionModel) {
        if (selectionModel == null) {
            selectionModel = EmptySelectionModel.sharedInstance();
        }
        TreeSelectionModel oldValue = this.selectionModel;
        if (this.selectionModel != null && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            selectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = selectionModel;
        if (this.selectionRedirector != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, this.selectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", false, true);
        }
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected TreePath[] getPathBetweenRows(int index0, int index1) {
        int rowCount;
        TreeUI tree = this.getUI();
        if (!(tree == null || (rowCount = this.getRowCount()) <= 0 || index0 < 0 && index1 < 0 || index0 >= rowCount && index1 >= rowCount)) {
            index0 = Math.min(rowCount - 1, Math.max(index0, 0));
            index1 = Math.min(rowCount - 1, Math.max(index1, 0));
            int minIndex = Math.min(index0, index1);
            int maxIndex = Math.max(index0, index1);
            TreePath[] selection = new TreePath[maxIndex - minIndex + 1];
            for (int counter = minIndex; counter <= maxIndex; ++counter) {
                selection[counter - minIndex] = tree.getPathForRow(this, counter);
            }
            return selection;
        }
        return new TreePath[0];
    }

    public void setSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        this.getSelectionModel().setSelectionPaths(paths);
    }

    public void addSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        if (paths != null && paths.length > 0) {
            this.getSelectionModel().addSelectionPaths(paths);
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        if (paths != null && paths.length > 0) {
            this.getSelectionModel().removeSelectionPaths(paths);
        }
    }

    public void removeSelectionPath(TreePath path) {
        this.getSelectionModel().removeSelectionPath(path);
    }

    public void removeSelectionPaths(TreePath[] paths) {
        this.getSelectionModel().removeSelectionPaths(paths);
    }

    public void removeSelectionRow(int row) {
        int[] rows = new int[]{row};
        this.removeSelectionRows(rows);
    }

    public void removeSelectionRows(int[] rows) {
        TreeUI ui = this.getUI();
        if (ui != null && rows != null) {
            int numRows = rows.length;
            TreePath[] paths = new TreePath[numRows];
            for (int counter = 0; counter < numRows; ++counter) {
                paths[counter] = ui.getPathForRow(this, rows[counter]);
            }
            this.removeSelectionPaths(paths);
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        if (this.settingUI) {
            this.uiTreeExpansionListener = tel;
        }
        this.listenerList.add(TreeExpansionListener.class, tel);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.listenerList.remove(TreeExpansionListener.class, tel);
        if (this.uiTreeExpansionListener == tel) {
            this.uiTreeExpansionListener = null;
        }
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        return (TreeExpansionListener[])this.listenerList.getListeners(TreeExpansionListener.class);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.listenerList.add(TreeWillExpandListener.class, tel);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.listenerList.remove(TreeWillExpandListener.class, tel);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        return (TreeWillExpandListener[])this.listenerList.getListeners(TreeWillExpandListener.class);
    }

    public void fireTreeExpanded(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        if (this.uiTreeExpansionListener != null) {
            e = new TreeExpansionEvent(this, path);
            this.uiTreeExpansionListener.treeExpanded(e);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeExpansionListener.class || listeners[i + 1] == this.uiTreeExpansionListener) continue;
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[i + 1]).treeExpanded(e);
        }
    }

    public void fireTreeCollapsed(TreePath path) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        if (this.uiTreeExpansionListener != null) {
            e = new TreeExpansionEvent(this, path);
            this.uiTreeExpansionListener.treeCollapsed(e);
        }
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeExpansionListener.class || listeners[i + 1] == this.uiTreeExpansionListener) continue;
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeExpansionListener)listeners[i + 1]).treeCollapsed(e);
        }
    }

    public void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeWillExpandListener.class) continue;
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[i + 1]).treeWillExpand(e);
        }
    }

    public void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        TreeExpansionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeWillExpandListener.class) continue;
            if (e == null) {
                e = new TreeExpansionEvent(this, path);
            }
            ((TreeWillExpandListener)listeners[i + 1]).treeWillCollapse(e);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.add(TreeSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.listenerList.remove(TreeSelectionListener.class, tsl);
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.listenerList.getListeners(TreeSelectionListener.class);
    }

    protected void fireValueChanged(TreeSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeSelectionListener.class) continue;
            ((TreeSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public void treeDidChange() {
        this.revalidate();
        this.repaint();
    }

    public void setVisibleRowCount(int newCount) {
        int oldCount = this.visibleRowCount;
        this.visibleRowCount = newCount;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, oldCount, this.visibleRowCount);
        this.invalidate();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    private void expandRoot() {
        TreeModel model = this.getModel();
        if (model != null && model.getRoot() != null) {
            this.expandPath(new TreePath(model.getRoot()));
        }
    }

    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        int max = this.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        prefix = prefix.toUpperCase();
        int increment = bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        do {
            TreePath path;
            String text;
            if (!(text = this.convertValueToText((path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), true, row, false)).toUpperCase().startsWith(prefix)) continue;
            return path;
        } while ((row = (row + increment + max) % max) != startingRow);
        return null;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Object expandedData;
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.cellRenderer != null && this.cellRenderer instanceof Serializable) {
            values.addElement(CELL_RENDERER_PROPERTY);
            values.addElement(this.cellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            values.addElement(CELL_EDITOR_PROPERTY);
            values.addElement(this.cellEditor);
        }
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            values.addElement("treeModel");
            values.addElement(this.treeModel);
        }
        if (this.selectionModel != null && this.selectionModel instanceof Serializable) {
            values.addElement(SELECTION_MODEL_PROPERTY);
            values.addElement(this.selectionModel);
        }
        if ((expandedData = this.getArchivableExpandedState()) != null) {
            values.addElement("expandedState");
            values.addElement(expandedData);
        }
        s.writeObject(values);
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.expandedState = new Hashtable();
        this.expandedStack = new Stack();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(CELL_RENDERER_PROPERTY)) {
            this.cellRenderer = (TreeCellRenderer)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(CELL_EDITOR_PROPERTY)) {
            this.cellEditor = (TreeCellEditor)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("treeModel")) {
            this.treeModel = (TreeModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (TreeSelectionModel)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("expandedState")) {
            this.unarchiveExpandedState(values.elementAt(++indexCounter));
            ++indexCounter;
        }
        if (this.listenerList.getListenerCount(TreeSelectionListener.class) != 0) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        if (this.treeModel != null) {
            this.treeModelListener = this.createTreeModelListener();
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
        }
    }

    private Object getArchivableExpandedState() {
        Enumeration<TreePath> paths;
        TreeModel model = this.getModel();
        if (model != null && (paths = this.expandedState.keys()) != null) {
            Vector<Object> state = new Vector<Object>();
            while (paths.hasMoreElements()) {
                int[] archivePath;
                TreePath path = paths.nextElement();
                try {
                    archivePath = this.getModelIndexsForPath(path);
                }
                catch (Error error) {
                    archivePath = null;
                }
                if (archivePath == null) continue;
                state.addElement(archivePath);
                state.addElement(this.expandedState.get(path));
            }
            return state;
        }
        return null;
    }

    private void unarchiveExpandedState(Object state) {
        if (state instanceof Vector) {
            Vector paths = (Vector)state;
            for (int counter = paths.size() - 1; counter >= 0; --counter) {
                Boolean eState = (Boolean)paths.elementAt(counter--);
                try {
                    TreePath path = this.getPathForIndexs((int[])paths.elementAt(counter));
                    if (path == null) continue;
                    this.expandedState.put(path, eState);
                    continue;
                }
                catch (Error error) {
                    // empty catch block
                }
            }
        }
    }

    private int[] getModelIndexsForPath(TreePath path) {
        if (path != null) {
            TreeModel model = this.getModel();
            int count = path.getPathCount();
            int[] indexs = new int[count - 1];
            Object parent = model.getRoot();
            for (int counter = 1; counter < count; ++counter) {
                indexs[counter - 1] = model.getIndexOfChild(parent, path.getPathComponent(counter));
                parent = path.getPathComponent(counter);
                if (indexs[counter - 1] >= 0) continue;
                return null;
            }
            return indexs;
        }
        return null;
    }

    private TreePath getPathForIndexs(int[] indexs) {
        if (indexs == null) {
            return null;
        }
        TreeModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int count = indexs.length;
        Object parent = model.getRoot();
        if (parent == null) {
            return null;
        }
        TreePath parentPath = new TreePath(parent);
        for (int counter = 0; counter < count; ++counter) {
            if ((parent = model.getChild(parent, indexs[counter])) == null) {
                return null;
            }
            parentPath = parentPath.pathByAddingChild(parent);
        }
        return parentPath;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        int width = this.getPreferredSize().width;
        int visRows = this.getVisibleRowCount();
        int height = -1;
        if (this.isFixedRowHeight()) {
            height = visRows * this.getRowHeight();
        } else {
            TreeUI ui = this.getUI();
            if (ui != null && visRows > 0) {
                Rectangle bounds;
                int rc = ui.getRowCount(this);
                if (rc >= visRows) {
                    Rectangle bounds2 = this.getRowBounds(visRows - 1);
                    if (bounds2 != null) {
                        height = bounds2.y + bounds2.height;
                    }
                } else if (rc > 0 && (bounds = this.getRowBounds(0)) != null) {
                    height = bounds.height * visRows;
                }
            }
            if (height == -1) {
                height = 16 * visRows;
            }
        }
        return new Dimension(width, height);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int firstIndex = this.getClosestRowForLocation(0, visibleRect.y);
            if (firstIndex != -1) {
                Rectangle rowBounds = this.getRowBounds(firstIndex);
                if (rowBounds.y != visibleRect.y) {
                    if (direction < 0) {
                        return Math.max(0, visibleRect.y - rowBounds.y);
                    }
                    return rowBounds.y + rowBounds.height - visibleRect.y;
                }
                if (direction < 0) {
                    if (firstIndex != 0) {
                        rowBounds = this.getRowBounds(firstIndex - 1);
                        return rowBounds.height;
                    }
                } else {
                    return rowBounds.height;
                }
            }
            return 0;
        }
        return 4;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport) {
            return parent.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = SwingUtilities.getUnwrappedParent(this);
        if (parent instanceof JViewport) {
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpandedState(TreePath path, boolean state) {
        if (path != null) {
            TreePath parentPath = path.getParentPath();
            Stack<Object> stack = this.expandedStack.size() == 0 ? new Stack() : this.expandedStack.pop();
            try {
                while (parentPath != null) {
                    if (this.isExpanded(parentPath)) {
                        parentPath = null;
                        continue;
                    }
                    stack.push(parentPath);
                    parentPath = parentPath.getParentPath();
                }
                for (int counter = stack.size() - 1; counter >= 0; --counter) {
                    parentPath = (TreePath)stack.pop();
                    if (this.isExpanded(parentPath)) continue;
                    try {
                        this.fireTreeWillExpand(parentPath);
                    }
                    catch (ExpandVetoException eve) {
                        if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                            stack.removeAllElements();
                            this.expandedStack.push(stack);
                        }
                        return;
                    }
                    this.expandedState.put(parentPath, Boolean.TRUE);
                    this.fireTreeExpanded(parentPath);
                    if (this.accessibleContext == null) continue;
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
            finally {
                if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                    stack.removeAllElements();
                    this.expandedStack.push(stack);
                }
            }
            if (!state) {
                Boolean cValue = this.expandedState.get(path);
                if (cValue != null && cValue.booleanValue()) {
                    try {
                        this.fireTreeWillCollapse(path);
                    }
                    catch (ExpandVetoException eve) {
                        return;
                    }
                    this.expandedState.put(path, Boolean.FALSE);
                    this.fireTreeCollapsed(path);
                    if (this.removeDescendantSelectedPaths(path, false) && !this.isPathSelected(path)) {
                        this.addSelectionPath(path);
                    }
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            } else {
                Boolean cValue = this.expandedState.get(path);
                if (cValue == null || !cValue.booleanValue()) {
                    try {
                        this.fireTreeWillExpand(path);
                    }
                    catch (ExpandVetoException eve) {
                        return;
                    }
                    this.expandedState.put(path, Boolean.TRUE);
                    this.fireTreeExpanded(path);
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            }
        }
    }

    protected Enumeration<TreePath> getDescendantToggledPaths(TreePath parent) {
        if (parent == null) {
            return null;
        }
        Vector<TreePath> descendants = new Vector<TreePath>();
        Enumeration<TreePath> nodes = this.expandedState.keys();
        while (nodes.hasMoreElements()) {
            TreePath path = nodes.nextElement();
            if (!parent.isDescendant(path)) continue;
            descendants.addElement(path);
        }
        return descendants.elements();
    }

    protected void removeDescendantToggledPaths(Enumeration<TreePath> toRemove) {
        if (toRemove != null) {
            while (toRemove.hasMoreElements()) {
                Enumeration<TreePath> descendants = this.getDescendantToggledPaths(toRemove.nextElement());
                if (descendants == null) continue;
                while (descendants.hasMoreElements()) {
                    this.expandedState.remove(descendants.nextElement());
                }
            }
        }
    }

    protected void clearToggledPaths() {
        this.expandedState.clear();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected boolean removeDescendantSelectedPaths(TreePath path, boolean includePath) {
        TreePath[] toRemove = this.getDescendantSelectedPaths(path, includePath);
        if (toRemove != null) {
            this.getSelectionModel().removeSelectionPaths(toRemove);
            return true;
        }
        return false;
    }

    private TreePath[] getDescendantSelectedPaths(TreePath path, boolean includePath) {
        TreePath[] selPaths;
        TreeSelectionModel sm = this.getSelectionModel();
        TreePath[] treePathArray = selPaths = sm != null ? sm.getSelectionPaths() : null;
        if (selPaths != null) {
            boolean shouldRemove = false;
            for (int counter = selPaths.length - 1; counter >= 0; --counter) {
                if (selPaths[counter] != null && path.isDescendant(selPaths[counter]) && (!path.equals(selPaths[counter]) || includePath)) {
                    shouldRemove = true;
                    continue;
                }
                selPaths[counter] = null;
            }
            if (!shouldRemove) {
                selPaths = null;
            }
            return selPaths;
        }
        return null;
    }

    void removeDescendantSelectedPaths(TreeModelEvent e) {
        TreePath pPath = SwingUtilities2.getTreePath(e, this.getModel());
        Object[] oldChildren = e.getChildren();
        TreeSelectionModel sm = this.getSelectionModel();
        if (sm != null && pPath != null && oldChildren != null && oldChildren.length > 0) {
            for (int counter = oldChildren.length - 1; counter >= 0; --counter) {
                this.removeDescendantSelectedPaths(pPath.pathByAddingChild(oldChildren[counter]), true);
            }
        }
    }

    @Override
    void setUIProperty(String propertyName, Object value) {
        if (propertyName == ROW_HEIGHT_PROPERTY) {
            if (!this.rowHeightSet) {
                this.setRowHeight(((Number)value).intValue());
                this.rowHeightSet = false;
            }
        } else if (propertyName == SCROLLS_ON_EXPAND_PROPERTY) {
            if (!this.scrollsOnExpandSet) {
                this.setScrollsOnExpand((Boolean)value);
                this.scrollsOnExpandSet = false;
            }
        } else if (propertyName == SHOWS_ROOT_HANDLES_PROPERTY) {
            if (!this.showsRootHandlesSet) {
                this.setShowsRootHandles((Boolean)value);
                this.showsRootHandlesSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    @Override
    protected String paramString() {
        String rootVisibleString = this.rootVisible ? "true" : "false";
        String showsRootHandlesString = this.showsRootHandles ? "true" : "false";
        String editableString = this.editable ? "true" : "false";
        String largeModelString = this.largeModel ? "true" : "false";
        String invokesStopCellEditingString = this.invokesStopCellEditing ? "true" : "false";
        String scrollsOnExpandString = this.scrollsOnExpand ? "true" : "false";
        return super.paramString() + ",editable=" + editableString + ",invokesStopCellEditing=" + invokesStopCellEditingString + ",largeModel=" + largeModelString + ",rootVisible=" + rootVisibleString + ",rowHeight=" + this.rowHeight + ",scrollsOnExpand=" + scrollsOnExpandString + ",showsRootHandles=" + showsRootHandlesString + ",toggleClickCount=" + this.toggleClickCount + ",visibleRowCount=" + this.visibleRowCount;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTree();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        TreePath leadSelectionPath;
        Accessible leadSelectionAccessible;

        public AccessibleJTree() {
            super(JTree.this);
            TreeModel model = JTree.this.getModel();
            if (model != null) {
                model.addTreeModelListener(this);
            }
            JTree.this.addTreeExpansionListener(this);
            JTree.this.addTreeSelectionListener(this);
            this.leadSelectionPath = JTree.this.getLeadSelectionPath();
            this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(JTree.this, this.leadSelectionPath, JTree.this) : null;
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            this.firePropertyChange("AccessibleSelection", false, true);
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", false, true);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            this.fireVisibleDataPropertyChange();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            this.fireVisibleDataPropertyChange();
            TreePath path = e.getPath();
            if (path != null) {
                AccessibleJTreeNode node = new AccessibleJTreeNode(JTree.this, path, null);
                PropertyChangeEvent pce = new PropertyChangeEvent(node, "AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
                this.firePropertyChange("AccessibleState", null, pce);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            this.fireVisibleDataPropertyChange();
            TreePath path = e.getPath();
            if (path != null) {
                AccessibleJTreeNode node = new AccessibleJTreeNode(JTree.this, path, null);
                PropertyChangeEvent pce = new PropertyChangeEvent(node, "AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
                this.firePropertyChange("AccessibleState", null, pce);
            }
        }

        void fireActiveDescendantPropertyChange(TreePath oldPath, TreePath newPath) {
            if (oldPath != newPath) {
                AccessibleJTreeNode oldLSA = oldPath != null ? new AccessibleJTreeNode(JTree.this, oldPath, null) : null;
                AccessibleJTreeNode newLSA = newPath != null ? new AccessibleJTreeNode(JTree.this, newPath, null) : null;
                this.firePropertyChange("AccessibleActiveDescendant", oldLSA, newLSA);
            }
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component c = this.getCurrentComponent();
            if (c instanceof Accessible) {
                return c.getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            TreeModel model = JTree.this.getModel();
            if (model == null) {
                return null;
            }
            Object treeRoot = model.getRoot();
            if (treeRoot == null) {
                return null;
            }
            TreePath path = new TreePath(treeRoot);
            if (JTree.this.isVisible(path)) {
                TreeCellRenderer r = JTree.this.getCellRenderer();
                TreeUI ui = JTree.this.getUI();
                if (ui != null) {
                    int row = ui.getRowForPath(JTree.this, path);
                    int lsr = JTree.this.getLeadSelectionRow();
                    boolean hasFocus = JTree.this.isFocusOwner() && lsr == row;
                    boolean selected = JTree.this.isPathSelected(path);
                    boolean expanded = JTree.this.isExpanded(path);
                    return r.getTreeCellRendererComponent(JTree.this, treeRoot, selected, expanded, model.isLeaf(treeRoot), row, hasFocus);
                }
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            TreePath path = JTree.this.getClosestPathForLocation(p.x, p.y);
            if (path != null) {
                return new AccessibleJTreeNode(JTree.this, path, null);
            }
            return null;
        }

        @Override
        public int getAccessibleChildrenCount() {
            TreeModel model = JTree.this.getModel();
            if (model == null) {
                return 0;
            }
            if (JTree.this.isRootVisible()) {
                return 1;
            }
            Object treeRoot = model.getRoot();
            if (treeRoot == null) {
                return 0;
            }
            return model.getChildCount(treeRoot);
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            TreeModel model = JTree.this.getModel();
            if (model == null) {
                return null;
            }
            Object treeRoot = model.getRoot();
            if (treeRoot == null) {
                return null;
            }
            if (JTree.this.isRootVisible()) {
                if (i == 0) {
                    Object[] objPath = new Object[]{treeRoot};
                    if (objPath[0] == null) {
                        return null;
                    }
                    TreePath path = new TreePath(objPath);
                    return new AccessibleJTreeNode(JTree.this, path, JTree.this);
                }
                return null;
            }
            int count = model.getChildCount(treeRoot);
            if (i < 0 || i >= count) {
                return null;
            }
            Object obj = model.getChild(treeRoot, i);
            if (obj == null) {
                return null;
            }
            Object[] objPath = new Object[]{treeRoot, obj};
            TreePath path = new TreePath(objPath);
            return new AccessibleJTreeNode(JTree.this, path, JTree.this);
        }

        @Override
        public int getAccessibleIndexInParent() {
            return super.getAccessibleIndexInParent();
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public int getAccessibleSelectionCount() {
            Object[] rootPath = new Object[]{JTree.this.treeModel.getRoot()};
            if (rootPath[0] == null) {
                return 0;
            }
            TreePath childPath = new TreePath(rootPath);
            if (JTree.this.isPathSelected(childPath)) {
                return 1;
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            if (i == 0) {
                Object[] rootPath = new Object[]{JTree.this.treeModel.getRoot()};
                if (rootPath[0] == null) {
                    return null;
                }
                TreePath childPath = new TreePath(rootPath);
                if (JTree.this.isPathSelected(childPath)) {
                    return new AccessibleJTreeNode(JTree.this, childPath, JTree.this);
                }
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            if (i == 0) {
                Object[] rootPath = new Object[]{JTree.this.treeModel.getRoot()};
                if (rootPath[0] == null) {
                    return false;
                }
                TreePath childPath = new TreePath(rootPath);
                return JTree.this.isPathSelected(childPath);
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int i) {
            TreeModel model = JTree.this.getModel();
            if (model != null && i == 0) {
                Object[] objPath = new Object[]{model.getRoot()};
                if (objPath[0] == null) {
                    return;
                }
                TreePath path = new TreePath(objPath);
                JTree.this.addSelectionPath(path);
            }
        }

        @Override
        public void removeAccessibleSelection(int i) {
            TreeModel model = JTree.this.getModel();
            if (model != null && i == 0) {
                Object[] objPath = new Object[]{model.getRoot()};
                if (objPath[0] == null) {
                    return;
                }
                TreePath path = new TreePath(objPath);
                JTree.this.removeSelectionPath(path);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            int childCount = this.getAccessibleChildrenCount();
            for (int i = 0; i < childCount; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            TreeModel model = JTree.this.getModel();
            if (model != null) {
                Object[] objPath = new Object[]{model.getRoot()};
                if (objPath[0] == null) {
                    return;
                }
                TreePath path = new TreePath(objPath);
                JTree.this.addSelectionPath(path);
            }
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree = null;
            private TreeModel treeModel = null;
            private Object obj = null;
            private TreePath path = null;
            private Accessible accessibleParent = null;
            private int index = 0;
            private boolean isLeaf = false;

            public AccessibleJTreeNode(JTree t, TreePath p, Accessible ap) {
                this.tree = t;
                this.path = p;
                this.accessibleParent = ap;
                this.treeModel = t.getModel();
                this.obj = p.getLastPathComponent();
                if (this.treeModel != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }

            private TreePath getChildTreePath(int i) {
                if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object childObj = this.treeModel.getChild(this.obj, i);
                Object[] objPath = this.path.getPath();
                Object[] objChildPath = new Object[objPath.length + 1];
                System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
                objChildPath[objChildPath.length - 1] = childObj;
                return new TreePath(objChildPath);
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getCurrentComponent();
                if (c instanceof Accessible) {
                    return c.getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                if (this.tree.isVisible(this.path)) {
                    TreeCellRenderer r = this.tree.getCellRenderer();
                    if (r == null) {
                        return null;
                    }
                    TreeUI ui = this.tree.getUI();
                    if (ui != null) {
                        int row = ui.getRowForPath(JTree.this, this.path);
                        boolean selected = this.tree.isPathSelected(this.path);
                        boolean expanded = this.tree.isExpanded(this.path);
                        boolean hasFocus = false;
                        return r.getTreeCellRendererComponent(this.tree, this.obj, selected, expanded, this.isLeaf, row, hasFocus);
                    }
                }
                return null;
            }

            @Override
            public String getAccessibleName() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    String name = ac.getAccessibleName();
                    if (name != null && name != "") {
                        return ac.getAccessibleName();
                    }
                    return null;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return (String)JTree.this.getClientProperty("AccessibleName");
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                } else {
                    super.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                } else {
                    super.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet states = ac != null ? ac.getAccessibleStateSet() : new AccessibleStateSet();
                if (this.isShowing()) {
                    states.add(AccessibleState.SHOWING);
                } else if (states.contains(AccessibleState.SHOWING)) {
                    states.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    states.add(AccessibleState.VISIBLE);
                } else if (states.contains(AccessibleState.VISIBLE)) {
                    states.remove(AccessibleState.VISIBLE);
                }
                if (this.tree.isPathSelected(this.path)) {
                    states.add(AccessibleState.SELECTED);
                }
                if (this.path == JTree.this.getLeadSelectionPath()) {
                    states.add(AccessibleState.ACTIVE);
                }
                if (!this.isLeaf) {
                    states.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.path)) {
                    states.add(AccessibleState.EXPANDED);
                } else {
                    states.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    states.add(AccessibleState.EDITABLE);
                }
                return states;
            }

            @Override
            public Accessible getAccessibleParent() {
                if (this.accessibleParent == null) {
                    Object[] objPath = this.path.getPath();
                    if (objPath.length > 1) {
                        Object objParent = objPath[objPath.length - 2];
                        if (this.treeModel != null) {
                            this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                        }
                        Object[] objParentPath = new Object[objPath.length - 1];
                        System.arraycopy(objPath, 0, objParentPath, 0, objPath.length - 1);
                        TreePath parentPath = new TreePath(objParentPath);
                        this.accessibleParent = new AccessibleJTreeNode(this.tree, parentPath, null);
                        this.setAccessibleParent(this.accessibleParent);
                    } else if (this.treeModel != null) {
                        this.accessibleParent = this.tree;
                        this.index = 0;
                        this.setAccessibleParent(this.accessibleParent);
                    }
                }
                return this.accessibleParent;
            }

            @Override
            public int getAccessibleIndexInParent() {
                Object[] objPath;
                if (this.accessibleParent == null) {
                    this.getAccessibleParent();
                }
                if ((objPath = this.path.getPath()).length > 1) {
                    Object objParent = objPath[objPath.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(objParent, this.obj);
                    }
                }
                return this.index;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return this.treeModel.getChildCount(this.obj);
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object childObj = this.treeModel.getChild(this.obj, i);
                Object[] objPath = this.path.getPath();
                Object[] objChildPath = new Object[objPath.length + 1];
                System.arraycopy(objPath, 0, objChildPath, 0, objPath.length);
                objChildPath[objChildPath.length - 1] = childObj;
                TreePath childPath = new TreePath(objChildPath);
                return new AccessibleJTreeNode(JTree.this, childPath, this);
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return this.tree.getLocale();
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                } else {
                    super.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                } else {
                    super.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                return this;
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && this.isLeaf) {
                    return this.getCurrentAccessibleContext().getAccessibleSelection();
                }
                return this;
            }

            @Override
            public AccessibleText getAccessibleText() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return this.getCurrentAccessibleContext().getAccessibleText();
                }
                return null;
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return this.getCurrentAccessibleContext().getAccessibleValue();
                }
                return null;
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                Rectangle pathBounds = this.tree.getPathBounds(this.path);
                Rectangle parentBounds = this.tree.getVisibleRect();
                return pathBounds != null && parentBounds != null && parentBounds.intersects(pathBounds);
            }

            @Override
            public void setVisible(boolean b) {
            }

            @Override
            public boolean isShowing() {
                return this.tree.isShowing() && this.isVisible();
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.tree != null) {
                    Point treeLocation = this.tree.getLocationOnScreen();
                    Rectangle pathBounds = this.tree.getPathBounds(this.path);
                    if (treeLocation != null && pathBounds != null) {
                        Point nodeLocation = new Point(pathBounds.x, pathBounds.y);
                        nodeLocation.translate(treeLocation.x, treeLocation.y);
                        return nodeLocation;
                    }
                    return null;
                }
                return null;
            }

            protected Point getLocationInJTree() {
                Rectangle r = this.tree.getPathBounds(this.path);
                if (r != null) {
                    return r.getLocation();
                }
                return null;
            }

            @Override
            public Point getLocation() {
                Rectangle r = this.getBounds();
                if (r != null) {
                    return r.getLocation();
                }
                return null;
            }

            @Override
            public void setLocation(Point p) {
            }

            @Override
            public Rectangle getBounds() {
                Rectangle r = this.tree.getPathBounds(this.path);
                Accessible parent = this.getAccessibleParent();
                if (parent != null && parent instanceof AccessibleJTreeNode) {
                    Point parentLoc = ((AccessibleJTreeNode)parent).getLocationInJTree();
                    if (parentLoc != null && r != null) {
                        r.translate(-parentLoc.x, -parentLoc.y);
                    } else {
                        return null;
                    }
                }
                return r;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setBounds(r);
                    }
                }
            }

            @Override
            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }

            @Override
            public int getAccessibleSelectionCount() {
                int count = 0;
                int childCount = this.getAccessibleChildrenCount();
                for (int i = 0; i < childCount; ++i) {
                    TreePath childPath = this.getChildTreePath(i);
                    if (!this.tree.isPathSelected(childPath)) continue;
                    ++count;
                }
                return count;
            }

            @Override
            public Accessible getAccessibleSelection(int i) {
                int childCount = this.getAccessibleChildrenCount();
                if (i < 0 || i >= childCount) {
                    return null;
                }
                int count = 0;
                for (int j = 0; j < childCount && i >= count; ++j) {
                    TreePath childPath = this.getChildTreePath(j);
                    if (!this.tree.isPathSelected(childPath)) continue;
                    if (count == i) {
                        return new AccessibleJTreeNode(this.tree, childPath, this);
                    }
                    ++count;
                }
                return null;
            }

            @Override
            public boolean isAccessibleChildSelected(int i) {
                int childCount = this.getAccessibleChildrenCount();
                if (i < 0 || i >= childCount) {
                    return false;
                }
                TreePath childPath = this.getChildTreePath(i);
                return this.tree.isPathSelected(childPath);
            }

            @Override
            public void addAccessibleSelection(int i) {
                TreeModel model = JTree.this.getModel();
                if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                    TreePath path = this.getChildTreePath(i);
                    JTree.this.addSelectionPath(path);
                }
            }

            @Override
            public void removeAccessibleSelection(int i) {
                TreeModel model = JTree.this.getModel();
                if (model != null && i >= 0 && i < this.getAccessibleChildrenCount()) {
                    TreePath path = this.getChildTreePath(i);
                    JTree.this.removeSelectionPath(path);
                }
            }

            @Override
            public void clearAccessibleSelection() {
                int childCount = this.getAccessibleChildrenCount();
                for (int i = 0; i < childCount; ++i) {
                    this.removeAccessibleSelection(i);
                }
            }

            @Override
            public void selectAllAccessibleSelection() {
                TreeModel model = JTree.this.getModel();
                if (model != null) {
                    int childCount = this.getAccessibleChildrenCount();
                    for (int i = 0; i < childCount; ++i) {
                        TreePath path = this.getChildTreePath(i);
                        JTree.this.addSelectionPath(path);
                    }
                }
            }

            @Override
            public int getAccessibleActionCount() {
                AccessibleAction aa;
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                    return aa.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
                }
                return this.isLeaf ? 0 : 1;
            }

            @Override
            public String getAccessibleActionDescription(int i) {
                AccessibleAction aa;
                if (i < 0 || i >= this.getAccessibleActionCount()) {
                    return null;
                }
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (i == 0) {
                    return AccessibleAction.TOGGLE_EXPAND;
                }
                if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                    return aa.getAccessibleActionDescription(i - 1);
                }
                return null;
            }

            @Override
            public boolean doAccessibleAction(int i) {
                AccessibleAction aa;
                if (i < 0 || i >= this.getAccessibleActionCount()) {
                    return false;
                }
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (i == 0) {
                    if (JTree.this.isExpanded(this.path)) {
                        JTree.this.collapsePath(this.path);
                    } else {
                        JTree.this.expandPath(this.path);
                    }
                    return true;
                }
                if (ac != null && (aa = ac.getAccessibleAction()) != null) {
                    return aa.doAccessibleAction(i - 1);
                }
                return false;
            }
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public static void createChildren(DefaultMutableTreeNode parent, Object children) {
            block4: {
                block5: {
                    block3: {
                        if (!(children instanceof Vector)) break block3;
                        Vector childVector = (Vector)children;
                        int maxCounter = childVector.size();
                        for (int counter = 0; counter < maxCounter; ++counter) {
                            parent.add(new DynamicUtilTreeNode(childVector.elementAt(counter), childVector.elementAt(counter)));
                        }
                        break block4;
                    }
                    if (!(children instanceof Hashtable)) break block5;
                    Hashtable childHT = (Hashtable)children;
                    Enumeration keys = childHT.keys();
                    while (keys.hasMoreElements()) {
                        Object aKey = keys.nextElement();
                        parent.add(new DynamicUtilTreeNode(aKey, childHT.get(aKey)));
                    }
                    break block4;
                }
                if (!(children instanceof Object[])) break block4;
                Object[] childArray = (Object[])children;
                int maxCounter = childArray.length;
                for (int counter = 0; counter < maxCounter; ++counter) {
                    parent.add(new DynamicUtilTreeNode(childArray[counter], childArray[counter]));
                }
            }
        }

        public DynamicUtilTreeNode(Object value, Object children) {
            super(value);
            this.childValue = children;
            if (children != null) {
                if (children instanceof Vector) {
                    this.setAllowsChildren(true);
                } else if (children instanceof Hashtable) {
                    this.setAllowsChildren(true);
                } else if (children instanceof Object[]) {
                    this.setAllowsChildren(true);
                } else {
                    this.setAllowsChildren(false);
                }
            } else {
                this.setAllowsChildren(false);
            }
        }

        @Override
        public boolean isLeaf() {
            return !this.getAllowsChildren();
        }

        @Override
        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicUtilTreeNode.createChildren(this, this.childValue);
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(index);
        }

        @Override
        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener {
        protected TreeModelHandler() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            if (e == null) {
                return;
            }
            TreePath parent = SwingUtilities2.getTreePath(e, JTree.this.getModel());
            if (parent == null) {
                return;
            }
            if (parent.getPathCount() == 1) {
                JTree.this.clearToggledPaths();
                Object treeRoot = JTree.this.treeModel.getRoot();
                if (treeRoot != null && !JTree.this.treeModel.isLeaf(treeRoot)) {
                    JTree.this.expandedState.put(parent, Boolean.TRUE);
                }
            } else if (JTree.this.expandedState.get(parent) != null) {
                Vector<TreePath> toRemove = new Vector<TreePath>(1);
                boolean isExpanded = JTree.this.isExpanded(parent);
                toRemove.addElement(parent);
                JTree.this.removeDescendantToggledPaths(toRemove.elements());
                if (isExpanded) {
                    TreeModel model = JTree.this.getModel();
                    if (model == null || model.isLeaf(parent.getLastPathComponent())) {
                        JTree.this.collapsePath(parent);
                    } else {
                        JTree.this.expandedState.put(parent, Boolean.TRUE);
                    }
                }
            }
            JTree.this.removeDescendantSelectedPaths(parent, false);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            TreeModel model;
            if (e == null) {
                return;
            }
            TreePath parent = SwingUtilities2.getTreePath(e, JTree.this.getModel());
            Object[] children = e.getChildren();
            if (children == null) {
                return;
            }
            Vector<TreePath> toRemove = new Vector<TreePath>(Math.max(1, children.length));
            for (int counter = children.length - 1; counter >= 0; --counter) {
                TreePath rPath = parent.pathByAddingChild(children[counter]);
                if (JTree.this.expandedState.get(rPath) == null) continue;
                toRemove.addElement(rPath);
            }
            if (toRemove.size() > 0) {
                JTree.this.removeDescendantToggledPaths(toRemove.elements());
            }
            if ((model = JTree.this.getModel()) == null || model.isLeaf(parent.getLastPathComponent())) {
                JTree.this.expandedState.remove(parent);
            }
            JTree.this.removeDescendantSelectedPaths(e);
        }
    }

    protected class TreeSelectionRedirector
    implements Serializable,
    TreeSelectionListener {
        protected TreeSelectionRedirector() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreeSelectionEvent newE = (TreeSelectionEvent)e.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(newE);
        }
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        protected EmptySelectionModel() {
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
        }

        @Override
        public void removeSelectionPaths(TreePath[] paths) {
        }

        @Override
        public void setSelectionMode(int mode) {
        }

        @Override
        public void setRowMapper(RowMapper mapper) {
        }

        @Override
        public void addTreeSelectionListener(TreeSelectionListener listener) {
        }

        @Override
        public void removeTreeSelectionListener(TreeSelectionListener listener) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }

    private class TreeTimer
    extends Timer {
        public TreeTimer() {
            super(2000, null);
            this.setRepeats(false);
        }

        @Override
        public void fireActionPerformed(ActionEvent ae) {
            JTree.this.expandRow(JTree.this.expandRow);
        }
    }

    public static final class DropLocation
    extends TransferHandler.DropLocation {
        private final TreePath path;
        private final int index;

        private DropLocation(Point p, TreePath path, int index) {
            super(p);
            this.path = path;
            this.index = index;
        }

        public int getChildIndex() {
            return this.index;
        }

        public TreePath getPath() {
            return this.path;
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.getDropPoint() + ",path=" + this.path + ",childIndex=" + this.index + "]";
        }
    }
}

