/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.lang.reflect.Array;
import java.util.EventListener;

public class EventListenerAggregate {
    private EventListener[] listenerList;

    public EventListenerAggregate(Class<? extends EventListener> listenerClass) {
        if (listenerClass == null) {
            throw new NullPointerException("listener class is null");
        }
        this.listenerList = (EventListener[])Array.newInstance(listenerClass, 0);
    }

    private Class<?> getListenerClass() {
        return this.listenerList.getClass().getComponentType();
    }

    public synchronized void add(EventListener listener) {
        Class<?> listenerClass = this.getListenerClass();
        if (!listenerClass.isInstance(listener)) {
            throw new ClassCastException("listener " + listener + " is not an instance of listener class " + listenerClass);
        }
        EventListener[] tmp = (EventListener[])Array.newInstance(listenerClass, this.listenerList.length + 1);
        System.arraycopy(this.listenerList, 0, tmp, 0, this.listenerList.length);
        tmp[this.listenerList.length] = listener;
        this.listenerList = tmp;
    }

    public synchronized boolean remove(EventListener listener) {
        Class<?> listenerClass = this.getListenerClass();
        if (!listenerClass.isInstance(listener)) {
            throw new ClassCastException("listener " + listener + " is not an instance of listener class " + listenerClass);
        }
        for (int i = 0; i < this.listenerList.length; ++i) {
            if (!this.listenerList[i].equals(listener)) continue;
            EventListener[] tmp = (EventListener[])Array.newInstance(listenerClass, this.listenerList.length - 1);
            System.arraycopy(this.listenerList, 0, tmp, 0, i);
            System.arraycopy(this.listenerList, i + 1, tmp, i, this.listenerList.length - i - 1);
            this.listenerList = tmp;
            return true;
        }
        return false;
    }

    public synchronized EventListener[] getListenersInternal() {
        return this.listenerList;
    }

    public synchronized EventListener[] getListenersCopy() {
        return this.listenerList.length == 0 ? this.listenerList : (EventListener[])this.listenerList.clone();
    }

    public synchronized int size() {
        return this.listenerList.length;
    }

    public synchronized boolean isEmpty() {
        return this.listenerList.length == 0;
    }
}

