/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import com.sun.java.swing.plaf.motif.MotifTextAreaUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.TextEvent;
import java.awt.im.InputMethodRequests;
import java.awt.peer.ComponentPeer;
import java.awt.peer.TextAreaPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;

final class XTextAreaPeer
extends XComponentPeer
implements TextAreaPeer {
    private final AWTTextPane textPane;
    private final AWTTextArea jtext;
    private final boolean firstChangeSkipped;
    private final JavaMouseEventHandler javaMouseEventHandler = new JavaMouseEventHandler(this);

    XTextAreaPeer(TextArea target) {
        super(target);
        this.target = target;
        String text = target.getText();
        this.jtext = new AWTTextArea(text, this);
        this.jtext.setWrapStyleWord(true);
        this.jtext.getDocument().addDocumentListener(this.jtext);
        XToolkit.specialPeerMap.put(this.jtext, this);
        this.textPane = new AWTTextPane(this.jtext, this, target.getParent());
        this.setBounds(this.x, this.y, this.width, this.height, 3);
        this.textPane.setVisible(true);
        this.textPane.validate();
        AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
        this.foreground = compAccessor.getForeground(target);
        if (this.foreground == null) {
            this.foreground = SystemColor.textText;
        }
        this.setForeground(this.foreground);
        this.background = compAccessor.getBackground(target);
        if (this.background == null) {
            this.background = target.isEditable() ? SystemColor.text : SystemColor.control;
        }
        this.setBackground(this.background);
        if (!target.isBackgroundSet()) {
            compAccessor.setBackground(target, this.background);
        }
        if (!target.isForegroundSet()) {
            target.setForeground(SystemColor.textText);
        }
        this.setFont(this.font);
        this.setTextImpl(target.getText());
        int start = target.getSelectionStart();
        int end = target.getSelectionEnd();
        this.setCaretPosition(Math.min(end, text.length()));
        if (end > start) {
            this.select(start, end);
        }
        this.setEditable(target.isEditable());
        this.setScrollBarVisibility();
        this.firstChangeSkipped = true;
    }

    @Override
    public void dispose() {
        XToolkit.specialPeerMap.remove(this.jtext);
        this.jtext.getCaret().setVisible(false);
        this.jtext.removeNotify();
        this.textPane.removeNotify();
        super.dispose();
    }

    @Override
    public void pSetCursor(Cursor cursor, boolean ignoreSubComponents) {
        if (ignoreSubComponents || this.javaMouseEventHandler == null) {
            super.pSetCursor(cursor, true);
            return;
        }
        Point cursorPos = new Point();
        ((XGlobalCursorManager)XGlobalCursorManager.getCursorManager()).getCursorPos(cursorPos);
        Point onScreen = this.getLocationOnScreen();
        Point localPoint = new Point(cursorPos.x - onScreen.x, cursorPos.y - onScreen.y);
        this.javaMouseEventHandler.setPointerToUnderPoint(localPoint);
        this.javaMouseEventHandler.setCursor();
    }

    private void setScrollBarVisibility() {
        int visibility = ((TextArea)this.target).getScrollbarVisibility();
        this.jtext.setLineWrap(false);
        if (visibility == 3) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(21);
            this.jtext.setLineWrap(true);
        } else if (visibility == 0) {
            this.textPane.setHorizontalScrollBarPolicy(32);
            this.textPane.setVerticalScrollBarPolicy(22);
        } else if (visibility == 1) {
            this.textPane.setHorizontalScrollBarPolicy(31);
            this.textPane.setVerticalScrollBarPolicy(22);
            this.jtext.setLineWrap(true);
        } else if (visibility == 2) {
            this.textPane.setVerticalScrollBarPolicy(21);
            this.textPane.setHorizontalScrollBarPolicy(32);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getMinimumSize(10, 60);
    }

    @Override
    public Dimension getPreferredSize(int rows, int cols) {
        return this.getMinimumSize(rows, cols);
    }

    @Override
    public Dimension getMinimumSize(int rows, int cols) {
        JScrollBar hsb;
        int vsbwidth = 0;
        int hsbheight = 0;
        JScrollBar vsb = this.textPane.getVerticalScrollBar();
        if (vsb != null) {
            vsbwidth = vsb.getMinimumSize().width;
        }
        if ((hsb = this.textPane.getHorizontalScrollBar()) != null) {
            hsbheight = hsb.getMinimumSize().height;
        }
        Font f = this.jtext.getFont();
        FontMetrics fm = this.jtext.getFontMetrics(f);
        return new Dimension(fm.charWidth('0') * cols + vsbwidth, fm.getHeight() * rows + hsbheight);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (this.textPane != null) {
            this.textPane.setVisible(b);
        }
    }

    void repaintText() {
        this.jtext.repaintNow();
    }

    @Override
    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.jtext.forwardFocusGained(e);
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.jtext.forwardFocusLost(e);
    }

    @Override
    public void repaint() {
        if (this.textPane != null) {
            this.textPane.repaint();
        }
    }

    @Override
    void paintPeer(Graphics g) {
        if (this.textPane != null) {
            this.textPane.paint(g);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        super.setBounds(x, y, width, height, op);
        if (this.textPane != null) {
            int childX = x;
            int childY = y;
            Container parent = this.target.getParent();
            while (parent.isLightweight()) {
                childX -= parent.getX();
                childY -= parent.getY();
                parent = parent.getParent();
            }
            this.textPane.setBounds(childX, childY, width, height);
            this.textPane.validate();
        }
    }

    @Override
    void handleJavaKeyEvent(KeyEvent e) {
        AWTAccessor.getComponentAccessor().processEvent(this.jtext, e);
    }

    @Override
    public boolean handlesWheelScrolling() {
        return true;
    }

    @Override
    void handleJavaMouseWheelEvent(MouseWheelEvent e) {
        AWTAccessor.getComponentAccessor().processEvent(this.textPane, e);
    }

    @Override
    public void handleJavaMouseEvent(MouseEvent e) {
        super.handleJavaMouseEvent(e);
        this.javaMouseEventHandler.handle(e);
    }

    @Override
    void handleJavaInputMethodEvent(InputMethodEvent e) {
        if (this.jtext != null) {
            this.jtext.processInputMethodEventPublic(e);
        }
    }

    @Override
    public void select(int s, int e) {
        this.jtext.select(s, e);
        this.jtext.repaint();
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.jtext != null) {
            this.jtext.setBackground(c);
            this.jtext.setSelectedTextColor(c);
        }
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.jtext != null) {
            this.jtext.setForeground(this.foreground);
            this.jtext.setSelectionColor(this.foreground);
            this.jtext.setCaretColor(this.foreground);
        }
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.jtext != null) {
            this.jtext.setFont(this.font);
        }
        this.textPane.validate();
    }

    @Override
    public void setEditable(boolean editable) {
        if (this.jtext != null) {
            this.jtext.setEditable(editable);
        }
        this.repaintText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.jtext != null) {
            this.jtext.setEnabled(enabled);
            this.jtext.repaint();
        }
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        if (this.jtext != null) {
            return this.jtext.getInputMethodRequests();
        }
        return null;
    }

    @Override
    public int getSelectionStart() {
        return this.jtext.getSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.jtext.getSelectionEnd();
    }

    @Override
    public String getText() {
        return this.jtext.getText();
    }

    @Override
    public void setText(String text) {
        this.setTextImpl(text);
        this.repaintText();
    }

    private void setTextImpl(String txt) {
        if (this.jtext != null) {
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.setText(txt);
            if (this.firstChangeSkipped) {
                this.postEvent(new TextEvent(this.target, 900));
            }
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
    }

    @Override
    public void insert(String txt, int p) {
        if (this.jtext != null) {
            JScrollBar bar;
            boolean doScroll = p >= this.jtext.getDocument().getLength() && this.jtext.getDocument().getLength() != 0;
            this.jtext.insert(txt, p);
            this.textPane.validate();
            if (doScroll && (bar = this.textPane.getVerticalScrollBar()) != null) {
                bar.setValue(bar.getMaximum() - bar.getVisibleAmount());
            }
        }
    }

    @Override
    public void replaceRange(String txt, int s, int e) {
        if (this.jtext != null) {
            this.jtext.getDocument().removeDocumentListener(this.jtext);
            this.jtext.replaceRange(txt, s, e);
            this.postEvent(new TextEvent(this.target, 900));
            this.jtext.getDocument().addDocumentListener(this.jtext);
        }
    }

    @Override
    public void setCaretPosition(int position) {
        this.jtext.setCaretPosition(position);
    }

    @Override
    public int getCaretPosition() {
        return this.jtext.getCaretPosition();
    }

    private static final class JavaMouseEventHandler {
        private final XTextAreaPeer outer;
        private final Pointer current = new Pointer();
        private boolean grabbed = false;

        JavaMouseEventHandler(XTextAreaPeer outer) {
            this.outer = outer;
        }

        void handle(MouseEvent event) {
            if (!this.grabbed) {
                this.setPointerToUnderPoint(event.getPoint());
            }
            this.dispatch(event);
            boolean wasGrabbed = this.grabbed;
            this.grabbed_update(event);
            if (wasGrabbed && !this.grabbed) {
                this.setPointerToUnderPoint(event.getPoint());
            }
            this.setCursor();
        }

        private void dispatch(MouseEvent event) {
            switch (this.current.getType()) {
                case TEXT: {
                    Point point = JavaMouseEventHandler.toViewportChildLocalSpace(this.outer.textPane.getViewport(), event.getPoint());
                    AWTTextArea jtext = this.outer.jtext;
                    MouseEvent newEvent = JavaMouseEventHandler.newMouseEvent(jtext, point, event);
                    int id = newEvent.getID();
                    if (id == 503 || id == 506) {
                        jtext.processMouseMotionEventPublic(newEvent);
                        break;
                    }
                    jtext.processMouseEventPublic(newEvent);
                    break;
                }
                case BAR: 
                case BUTTON: {
                    JComponent c = this.current.getBar();
                    Point p = JavaMouseEventHandler.toLocalSpace(c, event.getPoint());
                    if (this.current.getType() == Pointer.Type.BUTTON) {
                        c = this.current.getButton();
                        p = JavaMouseEventHandler.toLocalSpace(c, p);
                    }
                    AWTAccessor.getComponentAccessor().processEvent(c, JavaMouseEventHandler.newMouseEvent(c, p, event));
                }
            }
        }

        private static MouseEvent newMouseEvent(Component source, Point point, MouseEvent template) {
            MouseEvent e = template;
            MouseEvent nme = new MouseEvent(source, e.getID(), e.getWhen(), e.getModifiersEx() | e.getModifiers(), point.x, point.y, e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
            SunToolkit.setSystemGenerated(nme);
            return nme;
        }

        private void setCursor() {
            if (this.current.getType() == Pointer.Type.TEXT) {
                this.outer.pSetCursor(this.outer.target.getCursor(), true);
            } else {
                this.outer.pSetCursor(this.outer.textPane.getCursor(), true);
            }
        }

        private void grabbed_update(MouseEvent event) {
            int allButtonsMask = 7168;
            this.grabbed = (event.getModifiersEx() & 0x1C00) != 0;
        }

        private static Point toLocalSpace(Component local, Point inParentSpace) {
            Point p = inParentSpace;
            Point l = local.getLocation();
            return new Point(p.x - l.x, p.y - l.y);
        }

        private static Point toViewportChildLocalSpace(JViewport v, Point inViewportParentSpace) {
            Point l = JavaMouseEventHandler.toLocalSpace(v, inViewportParentSpace);
            Point p = v.getViewPosition();
            l.x += p.x;
            l.y += p.y;
            return l;
        }

        private void setPointerToUnderPoint(Point point) {
            if (this.outer.textPane.getViewport().getBounds().contains(point)) {
                this.current.setText();
            } else if (!this.setPointerIfPointOverScrollbar(this.outer.textPane.getVerticalScrollBar(), point) && !this.setPointerIfPointOverScrollbar(this.outer.textPane.getHorizontalScrollBar(), point)) {
                this.current.setNone();
            }
        }

        private boolean setPointerIfPointOverScrollbar(JScrollBar bar, Point point) {
            if (!bar.getBounds().contains(point)) {
                return false;
            }
            this.current.setBar(bar);
            Point local = JavaMouseEventHandler.toLocalSpace(bar, point);
            XAWTScrollBarUI ui = (XAWTScrollBarUI)bar.getUI();
            if (!this.setPointerIfPointOverButton(ui.getIncreaseButton(), local)) {
                this.setPointerIfPointOverButton(ui.getDecreaseButton(), local);
            }
            return true;
        }

        private boolean setPointerIfPointOverButton(JButton button, Point point) {
            if (!button.getBounds().contains(point)) {
                return false;
            }
            this.current.setButton(button);
            return true;
        }

        private static final class Pointer {
            private Type type;
            private JScrollBar bar;
            private JButton button;

            private Pointer() {
            }

            Type getType() {
                return this.type;
            }

            boolean isNone() {
                return this.type == Type.NONE;
            }

            JScrollBar getBar() {
                boolean ok;
                boolean bl = ok = this.type == Type.BAR || this.type == Type.BUTTON;
                assert (ok);
                return ok ? this.bar : null;
            }

            JButton getButton() {
                boolean ok;
                boolean bl = ok = this.type == Type.BUTTON;
                assert (ok);
                return ok ? this.button : null;
            }

            void setNone() {
                this.type = Type.NONE;
            }

            void setText() {
                this.type = Type.TEXT;
            }

            void setBar(JScrollBar bar) {
                this.bar = bar;
                this.type = Type.BAR;
            }

            void setButton(JButton button) {
                this.button = button;
                this.type = Type.BUTTON;
            }

            static enum Type {
                NONE,
                TEXT,
                BAR,
                BUTTON;

            }
        }
    }

    static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow = SystemColor.controlDkShadow;
        private Color lightShadow = SystemColor.controlLtHighlight;
        private Color control = SystemColor.controlShadow;
        private boolean isRaised;

        BevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
            this.isRaised = isRaised;
            this.darkShadow = darkShadow;
            this.lightShadow = lightShadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x, y + 1);
            g.setColor(this.control);
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
            g.drawLine(x + 1, y + h - 1, x + 1, y + 1);
            g.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + 1);
            g.setColor(this.control);
            g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
            g.drawLine(x + w - 2, y + h - 2, x + w - 2, y + 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 2;
            insets.bottom = 2;
            insets.left = 2;
            insets.top = 2;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }
    }

    private class AWTTextPane
    extends JScrollPane
    implements FocusListener {
        private final JTextArea jtext;
        private final XWindow xwin;
        private final Color control;
        private final Color focus;

        AWTTextPane(JTextArea jt, XWindow xwin, Container parent) {
            super(jt);
            this.control = SystemColor.control;
            this.focus = SystemColor.activeCaptionBorder;
            this.xwin = xwin;
            this.setDoubleBuffered(true);
            jt.addFocusListener(this);
            AWTAccessor.getComponentAccessor().setParent(this, parent);
            this.setViewportBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
            this.jtext = jt;
            this.setFocusable(false);
            this.addNotify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidate() {
            Object object = this.getTreeLock();
            synchronized (object) {
                Container parent = this.getParent();
                AWTAccessor.getComponentAccessor().setParent(this, null);
                try {
                    super.invalidate();
                }
                finally {
                    AWTAccessor.getComponentAccessor().setParent(this, parent);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Graphics g = this.getGraphics();
            Rectangle r = this.getViewportBorderBounds();
            g.setColor(this.focus);
            g.drawRect(r.x, r.y, r.width, r.height);
            g.dispose();
        }

        @Override
        public void focusLost(FocusEvent e) {
            Graphics g = this.getGraphics();
            Rectangle r = this.getViewportBorderBounds();
            g.setColor(this.control);
            g.drawRect(r.x, r.y, r.width, r.height);
            g.dispose();
        }

        public Window getRealParent() {
            return (Window)this.xwin.target;
        }

        @Override
        public ComponentPeer getPeer() {
            return (ComponentPeer)((Object)this.xwin);
        }

        @Override
        public void updateUI() {
            XAWTScrollPaneUI ui = new XAWTScrollPaneUI();
            this.setUI((ComponentUI)ui);
        }

        @Override
        public JScrollBar createVerticalScrollBar() {
            return new XAWTScrollBar(1);
        }

        @Override
        public JScrollBar createHorizontalScrollBar() {
            return new XAWTScrollBar(0);
        }

        public JTextArea getTextArea() {
            return this.jtext;
        }

        @Override
        public Graphics getGraphics() {
            return this.xwin.getGraphics();
        }

        final class XAWTScrollBar
        extends JScrollPane.ScrollBar {
            XAWTScrollBar(int i) {
                super(AWTTextPane.this, i);
                this.setFocusable(false);
            }

            @Override
            public void updateUI() {
                XAWTScrollBarUI ui = new XAWTScrollBarUI();
                this.setUI((ComponentUI)ui);
            }
        }
    }

    final class XAWTScrollPaneUI
    extends BasicScrollPaneUI {
        private final Border vsbMarginBorderR = new EmptyBorder(0, 2, 0, 0);
        private final Border vsbMarginBorderL = new EmptyBorder(0, 0, 0, 2);
        private final Border hsbMarginBorder = new EmptyBorder(2, 0, 0, 0);
        private Border vsbBorder;
        private Border hsbBorder;
        private PropertyChangeListener propertyChangeHandler;

        XAWTScrollPaneUI() {
        }

        @Override
        protected void installListeners(JScrollPane scrollPane) {
            super.installListeners(scrollPane);
            this.propertyChangeHandler = this.createPropertyChangeHandler();
            scrollPane.addPropertyChangeListener(this.propertyChangeHandler);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Border vpBorder = this.scrollpane.getViewportBorder();
            if (vpBorder != null) {
                Rectangle r = this.scrollpane.getViewportBorderBounds();
                vpBorder.paintBorder(this.scrollpane, g, r.x, r.y, r.width, r.height);
            }
        }

        @Override
        protected void uninstallListeners(JComponent scrollPane) {
            super.uninstallListeners(scrollPane);
            scrollPane.removePropertyChangeListener(this.propertyChangeHandler);
        }

        private PropertyChangeListener createPropertyChangeHandler() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    JScrollPane pane;
                    JScrollBar vsb;
                    String propertyName = e.getPropertyName();
                    if (propertyName.equals("componentOrientation") && (vsb = (pane = (JScrollPane)e.getSource()).getVerticalScrollBar()) != null) {
                        if (XAWTScrollPaneUI.this.isLeftToRight(pane)) {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, 4, 0, -4), vsb.getBorder());
                        } else {
                            XAWTScrollPaneUI.this.vsbBorder = new CompoundBorder(new EmptyBorder(0, -4, 0, 4), vsb.getBorder());
                        }
                        vsb.setBorder(XAWTScrollPaneUI.this.vsbBorder);
                    }
                }
            };
        }

        boolean isLeftToRight(Component c) {
            return c.getComponentOrientation().isLeftToRight();
        }

        @Override
        protected void installDefaults(JScrollPane scrollpane) {
            JScrollBar hsb;
            Border b = scrollpane.getBorder();
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            scrollpane.setBorder(uidefaults.getBorder("ScrollPane.border"));
            scrollpane.setBackground(uidefaults.getColor("ScrollPane.background"));
            scrollpane.setViewportBorder(uidefaults.getBorder("TextField.border"));
            JScrollBar vsb = scrollpane.getVerticalScrollBar();
            if (vsb != null) {
                this.vsbBorder = this.isLeftToRight(scrollpane) ? new CompoundBorder(this.vsbMarginBorderR, vsb.getBorder()) : new CompoundBorder(this.vsbMarginBorderL, vsb.getBorder());
                vsb.setBorder(this.vsbBorder);
            }
            if ((hsb = scrollpane.getHorizontalScrollBar()) != null) {
                this.hsbBorder = new CompoundBorder(this.hsbMarginBorder, hsb.getBorder());
                hsb.setBorder(this.hsbBorder);
            }
        }

        @Override
        protected void uninstallDefaults(JScrollPane c) {
            JScrollBar hsb;
            super.uninstallDefaults(c);
            JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
            if (vsb != null) {
                if (vsb.getBorder() == this.vsbBorder) {
                    vsb.setBorder(null);
                }
                this.vsbBorder = null;
            }
            if ((hsb = this.scrollpane.getHorizontalScrollBar()) != null) {
                if (hsb.getBorder() == this.hsbBorder) {
                    hsb.setBorder(null);
                }
                this.hsbBorder = null;
            }
        }
    }

    final class AWTTextArea
    extends JTextArea
    implements DocumentListener {
        private boolean isFocused;
        private final XTextAreaPeer peer;

        AWTTextArea(String text, XTextAreaPeer peer) {
            super(text);
            this.isFocused = false;
            this.setFocusable(false);
            this.peer = peer;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (this.peer != null) {
                this.peer.postEvent(new TextEvent(this.peer.target, 900));
            }
        }

        void forwardFocusGained(FocusEvent e) {
            this.isFocused = true;
            FocusEvent fe = CausedFocusEvent.retarget(e, this);
            super.processFocusEvent(fe);
        }

        void forwardFocusLost(FocusEvent e) {
            this.isFocused = false;
            FocusEvent fe = CausedFocusEvent.retarget(e, this);
            super.processFocusEvent(fe);
        }

        @Override
        public boolean hasFocus() {
            return this.isFocused;
        }

        public void repaintNow() {
            this.paintImmediately(this.getBounds());
        }

        public void processMouseEventPublic(MouseEvent e) {
            this.processMouseEvent(e);
        }

        public void processMouseMotionEventPublic(MouseEvent e) {
            this.processMouseMotionEvent(e);
        }

        public void processInputMethodEventPublic(InputMethodEvent e) {
            this.processInputMethodEvent(e);
        }

        @Override
        public void updateUI() {
            AWTTextAreaUI ui = new AWTTextAreaUI();
            this.setUI((ComponentUI)ui);
        }

        @Override
        public void setTransferHandler(TransferHandler newHandler) {
            TransferHandler oldHandler = (TransferHandler)this.getClientProperty(AWTAccessor.getClientPropertyKeyAccessor().getJComponent_TRANSFER_HANDLER());
            this.putClientProperty(AWTAccessor.getClientPropertyKeyAccessor().getJComponent_TRANSFER_HANDLER(), newHandler);
            this.firePropertyChange("transferHandler", oldHandler, newHandler);
        }
    }

    final class XAWTScrollBarUI
    extends BasicScrollBarUI {
        XAWTScrollBarUI() {
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            this.scrollbar.setBorder(new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight));
        }

        @Override
        protected void configureScrollBarColors() {
            Color fg;
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            Color bg = this.scrollbar.getBackground();
            if (bg == null || bg instanceof UIResource) {
                this.scrollbar.setBackground(uidefaults.getColor("ScrollBar.background"));
            }
            if ((fg = this.scrollbar.getForeground()) == null || fg instanceof UIResource) {
                this.scrollbar.setForeground(uidefaults.getColor("ScrollBar.foreground"));
            }
            this.thumbHighlightColor = uidefaults.getColor("ScrollBar.thumbHighlight");
            this.thumbLightShadowColor = uidefaults.getColor("ScrollBar.thumbShadow");
            this.thumbDarkShadowColor = uidefaults.getColor("ScrollBar.thumbDarkShadow");
            this.thumbColor = uidefaults.getColor("ScrollBar.thumb");
            this.trackColor = uidefaults.getColor("ScrollBar.track");
            this.trackHighlightColor = uidefaults.getColor("ScrollBar.trackHighlight");
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            XAWTScrollBarButton b = new XAWTScrollBarButton(orientation);
            return b;
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            XAWTScrollBarButton b = new XAWTScrollBarButton(orientation);
            return b;
        }

        public JButton getDecreaseButton() {
            return this.decrButton;
        }

        public JButton getIncreaseButton() {
            return this.incrButton;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            this.paintTrack(g, c, this.getTrackBounds());
            Rectangle thumbBounds = this.getThumbBounds();
            this.paintThumb(g, c, thumbBounds);
        }

        @Override
        public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
            if (!this.scrollbar.isEnabled()) {
                return;
            }
            if (thumbBounds.isEmpty()) {
                thumbBounds = this.getTrackBounds();
            }
            int w = thumbBounds.width;
            int h = thumbBounds.height;
            g.translate(thumbBounds.x, thumbBounds.y);
            g.setColor(this.thumbColor);
            g.fillRect(0, 0, w - 1, h - 1);
            g.setColor(this.thumbHighlightColor);
            g.drawLine(0, 0, 0, h - 1);
            g.drawLine(1, 0, w - 1, 0);
            g.setColor(this.thumbLightShadowColor);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 2);
            g.translate(-thumbBounds.x, -thumbBounds.y);
        }
    }

    final class XAWTScrollBarButton
    extends BasicArrowButton {
        private UIDefaults uidefaults;
        private Color darkShadow;
        private Color lightShadow;
        private Color buttonBack;

        XAWTScrollBarButton(int direction) {
            super(direction);
            this.uidefaults = XToolkit.getUIDefaults();
            this.darkShadow = SystemColor.controlShadow;
            this.lightShadow = SystemColor.controlLtHighlight;
            this.buttonBack = this.uidefaults.getColor("ScrollBar.track");
            switch (direction) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    this.direction = direction;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid direction");
                }
            }
            this.setRequestFocusEnabled(false);
            this.setOpaque(true);
            this.setBackground(this.uidefaults.getColor("ScrollBar.thumb"));
            this.setForeground(this.uidefaults.getColor("ScrollBar.foreground"));
        }

        @Override
        public Dimension getPreferredSize() {
            switch (this.direction) {
                case 1: 
                case 5: {
                    return new Dimension(11, 12);
                }
            }
            return new Dimension(12, 11);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
            boolean isPressed;
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.isOpaque()) {
                g.setColor(this.buttonBack);
                g.fillRect(0, 0, w, h);
            }
            Color lead = (isPressed = this.getModel().isPressed()) ? this.darkShadow : this.lightShadow;
            Color trail = isPressed ? this.lightShadow : this.darkShadow;
            Color fill = this.getBackground();
            int cx = w / 2;
            int cy = h / 2;
            int s = Math.min(w, h);
            switch (this.direction) {
                case 1: {
                    g.setColor(lead);
                    g.drawLine(cx, 0, cx, 0);
                    int x = cx - 1;
                    int dx = 1;
                    for (int y = 1; y <= s - 2; y += 2) {
                        g.setColor(lead);
                        g.drawLine(x, y, x, y);
                        if (y >= s - 2) {
                            g.drawLine(x, y + 1, x, y + 1);
                        }
                        g.setColor(fill);
                        g.drawLine(x + 1, y, x + dx, y);
                        if (y < s - 2) {
                            g.drawLine(x, y + 1, x + dx + 1, y + 1);
                        }
                        g.setColor(trail);
                        g.drawLine(x + dx + 1, y, x + dx + 1, y);
                        if (y >= s - 2) {
                            g.drawLine(x + 1, y + 1, x + dx + 1, y + 1);
                        }
                        dx += 2;
                        --x;
                    }
                    break;
                }
                case 5: {
                    g.setColor(trail);
                    g.drawLine(cx, s, cx, s);
                    int x = cx - 1;
                    int dx = 1;
                    for (int y = s - 1; y >= 1; y -= 2) {
                        g.setColor(lead);
                        g.drawLine(x, y, x, y);
                        if (y <= 2) {
                            g.drawLine(x, y - 1, x + dx + 1, y - 1);
                        }
                        g.setColor(fill);
                        g.drawLine(x + 1, y, x + dx, y);
                        if (y > 2) {
                            g.drawLine(x, y - 1, x + dx + 1, y - 1);
                        }
                        g.setColor(trail);
                        g.drawLine(x + dx + 1, y, x + dx + 1, y);
                        dx += 2;
                        --x;
                    }
                    break;
                }
                case 3: {
                    g.setColor(lead);
                    g.drawLine(s, cy, s, cy);
                    int y = cy - 1;
                    int dy = 1;
                    for (int x = s - 1; x >= 1; x -= 2) {
                        g.setColor(lead);
                        g.drawLine(x, y, x, y);
                        if (x <= 2) {
                            g.drawLine(x - 1, y, x - 1, y + dy + 1);
                        }
                        g.setColor(fill);
                        g.drawLine(x, y + 1, x, y + dy);
                        if (x > 2) {
                            g.drawLine(x - 1, y, x - 1, y + dy + 1);
                        }
                        g.setColor(trail);
                        g.drawLine(x, y + dy + 1, x, y + dy + 1);
                        dy += 2;
                        --y;
                    }
                    break;
                }
                case 7: {
                    g.setColor(trail);
                    g.drawLine(0, cy, 0, cy);
                    int y = cy - 1;
                    int dy = 1;
                    for (int x = 1; x <= s - 2; x += 2) {
                        g.setColor(lead);
                        g.drawLine(x, y, x, y);
                        if (x >= s - 2) {
                            g.drawLine(x + 1, y, x + 1, y);
                        }
                        g.setColor(fill);
                        g.drawLine(x, y + 1, x, y + dy);
                        if (x < s - 2) {
                            g.drawLine(x + 1, y, x + 1, y + dy + 1);
                        }
                        g.setColor(trail);
                        g.drawLine(x, y + dy + 1, x, y + dy + 1);
                        if (x >= s - 2) {
                            g.drawLine(x + 1, y + 1, x + 1, y + dy + 1);
                        }
                        dy += 2;
                        --y;
                    }
                    break;
                }
            }
        }
    }

    static final class XAWTCaret
    extends DefaultCaret {
        XAWTCaret() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            if (this.getComponent().isEnabled()) {
                super.setVisible(true);
            }
            this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            super.focusLost(e);
            this.getComponent().repaint();
        }

        @Override
        public void setSelectionVisible(boolean vis) {
            if (vis) {
                super.setSelectionVisible(vis);
            } else {
                this.setDot(this.getDot());
            }
        }
    }

    final class AWTTextAreaUI
    extends MotifTextAreaUI {
        private JTextArea jta;

        AWTTextAreaUI() {
        }

        @Override
        protected String getPropertyPrefix() {
            return "TextArea";
        }

        @Override
        public void installUI(JComponent c) {
            Color dfg;
            Color sfg;
            Color s;
            Color color;
            Color fg;
            Color bg;
            super.installUI(c);
            JTextArea editor = this.jta = (JTextArea)c;
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            String prefix = this.getPropertyPrefix();
            Font f = editor.getFont();
            if (f == null || f instanceof UIResource) {
                editor.setFont(uidefaults.getFont(prefix + ".font"));
            }
            if ((bg = editor.getBackground()) == null || bg instanceof UIResource) {
                editor.setBackground(uidefaults.getColor(prefix + ".background"));
            }
            if ((fg = editor.getForeground()) == null || fg instanceof UIResource) {
                editor.setForeground(uidefaults.getColor(prefix + ".foreground"));
            }
            if ((color = editor.getCaretColor()) == null || color instanceof UIResource) {
                editor.setCaretColor(uidefaults.getColor(prefix + ".caretForeground"));
            }
            if ((s = editor.getSelectionColor()) == null || s instanceof UIResource) {
                editor.setSelectionColor(uidefaults.getColor(prefix + ".selectionBackground"));
            }
            if ((sfg = editor.getSelectedTextColor()) == null || sfg instanceof UIResource) {
                editor.setSelectedTextColor(uidefaults.getColor(prefix + ".selectionForeground"));
            }
            if ((dfg = editor.getDisabledTextColor()) == null || dfg instanceof UIResource) {
                editor.setDisabledTextColor(uidefaults.getColor(prefix + ".inactiveForeground"));
            }
            BevelBorder b = new BevelBorder(false, SystemColor.controlDkShadow, SystemColor.controlLtHighlight);
            editor.setBorder(new BorderUIResource.CompoundBorderUIResource(b, new EmptyBorder(2, 2, 2, 2)));
            Insets margin = editor.getMargin();
            if (margin == null || margin instanceof UIResource) {
                editor.setMargin(uidefaults.getInsets(prefix + ".margin"));
            }
        }

        @Override
        protected void installKeyboardActions() {
            super.installKeyboardActions();
            JTextComponent comp = this.getComponent();
            UIDefaults uidefaults = XToolkit.getUIDefaults();
            String prefix = this.getPropertyPrefix();
            InputMap map = (InputMap)uidefaults.get(prefix + ".focusInputMap");
            if (map != null) {
                SwingUtilities.replaceUIInputMap(comp, 0, map);
            }
        }

        @Override
        protected Caret createCaret() {
            return new XAWTCaret();
        }
    }
}

