/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.Arrays;
import sun.awt.geom.PathConsumer2D;
import sun.java2d.marlin.Curve;
import sun.java2d.marlin.Helpers;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.RendererContext;

final class Stroker
implements PathConsumer2D,
MarlinConst {
    private static final int MOVE_TO = 0;
    private static final int DRAWING_OP_TO = 1;
    private static final int CLOSE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private static final float ROUND_JOIN_THRESHOLD = 0.015258789f;
    private static final float C = 0.5522848f;
    private static final int MAX_N_CURVES = 11;
    private PathConsumer2D out;
    private int capStyle;
    private int joinStyle;
    private float lineWidth2;
    private float invHalfLineWidth2Sq;
    private final float[] offset0 = new float[2];
    private final float[] offset1 = new float[2];
    private final float[] offset2 = new float[2];
    private final float[] miter = new float[2];
    private float miterLimitSq;
    private int prev;
    private float sx0;
    private float sy0;
    private float sdx;
    private float sdy;
    private float cx0;
    private float cy0;
    private float cdx;
    private float cdy;
    private float smx;
    private float smy;
    private float cmx;
    private float cmy;
    private final PolyStack reverse;
    private final float[] middle = new float[16];
    private final float[] lp = new float[8];
    private final float[] rp = new float[8];
    private final float[] subdivTs = new float[10];
    final RendererContext rdrCtx;
    final Curve curve;

    Stroker(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.reverse = new PolyStack(rdrCtx);
        this.curve = rdrCtx.curve;
    }

    Stroker init(PathConsumer2D pc2d, float lineWidth, int capStyle, int joinStyle, float miterLimit) {
        this.out = pc2d;
        this.lineWidth2 = lineWidth / 2.0f;
        this.invHalfLineWidth2Sq = 1.0f / (2.0f * this.lineWidth2 * this.lineWidth2);
        this.capStyle = capStyle;
        this.joinStyle = joinStyle;
        float limit = miterLimit * this.lineWidth2;
        this.miterLimitSq = limit * limit;
        this.prev = 2;
        this.rdrCtx.stroking = 1;
        return this;
    }

    void dispose() {
        this.reverse.dispose();
    }

    private static void computeOffset(float lx, float ly, float w, float[] m) {
        float len = lx * lx + ly * ly;
        if (len == 0.0f) {
            m[0] = 0.0f;
            m[1] = 0.0f;
        } else {
            len = (float)Math.sqrt(len);
            m[0] = ly * w / len;
            m[1] = -(lx * w) / len;
        }
    }

    private static boolean isCW(float dx1, float dy1, float dx2, float dy2) {
        return dx1 * dy2 <= dy1 * dx2;
    }

    private void drawRoundJoin(float x, float y, float omx, float omy, float mx, float my, boolean rev, float threshold) {
        if (omx == 0.0f && omy == 0.0f || mx == 0.0f && my == 0.0f) {
            return;
        }
        float domx = omx - mx;
        float domy = omy - my;
        float len = domx * domx + domy * domy;
        if (len < threshold) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        this.drawRoundJoin(x, y, omx, omy, mx, my, rev);
    }

    private void drawRoundJoin(float cx, float cy, float omx, float omy, float mx, float my, boolean rev) {
        float cosext = omx * mx + omy * my;
        int numCurves = cosext >= 0.0f ? 1 : 2;
        switch (numCurves) {
            case 1: {
                this.drawBezApproxForArc(cx, cy, omx, omy, mx, my, rev);
                break;
            }
            case 2: {
                float nx = my - omy;
                float ny = omx - mx;
                float nlen = (float)Math.sqrt(nx * nx + ny * ny);
                float scale = this.lineWidth2 / nlen;
                float mmx = nx * scale;
                float mmy = ny * scale;
                if (rev) {
                    mmx = -mmx;
                    mmy = -mmy;
                }
                this.drawBezApproxForArc(cx, cy, omx, omy, mmx, mmy, rev);
                this.drawBezApproxForArc(cx, cy, mmx, mmy, mx, my, rev);
                break;
            }
        }
    }

    private void drawBezApproxForArc(float cx, float cy, float omx, float omy, float mx, float my, boolean rev) {
        float cosext2 = (omx * mx + omy * my) * this.invHalfLineWidth2Sq;
        if (cosext2 >= 0.5f) {
            return;
        }
        float cv = (float)(1.3333333333333333 * Math.sqrt(0.5 - (double)cosext2) / (1.0 + Math.sqrt((double)cosext2 + 0.5)));
        if (rev) {
            cv = -cv;
        }
        float x1 = cx + omx;
        float y1 = cy + omy;
        float x2 = x1 - cv * omy;
        float y2 = y1 + cv * omx;
        float x4 = cx + mx;
        float y4 = cy + my;
        float x3 = x4 + cv * my;
        float y3 = y4 - cv * mx;
        this.emitCurveTo(x1, y1, x2, y2, x3, y3, x4, y4, rev);
    }

    private void drawRoundCap(float cx, float cy, float mx, float my) {
        this.emitCurveTo(cx + mx - 0.5522848f * my, cy + my + 0.5522848f * mx, cx - my + 0.5522848f * mx, cy + mx + 0.5522848f * my, cx - my, cy + mx);
        this.emitCurveTo(cx - my - 0.5522848f * mx, cy + mx - 0.5522848f * my, cx - mx - 0.5522848f * my, cy - my + 0.5522848f * mx, cx - mx, cy - my);
    }

    private static void computeIntersection(float x0, float y0, float x1, float y1, float x0p, float y0p, float x1p, float y1p, float[] m, int off) {
        float x10 = x1 - x0;
        float y10 = y1 - y0;
        float x10p = x1p - x0p;
        float y10p = y1p - y0p;
        float den = x10 * y10p - x10p * y10;
        float t = x10p * (y0 - y0p) - y10p * (x0 - x0p);
        m[off++] = x0 + (t /= den) * x10;
        m[off] = y0 + t * y10;
    }

    private void drawMiter(float pdx, float pdy, float x0, float y0, float dx, float dy, float omx, float omy, float mx, float my, boolean rev) {
        if (mx == omx && my == omy || pdx == 0.0f && pdy == 0.0f || dx == 0.0f && dy == 0.0f) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        Stroker.computeIntersection(x0 - pdx + omx, y0 - pdy + omy, x0 + omx, y0 + omy, dx + x0 + mx, dy + y0 + my, x0 + mx, y0 + my, this.miter, 0);
        float miterX = this.miter[0];
        float miterY = this.miter[1];
        float lenSq = (miterX - x0) * (miterX - x0) + (miterY - y0) * (miterY - y0);
        if (lenSq < this.miterLimitSq) {
            this.emitLineTo(miterX, miterY, rev);
        }
    }

    @Override
    public void moveTo(float x0, float y0) {
        if (this.prev == 1) {
            this.finish();
        }
        this.sx0 = this.cx0 = x0;
        this.sy0 = this.cy0 = y0;
        this.sdx = 1.0f;
        this.cdx = 1.0f;
        this.sdy = 0.0f;
        this.cdy = 0.0f;
        this.prev = 0;
    }

    @Override
    public void lineTo(float x1, float y1) {
        float dx = x1 - this.cx0;
        float dy = y1 - this.cy0;
        if (dx == 0.0f && dy == 0.0f) {
            dx = 1.0f;
        }
        Stroker.computeOffset(dx, dy, this.lineWidth2, this.offset0);
        float mx = this.offset0[0];
        float my = this.offset0[1];
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dx, dy, this.cmx, this.cmy, mx, my);
        this.emitLineTo(this.cx0 + mx, this.cy0 + my);
        this.emitLineTo(x1 + mx, y1 + my);
        this.emitLineToRev(this.cx0 - mx, this.cy0 - my);
        this.emitLineToRev(x1 - mx, y1 - my);
        this.cmx = mx;
        this.cmy = my;
        this.cdx = dx;
        this.cdy = dy;
        this.cx0 = x1;
        this.cy0 = y1;
        this.prev = 1;
    }

    @Override
    public void closePath() {
        if (this.prev != 1) {
            if (this.prev == 2) {
                return;
            }
            this.emitMoveTo(this.cx0, this.cy0 - this.lineWidth2);
            this.smx = 0.0f;
            this.cmx = 0.0f;
            this.cmy = this.smy = -this.lineWidth2;
            this.sdx = 1.0f;
            this.cdx = 1.0f;
            this.sdy = 0.0f;
            this.cdy = 0.0f;
            this.finish();
            return;
        }
        if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
            this.lineTo(this.sx0, this.sy0);
        }
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, this.sdx, this.sdy, this.cmx, this.cmy, this.smx, this.smy);
        this.emitLineTo(this.sx0 + this.smx, this.sy0 + this.smy);
        this.emitMoveTo(this.sx0 - this.smx, this.sy0 - this.smy);
        this.emitReverse();
        this.prev = 2;
        this.emitClose();
    }

    private void emitReverse() {
        this.reverse.popAll(this.out);
    }

    @Override
    public void pathDone() {
        if (this.prev == 1) {
            this.finish();
        }
        this.out.pathDone();
        this.prev = 2;
        this.dispose();
    }

    private void finish() {
        if (this.capStyle == 1) {
            this.drawRoundCap(this.cx0, this.cy0, this.cmx, this.cmy);
        } else if (this.capStyle == 2) {
            this.emitLineTo(this.cx0 - this.cmy + this.cmx, this.cy0 + this.cmx + this.cmy);
            this.emitLineTo(this.cx0 - this.cmy - this.cmx, this.cy0 + this.cmx - this.cmy);
        }
        this.emitReverse();
        if (this.capStyle == 1) {
            this.drawRoundCap(this.sx0, this.sy0, -this.smx, -this.smy);
        } else if (this.capStyle == 2) {
            this.emitLineTo(this.sx0 + this.smy - this.smx, this.sy0 - this.smx - this.smy);
            this.emitLineTo(this.sx0 + this.smy + this.smx, this.sy0 - this.smx + this.smy);
        }
        this.emitClose();
    }

    private void emitMoveTo(float x0, float y0) {
        this.out.moveTo(x0, y0);
    }

    private void emitLineTo(float x1, float y1) {
        this.out.lineTo(x1, y1);
    }

    private void emitLineToRev(float x1, float y1) {
        this.reverse.pushLine(x1, y1);
    }

    private void emitLineTo(float x1, float y1, boolean rev) {
        if (rev) {
            this.emitLineToRev(x1, y1);
        } else {
            this.emitLineTo(x1, y1);
        }
    }

    private void emitQuadTo(float x1, float y1, float x2, float y2) {
        this.out.quadTo(x1, y1, x2, y2);
    }

    private void emitQuadToRev(float x0, float y0, float x1, float y1) {
        this.reverse.pushQuad(x0, y0, x1, y1);
    }

    private void emitCurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.out.curveTo(x1, y1, x2, y2, x3, y3);
    }

    private void emitCurveToRev(float x0, float y0, float x1, float y1, float x2, float y2) {
        this.reverse.pushCubic(x0, y0, x1, y1, x2, y2);
    }

    private void emitCurveTo(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, boolean rev) {
        if (rev) {
            this.reverse.pushCubic(x0, y0, x1, y1, x2, y2);
        } else {
            this.out.curveTo(x1, y1, x2, y2, x3, y3);
        }
    }

    private void emitClose() {
        this.out.closePath();
    }

    private void drawJoin(float pdx, float pdy, float x0, float y0, float dx, float dy, float omx, float omy, float mx, float my) {
        if (this.prev != 1) {
            this.emitMoveTo(x0 + mx, y0 + my);
            this.sdx = dx;
            this.sdy = dy;
            this.smx = mx;
            this.smy = my;
        } else {
            boolean cw = Stroker.isCW(pdx, pdy, dx, dy);
            if (this.joinStyle == 0) {
                this.drawMiter(pdx, pdy, x0, y0, dx, dy, omx, omy, mx, my, cw);
            } else if (this.joinStyle == 1) {
                this.drawRoundJoin(x0, y0, omx, omy, mx, my, cw, 0.015258789f);
            }
            this.emitLineTo(x0, y0, !cw);
        }
        this.prev = 1;
    }

    private static boolean within(float x1, float y1, float x2, float y2, float ERR) {
        assert (ERR > 0.0f) : "";
        return Helpers.within(x1, x2, ERR) && Helpers.within(y1, y2, ERR);
    }

    private void getLineOffsets(float x1, float y1, float x2, float y2, float[] left, float[] right) {
        Stroker.computeOffset(x2 - x1, y2 - y1, this.lineWidth2, this.offset0);
        float mx = this.offset0[0];
        float my = this.offset0[1];
        left[0] = x1 + mx;
        left[1] = y1 + my;
        left[2] = x2 + mx;
        left[3] = y2 + my;
        right[0] = x1 - mx;
        right[1] = y1 - my;
        right[2] = x2 - mx;
        right[3] = y2 - my;
    }

    private int computeOffsetCubic(float[] pts, int off, float[] leftOff, float[] rightOff) {
        float x1 = pts[off + 0];
        float y1 = pts[off + 1];
        float x2 = pts[off + 2];
        float y2 = pts[off + 3];
        float x3 = pts[off + 4];
        float y3 = pts[off + 5];
        float x4 = pts[off + 6];
        float y4 = pts[off + 7];
        float dx4 = x4 - x3;
        float dy4 = y4 - y3;
        float dx1 = x2 - x1;
        float dy1 = y2 - y1;
        boolean p1eqp2 = Stroker.within(x1, y1, x2, y2, 6.0f * Math.ulp(y2));
        boolean p3eqp4 = Stroker.within(x3, y3, x4, y4, 6.0f * Math.ulp(y4));
        if (p1eqp2 && p3eqp4) {
            this.getLineOffsets(x1, y1, x4, y4, leftOff, rightOff);
            return 4;
        }
        if (p1eqp2) {
            dx1 = x3 - x1;
            dy1 = y3 - y1;
        } else if (p3eqp4) {
            dx4 = x4 - x2;
            dy4 = y4 - y2;
        }
        float dotsq = dx1 * dx4 + dy1 * dy4;
        dotsq *= dotsq;
        float l1sq = dx1 * dx1 + dy1 * dy1;
        float l4sq = dx4 * dx4 + dy4 * dy4;
        if (Helpers.within(dotsq, l1sq * l4sq, 4.0f * Math.ulp(dotsq))) {
            this.getLineOffsets(x1, y1, x4, y4, leftOff, rightOff);
            return 4;
        }
        float x = (x1 + 3.0f * (x2 + x3) + x4) / 8.0f;
        float y = (y1 + 3.0f * (y2 + y3) + y4) / 8.0f;
        float dxm = x3 + x4 - x1 - x2;
        float dym = y3 + y4 - y1 - y2;
        Stroker.computeOffset(dx1, dy1, this.lineWidth2, this.offset0);
        Stroker.computeOffset(dxm, dym, this.lineWidth2, this.offset1);
        Stroker.computeOffset(dx4, dy4, this.lineWidth2, this.offset2);
        float x1p = x1 + this.offset0[0];
        float y1p = y1 + this.offset0[1];
        float xi = x + this.offset1[0];
        float yi = y + this.offset1[1];
        float x4p = x4 + this.offset2[0];
        float y4p = y4 + this.offset2[1];
        float invdet43 = 4.0f / (3.0f * (dx1 * dy4 - dy1 * dx4));
        float two_pi_m_p1_m_p4x = 2.0f * xi - x1p - x4p;
        float two_pi_m_p1_m_p4y = 2.0f * yi - y1p - y4p;
        float c1 = invdet43 * (dy4 * two_pi_m_p1_m_p4x - dx4 * two_pi_m_p1_m_p4y);
        float c2 = invdet43 * (dx1 * two_pi_m_p1_m_p4y - dy1 * two_pi_m_p1_m_p4x);
        float x2p = x1p + c1 * dx1;
        float y2p = y1p + c1 * dy1;
        float x3p = x4p + c2 * dx4;
        float y3p = y4p + c2 * dy4;
        leftOff[0] = x1p;
        leftOff[1] = y1p;
        leftOff[2] = x2p;
        leftOff[3] = y2p;
        leftOff[4] = x3p;
        leftOff[5] = y3p;
        leftOff[6] = x4p;
        leftOff[7] = y4p;
        x1p = x1 - this.offset0[0];
        y1p = y1 - this.offset0[1];
        x4p = x4 - this.offset2[0];
        y4p = y4 - this.offset2[1];
        two_pi_m_p1_m_p4x = 2.0f * (xi -= 2.0f * this.offset1[0]) - x1p - x4p;
        two_pi_m_p1_m_p4y = 2.0f * (yi -= 2.0f * this.offset1[1]) - y1p - y4p;
        c1 = invdet43 * (dy4 * two_pi_m_p1_m_p4x - dx4 * two_pi_m_p1_m_p4y);
        c2 = invdet43 * (dx1 * two_pi_m_p1_m_p4y - dy1 * two_pi_m_p1_m_p4x);
        x2p = x1p + c1 * dx1;
        y2p = y1p + c1 * dy1;
        x3p = x4p + c2 * dx4;
        y3p = y4p + c2 * dy4;
        rightOff[0] = x1p;
        rightOff[1] = y1p;
        rightOff[2] = x2p;
        rightOff[3] = y2p;
        rightOff[4] = x3p;
        rightOff[5] = y3p;
        rightOff[6] = x4p;
        rightOff[7] = y4p;
        return 8;
    }

    private int computeOffsetQuad(float[] pts, int off, float[] leftOff, float[] rightOff) {
        float x1 = pts[off + 0];
        float y1 = pts[off + 1];
        float x2 = pts[off + 2];
        float y2 = pts[off + 3];
        float x3 = pts[off + 4];
        float y3 = pts[off + 5];
        float dx3 = x3 - x2;
        float dy3 = y3 - y2;
        float dx1 = x2 - x1;
        float dy1 = y2 - y1;
        Stroker.computeOffset(dx1, dy1, this.lineWidth2, this.offset0);
        Stroker.computeOffset(dx3, dy3, this.lineWidth2, this.offset1);
        leftOff[0] = x1 + this.offset0[0];
        leftOff[1] = y1 + this.offset0[1];
        leftOff[4] = x3 + this.offset1[0];
        leftOff[5] = y3 + this.offset1[1];
        rightOff[0] = x1 - this.offset0[0];
        rightOff[1] = y1 - this.offset0[1];
        rightOff[4] = x3 - this.offset1[0];
        rightOff[5] = y3 - this.offset1[1];
        float x1p = leftOff[0];
        float y1p = leftOff[1];
        float x3p = leftOff[4];
        float y3p = leftOff[5];
        Stroker.computeIntersection(x1p, y1p, x1p + dx1, y1p + dy1, x3p, y3p, x3p - dx3, y3p - dy3, leftOff, 2);
        float cx = leftOff[2];
        float cy = leftOff[3];
        if (!Stroker.isFinite(cx) || !Stroker.isFinite(cy)) {
            x1p = rightOff[0];
            y1p = rightOff[1];
            x3p = rightOff[4];
            y3p = rightOff[5];
            Stroker.computeIntersection(x1p, y1p, x1p + dx1, y1p + dy1, x3p, y3p, x3p - dx3, y3p - dy3, rightOff, 2);
            cx = rightOff[2];
            cy = rightOff[3];
            if (!Stroker.isFinite(cx) || !Stroker.isFinite(cy)) {
                this.getLineOffsets(x1, y1, x3, y3, leftOff, rightOff);
                return 4;
            }
            leftOff[2] = 2.0f * x2 - cx;
            leftOff[3] = 2.0f * y2 - cy;
            return 6;
        }
        rightOff[2] = 2.0f * x2 - cx;
        rightOff[3] = 2.0f * y2 - cy;
        return 6;
    }

    private static boolean isFinite(float x) {
        return Float.NEGATIVE_INFINITY < x && x < Float.POSITIVE_INFINITY;
    }

    private static int findSubdivPoints(Curve c, float[] pts, float[] ts, int type, float w) {
        float x12 = pts[2] - pts[0];
        float y12 = pts[3] - pts[1];
        if (y12 != 0.0f && x12 != 0.0f) {
            float hypot = (float)Math.sqrt(x12 * x12 + y12 * y12);
            float cos = x12 / hypot;
            float sin = y12 / hypot;
            float x1 = cos * pts[0] + sin * pts[1];
            float y1 = cos * pts[1] - sin * pts[0];
            float x2 = cos * pts[2] + sin * pts[3];
            float y2 = cos * pts[3] - sin * pts[2];
            float x3 = cos * pts[4] + sin * pts[5];
            float y3 = cos * pts[5] - sin * pts[4];
            switch (type) {
                case 8: {
                    float x4 = cos * pts[6] + sin * pts[7];
                    float y4 = cos * pts[7] - sin * pts[6];
                    c.set(x1, y1, x2, y2, x3, y3, x4, y4);
                    break;
                }
                case 6: {
                    c.set(x1, y1, x2, y2, x3, y3);
                    break;
                }
            }
        } else {
            c.set(pts, type);
        }
        int ret = 0;
        ret += c.dxRoots(ts, ret);
        ret += c.dyRoots(ts, ret);
        if (type == 8) {
            ret += c.infPoints(ts, ret);
        }
        ret += c.rootsOfROCMinusW(ts, ret, w, 1.0E-4f);
        ret = Helpers.filterOutNotInAB(ts, 0, ret, 1.0E-4f, 0.9999f);
        Helpers.isort(ts, 0, ret);
        return ret;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        float len;
        boolean p3eqp4;
        float[] mid = this.middle;
        mid[0] = this.cx0;
        mid[1] = this.cy0;
        mid[2] = x1;
        mid[3] = y1;
        mid[4] = x2;
        mid[5] = y2;
        mid[6] = x3;
        mid[7] = y3;
        float xf = mid[6];
        float yf = mid[7];
        float dxs = mid[2] - mid[0];
        float dys = mid[3] - mid[1];
        float dxf = mid[6] - mid[4];
        float dyf = mid[7] - mid[5];
        boolean p1eqp2 = dxs == 0.0f && dys == 0.0f;
        boolean bl = p3eqp4 = dxf == 0.0f && dyf == 0.0f;
        if (p1eqp2) {
            dxs = mid[4] - mid[0];
            dys = mid[5] - mid[1];
            if (dxs == 0.0f && dys == 0.0f) {
                dxs = mid[6] - mid[0];
                dys = mid[7] - mid[1];
            }
        }
        if (p3eqp4) {
            dxf = mid[6] - mid[2];
            dyf = mid[7] - mid[3];
            if (dxf == 0.0f && dyf == 0.0f) {
                dxf = mid[6] - mid[0];
                dyf = mid[7] - mid[1];
            }
        }
        if (dxs == 0.0f && dys == 0.0f) {
            this.lineTo(mid[0], mid[1]);
            return;
        }
        if (Math.abs(dxs) < 0.1f && Math.abs(dys) < 0.1f) {
            len = (float)Math.sqrt(dxs * dxs + dys * dys);
            dxs /= len;
            dys /= len;
        }
        if (Math.abs(dxf) < 0.1f && Math.abs(dyf) < 0.1f) {
            len = (float)Math.sqrt(dxf * dxf + dyf * dyf);
            dxf /= len;
            dyf /= len;
        }
        Stroker.computeOffset(dxs, dys, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dxs, dys, this.cmx, this.cmy, this.offset0[0], this.offset0[1]);
        int nSplits = Stroker.findSubdivPoints(this.curve, mid, this.subdivTs, 8, this.lineWidth2);
        float[] l = this.lp;
        float[] r = this.rp;
        int kind = 0;
        Curve.BreakPtrIterator it = this.curve.breakPtsAtTs(mid, 8, this.subdivTs, nSplits);
        while (it.hasNext()) {
            int curCurveOff = it.next();
            kind = this.computeOffsetCubic(mid, curCurveOff, l, r);
            this.emitLineTo(l[0], l[1]);
            switch (kind) {
                case 8: {
                    this.emitCurveTo(l[2], l[3], l[4], l[5], l[6], l[7]);
                    this.emitCurveToRev(r[0], r[1], r[2], r[3], r[4], r[5]);
                    break;
                }
                case 4: {
                    this.emitLineTo(l[2], l[3]);
                    this.emitLineToRev(r[0], r[1]);
                    break;
                }
            }
            this.emitLineToRev(r[kind - 2], r[kind - 1]);
        }
        this.cmx = (l[kind - 2] - r[kind - 2]) / 2.0f;
        this.cmy = (l[kind - 1] - r[kind - 1]) / 2.0f;
        this.cdx = dxf;
        this.cdy = dyf;
        this.cx0 = xf;
        this.cy0 = yf;
        this.prev = 1;
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        float len;
        float[] mid = this.middle;
        mid[0] = this.cx0;
        mid[1] = this.cy0;
        mid[2] = x1;
        mid[3] = y1;
        mid[4] = x2;
        mid[5] = y2;
        float xf = mid[4];
        float yf = mid[5];
        float dxs = mid[2] - mid[0];
        float dys = mid[3] - mid[1];
        float dxf = mid[4] - mid[2];
        float dyf = mid[5] - mid[3];
        if (dxs == 0.0f && dys == 0.0f || dxf == 0.0f && dyf == 0.0f) {
            dxs = dxf = mid[4] - mid[0];
            dys = dyf = mid[5] - mid[1];
        }
        if (dxs == 0.0f && dys == 0.0f) {
            this.lineTo(mid[0], mid[1]);
            return;
        }
        if (Math.abs(dxs) < 0.1f && Math.abs(dys) < 0.1f) {
            len = (float)Math.sqrt(dxs * dxs + dys * dys);
            dxs /= len;
            dys /= len;
        }
        if (Math.abs(dxf) < 0.1f && Math.abs(dyf) < 0.1f) {
            len = (float)Math.sqrt(dxf * dxf + dyf * dyf);
            dxf /= len;
            dyf /= len;
        }
        Stroker.computeOffset(dxs, dys, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dxs, dys, this.cmx, this.cmy, this.offset0[0], this.offset0[1]);
        int nSplits = Stroker.findSubdivPoints(this.curve, mid, this.subdivTs, 6, this.lineWidth2);
        float[] l = this.lp;
        float[] r = this.rp;
        int kind = 0;
        Curve.BreakPtrIterator it = this.curve.breakPtsAtTs(mid, 6, this.subdivTs, nSplits);
        while (it.hasNext()) {
            int curCurveOff = it.next();
            kind = this.computeOffsetQuad(mid, curCurveOff, l, r);
            this.emitLineTo(l[0], l[1]);
            switch (kind) {
                case 6: {
                    this.emitQuadTo(l[2], l[3], l[4], l[5]);
                    this.emitQuadToRev(r[0], r[1], r[2], r[3]);
                    break;
                }
                case 4: {
                    this.emitLineTo(l[2], l[3]);
                    this.emitLineToRev(r[0], r[1]);
                    break;
                }
            }
            this.emitLineToRev(r[kind - 2], r[kind - 1]);
        }
        this.cmx = (l[kind - 2] - r[kind - 2]) / 2.0f;
        this.cmy = (l[kind - 1] - r[kind - 1]) / 2.0f;
        this.cdx = dxf;
        this.cdy = dyf;
        this.cx0 = xf;
        this.cy0 = yf;
        this.prev = 1;
    }

    @Override
    public long getNativeConsumer() {
        throw new InternalError("Stroker doesn't use a native consumer");
    }

    static final class PolyStack {
        private static final byte TYPE_LINETO = 0;
        private static final byte TYPE_QUADTO = 1;
        private static final byte TYPE_CUBICTO = 2;
        float[] curves;
        int end;
        byte[] curveTypes;
        int numCurves;
        final RendererContext rdrCtx;
        private final float[] curves_initial = new float[8193];
        private final byte[] curveTypes_initial = new byte[8193];
        int curveTypesUseMark;
        int curvesUseMark;

        PolyStack(RendererContext rdrCtx) {
            this.rdrCtx = rdrCtx;
            this.curves = this.curves_initial;
            this.curveTypes = this.curveTypes_initial;
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.doStats) {
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
        }

        void dispose() {
            this.end = 0;
            this.numCurves = 0;
            if (MarlinConst.doStats) {
                RendererContext.stats.stat_rdr_poly_stack_types.add(this.curveTypesUseMark);
                RendererContext.stats.stat_rdr_poly_stack_curves.add(this.curvesUseMark);
                this.curveTypesUseMark = 0;
                this.curvesUseMark = 0;
            }
            if (this.curves != this.curves_initial) {
                this.rdrCtx.putDirtyFloatArray(this.curves);
                this.curves = this.curves_initial;
            }
            if (this.curveTypes != this.curveTypes_initial) {
                this.rdrCtx.putDirtyByteArray(this.curveTypes);
                this.curveTypes = this.curveTypes_initial;
            }
        }

        private void ensureSpace(int n) {
            if (this.curves.length - this.end < n) {
                if (MarlinConst.doStats) {
                    RendererContext.stats.stat_array_stroker_polystack_curves.add(this.end + n);
                }
                this.curves = this.rdrCtx.widenDirtyFloatArray(this.curves, this.end, this.end + n);
            }
            if (this.curveTypes.length <= this.numCurves) {
                if (MarlinConst.doStats) {
                    RendererContext.stats.stat_array_stroker_polystack_curveTypes.add(this.numCurves + 1);
                }
                this.curveTypes = this.rdrCtx.widenDirtyByteArray(this.curveTypes, this.numCurves, this.numCurves + 1);
            }
        }

        void pushCubic(float x0, float y0, float x1, float y1, float x2, float y2) {
            this.ensureSpace(6);
            this.curveTypes[this.numCurves++] = 2;
            float[] _curves = this.curves;
            int e = this.end;
            _curves[e++] = x2;
            _curves[e++] = y2;
            _curves[e++] = x1;
            _curves[e++] = y1;
            _curves[e++] = x0;
            _curves[e++] = y0;
            this.end = e;
        }

        void pushQuad(float x0, float y0, float x1, float y1) {
            this.ensureSpace(4);
            this.curveTypes[this.numCurves++] = 1;
            float[] _curves = this.curves;
            int e = this.end;
            _curves[e++] = x1;
            _curves[e++] = y1;
            _curves[e++] = x0;
            _curves[e++] = y0;
            this.end = e;
        }

        void pushLine(float x, float y) {
            this.ensureSpace(2);
            this.curveTypes[this.numCurves++] = 0;
            this.curves[this.end++] = x;
            this.curves[this.end++] = y;
        }

        void popAll(PathConsumer2D io) {
            if (MarlinConst.doStats) {
                if (this.numCurves > this.curveTypesUseMark) {
                    this.curveTypesUseMark = this.numCurves;
                }
                if (this.end > this.curvesUseMark) {
                    this.curvesUseMark = this.end;
                }
            }
            byte[] _curveTypes = this.curveTypes;
            float[] _curves = this.curves;
            int nc = this.numCurves;
            int e = this.end;
            block5: while (nc != 0) {
                switch (_curveTypes[--nc]) {
                    case 0: {
                        io.lineTo(_curves[e -= 2], _curves[e + 1]);
                        continue block5;
                    }
                    case 1: {
                        io.quadTo(_curves[(e -= 4) + 0], _curves[e + 1], _curves[e + 2], _curves[e + 3]);
                        continue block5;
                    }
                    case 2: {
                        io.curveTo(_curves[(e -= 6) + 0], _curves[e + 1], _curves[e + 2], _curves[e + 3], _curves[e + 4], _curves[e + 5]);
                        continue block5;
                    }
                }
            }
            this.numCurves = 0;
            this.end = 0;
        }

        public String toString() {
            String ret = "";
            int nc = this.numCurves;
            int e = this.end;
            while (nc != 0) {
                int len;
                switch (this.curveTypes[--nc]) {
                    case 0: {
                        len = 2;
                        ret = ret + "line: ";
                        break;
                    }
                    case 1: {
                        len = 4;
                        ret = ret + "quad: ";
                        break;
                    }
                    case 2: {
                        len = 6;
                        ret = ret + "cubic: ";
                        break;
                    }
                    default: {
                        len = 0;
                    }
                }
                ret = ret + Arrays.toString(Arrays.copyOfRange(this.curves, e -= len, e + len)) + "\n";
            }
            return ret;
        }
    }
}

