/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.List;
import sun.font.GlyphList;
import sun.font.XRGlyphCacheEntry;
import sun.java2d.jules.TrapezoidList;
import sun.java2d.pipe.Region;
import sun.java2d.xr.GrowableEltArray;
import sun.java2d.xr.GrowableIntArray;
import sun.java2d.xr.GrowableRectArray;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRColor;
import sun.java2d.xr.XRUtils;

public class XRBackendNative
implements XRBackend {
    private static long FMTPTR_A8;
    private static long FMTPTR_ARGB32;
    private static long MASK_XIMG;

    private static native void initIDs();

    @Override
    public native long createGC(int var1);

    @Override
    public native void freeGC(long var1);

    @Override
    public native int createPixmap(int var1, int var2, int var3, int var4);

    private native int createPictureNative(int var1, long var2);

    @Override
    public native void freePicture(int var1);

    @Override
    public native void freePixmap(int var1);

    @Override
    public native void setGCExposures(long var1, boolean var3);

    @Override
    public native void setGCForeground(long var1, int var3);

    @Override
    public native void setPictureRepeat(int var1, int var2);

    @Override
    public native void copyArea(int var1, int var2, long var3, int var5, int var6, int var7, int var8, int var9, int var10);

    @Override
    public native void setGCMode(long var1, boolean var3);

    private static native void GCRectanglesNative(int var0, long var1, int[] var3, int var4);

    @Override
    public native void renderComposite(byte var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    private native void renderRectangle(int var1, byte var2, short var3, short var4, short var5, short var6, int var7, int var8, int var9, int var10);

    private static native void XRenderRectanglesNative(int var0, byte var1, short var2, short var3, short var4, short var5, int[] var6, int var7);

    private native void XRSetTransformNative(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int XRCreateLinearGradientPaintNative(float[] var0, short[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    private static native int XRCreateRadialGradientPaintNative(float[] var0, short[] var1, int var2, int var3, int var4, int var5, int var6, int var7);

    @Override
    public native void setFilter(int var1, int var2);

    private static native void XRSetClipNative(long var0, int var2, int var3, int var4, int var5, Region var6, boolean var7);

    @Override
    public void GCRectangles(int drawable, long gc, GrowableRectArray rects) {
        XRBackendNative.GCRectanglesNative(drawable, gc, rects.getArray(), rects.getSize());
    }

    @Override
    public int createPicture(int drawable, int formatID) {
        return this.createPictureNative(drawable, XRBackendNative.getFormatPtr(formatID));
    }

    @Override
    public void setPictureTransform(int picture, AffineTransform transform) {
        this.XRSetTransformNative(picture, XRUtils.XDoubleToFixed(transform.getScaleX()), XRUtils.XDoubleToFixed(transform.getShearX()), XRUtils.XDoubleToFixed(transform.getTranslateX()), XRUtils.XDoubleToFixed(transform.getShearY()), XRUtils.XDoubleToFixed(transform.getScaleY()), XRUtils.XDoubleToFixed(transform.getTranslateY()));
    }

    @Override
    public void renderRectangle(int dst, byte op, XRColor color, int x, int y, int width, int height) {
        this.renderRectangle(dst, op, (short)color.red, (short)color.green, (short)color.blue, (short)color.alpha, x, y, width, height);
    }

    private short[] getRenderColors(int[] pixels) {
        short[] renderColors = new short[pixels.length * 4];
        XRColor c = new XRColor();
        for (int i = 0; i < pixels.length; ++i) {
            c.setColorValues(pixels[i], true);
            renderColors[i * 4 + 0] = (short)c.alpha;
            renderColors[i * 4 + 1] = (short)c.red;
            renderColors[i * 4 + 2] = (short)c.green;
            renderColors[i * 4 + 3] = (short)c.blue;
        }
        return renderColors;
    }

    private static long getFormatPtr(int formatID) {
        switch (formatID) {
            case 2: {
                return FMTPTR_A8;
            }
            case 0: {
                return FMTPTR_ARGB32;
            }
        }
        return 0L;
    }

    @Override
    public int createLinearGradient(Point2D p1, Point2D p2, float[] fractions, int[] pixels, int repeat) {
        short[] colorValues = this.getRenderColors(pixels);
        int gradient = XRBackendNative.XRCreateLinearGradientPaintNative(fractions, colorValues, XRUtils.XDoubleToFixed(p1.getX()), XRUtils.XDoubleToFixed(p1.getY()), XRUtils.XDoubleToFixed(p2.getX()), XRUtils.XDoubleToFixed(p2.getY()), fractions.length, repeat);
        return gradient;
    }

    @Override
    public int createRadialGradient(float centerX, float centerY, float innerRadius, float outerRadius, float[] fractions, int[] pixels, int repeat) {
        short[] colorValues = this.getRenderColors(pixels);
        return XRBackendNative.XRCreateRadialGradientPaintNative(fractions, colorValues, fractions.length, XRUtils.XDoubleToFixed(centerX), XRUtils.XDoubleToFixed(centerY), XRUtils.XDoubleToFixed(innerRadius), XRUtils.XDoubleToFixed(outerRadius), repeat);
    }

    @Override
    public void setGCClipRectangles(long gc, Region clip) {
        XRBackendNative.XRSetClipNative(gc, clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY(), clip.isRectangular() ? null : clip, true);
    }

    @Override
    public void setClipRectangles(int picture, Region clip) {
        if (clip != null) {
            XRBackendNative.XRSetClipNative(picture, clip.getLoX(), clip.getLoY(), clip.getHiX(), clip.getHiY(), clip.isRectangular() ? null : clip, false);
        } else {
            XRBackendNative.XRSetClipNative(picture, 0, 0, Short.MAX_VALUE, Short.MAX_VALUE, null, false);
        }
    }

    @Override
    public void renderRectangles(int dst, byte op, XRColor color, GrowableRectArray rects) {
        XRBackendNative.XRenderRectanglesNative(dst, op, (short)color.red, (short)color.green, (short)color.blue, (short)color.alpha, rects.getArray(), rects.getSize());
    }

    private static long[] getGlyphInfoPtrs(List<XRGlyphCacheEntry> cacheEntries) {
        long[] glyphInfoPtrs = new long[cacheEntries.size()];
        for (int i = 0; i < cacheEntries.size(); ++i) {
            glyphInfoPtrs[i] = cacheEntries.get(i).getGlyphInfoPtr();
        }
        return glyphInfoPtrs;
    }

    @Override
    public void XRenderAddGlyphs(int glyphSet, GlyphList gl, List<XRGlyphCacheEntry> cacheEntries, byte[] pixelData) {
        long[] glyphInfoPtrs = XRBackendNative.getGlyphInfoPtrs(cacheEntries);
        XRBackendNative.XRAddGlyphsNative(glyphSet, glyphInfoPtrs, glyphInfoPtrs.length, pixelData, pixelData.length);
    }

    @Override
    public void XRenderFreeGlyphs(int glyphSet, int[] gids) {
        XRBackendNative.XRFreeGlyphsNative(glyphSet, gids, gids.length);
    }

    private static native void XRAddGlyphsNative(int var0, long[] var1, int var2, byte[] var3, int var4);

    private static native void XRFreeGlyphsNative(int var0, int[] var1, int var2);

    private static native void XRenderCompositeTextNative(int var0, int var1, int var2, int var3, int var4, long var5, int[] var7, int[] var8, int var9, int var10);

    @Override
    public int XRenderCreateGlyphSet(int formatID) {
        return XRBackendNative.XRenderCreateGlyphSetNative(XRBackendNative.getFormatPtr(formatID));
    }

    private static native int XRenderCreateGlyphSetNative(long var0);

    @Override
    public void XRenderCompositeText(byte op, int src, int dst, int maskFormatID, int sx, int sy, int dx, int dy, int glyphset, GrowableEltArray elts) {
        GrowableIntArray glyphs = elts.getGlyphs();
        XRBackendNative.XRenderCompositeTextNative(op, src, dst, sx, sy, 0L, elts.getArray(), glyphs.getArray(), elts.getSize(), glyphs.getSize());
    }

    @Override
    public void putMaskImage(int drawable, long gc, byte[] imageData, int sx, int sy, int dx, int dy, int width, int height, int maskOff, int maskScan, float ea) {
        XRBackendNative.putMaskNative(drawable, gc, imageData, sx, sy, dx, dy, width, height, maskOff, maskScan, ea, MASK_XIMG);
    }

    private static native void putMaskNative(int var0, long var1, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, float var12, long var13);

    public void padBlit(byte op, int srcPict, int maskPict, int dstPict, AffineTransform maskTrx, int maskWidth, int maskHeight, int lastMaskWidth, int lastMaskHeight, int sx, int sy, int dx, int dy, int w, int h) {
        XRBackendNative.padBlitNative(op, srcPict, maskPict, dstPict, XRUtils.XDoubleToFixed(maskTrx.getScaleX()), XRUtils.XDoubleToFixed(maskTrx.getShearX()), XRUtils.XDoubleToFixed(maskTrx.getTranslateX()), XRUtils.XDoubleToFixed(maskTrx.getShearY()), XRUtils.XDoubleToFixed(maskTrx.getScaleY()), XRUtils.XDoubleToFixed(maskTrx.getTranslateY()), maskWidth, maskHeight, lastMaskWidth, lastMaskHeight, sx, sy, dx, dy, w, h);
    }

    private static native void padBlitNative(byte var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17, int var18, int var19);

    @Override
    public void renderCompositeTrapezoids(byte op, int src, int maskFormat, int dst, int srcX, int srcY, TrapezoidList trapList) {
        XRBackendNative.renderCompositeTrapezoidsNative(op, src, XRBackendNative.getFormatPtr(maskFormat), dst, srcX, srcY, trapList.getTrapArray());
    }

    private static native void renderCompositeTrapezoidsNative(byte var0, int var1, long var2, int var4, int var5, int var6, int[] var7);

    static {
        XRBackendNative.initIDs();
    }
}

