/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileLock;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import sun.nio.ch.AsynchronousFileChannelImpl;
import sun.nio.ch.CompletedFuture;
import sun.nio.ch.FileDispatcher;
import sun.nio.ch.FileDispatcherImpl;
import sun.nio.ch.FileLockImpl;
import sun.nio.ch.IOUtil;
import sun.nio.ch.Invoker;
import sun.nio.ch.NativeThreadSet;
import sun.nio.ch.PendingFuture;
import sun.nio.ch.ThreadPool;

public class SimpleAsynchronousFileChannelImpl
extends AsynchronousFileChannelImpl {
    private static final FileDispatcher nd = new FileDispatcherImpl();
    private final NativeThreadSet threads = new NativeThreadSet(2);

    SimpleAsynchronousFileChannelImpl(FileDescriptor fdObj, boolean reading, boolean writing, ExecutorService executor) {
        super(fdObj, reading, writing, executor);
    }

    public static AsynchronousFileChannel open(FileDescriptor fdo, boolean reading, boolean writing, ThreadPool pool) {
        ExecutorService executor = pool == null ? DefaultExecutorHolder.defaultExecutor : pool.executor();
        return new SimpleAsynchronousFileChannelImpl(fdo, reading, writing, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        FileDescriptor fileDescriptor = this.fdObj;
        synchronized (fileDescriptor) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        this.invalidateAllLocks();
        this.threads.signalAndWait();
        this.closeLock.writeLock().lock();
        this.closeLock.writeLock().unlock();
        nd.close(this.fdObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        int ti = this.threads.add();
        try {
            long l;
            long n = 0L;
            try {
                this.begin();
                while ((n = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                l = n;
                this.end(n >= 0L);
            }
            catch (Throwable throwable) {
                this.end(n >= 0L);
                throw throwable;
            }
            return l;
        }
        finally {
            this.threads.remove(ti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsynchronousFileChannel truncate(long size) throws IOException {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative size");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        int ti = this.threads.add();
        try {
            SimpleAsynchronousFileChannelImpl simpleAsynchronousFileChannelImpl;
            long n = 0L;
            try {
                this.begin();
                while ((n = nd.size(this.fdObj)) == -3L && this.isOpen()) {
                }
                if (size < n && this.isOpen()) {
                    while ((n = (long)nd.truncate(this.fdObj, size)) == -3L && this.isOpen()) {
                    }
                }
                simpleAsynchronousFileChannelImpl = this;
                this.end(n > 0L);
            }
            catch (Throwable throwable) {
                this.end(n > 0L);
                throw throwable;
            }
            return simpleAsynchronousFileChannelImpl;
        }
        finally {
            this.threads.remove(ti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void force(boolean metaData) throws IOException {
        int ti = this.threads.add();
        try {
            int n = 0;
            try {
                this.begin();
                while ((n = nd.force(this.fdObj, metaData)) == -3 && this.isOpen()) {
                }
                this.end(n >= 0);
            }
            catch (Throwable throwable) {
                this.end(n >= 0);
                throw throwable;
            }
        }
        finally {
            this.threads.remove(ti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <A> Future<FileLock> implLock(final long position, final long size, final boolean shared, final A attachment, final CompletionHandler<FileLock, ? super A> handler) {
        if (shared && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writing) {
            throw new NonWritableChannelException();
        }
        final FileLockImpl fli = this.addToFileLockTable(position, size, shared);
        if (fli == null) {
            ClosedChannelException exc = new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withFailure(exc);
            }
            Invoker.invokeIndirectly(handler, attachment, null, exc, this.executor);
            return null;
        }
        final PendingFuture result = handler == null ? new PendingFuture(this) : null;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Throwable exc = null;
                int ti = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    try {
                        int n;
                        SimpleAsynchronousFileChannelImpl.this.begin();
                        while ((n = nd.lock(SimpleAsynchronousFileChannelImpl.this.fdObj, true, position, size, shared)) == 2 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        }
                        if (n != 0 || !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                            throw new AsynchronousCloseException();
                        }
                    }
                    catch (IOException x2) {
                        AsynchronousCloseException x2;
                        SimpleAsynchronousFileChannelImpl.this.removeFromFileLockTable(fli);
                        if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                            x2 = new AsynchronousCloseException();
                        }
                        exc = x2;
                    }
                    finally {
                        SimpleAsynchronousFileChannelImpl.this.end();
                    }
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(ti);
                }
                if (handler == null) {
                    result.setResult(fli, exc);
                } else {
                    Invoker.invokeUnchecked(handler, attachment, fli, exc);
                }
            }
        };
        boolean executed = false;
        try {
            this.executor.execute(task);
            executed = true;
        }
        finally {
            if (!executed) {
                this.removeFromFileLockTable(fli);
            }
        }
        return result;
    }

    @Override
    public FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (shared && !this.reading) {
            throw new NonReadableChannelException();
        }
        if (!shared && !this.writing) {
            throw new NonWritableChannelException();
        }
        FileLockImpl fli = this.addToFileLockTable(position, size, shared);
        if (fli == null) {
            throw new ClosedChannelException();
        }
        int ti = this.threads.add();
        boolean gotLock = false;
        try {
            int n;
            this.begin();
            while ((n = nd.lock(this.fdObj, false, position, size, shared)) == 2 && this.isOpen()) {
            }
            if (n == 0 && this.isOpen()) {
                gotLock = true;
                FileLockImpl fileLockImpl = fli;
                return fileLockImpl;
            }
            if (n == -1) {
                FileLock fileLock = null;
                return fileLock;
            }
            if (n == 2) {
                throw new AsynchronousCloseException();
            }
            throw new AssertionError();
        }
        finally {
            if (!gotLock) {
                this.removeFromFileLockTable(fli);
            }
            this.end();
            this.threads.remove(ti);
        }
    }

    @Override
    protected void implRelease(FileLockImpl fli) throws IOException {
        nd.release(this.fdObj, fli.position(), fli.size());
    }

    @Override
    <A> Future<Integer> implRead(final ByteBuffer dst, final long position, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.reading) {
            throw new NonReadableChannelException();
        }
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (!this.isOpen() || dst.remaining() == 0) {
            ClosedChannelException exc;
            ClosedChannelException closedChannelException = exc = this.isOpen() ? null : new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withResult(0, exc);
            }
            Invoker.invokeIndirectly(handler, attachment, 0, exc, this.executor);
            return null;
        }
        final PendingFuture result = handler == null ? new PendingFuture(this) : null;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n = 0;
                Throwable exc = null;
                int ti = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n = IOUtil.read(SimpleAsynchronousFileChannelImpl.this.fdObj, dst, position, nd)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                }
                catch (IOException x2) {
                    AsynchronousCloseException x2;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        x2 = new AsynchronousCloseException();
                    }
                    exc = x2;
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(ti);
                }
                if (handler == null) {
                    result.setResult(n, exc);
                } else {
                    Invoker.invokeUnchecked(handler, attachment, n, exc);
                }
            }
        };
        this.executor.execute(task);
        return result;
    }

    @Override
    <A> Future<Integer> implWrite(final ByteBuffer src, final long position, final A attachment, final CompletionHandler<Integer, ? super A> handler) {
        if (position < 0L) {
            throw new IllegalArgumentException("Negative position");
        }
        if (!this.writing) {
            throw new NonWritableChannelException();
        }
        if (!this.isOpen() || src.remaining() == 0) {
            ClosedChannelException exc;
            ClosedChannelException closedChannelException = exc = this.isOpen() ? null : new ClosedChannelException();
            if (handler == null) {
                return CompletedFuture.withResult(0, exc);
            }
            Invoker.invokeIndirectly(handler, attachment, 0, exc, this.executor);
            return null;
        }
        final PendingFuture result = handler == null ? new PendingFuture(this) : null;
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int n = 0;
                Throwable exc = null;
                int ti = SimpleAsynchronousFileChannelImpl.this.threads.add();
                try {
                    SimpleAsynchronousFileChannelImpl.this.begin();
                    while ((n = IOUtil.write(SimpleAsynchronousFileChannelImpl.this.fdObj, src, position, nd)) == -3 && SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                    }
                    if (n < 0 && !SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        throw new AsynchronousCloseException();
                    }
                }
                catch (IOException x2) {
                    AsynchronousCloseException x2;
                    if (!SimpleAsynchronousFileChannelImpl.this.isOpen()) {
                        x2 = new AsynchronousCloseException();
                    }
                    exc = x2;
                }
                finally {
                    SimpleAsynchronousFileChannelImpl.this.end();
                    SimpleAsynchronousFileChannelImpl.this.threads.remove(ti);
                }
                if (handler == null) {
                    result.setResult(n, exc);
                } else {
                    Invoker.invokeUnchecked(handler, attachment, n, exc);
                }
            }
        };
        this.executor.execute(task);
        return result;
    }

    private static class DefaultExecutorHolder {
        static final ExecutorService defaultExecutor = ThreadPool.createDefault().executor();

        private DefaultExecutorHolder() {
        }
    }
}

