/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KerberosTime {
    private final long kerberosTime;
    private final int microSeconds;
    private static long initMilli = System.currentTimeMillis();
    private static long initMicro = System.nanoTime() / 1000L;
    private static boolean DEBUG = Krb5.DEBUG;

    private KerberosTime(long time, int micro) {
        this.kerberosTime = time;
        this.microSeconds = micro;
    }

    public KerberosTime(long time) {
        this(time, 0);
    }

    public KerberosTime(String time) throws Asn1Exception {
        this(KerberosTime.toKerberosTime(time), 0);
    }

    private static long toKerberosTime(String time) throws Asn1Exception {
        if (time.length() != 15) {
            throw new Asn1Exception(900);
        }
        if (time.charAt(14) != 'Z') {
            throw new Asn1Exception(900);
        }
        int year = Integer.parseInt(time.substring(0, 4));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(year, Integer.parseInt(time.substring(4, 6)) - 1, Integer.parseInt(time.substring(6, 8)), Integer.parseInt(time.substring(8, 10)), Integer.parseInt(time.substring(10, 12)), Integer.parseInt(time.substring(12, 14)));
        return calendar.getTimeInMillis();
    }

    public KerberosTime(Date time) {
        this(time.getTime(), 0);
    }

    public KerberosTime(Instant instant) {
        this(instant.getEpochSecond() * 1000L + (long)instant.getNano() / 1000000L, instant.getNano() / 1000 % 1000);
    }

    public static KerberosTime now() {
        long newMilli = System.currentTimeMillis();
        long newMicro = System.nanoTime() / 1000L;
        long microElapsed = newMicro - initMicro;
        long calcMilli = initMilli + microElapsed / 1000L;
        if (calcMilli - newMilli > 100L || newMilli - calcMilli > 100L) {
            if (DEBUG) {
                System.out.println("System time adjusted");
            }
            initMilli = newMilli;
            initMicro = newMicro;
            return new KerberosTime(newMilli, 0);
        }
        return new KerberosTime(calcMilli, (int)(microElapsed % 1000L));
    }

    public String toGeneralizedTimeString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.setTimeInMillis(this.kerberosTime);
        return String.format("%04d%02d%02d%02d%02d%02dZ", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream out = new DerOutputStream();
        out.putGeneralizedTime(this.toDate());
        return out.toByteArray();
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public Date toDate() {
        return new Date(this.kerberosTime);
    }

    public int getMicroSeconds() {
        Long temp_long = new Long(this.kerberosTime % 1000L * 1000L);
        return temp_long.intValue() + this.microSeconds;
    }

    public KerberosTime withMicroSeconds(int usec) {
        return new KerberosTime(this.kerberosTime - this.kerberosTime % 1000L + (long)usec / 1000L, usec % 1000);
    }

    private boolean inClockSkew(int clockSkew) {
        return Math.abs(this.kerberosTime - System.currentTimeMillis()) <= (long)clockSkew * 1000L;
    }

    public boolean inClockSkew() {
        return this.inClockSkew(KerberosTime.getDefaultSkew());
    }

    public boolean greaterThanWRTClockSkew(KerberosTime time, int clockSkew) {
        return this.kerberosTime - time.kerberosTime > (long)clockSkew * 1000L;
    }

    public boolean greaterThanWRTClockSkew(KerberosTime time) {
        return this.greaterThanWRTClockSkew(time, KerberosTime.getDefaultSkew());
    }

    public boolean greaterThan(KerberosTime time) {
        return this.kerberosTime > time.kerberosTime || this.kerberosTime == time.kerberosTime && this.microSeconds > time.microSeconds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KerberosTime)) {
            return false;
        }
        return this.kerberosTime == ((KerberosTime)obj).kerberosTime && this.microSeconds == ((KerberosTime)obj).microSeconds;
    }

    public int hashCode() {
        int result = 629 + (int)(this.kerberosTime ^ this.kerberosTime >>> 32);
        return result * 17 + this.microSeconds;
    }

    public boolean isZero() {
        return this.kerberosTime == 0L && this.microSeconds == 0;
    }

    public int getSeconds() {
        Long temp_long = new Long(this.kerberosTime / 1000L);
        return temp_long.intValue();
    }

    public static KerberosTime parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        Date temp = subDer.getGeneralizedTime();
        return new KerberosTime(temp.getTime(), 0);
    }

    public static int getDefaultSkew() {
        int tdiff;
        block3: {
            tdiff = 300;
            try {
                tdiff = Config.getInstance().getIntValue("libdefaults", "clockskew");
                if (tdiff == Integer.MIN_VALUE) {
                    tdiff = 300;
                }
            }
            catch (KrbException e) {
                if (!DEBUG) break block3;
                System.out.println("Exception in getting clockskew from Configuration using default value " + e.getMessage());
            }
        }
        return tdiff;
    }

    public String toString() {
        return this.toGeneralizedTimeString();
    }
}

