@assets
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js" async data-navigate-track></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
@endassets
<div class="container mx-auto mt-3 py-2 px-4">

    {{-- <style>
        .swiper-button-next::after {
            font-size: 18px;
            font-weight: bold;
        }

        .swiper-button-prev::after {
            font-size: 18px;
            font-weight: bold;
        }
    </style> --}}
    <div role="region" class="relative " aria-labelledby="banner-title">
        <h1 id="banner-title" class="text-2xl md:text-3xl font-bold text-gray-800 sr-only">{{ __('messages.t_discover_chat_buy',
                    ['siteName' => $generalSettings->site_name]) }}</h1>
        <div role="group" wire:ignore
            class="swiper mySwiper  shadow-sm ring-1 ring-gray-950/5 dark:ring-white/10  classic:ring-black rounded-lg transition-all !h-36   sm:!h-64 md:!h-72 lg:!h-96">
            <!-- Swiper Slides -->
            <div class="swiper-wrapper ">
                @foreach ($banners as $key=>$banner)
                <div wire:key='banner-{{$banner->id}}' class="swiper-slide  rounded-lg  text-center h-full w-full"
                    @if ($banner->banner_type === 'link')
                    wire:click='updateClickCount({{$banner->id}})'
                    @endif
                    data-banner-id="{{ $banner->id }}">
                    <img src="{{Storage::url($banner->image)}}" id="banner-{{$banner->id}}"
                        class="absolute inset-0  bg-opacity-10 cursor-pointer w-full h-full bg-center  object-cover rounded-lg"
                        alt="{{$banner->alternative_text??__('messages.t_alt_banner')}}">

                    @if ($banner->banner_type === 'html')
                        {!! $banner->html !!}
                    @endif
                </div>
                @endforeach
            </div>

            <!-- Navigation Buttons (classic)-->
            @if (getCurrentTheme() != 'modern')
            <button type="button" x-data x-tooltip="{
            content: '{{__('messages.t_tooltip_next')}}',
            theme: $store.theme,
            }" class="swiper-button-next banner-carousel-side-buttons !hidden md:!block ">
            <span class="sr-only">{{ __('messages.t_aria_label_next_item') }}</span>
            </button>

            <button type="button" aria-label="{{ __('messages.t_aria_label_previous_item') }}" x-data x-tooltip="{
            content: '{{__('messages.t_tooltip_previous')}}',
            theme: $store.theme,
            }" class="swiper-button-prev banner-carousel-side-buttons !hidden md:!block ">
            <span class="sr-only">{{ __('messages.t_aria_label_previous_item') }}</span>
            </button>
            @endif

            <!-- Autoplay Buttons-->
            @if ($this->bannerSettings->enable_autoplay)
            <button x-cloak id="autoplayButton"
                class="absolute right-3 bottom-3 z-10 text-black {{ getCurrentTheme() == 'modern' ? 'bg-primary-600 text-white' : 'bg-white ' }} bg-opacity-60 focus:bg-opacity-95 rounded cursor-pointer apply-themes w-6 h-6 font-bold"
                x-data="{ isPlaying: {{ $this->bannerSettings->enable_autoplay ? 'true' : 'false' }} }"
                @click="isPlaying = !isPlaying; updateautoPlayStatus()"
                x-tooltip="{
            content: isPlaying ? '{{ __('messages.t_tooltip_pause') }}' : '{{ __('messages.t_tooltip_play') }}',
            theme: $store.theme,
            }">
            <template x-if="isPlaying">
                <div>
                    <span class="sr-only">{{('messages.t_aria_label_pause')}}</span>
                    <x-heroicon-o-pause />
                </div>
            </template>
            <template x-if="!isPlaying">
                <div>
                    <span class="sr-only">{{('messages.t_aria_label_play')}}</span>
                    <x-heroicon-o-play />
                </div>
            </template>
            </button>
            @endif
        </div>
        <!-- Navigation Buttons (classic)-->
        @if (getCurrentTheme() == 'modern')
        <button type="button" aria-label="{{ __('messages.t_aria_label_next_item') }}" x-data x-tooltip="{
        content: '{{__('messages.t_tooltip_next')}}',
        theme: $store.theme,
        }" class="swiper-button-next-modern  apply-themes bg-primary-600  rounded-full !hidden md:!block z-10">
            <x-heroicon-o-chevron-right class="h-7 w-7 text-white p-1" aria-hidden="true" />

        </button>

        <button type="button" aria-label="{{ __('messages.t_aria_label_previous_item') }}" x-data x-tooltip="{
        content: '{{__('messages.t_tooltip_previous')}}',
        theme: $store.theme,
        }" class="swiper-button-prev-modern  apply-themes bg-primary-600  rounded-full !hidden md:!block z-10">
            <x-heroicon-o-chevron-left class="h-7 w-7 text-white p-1" aria-hidden="true" />
        </button>
        @endif
    </div>

    <div wire:ignore
        class="mx-auto w-fit mt-2  h-[6%] !max-w-[90%]  {{$this->bannerSettings->enable_pagination_count?'with-pagination-count':'without-pagination-count'}} ">
        <div class="swiper-pagination-custom !flex  rounded transition-all !overflow-x-auto  p-1"  data-swiper-pagination="true" role="presentation">
        </div>
    </div>

    <script data-navigate-once>
        //Define bannerSettings
        const bannerSettings = {
            autoplay: {{ $this->bannerSettings->enable_autoplay ? 'true' : 'false' }},
            autoplayInterval: {{ $this->bannerSettings->autoplay_interval ?? 1500 }},
            enablePaginationCount:{{ $this->bannerSettings->enable_pagination_count ? 'true' : 'false' }}
        };

        var stopButton=document.getElementById('stopAutoPlay');
        var startButton=document.getElementById('startAutoPlay');

        //Define Swiper options
        const swiperOptions={
            loop: true,
            pagination: {
                el: ".swiper-pagination-custom",
                clickable: true,
            },
            navigation: {
                nextEl: "{{getCurrentTheme() == 'modern'? '.swiper-button-next-modern' : '.swiper-button-next'}}",
                prevEl: "{{getCurrentTheme() == 'modern'? '.swiper-button-prev-modern' : '.swiper-button-prev'}}",
            },
            lazy: {
            loadPrevNext: true, // pre-loads the next image to avoid showing a loading placeholder if possible
            loadPrevNextAmount: 2 //or, if you wish, preload the next 2 images
          },
        };

        //Define autoplay options based on the condition
        if(bannerSettings.autoplay){
            swiperOptions.autoplay={
                delay: bannerSettings.autoplayInterval,
                disableOnInteraction: false
            }
        }

        if(bannerSettings.enablePaginationCount){
            swiperOptions.pagination.renderBullet=function (index, className) {
                const itemCount=document.querySelectorAll('.swiper-slide').length;
                const id="banner-"+(index+1);
                const image=document.getElementById(id);
                const alt = image && image.alt ? image.alt.replace(/'/g, "\\'") : null;
                const bannerText=`{{__('messages.t_tooltip_banner')}} ${(index+1)}`;
                const tooltip=`x-tooltip="{
                    content: '${alt ? alt : bannerText }',
                    theme: $store.theme,
                }"`;
                const button='<button '+ tooltip +' type="button" class="' + className + '">' + (index + 1)+'/' +itemCount+"</button>";

                return button;
            }
        }
        var swiper;
        document.addEventListener('livewire:navigated', () => {
         swiper = new Swiper(".mySwiper", swiperOptions);
            if(swiper){
                const autoPlayStatus=swiper.autoplay.running;
                waitForElement("#stopAutoPlay", () => {
                    updateautoPlayButtons(startButton,stopButton,autoPlayStatus);
                });
            }
        })
        function updateautoPlayButtons(startButton,stopButton,autoPlayStatus){
            if(autoPlayStatus){
                startButton.style.display='none';
                stopButton.style.display='block';
            }else{
                startButton.style.display='block';
                stopButton.style.display='none';
            }
        }
        function updateautoPlayStatus(){
            const autoPlayStatus=!swiper.autoplay.running;
            autoPlayStatus?swiper.autoplay.start():swiper.autoplay.stop();
            updateautoPlayButtons(startButton,stopButton,autoPlayStatus);
        }
         // Intersection Observer to track when a banner is visible
         const options = {
                root: null,
                rootMargin: '0px',
                threshold: 0.5
            };

            const observer = new IntersectionObserver((entries, observer) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const bannerId = entry.target.getAttribute('data-banner-id');
                        Livewire.dispatch('update-banner-view', {bannerId:bannerId});
                    }
                });
            }, options);
        document.addEventListener('livewire:initialized', () => {

        document.querySelectorAll('.swiper-slide').forEach(slide => {
                observer.observe(slide);
            });
        });
        function waitForElement(selector, callback) {
            const intervalId = setInterval(() => {
              if (document.querySelector(selector)) {
                clearInterval(intervalId);
                callback();
              }
            }, 500);
        }
    </script>
</div>
