<?php

namespace Adfox\Appearance\Filament\Resources\BannerResource\Pages;

use Adfox\Appearance\Filament\Resources\BannerResource;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\DailyBannerClicksChart;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\DailyBannerViewsChart;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\MonthlyBannerClicksChart;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\MonthlyBannerViewsChart;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\YearlyBannerClicksChart;
use Adfox\Appearance\Filament\Resources\BannerResource\Widgets\YearlyBannerViewsChart;
use Filament\Resources\Pages\Page;
use Filament\Widgets\StatsOverviewWidget\Stat;

class ReportBanner extends Page
{
    protected static string $resource = BannerResource::class;
    public $record;
    protected static string $view = 'appearance::filament.resources.banner-resource.pages.report-banner';

    public function getTitle(): string
    {
        return __('messages.t_ap_manage_banner_analytics');
    }
    protected function getHeaderWidgets(): array
    {
        return [
            DailyBannerViewsChart::make(['bannerId'=>$this->record]),
            DailyBannerClicksChart::make(['bannerId'=>$this->record]),
            MonthlyBannerClicksChart::make(['bannerId'=>$this->record]),
            MonthlyBannerViewsChart::make(['bannerId'=>$this->record]),
            YearlyBannerViewsChart::make(['bannerId'=>$this->record]),
            YearlyBannerClicksChart::make(['bannerId'=>$this->record]),
        ];
    }
}
