<?php

namespace Adfox\Appearance\Traits;

use App\Models\City;
use App\Models\Country;
use App\Models\State;
use Filament\Forms\Components\Select;
use Filament\Forms\Get;
use Filament\Forms\Set;

trait LocationFormFields
{
    public static function getLocationFormFields(): array
    {
        return [
            Select::make('country_id')
                ->searchable()
                ->label(__('messages.t_ap_country'))
                ->options(Country::orderBy('name')->pluck('name', 'id')->toArray())
                ->live()
                ->afterStateUpdated(function (Set $set) {
                    $set('state_id', null);
                    $set('city_id', null);
                }),

            Select::make('state_id')
                ->searchable()
                ->label(__('messages.t_ap_state'))
                ->options(function (Get $get) {
                    $countryId = $get('country_id');
                    if (!$countryId) {
                        return [];
                    }
                    return State::where('country_id', $countryId)->orderBy('name')->pluck('name', 'id')->toArray();
                })
                ->live()
                ->hidden(fn(Get $get): bool => !$get('country_id'))
                ->afterStateUpdated(fn(callable $set) => $set('city_id', null)),

            Select::make('city_id')
                ->searchable()
                ->label(__('messages.t_ap_city'))
                ->options(function (Get $get) {
                    $stateId = $get('state_id');
                    if (!$stateId) {
                        return [];
                    }
                    return City::where('state_id', $stateId)->orderBy('name')->pluck('name', 'id')->toArray();
                })
                ->hidden(fn(Get $get): bool => !$get('state_id'))

        ];
    }
}
