<div class="space-y-4" x-data="{
    search: '',
    open: false
}">
    <div class="flex justify-between items-center gap-2">
        <div class="flex relative md:w-[30%]">
            <input wire:keydown.enter="$dispatch('update-ad-data')" wire:model="search" x-model="search"
                   type="text" x-on:input="open = search.length > 0"
                   class="md:min-w-full w-full  shadow-sm ring-1 ring-gray-950/10 border-none bg-white h-10 md:h-10 pr-10 pl-4 rounded-xl focus:outline-none placeholder-muted
                    focus-within:ring-2 dark:bg-white/5 focus-within:ring-primary-600 dark:ring-white/20 dark:focus-within:ring-primary-500 dark:placeholder:text-gray-500
                    classic:focus:ring-primary-600 classic:ring-black" name="search"
                   placeholder="{{ __('messages.t_feed_back_search') }}">
            <x-icon-close x-on:click="search = ''; open = false" role="button" aria-label="{{__('messages.t_aria_label_close_search')}}"
                          class="w-4 h-4 text-gray-400 dark:text-gray-500 absolute right-0 top-0 mt-[.8rem] mr-3 cursor-pointer classic:text-black"
                          x-show="search.length > 0" x-cloak />
            <!-- Search Icon button-->
            <button type="button" x-bind:disabled="!open" aria-label="{{__('messages.t_aria_label_search')}}"
            x-tooltip="{
                content: '{{ __('messages.t_tooltip_search') }}',
                theme: $store.theme,
            }"
                    class="disabled:text-gray-600 dark:text-gray-500 absolute right-0 top-0 mt-[.4rem] mr-2 text-white bg-primary-600 p-1 rounded-full disabled:bg-gray-200"
                    wire:click="$dispatch('update-ad-data')">
                <x-icon-search class="w-5 h-5 p-[1px]" />
            </button>
        </div>
        <div class="md:flex-grow-0 flex-grow !w-32">
            <x-filament::input.wrapper class="!w-32 ml-auto" >
                <x-filament::input.select wire:model.live="sortBy" id="sort-by" aria-label="{{__('messages.t_aria_label_sort_by')}}">
                    <option value="date_desc">{{__('messages.t_most_recent')}}</option>
                    <option value="date_asc">{{__('messages.t_oldest_first')}}</option>
                    <option value="rating_high">{{__('messages.t_highest_rating')}}</option>
                    <option value="rating_low">{{__('messages.t_lowest_rating')}}</option>
                </x-filament::input.select>
            </x-filament::input.wrapper>
        </div>
    </div>
    @if($feedbackDetails->isEmpty())
    <div class="bg-white dark:bg-gray-900 px-6 py-12 rounded-lg shadow ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black">
        <x-not-found description="{{ __('messages.t_no_feedback_found_for_this_seller') }}" />
    </div>

    @else
    @foreach ($feedbackDetails as $feedback)
    <div wire:key="feedback-{{$feedback->id}}" class="bg-white dark:bg-gray-900/20 p-4 rounded-lg shadow ring-1 ring-gray-950/10 dark:ring-white/10 classic:ring-black">
        <div class="flex items-center justify-between mb-2">
            <div class="lg:flex gap-2 grid grid-cols-1">
                <p class="font-semibold text-gray-800 dark:text-gray-200">{{__('messages.t_by')}}
                   <a href="{{ route('view-profile', ['slug' => $feedback->buyer->getSlugAttribute(), 'id' => $feedback->buyer->id]) }}"> {{ $feedback->buyer->name ?? __('messages.t_anonymous') }} </a>
                </p>
                <div class="flex items-center gap-x-1">
                    <x-star-rating :rating="$feedback->rating" :name="'list'" :id="$feedback->id" wire:key="star-rating-feedback-{{ $feedback->id }}" />
                </div>
            </div>
            <div class="lg:flex gap-2 grid grid-cols-1">
                <p class="font-semibold text-sm text-custom-600 dark:text-custom-400 group-hover/link:underline group-focus-visible/link:underline" style="--c-400:var(--primary-400);--c-600:var(--primary-600);">
                    {{ __('messages.t_'.$feedback->interaction) }}
                </p>
                <span class="text-sm text-gray-600 dark:text-gray-200">{{ $feedback->created_at->format('d/m/Y') }}</span>
            </div>
        </div>

        <p class="text-gray-700 dark:text-gray-200">{{ $feedback->detail }}</p>

        <div class="flex items-center justify-between mt-2">
            <div class="flex items-center gap-x-2">
                @if ($feedbackSettings->enable_likes)
                <button type="button" class="flex items-center dark:text-gray-200 text-gray-700 hover:text-gray-900 " wire:click="likeFeedback({{ $feedback->id }})">
                    {{__('messages.t_like_feedback')}}
                </button>
                @endif
                @if ($feedbackSettings->enable_replies)
                {{ ($this->replyAction)(['feedbackId' => $feedback->id]) }}
                @endif
            </div>
            @if ($feedbackSettings->enable_likes)
            <span role="status" class="text-green-500 flex items-center">
                <x-heroicon-o-hand-thumb-up class="w-6 h-6" />
                <span aria-label="{{__('messages.t_aria_label_no_of_likes')}}">{{ $feedback->likes->count() }}</span>
            </span>
            @endif
        </div>

        {{-- Replies List --}}
        <div class="mt-4 space-y-3 pl-4">
            @foreach ($feedback->replies as $reply)
            <div wire:key="reply-{{$reply->id}}" class="bg-gray-50 dark:bg-gray-800 p-3 rounded-lg">
                <div class="flex justify-between items-center">
                    <span class="font-medium text-gray-900 dark:text-gray-100">{{ $reply->user->name }}</span>
                    <span class="text-xs text-gray-700 dark:text-gray-300">{{ $reply->created_at->format('d/m/Y') }}</span>
                </div>
                <p class="text-gray-700 dark:text-gray-200">{{ $reply->reply }}</p>
            </div>
            @endforeach
        </div>
    </div>
    @endforeach
    @endif
    <x-filament-actions::modals />
</div>
