<?php

namespace Adfox\Feedback\Filament\Resources;

use Adfox\Feedback\Filament\Resources\FeedbackResource\Pages;
use App\Filament\Clusters\FeedbackManagement;
use App\Models\Feedback;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Actions\Action;
use Filament\Tables\Columns\SelectColumn;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Str;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;


class FeedbackResource extends Resource implements HasShieldPermissions
{
    protected static ?string $model = Feedback::class;

    protected static ?string $cluster = FeedbackManagement::class;

    protected static ?string $navigationIcon = 'heroicon-o-star';

    public static function getModelLabel(): string
    {
        return __('messages.t_ap_seller_reviews');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_all_reviews');
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view_any',
            'delete_any',
            'view_detail'
        ];
    }


    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_feedback');
    }

    public static function canDelete($record): bool
    {
        return userHasPermission('delete_feedback');
    }

    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_feedback');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                //
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->defaultSort('created_at', 'desc')
            ->modifyQueryUsing(fn(Builder $query) => $query)
            ->columns([
                TextColumn::make('buyer.name')
                    ->label(__('messages.t_ap_buyer'))
                    ->searchable()
                    ->sortable(),

                TextColumn::make('seller.name')
                    ->label(__('messages.t_ap_seller'))
                    ->searchable()
                    ->sortable(),

                TextColumn::make('experience')
                    ->label(__('messages.t_ap_experience'))
                    ->searchable()
                    ->badge()
                    ->colors([
                        'success' => 'positive',
                        'warning' => 'neutral',
                        'danger' => 'negative',
                    ]),

                TextColumn::make('interaction')
                    ->label(__('messages.t_ap_interaction'))
                    ->searchable()
                    ->formatStateUsing(fn(string $state): string => Str::title(str_replace('_', ' ', $state)))
                    ->badge(),

                // TODO: Un-command in future
                // SelectColumn::make('interaction')
                //     ->disabled()
                //     ->options([
                //         'successful_purchase' => __('messages.t_ap_successful_purchase'),
                //         'deal_failed' => __('messages.t_ap_deal_failed'),
                //         'didnt_come_to_deal' => __('messages.t_ap_didnt_come_to_deal'),
                //         'cant_reach_seller' => __('messages.t_ap_cant_reach_seller'),
                //     ])
                //     ->selectablePlaceholder(false),

                TextColumn::make('detail')
                    ->label(__('messages.t_ap_detail'))
                    ->limit(50)
                    ->searchable(),

                TextColumn::make('created_at')
                    ->label(__('messages.t_ap_posted_on'))
                    ->date()
                    ->sortable(),

                TextColumn::make('likes_count')
                    ->counts('likes')
                    ->label(__('messages.t_ap_likes'))
                    ->sortable(),

                TextColumn::make('replies_count')
                    ->counts('replies')
                    ->label(__('messages.t_ap_replies'))
                    ->sortable(),

            ])
            ->filters([
                //
            ])
            ->actions([
                Action::make('view')
                    ->icon('heroicon-o-eye')
                    ->label(__('messages.t_ap_view_details'))
                    ->visible(fn () => userHasPermission('view_detail_feedback'))
                    ->url(fn(Feedback $record): string => route('feedback', [
                        'id' => $record->seller_id
                    ]))
                    ->openUrlInNewTab(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListFeedback::route('/'),
            // 'create' => Pages\CreateFeedback::route('/create'),
            // 'edit' => Pages\EditFeedback::route('/{record}/edit'),
        ];
    }
}
