<?php

namespace Adfox\LiveChat;

use Filament\Panel;
use Filament\Contracts\Plugin;

class LiveChatPlugin implements Plugin
{
    public function getId(): string
    {
        return 'live-chat';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\LiveChat\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\LiveChat\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
