<div>
    <style>
        .iti{
            width: 100%;
        }


    </style>
    @assets
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
    @endassets

    <!-- Header -->
    <div class="flex justify-between items-center mb-6">
        <x-brand />

        <a href="/" class="hover:underline text-lg flex items-center gap-x-2" wire:navigate>
            <span>
                <x-heroicon-o-arrow-left class="w-5 h-5 cursor-pointer" />
            </span>
            {{ __('messages.t_back_to_home') }}
        </a>
    </div>


    <!-- Login Title -->
    <h1 class="text-2xl md:text-3xl mt-12 mb-8 font-semibold">{{ __('messages.t_login') }}</h1>


    <form id="form" class="space-y-6">
        @csrf
        <div class="space-y-1" >
            <x-label for="mobile" :value="__('messages.t_mobile')" />
            <div class="mt-1">
                <x-filament::input.wrapper wire:ignore>

                    <x-filament::input
                            id="phone"
                            type="tel"
                             name="phone"
                            autofocus
                            class="w-full"
                    />
                </x-filament::input.wrapper>

                <div class="text-red-500">@error('phoneNumber') {{ $message }} @enderror</div>


            <div class="alert alert-info" style="display: none;"></div>

            </div>
        </div>
<!-- feedback message -->
@if (session('status') == 'otp-failed')
<div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">
    {{ __('
    We apologize for the inconvenience you are experiencing with our OTP (One-Time Password) delivery.') }}
</div>
@else
<div class="mb-4 font-medium text-sm text-red-600 dark:text-red-400">
    {{ session('status') }}
</div>
@endif

        <div>
            <x-button.secondary  size="lg" class="block w-full dark:bg-primary-600 ">
                {{ __('messages.t_send_otp_action') }}
            </x-button.secondary>
        </div>

        <div>
            <p class="text-sm text-center text-slate-600 dark:text-gray-200">
                {{ __('messages.t_already_have_account') }}
                <a href="{{ route('login') }}" class="font-medium  underline">
                    {{ __('messages.t_login') }}
                </a>
            </p>
        </div>

    </form>
    @script
   <script>

        const phoneInputField = document.querySelector("#phone");
        function getIp(callback) {
     fetch('https://ipinfo.io/json?token=af99e3dad456d9', { headers: { 'Accept': 'application/json' }})
       .then((resp) => resp.json())
       .catch(() => {
         return {
           country: 'us',
         };
       })
       .then((resp) => callback(resp.country));
    }
        const phoneInput = window.intlTelInput(phoneInputField, {
            initialCountry: "{{$generalSettings->default_mobile_country??'us'}}",
     geoIpLookup: getIp,
          utilsScript:
            "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js",
        });
        const info = document.querySelector(".alert-info");

        document.getElementById ("form").addEventListener ("submit", process, false);
    function process(event) {
     event.preventDefault();

     const phoneNumber = phoneInput.getNumber();

    @this.dispatch('sendOtp', { number: phoneNumber });

    }
    </script>
    @endscript
</div>
