<?php

namespace Adfox\LoginOtp;

use Filament\Panel;
use Filament\Contracts\Plugin;

class LoginOtpPlugin implements Plugin
{
    public function getId(): string
    {
        return 'login-otp';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\LoginOtp\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\LoginOtp\\Filament\\Pages'
                );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
