<?php

namespace Adfox\Mollie\Filament\Pages;

use App\Settings\MollieSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use Illuminate\Support\Facades\Config;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class ManageMollie extends SettingsPage
{
    use HasPageShield;


    protected static ?string $slug = 'manage-mollie-settings';

    protected static string $settings = MollieSettings::class;

    protected static ?int $navigationSort = 30;

    public static function getNavigationBadgeTooltip(): ?string
    {
        return 'Mollie Payment Module (Addon) - Process payments through Mollie gateway, popular in Europe. Requires separate purchase.';
    }

    public static function getNavigationBadge(): ?string
    {
        $isDemo = Config::get('app.demo');
        return  $isDemo  ? 'Addon' : '';
    }

    public static function getNavigationBadgeColor(): ?string
    {
        return 'danger';
    }


    public static function canAccess(): bool
    {
        return userHasPermission('page_ManageMollie');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_mollie_settings');
    }

    public static function getNavigationGroup(): string
    {
        return __('messages.t_ap_payment_gateways');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_mollie_settings');
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(MollieSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the MollieSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }

    public function form(Form $form): Form
    {
        $currenciesConfig = config('money.currencies');
        $currencyCodes = array_keys($currenciesConfig);
        $isDemo = Config::get('app.demo');

        return $form
            ->schema([
                TextInput::make('name')
                    ->label(__('messages.t_ap_mollie_name'))
                    ->required()
                    ->helperText(__('messages.t_ap_mollie_name_helper')),

                Toggle::make('status')
                    ->label(__('messages.t_ap_enable_mollie'))
                    ->helperText(__('messages.t_ap_enable_mollie_helper')),

                Select::make('currency')
                    ->label(__('messages.t_ap_default_currency'))
                    ->options(array_combine($currencyCodes, $currencyCodes))
                    ->required()
                    ->helperText(__('messages.t_ap_default_currency_helper')),

                $isDemo ?
                TextInput::make('api_key')
                    ->label(__('messages.t_ap_mollie_api_key'))
                    ->placeholder('*****')
                    ->disabled()
                    ->helperText(__('messages.t_ap_mollie_api_key_demo_helper')) :
                TextInput::make('api_key')
                    ->label(__('messages.t_ap_mollie_api_key'))
                    ->required()
                    ->helperText(__('messages.t_ap_mollie_api_key_helper')),

                TextInput::make('exchange_rate')
                    ->label(__('messages.t_ap_exchange_rate'))
                    ->numeric()
                    ->required()
                    ->helperText(__('messages.t_ap_exchange_rate_helper'))

                // $isDemo ?
                // TextInput::make('webhook_url')
                //     ->label('Mollie Webhook URL')
                //     ->placeholder('*****')
                //     ->disabled()
                //     ->helperText('Your Mollie Webhook URL (hidden in demo mode).') :
                // TextInput::make('webhook_url')
                //     ->label('Mollie Webhook URL')
                //     ->required()
                //     ->helperText('Your Mollie Webhook URL.'),

                // $isDemo ?
                // TextInput::make('redirect_url')
                //     ->label('Mollie Redirect URL')
                //     ->placeholder('*****')
                //     ->disabled()
                //     ->helperText('Your Mollie Redirect URL (hidden in demo mode).') :
                // TextInput::make('redirect_url')
                //     ->label('Mollie Redirect URL')
                //     ->required()
                //     ->helperText('Your Mollie Redirect URL.'),
            ])
            ->columns(2);
    }
}
