<?php

namespace Adfox\Mollie;

use Filament\Panel;
use Filament\Contracts\Plugin;

class MolliePlugin implements Plugin
{
    public function getId(): string
    {
        return 'mollie';
    }

    public function register(Panel $panel): void
    {
        if ($panel->getId() == 'admin') {
            $panel->discoverResources(
                in: __DIR__ . '/Filament/Resources',
                for: 'Adfox\\Mollie\\Filament\\Resources'
            )->discoverPages(
                    in: __DIR__ . '/Filament/Pages',
                    for: 'Adfox\\Mollie\\Filament\\Pages'
            );
        }
    }

    public function boot(Panel $panel): void
    {
    }
}
