@props(['item', 'selectedItems', 'title'])

@php
    use Carbon\Carbon;

    $today = Carbon::today();
    $isOfferActive = $item->offer_enabled && $item->offer_price && $item->offer_start <= $today && $item->offer_end >= $today;

    $offerPercentage = null;
    if ($isOfferActive && $item->price > $item->offer_price) {
        $discount = $item->price - $item->offer_price;
        $offerPercentage = round(($discount / $item->price) * 100);
    }
@endphp

<button type="button" wire:click="toggleSelection({{ $item->id }})" aria-pressed="{{ in_array($item->id, $selectedItems) ? 'true' : 'false' }}"
    @class([
           'block w-full border font-medium border-gray-200 dark:border-white/10 classic:border-black dark:bg-gray-950 bg-white rounded-xl cursor-pointer transition-all md:hover:transform md:hover:-translate-y-1 relative',
           'border-b-4 border-r-4' => in_array($item->id, $selectedItems),
    ])
>
    <div class="px-4 py-4 flex  items-center justify-between">
        <div class="flex gap-x-2 items-center">
            @if(in_array($item->id, $selectedItems))
                <x-heroicon-s-check-circle class="w-8 h-8 text-success-600" />
            @else
                <div  class="w-8 h-8 flex items-center justify-center">
                   <span class="w-6 h-6 text-gray-900 rounded-full border border-black dark:border-white block"></span>
                </div>
            @endif
            <div>{{ $title }}</div>
        </div>
        <div>
            @if($offerPercentage)
                <div class="mt-3 flex gap-x-1">
                    <div>
                        <span class="text-red-600">{{ formatPriceWithCurrency($item->offer_price) }}</span>
                        <span class="text-xs text-white px-2 py-1 absolute top-0 right-0 rounded-tr-xl bg-green-800">({{ $offerPercentage }}% {{ __('messages.t_off') }})</span>
                    </div>
                    <span class="line-through">{{ formatPriceWithCurrency($item->price) }}</span>
                </div>
            @else
                <span>{{ formatPriceWithCurrency($item->price) }}</span>
            @endif
        </div>

    </div>
</button>
