<?php

namespace Adfox\Packages\Filament\Pages;

use App\Filament\Clusters\PackageManagement;
use App\Settings\PackageSettings;
use App\Settings\SubscriptionSettings;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Form;
use Filament\Pages\SettingsPage;
use BezhanSalleh\FilamentShield\Traits\HasPageShield;

class PackageSetup extends SettingsPage
{
    use HasPageShield;

    protected static ?string $slug = 'manage-package-settings';
    protected static string $settings = PackageSettings::class;
    protected static ?int $navigationSort = 0;

    protected static ?string $navigationIcon = 'heroicon-o-cog-6-tooth';

    protected static ?string $cluster = PackageManagement::class;

    public static function canAccess(): bool
    {
        return userHasPermission('page_PackageSetup');
    }

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_package_configuration');
    }

    public function getTitle(): string
    {
        return __('messages.t_ap_package_settings');
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        $previousData = app(PackageSettings::class);
        $filtered = [];

        foreach ($data as $key => $item) {
            // Check if the property exists in the GeneralSettings class
            if (property_exists($previousData, $key)) {
                // Get the type of the property
                $propertyType = gettype($previousData->$key);

                // If the item is null and the property type is string, set it to an empty string
                if (is_null($item) && $propertyType === 'string') {
                    $filtered[$key] = '';
                    continue;
                }
            }
            // For other cases, just copy the item as is
            $filtered[$key] = $item;
        }
        return $filtered;
    }


     /**
     * After saving, disable Subscription settings if Packages are enabled.
     */
    public function afterSave()
    {
        $subscriptionSettings = app(SubscriptionSettings::class);

        if ($this->data['status'] ?? false) {
            $subscriptionSettings->status = false;
            $subscriptionSettings->combine_subscriptions_and_orders = false;
            $subscriptionSettings->save();
        }
    }

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Toggle::make('status')
                ->label(__('messages.t_ap_enable_packages'))
                ->helperText(__('messages.t_ap_enable_packages_helper')),

            TextInput::make('free_ad_limit')
                ->numeric()
                ->minValue(1)
                ->label(__('messages.t_ap_free_ad_limit'))
                ->placeholder(__('messages.t_ap_free_ad_limit_placeholder'))
                ->required(),

            Select::make('ad_renewal_period')
                ->label(__('messages.t_ap_ad_renewal_period'))
                ->options([
                    'month' => __('messages.t_ap_monthly'),
                    'year' => __('messages.t_ap_yearly')
                ])
                ->required()
                ->helperText(__('messages.t_ap_ad_renewal_period_helper')),

            ])
            ->columns(2);
    }
}
