<div class=" ">
    <style>
        .fi-main {
            max-width: none;
        }
        table {
            border-collapse: separate;
            border-radius: 14px;
            border-spacing: 0px;
        }

        thead {
            display: table-header-group;
            vertical-align: middle;
            border-color: inherit;
            border-collapse: separate;
            color: white;
        }

        tr {
            display: table-row;
            vertical-align: inherit;
            border-color: inherit;
        }

        th:last-child {
            border-start-end-radius: 14px;

        }

        tr:last-child td:last-child {
            border-end-end-radius: 14px;

        }

        th,
        td {
            padding: 5px 4px 6px 4px;
            text-align: left;
            vertical-align: top;
        }

        td {
            border-top: 1px solid black;
        }
    </style>
    {{-- <div class="flex gap-4 flex-wrap"> --}}
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-3 xl:grid-cols-4 auto-fill-250 gap-4 ">
        @forelse ($plans as $index=>$plan)
            <livewire:subscription::plan.plan-item :$plan :$index />
        @empty
            <section class="place-self-center col-span-4">
                <img src="/images/no-plan.svg" alt="" srcset="">
                <p class="p-4">{{ __('messages.t_no_plans_found') }}</p>
            </section>
        @endforelse
    </div>
    @if ($subscriptionSettings->show_comparison_table && $plans && count($plans))

        <div class="mt-4">
            <h1 class=" text-xl text-[#333] font-lexend font-bold dark:text-white">{{ __('messages.t_compare_plans') }}
            </h1>
            <div class=" overflow-x-auto w-full">
                <table class=" font-sans mt-5 w-full border border-r-0 dark:border-white/10 classic:border-black">
                    <thead class="text-white font-semibold">
                        <tr>
                            <th
                                class=" text-left px-3 py-2.5 bg-primary-700 rounded-ss-[14px] border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white whitespace-nowrap">
                            </th>
                            @foreach ($plans as $plan)
                                <th
                                    class=" text-left px-3 py-2.5 bg-primary-700  border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white whitespace-nowrap">
                                    {{ $plan->name }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody class=" text-[#09101D]">
                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_image_limit') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ $plan->images_limit }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_video_posting') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->video_posting)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_ads_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->ads_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_banner_count') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ $plan->banner_count }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_enable_user_profile_description') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->enable_user_profile_description)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_enable_social_media_links') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->enable_social_media_links)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_enable_location') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->enable_location)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_rating') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->rating)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_filter_options_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->filter_options_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_seo_tools_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->seo_tools_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_utm_parameters_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->utm_parameters_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_number_of_visits') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->number_of_visits)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_traffic_source') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->traffic_source)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_average_view_time') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->average_view_time)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_number_of_favorites') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->number_of_favorites)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_contact_conversion_rate_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->contact_conversion_rate_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_clicks_on_link') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->clicks_on_link)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_demographic_analysis_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->demographic_analysis_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_product_engagement_level') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ __('messages.t_' . $plan->product_engagement_level) }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_product_performance_analysis') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->product_performance_analysis)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_boost_analysis') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->boost_analysis)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        {{-- <tr>
                    <td class=" border-r border-[#D1D5D8] classic:border-black dark:text-white p-3 whitespace-nowrap">{{__('messages.t_custom_reports_level')}}
                    </td>
                @foreach ($plans as $plan)
                <td class=" border-r border-[#D1D5D8] classic:border-black dark:text-white p-3 whitespace-nowrap">{{$plan->custom_reports_level}}</td>
                @endforeach
                </tr> --}}

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_automated_alerts') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->automated_alerts)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_chat_limit') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    {{ $plan->chat_limit }}</td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_automated_messages') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->automated_messages)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                        <tr>
                            <td
                                class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                {{ __('messages.t_automated_email_marketing') }}
                            </td>
                            @foreach ($plans as $plan)
                                <td
                                    class=" border-r border-[#D1D5D8] classic:border-black dark:border-white/10 dark:text-white p-3 whitespace-nowrap">
                                    @if ($plan->automated_email_marketing)
                                        <x-heroicon-c-check class="h-5 w-5 text-green-600" />
                                    @else
                                        <x-heroicon-c-x-mark class="h-5 w-5 text-red-600" />
                                    @endif
                                </td>
                            @endforeach
                        </tr>

                    </tbody>
                </table>
            </div>
        </div>
    @endif
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('truncate', () => ({
                truncated: [false, false],
                truncatable: [false, false],
                setTruncate(index, element) {
                    if (element.offsetHeight < element.scrollHeight ||
                        element.offsetWidth < element.scrollWidth) {
                        // your element has an overflow, ie. truncated
                        // show read more button
                        this.truncated[index] = true;
                        this.truncatable[index] = true;
                    } else {
                        // your element doesn't have overflow
                        this.truncated[index] = false;
                        this.truncatable[index] = false;

                    }
                },
                isTruncated(index) {
                    return true;
                }
            }))
        })
    </script>
</div>
