<div>
    <div class="my-2">
        <label for="">{{ __('messages.t_enter_coupon_code') }}</label>
        <div class="flex items-center py-2 gap-2 w-full">
            <x-filament::input.wrapper class="w-full">
                <x-filament::input type="text" wire:model="couponCode" />
            </x-filament::input.wrapper>
            <x-filament::button wire:click="applyCoupon">{{ __('messages.t_apply') }}</x-filament::button>
        </div>

        <div class="flex gap-1">
            @if ($appliedCoupon)
            <p class="flex gap-1 items-center bg-green-400 w-fit h-full rounded-lg p-1">{{ $appliedCoupon->code }}
                <x-heroicon-o-x-mark class="w-4 h-4 cursor-pointer"
                    wire:click='removeCoupon({{ $appliedCoupon->id }})' />
            </p>
            @endif
        </div>
    </div>
    <div
        class="bg-white dark:bg-gray-700 dark:border-gray-600 dark:text-gray-400 p-4 shadow-sm rounded-lg mb-6 border border-gray-200 dark:border-white/10 classic:border-black">
        <!-- Summary Header -->
        <h3 class="text-lg font-semibold border-b border-gray-200  dark:border-white/10 classic:border-black pb-2 mb-4">
            {{ __('messages.t_summary') }} <span class="font-normal text-xs"> ({{ __('messages.t_subscription') }})
            </span>
        </h3>
        <!-- Plan Details -->
        <div x-data="{
            collapsed: false,
        }" class="py-1">
            <div class="flex justify-between ">
                <div>
                    <span class="font-semibold line-clamp-1" title="{{ $plan->description }}">{{ $plan->name }}</span>
                    @if (count($plan?->features))
                    <div class="text-xs cursor-pointer w-fit text-blue-600">
                        <span x-show="!collapsed" x-cloak x-on:click="collapsed=true">{{ __('messages.t_show_features')
                            }}</span>
                        <span x-show="collapsed" x-cloak x-on:click="collapsed=false">{{ __('messages.t_hide_features')
                            }}</span>
                    </div>
                    @endif
                </div>
                <div class="text-end">
                    @if ($plan->invoice_interval == 'month')
                    <span class="font-normal "> {{ __('messages.t_monthly') }}</span>
                    <p class="text-xs text-gray-600">{{ __('messages.t_every_30_days') }}</p>
                    @endif
                </div>
            </div>

            @if (count($plan?->features))
            <ul x-collapse x-show="collapsed"
                class=" list-inside list-disc space-y-1 text-sm font-normal marker:text-lg marker:text-primary-700 dark:marker:text-primary-600">
                <h2 class="font-medium pt-1">{{ __('messages.t_included_in_this_plan') }}</h2>
                @foreach ($plan?->features as $key => $feature)
                <li wire:key='feature-{{ $feature->id }}'>{{ $feature->name }} - {{ $feature->value }}</li>
                @endforeach
            </ul>
            @endif
        </div>

        <!-- Subtotal -->
        <div class="flex justify-between py-1">
            <span class="font-semibold">{{ __('messages.t_subtotal') }}</span>
            <span>{{ formatPriceWithCurrency($subtotal) }}
</span>
        </div>


        @if ($appliedCoupon)
        <div class="flex justify-between py-1 line-through">
            <span class="font-semibold">{{ $appliedCoupon->code }}</span>
            <span>{{ formatPriceWithCurrency($this->calculateDiscount($appliedCoupon, $subtotal)) }}</span>
        </div>
        @endif
        @if ($discountAmount)
        <!-- discountAmount -->
        <div class="flex justify-between py-1">
            <span class="font-semibold">{{ __('messages.t_total_discount') }}</span>
            <span>{{ formatPriceWithCurrency($discountAmount) }}</span>
        </div>
        @endif

        <!-- Tax -->
        {{-- <div class="flex justify-between py-1">
            <span>{{ __('messages.t_tax') }}</span>
            <span>{{ config('app.currency_symbol') }}{{ \Number::format(floatval($tax), locale:
                $paymentSettings->currency_locale) }}</span>
        </div> --}}

        <!-- Divider -->
        <div class="border-t my-3 border-gray-200  dark:border-white/10 classic:border-black"></div>

        <!-- Total -->
        <div class="flex justify-between py-1">
            <span class="font-semibold text-lg">{{ __('messages.t_total') }}</span>
            <span class="font-semibold text-lg"> {{ formatPriceWithCurrency($total) }}</span>
        </div>

        {{-- Exchange Rate --}}
        {{-- @if ($this->defaultCurrency && $this->isDifferentRate)
        <div class="flex justify-between py-1">
            <span class="font-semibold text-lg">{{ __('messages.t_total_including_exchange_rate') }}</span>

            <span class="font-semibold text-lg">{{ $this->getExchangeCurrencySymbol() }}{{
                \Number::format(floatval($this->convertedTotal), locale: $paymentSettings->currency_locale) }}</span>
        </div>
        @endif--}}
    </div>

    <div class="">
        <div class="w-full">
            <h3 class="mb-6">{{ __('messages.t_choose_subscription_label') }}</h3>
            @if(count($this->initializePaymentOptions()) >= 1)
            <form wire:submit.prevent class="">
                <div class="mb-5 payment-methods">
                    {{ $this->form }}
                </div>
            </form>
            @else
            @include('components.empty-payment')
            @endif
        </div>
        <div class="w-full">
            @if ($currentPayment)
            <livewire:dynamic-component :key="$currentPayment" :component="$currentPayment" :data="$this->paymentData"
                :total="$this->defaultCurrency && $this->isDifferentRate ? $this->convertedTotal : $total" :$subtotal
                :$tax />
            @endif
        </div>
    </div>
</div>
