<div>
    {{-- {!! SEO::generate() !!} --}}
    <div>
        @if ($promotionType=='apply')
        @forelse ($availablePlanPromotions as $item)
        <div role="button" aria-label="{{ $item->name }}" wire:click="$parent.toggleSelection({{ $item->id }})" wire:key="plan-promotion-{{ $item->id }}"
            class="bg-white flex gap-x-2 ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 px-3 py-4 rounded-xl mb-6 cursor-pointer classic:ring-black">
            <div>
                @if(in_array($item->id,$selectedPromotions))
                <x-heroicon-s-check-circle class="w-8 h-8 text-success-600" />
                @else
                <div class="w-8 h-8 flex items-center justify-center">
                    <span class="w-6 h-6 text-gray-900 rounded-full border border-black block"></span>
                </div>
                @endif
            </div>
            <div>
                <p class="font-semibold text-lg">{{ $item->name }}</p>
                <p>{{ __('messages.t_available') }}: {{ $this->getRemainAdPromotionCount($item->id) }}</p>
            </div>
        </div>
        @empty
        <x-subscription-prompt />
        <div>
            {{__('messages.t_empty_plan_promotion_message')}}

        </div>
        @endforelse

        @else
        <p class="mb-6">{{ __('messages.t_boost_ad_visibility') }}</p>
        <div>
            @foreach($promotions as $promotion)
            <div role="button" aria-label="{{ $promotion->name }}" wire:click="$parent.toggleSelection({{ $promotion->id }})" wire:key="promotion-{{ $promotion->id }}"
                class="bg-white flex justify-between items-center ring-1 ring-gray-950/5 dark:bg-gray-900 dark:ring-white/10 px-3 py-2 rounded-xl mb-6 cursor-pointer classic:ring-black {{$homeSettings->enable_hover_animation?'classic-hover-shadow':''}}"
                {{-- x-data="{
                selectedPromotions: @entangle('selectedPromotions'),
                isActive: function() {
                    return Object.values(this.selectedPromotions).includes('{{ $promotion->id }}');
                }
            }" --}} {{-- :class="{ 'bg-white classic:shadow-custom': isActive() }" --}}>
                {{-- @php
                $promotionStatus = $this->isActivePromotion($promotion->id);
                @endphp --}}
                <div>
                    <div class="flex items-center gap-x-3">
                        <img src="{{ asset('images/' . $promotion->image) }}" alt="{{ $promotion->name }}"
                            class="mx-auto w-10 h-10">
                        <div>
                            <p class="font-semibold">
                                {{ $promotion->name }} - {{ $promotion->duration }} days -
                                {{config('app.currency_symbol').' '. \Number::format(floatval($promotion->price),
                                locale: $paymentSettings->currency_locale) }}
                            </p>
                            <p class="text-sm ">{{ $promotion->description }}</p>
                        </div>
                    </div>
                </div>
                <div>
                    {{-- @if($promotionStatus['isActive'])
                    <div class="text-green-800 font-semibold">
                        <span>{{__('messages.t_active_status')}}: {{
                            \Carbon\Carbon::parse($promotionStatus['start_date'])->translatedFormat('M d') }} - {{
                            \Carbon\Carbon::parse($promotionStatus['end_date'])->translatedFormat('M d') }}</span>
                    </div>
                    @else --}}
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input wire:click="$parent.toggleSelection({{ $promotion->id }})" type="checkbox" name="promotion"
                            value="{{ $promotion->id }}" class="sr-only peer"
                            @checked(in_array($promotion->id,$selectedPromotions))>
                        <div aria-hidden="true"
                            class="w-11 h-6 bg-gray-200 border  peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-gray-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-black">
                        </div>
                        <span class="ml-3 text-sm md:text-base  text-gray-900 dark:text-gray-300"></span>
                    </label>
                    {{-- @endif --}}
                </div>
            </div>
            @endforeach
        </div>
    </div>
    @endif
    @if(in_array(4, $selectedPromotions))
    <form wire:submit>
        <div class="mb-5">
            {{ $this->form }}
        </div>
    </form>
    @endif

</div>
</div>
