<?php

namespace Adfox\WalletSystem\Filament\Resources;

use Adfox\WalletSystem\Filament\Resources\PendingRefundResource\Pages;
use App\Models\Reservation\RefundTransaction;
use App\Traits\HandleOrderRefundTrait;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use BezhanSalleh\FilamentShield\Contracts\HasShieldPermissions;
use App\Filament\Clusters\WalletSystem;

class PendingRefundResource extends Resource implements HasShieldPermissions
{
    use HandleOrderRefundTrait;
    protected static ?string $model = RefundTransaction::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    protected static ?string $cluster = WalletSystem::class;

    public static function getNavigationLabel(): string
    {
        return __('messages.t_ap_pending_refund_request_label');
    }

    public static function getModelLabel(): string
    {
        return __('messages.t_ap_pending_refund_request_label');
    }

    public static function getPermissionPrefixes(): array
    {
        return [
            'view_any',
            'delete_any'
        ];
    }

    public static function canViewAny(): bool
    {
        return userHasPermission('view_any_pending::refund');
    }

    public static function canDeleteAny(): bool
    {
        return userHasPermission('delete_any_pending::refund');
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema(HandleOrderRefundTrait::orderNotReceivedForm());
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListPendingRefunds::route('/'),
            // 'create' => Pages\CreatePendingRefund::route('/create'),
            // 'edit' => Pages\EditPendingRefund::route('/{record}/edit'),
        ];
    }
}
