/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.security.BasicPermission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Configuration;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.Recording;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PlatformRecorder;
import jdk.jfr.internal.PlatformRecording;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;

public final class FlightRecorderPermission
extends BasicPermission {
    public FlightRecorderPermission(String name) {
        super(Objects.requireNonNull(name));
        if (!name.equals("accessFlightRecorder") && !name.equals("registerEvent")) {
            throw new IllegalArgumentException("name: " + name);
        }
    }

    static {
        PrivateAccess.setPrivateAccess(new InternalAccess());
    }

    private static final class InternalAccess
    extends PrivateAccess {
        private InternalAccess() {
        }

        @Override
        public Type getType(Object o) {
            if (o instanceof AnnotationElement) {
                return ((AnnotationElement)o).getType();
            }
            if (o instanceof EventType) {
                return ((EventType)o).getType();
            }
            if (o instanceof ValueDescriptor) {
                return ((ValueDescriptor)o).getType();
            }
            if (o instanceof SettingDescriptor) {
                return ((SettingDescriptor)o).getType();
            }
            throw new Error("Unknown type " + o.getClass());
        }

        @Override
        public Configuration newConfiguration(String name, String label, String description, String provider, Map<String, String> settings, String contents) {
            return new Configuration(name, label, description, provider, settings, contents);
        }

        @Override
        public EventType newEventType(PlatformEventType platformEventType) {
            return new EventType(platformEventType);
        }

        @Override
        public AnnotationElement newAnnotation(Type annotationType, List<Object> values, boolean boot) {
            return new AnnotationElement(annotationType, values, boot);
        }

        @Override
        public ValueDescriptor newValueDescriptor(String name, Type fieldType, List<AnnotationElement> annos, int dimension, boolean constantPool, String fieldName) {
            return new ValueDescriptor(fieldType, name, annos, dimension, constantPool, fieldName);
        }

        @Override
        public PlatformRecording getPlatformRecording(Recording r) {
            return r.getInternal();
        }

        @Override
        public PlatformEventType getPlatformEventType(EventType eventType) {
            return eventType.getPlatformEventType();
        }

        @Override
        public boolean isConstantPool(ValueDescriptor v) {
            return v.isConstantPool();
        }

        @Override
        public void setAnnotations(ValueDescriptor v, List<AnnotationElement> a) {
            v.setAnnotations(a);
        }

        @Override
        public void setAnnotations(SettingDescriptor s, List<AnnotationElement> a) {
            s.setAnnotations(a);
        }

        @Override
        public String getFieldName(ValueDescriptor v) {
            return v.getJavaFieldName();
        }

        @Override
        public ValueDescriptor newValueDescriptor(Class<?> type, String name) {
            return new ValueDescriptor(type, name, Collections.emptyList(), true);
        }

        @Override
        public SettingDescriptor newSettingDescriptor(Type type, String name, String defaultValue, List<AnnotationElement> annotations) {
            return new SettingDescriptor(type, name, defaultValue, annotations);
        }

        @Override
        public boolean isUnsigned(ValueDescriptor v) {
            return v.isUnsigned();
        }

        @Override
        public PlatformRecorder getPlatformRecorder() {
            return FlightRecorder.getFlightRecorder().getInternal();
        }
    }
}

