/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Objects;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;

final class RepositoryChunk {
    private static final int MAX_CHUNK_NAMES = 100;
    static final Comparator<RepositoryChunk> END_TIME_COMPARATOR = new Comparator<RepositoryChunk>(){

        @Override
        public int compare(RepositoryChunk c1, RepositoryChunk c2) {
            return c1.endTime.compareTo(c2.endTime);
        }
    };
    private final SecuritySupport.SafePath repositoryPath;
    private final SecuritySupport.SafePath unFinishedFile;
    private final SecuritySupport.SafePath file;
    private final Instant startTime;
    private final RandomAccessFile unFinishedRAF;
    private Instant endTime = null;
    private int refCount = 0;
    private long size;

    RepositoryChunk(SecuritySupport.SafePath path, Instant startTime) throws Exception {
        ZonedDateTime z = ZonedDateTime.now();
        String fileName = Repository.REPO_DATE_FORMAT.format(LocalDateTime.ofInstant(startTime, z.getZone()));
        this.startTime = startTime;
        this.repositoryPath = path;
        this.unFinishedFile = RepositoryChunk.findFileName(this.repositoryPath, fileName, ".part");
        this.file = RepositoryChunk.findFileName(this.repositoryPath, fileName, ".jfr");
        this.unFinishedRAF = SecuritySupport.createRandomAccessFile(this.unFinishedFile);
        SecuritySupport.touch(this.file);
    }

    private static SecuritySupport.SafePath findFileName(SecuritySupport.SafePath directory, String name, String extension) throws Exception {
        Path p = directory.toPath().resolve(name + extension);
        for (int i = 1; i < 100; ++i) {
            SecuritySupport.SafePath s = new SecuritySupport.SafePath(p);
            if (!SecuritySupport.exists(s)) {
                return s;
            }
            String extendedName = String.format("%s_%02d%s", name, i, extension);
            p = directory.toPath().resolve(extendedName);
        }
        p = directory.toPath().resolve(name + "_" + System.currentTimeMillis() + extension);
        return SecuritySupport.toRealPath(new SecuritySupport.SafePath(p));
    }

    public SecuritySupport.SafePath getUnfishedFile() {
        return this.unFinishedFile;
    }

    void finish(Instant endTime) {
        try {
            this.finishWithException(endTime);
        }
        catch (IOException e) {
            Logger.log(LogTag.JFR, LogLevel.ERROR, "Could not finish chunk. " + e.getMessage());
        }
    }

    private void finishWithException(Instant endTime) throws IOException {
        this.unFinishedRAF.close();
        this.size = RepositoryChunk.finish(this.unFinishedFile, this.file);
        this.endTime = endTime;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Chunk finished: " + this.file);
    }

    private static long finish(SecuritySupport.SafePath unFinishedFile, SecuritySupport.SafePath file) throws IOException {
        Objects.requireNonNull(unFinishedFile);
        Objects.requireNonNull(file);
        SecuritySupport.delete(file);
        SecuritySupport.moveReplace(unFinishedFile, file);
        return SecuritySupport.getFileSize(file);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    private void delete(SecuritySupport.SafePath f) {
        block2: {
            try {
                SecuritySupport.delete(f);
                Logger.log(LogTag.JFR, LogLevel.DEBUG, () -> "Repository chunk " + f + " deleted");
            }
            catch (IOException e) {
                Logger.log(LogTag.JFR, LogLevel.ERROR, () -> "Repository chunk " + f + " could not be deleted: " + e.getMessage());
                if (f == null) break block2;
                SecuritySupport.deleteOnExit(f);
            }
        }
    }

    private void destroy() {
        if (!this.isFinished()) {
            this.finish(Instant.MIN);
        }
        if (this.file != null) {
            this.delete(this.file);
        }
        try {
            this.unFinishedRAF.close();
        }
        catch (IOException e) {
            Logger.log(LogTag.JFR, LogLevel.ERROR, () -> "Could not close random access file: " + this.unFinishedFile.toString() + ". File will not be deleted due to: " + e.getMessage());
        }
    }

    public synchronized void use() {
        ++this.refCount;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Use chunk " + this.toString() + " ref count now " + this.refCount);
    }

    public synchronized void release() {
        --this.refCount;
        Logger.log(LogTag.JFR_SYSTEM, LogLevel.DEBUG, () -> "Release chunk " + this.toString() + " ref count now " + this.refCount);
        if (this.refCount == 0) {
            this.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        boolean destroy = false;
        RepositoryChunk repositoryChunk = this;
        synchronized (repositoryChunk) {
            if (this.refCount > 0) {
                destroy = true;
            }
        }
        if (destroy) {
            this.destroy();
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFinished() {
        return this.endTime != null;
    }

    public String toString() {
        if (this.isFinished()) {
            return this.file.toString();
        }
        return this.unFinishedFile.toString();
    }

    ReadableByteChannel newChannel() throws IOException {
        if (!this.isFinished()) {
            throw new IOException("Chunk not finished");
        }
        return SecuritySupport.newFileChannelToRead(this.file);
    }

    public boolean inInterval(Instant startTime, Instant endTime) {
        if (startTime != null && this.getEndTime().isBefore(startTime)) {
            return false;
        }
        return endTime == null || !this.getStartTime().isAfter(endTime);
    }

    public SecuritySupport.SafePath getFile() {
        return this.file;
    }
}

