/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import jdk.jfr.Configuration;
import jdk.management.jfr.Stringifier;

public final class ConfigurationInfo {
    private final Map<String, String> settings;
    private final String name;
    private final String label;
    private final String description;
    private final String provider;
    private final String contents;

    ConfigurationInfo(Configuration config) {
        this.settings = config.getSettings();
        this.name = config.getName();
        this.label = config.getLabel();
        this.description = config.getDescription();
        this.provider = config.getProvider();
        this.contents = config.getContents();
    }

    private ConfigurationInfo(CompositeData cd) {
        this.settings = ConfigurationInfo.createMap(cd.get("settings"));
        this.name = (String)cd.get("name");
        this.label = (String)cd.get("label");
        this.description = (String)cd.get("description");
        this.provider = (String)cd.get("provider");
        this.contents = (String)cd.get("contents");
    }

    private static Map<String, String> createMap(Object o) {
        if (o instanceof TabularData) {
            TabularData td = (TabularData)o;
            Collection<?> values = td.values();
            HashMap<String, String> map = new HashMap<String, String>(values.size());
            for (Object value : td.values()) {
                if (!(value instanceof CompositeData)) continue;
                CompositeData cdRow = (CompositeData)value;
                Object k = cdRow.get("key");
                Object v = cdRow.get("value");
                if (!(k instanceof String) || !(v instanceof String)) continue;
                map.put((String)k, (String)v);
            }
            return Collections.unmodifiableMap(map);
        }
        return Collections.emptyMap();
    }

    public String getProvider() {
        return this.provider;
    }

    public String getContents() {
        return this.contents;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConfigurationInfo from(CompositeData cd) {
        if (cd == null) {
            return null;
        }
        return new ConfigurationInfo(cd);
    }

    public String toString() {
        Stringifier s = new Stringifier();
        s.add("name", this.name);
        s.add("label", this.label);
        s.add("description", this.description);
        s.add("provider", this.provider);
        return s.toString();
    }
}

