/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifBorders;
import com.sun.java.swing.plaf.motif.MotifInternalFrameTitlePane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import sun.awt.AWTAccessor;
import sun.swing.SwingUtilities2;

public class MotifDesktopIconUI
extends BasicDesktopIconUI {
    protected DesktopIconActionListener desktopIconActionListener;
    protected DesktopIconMouseListener desktopIconMouseListener;
    protected Icon defaultIcon;
    protected IconButton iconButton;
    protected IconLabel iconLabel;
    private MotifInternalFrameTitlePane sysMenuTitlePane;
    JPopupMenu systemMenu;
    EventListener mml;
    static final int LABEL_HEIGHT = 18;
    static final int LABEL_DIVIDER = 4;
    static final Font defaultTitleFont = new Font("SansSerif", 0, 12);

    public static ComponentUI createUI(JComponent c) {
        return new MotifDesktopIconUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.setDefaultIcon(UIManager.getIcon("DesktopIcon.icon"));
        this.iconButton = this.createIconButton(this.defaultIcon);
        this.sysMenuTitlePane = new MotifInternalFrameTitlePane(this.frame);
        this.systemMenu = this.sysMenuTitlePane.getSystemMenu();
        MotifBorders.FrameBorder border = new MotifBorders.FrameBorder(this.desktopIcon);
        this.desktopIcon.setLayout(new BorderLayout());
        this.iconButton.setBorder(border);
        this.desktopIcon.add((Component)this.iconButton, "Center");
        this.iconLabel = this.createIconLabel(this.frame);
        this.iconLabel.setBorder(border);
        this.desktopIcon.add((Component)this.iconLabel, "South");
        this.desktopIcon.setSize(this.desktopIcon.getPreferredSize());
        this.desktopIcon.validate();
        JLayeredPane.putLayer(this.desktopIcon, JLayeredPane.getLayer(this.frame));
    }

    @Override
    protected void installComponents() {
    }

    @Override
    protected void uninstallComponents() {
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktopIconActionListener = this.createDesktopIconActionListener();
        this.desktopIconMouseListener = this.createDesktopIconMouseListener();
        this.iconButton.addActionListener(this.desktopIconActionListener);
        this.iconButton.addMouseListener(this.desktopIconMouseListener);
        this.iconLabel.addMouseListener(this.desktopIconMouseListener);
    }

    JInternalFrame.JDesktopIcon getDesktopIcon() {
        return this.desktopIcon;
    }

    void setDesktopIcon(JInternalFrame.JDesktopIcon d) {
        this.desktopIcon = d;
    }

    JInternalFrame getFrame() {
        return this.frame;
    }

    void setFrame(JInternalFrame f) {
        this.frame = f;
    }

    protected void showSystemMenu() {
        this.systemMenu.show(this.iconButton, 0, this.getDesktopIcon().getHeight());
    }

    protected void hideSystemMenu() {
        this.systemMenu.setVisible(false);
    }

    protected IconLabel createIconLabel(JInternalFrame frame) {
        return new IconLabel(frame);
    }

    protected IconButton createIconButton(Icon i) {
        return new IconButton(i);
    }

    protected DesktopIconActionListener createDesktopIconActionListener() {
        return new DesktopIconActionListener();
    }

    protected DesktopIconMouseListener createDesktopIconMouseListener() {
        return new DesktopIconMouseListener();
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.iconButton);
        this.desktopIcon.remove(this.iconLabel);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.iconButton.removeActionListener(this.desktopIconActionListener);
        this.iconButton.removeMouseListener(this.desktopIconMouseListener);
        this.sysMenuTitlePane.uninstallListeners();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        JInternalFrame iframe = this.desktopIcon.getInternalFrame();
        int w = this.defaultIcon.getIconWidth();
        int h = this.defaultIcon.getIconHeight() + 18 + 4;
        Border border = iframe.getBorder();
        if (border != null) {
            w += border.getBorderInsets((Component)iframe).left + border.getBorderInsets((Component)iframe).right;
            h += border.getBorderInsets((Component)iframe).bottom + border.getBorderInsets((Component)iframe).top;
        }
        return new Dimension(w, h);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Icon getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(Icon newIcon) {
        this.defaultIcon = newIcon;
    }

    protected class DesktopIconMouseListener
    extends MouseAdapter {
        protected DesktopIconMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() > 1) {
                try {
                    MotifDesktopIconUI.this.getFrame().setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                MotifDesktopIconUI.this.systemMenu.setVisible(false);
                MotifDesktopIconUI.this.getFrame().getDesktopPane().getDesktopManager().endDraggingFrame((JComponent)e.getSource());
            }
        }
    }

    protected class DesktopIconActionListener
    implements ActionListener {
        protected DesktopIconActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MotifDesktopIconUI.this.systemMenu.show(MotifDesktopIconUI.this.iconButton, 0, MotifDesktopIconUI.this.getDesktopIcon().getHeight());
        }
    }

    protected class IconButton
    extends JButton {
        Icon icon;

        IconButton(Icon icon) {
            super(icon);
            this.icon = icon;
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (!MotifDesktopIconUI.this.systemMenu.isShowing()) {
                        IconButton.this.forwardEventToParent(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    IconButton.this.forwardEventToParent(e);
                }
            });
        }

        void forwardEventToParent(MouseEvent e) {
            MouseEvent newEvent = new MouseEvent(this.getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
            AWTAccessor.MouseEventAccessor meAccessor = AWTAccessor.getMouseEventAccessor();
            meAccessor.setCausedByTouchEvent(newEvent, meAccessor.isCausedByTouchEvent(e));
            this.getParent().dispatchEvent(newEvent);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }

    protected class IconLabel
    extends JPanel {
        JInternalFrame frame;

        IconLabel(JInternalFrame f) {
            this.frame = f;
            this.setFont(defaultTitleFont);
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    IconLabel.this.forwardEventToParent(e);
                }
            });
        }

        void forwardEventToParent(MouseEvent e) {
            MouseEvent newEvent = new MouseEvent(this.getParent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), 0);
            AWTAccessor.MouseEventAccessor meAccessor = AWTAccessor.getMouseEventAccessor();
            meAccessor.setCausedByTouchEvent(newEvent, meAccessor.isCausedByTouchEvent(e));
            this.getParent().dispatchEvent(newEvent);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(MotifDesktopIconUI.this.defaultIcon.getIconWidth() + 1, 22);
        }

        @Override
        public Dimension getPreferredSize() {
            String title = this.frame.getTitle();
            FontMetrics fm = this.frame.getFontMetrics(defaultTitleFont);
            int w = 4;
            if (title != null) {
                w += SwingUtilities2.stringWidth(this.frame, fm, title);
            }
            return new Dimension(w, 22);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int maxX = this.getWidth() - 1;
            Color shadow = UIManager.getColor("inactiveCaptionBorder").darker().darker();
            g.setColor(shadow);
            g.setClip(0, 0, this.getWidth(), this.getHeight());
            g.drawLine(maxX - 1, 1, maxX - 1, 1);
            g.drawLine(maxX, 0, maxX, 0);
            g.setColor(UIManager.getColor("inactiveCaption"));
            g.fillRect(2, 1, maxX - 3, 19);
            g.setClip(2, 1, maxX - 4, 18);
            int y = 18 - SwingUtilities2.getFontMetrics((JComponent)this.frame, g).getDescent();
            g.setColor(UIManager.getColor("inactiveCaptionText"));
            String title = this.frame.getTitle();
            if (title != null) {
                SwingUtilities2.drawString((JComponent)this.frame, g, title, 4, y);
            }
        }
    }
}

