/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.internal;

import com.sun.jmx.remote.internal.NotificationBuffer;
import com.sun.jmx.remote.internal.NotificationBufferFilter;
import com.sun.jmx.remote.security.NotificationAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanPermission;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.NotificationResult;
import javax.management.remote.TargetedNotification;
import javax.security.auth.Subject;

public class ServerNotifForwarder {
    private final NotifForwarderBufferFilter bufferFilter = new NotifForwarderBufferFilter();
    private MBeanServer mbeanServer;
    private final String connectionId;
    private final long connectionTimeout;
    private static int listenerCounter = 0;
    private static final int[] listenerCounterLock = new int[0];
    private NotificationBuffer notifBuffer;
    private final Map<ObjectName, Set<IdAndFilter>> listenerMap = new HashMap<ObjectName, Set<IdAndFilter>>();
    private boolean terminated = false;
    private final int[] terminationLock = new int[0];
    static final String broadcasterClass = NotificationBroadcaster.class.getName();
    private final boolean checkNotificationEmission;
    private final NotificationAccessController notificationAccessController;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.misc", "ServerNotifForwarder");

    public ServerNotifForwarder(MBeanServer mbeanServer, Map<String, ?> env, NotificationBuffer notifBuffer, String connectionId) {
        this.mbeanServer = mbeanServer;
        this.notifBuffer = notifBuffer;
        this.connectionId = connectionId;
        this.connectionTimeout = EnvHelp.getServerConnectionTimeout(env);
        String stringBoolean = (String)env.get("jmx.remote.x.check.notification.emission");
        this.checkNotificationEmission = EnvHelp.computeBooleanFromString(stringBoolean);
        this.notificationAccessController = EnvHelp.getNotificationAccessController(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addNotificationListener(final ObjectName name, NotificationFilter filter) throws InstanceNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("addNotificationListener", "Add a listener at " + name);
        }
        this.checkState();
        this.checkMBeanPermission(name, "addNotificationListener");
        if (this.notificationAccessController != null) {
            this.notificationAccessController.addNotificationListener(this.connectionId, name, this.getSubject());
        }
        try {
            boolean instanceOf = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws InstanceNotFoundException {
                    return ServerNotifForwarder.this.mbeanServer.isInstanceOf(name, broadcasterClass);
                }
            });
            if (!instanceOf) {
                throw new IllegalArgumentException("The specified MBean [" + name + "] is not a NotificationBroadcaster object.");
            }
        }
        catch (PrivilegedActionException e) {
            throw (InstanceNotFoundException)ServerNotifForwarder.extractException(e);
        }
        Integer id = this.getListenerID();
        ObjectName nn = name;
        if (name.getDomain() == null || name.getDomain().equals("")) {
            try {
                nn = ObjectName.getInstance(this.mbeanServer.getDefaultDomain(), name.getKeyPropertyList());
            }
            catch (MalformedObjectNameException mfoe) {
                IOException ioe = new IOException(mfoe.getMessage());
                ioe.initCause(mfoe);
                throw ioe;
            }
        }
        Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
        synchronized (map) {
            IdAndFilter idaf = new IdAndFilter(id, filter);
            Set<IdAndFilter> set = this.listenerMap.get(nn);
            if (set == null) {
                set = Collections.singleton(idaf);
            } else {
                if (set.size() == 1) {
                    set = new HashSet<IdAndFilter>(set);
                }
                set.add(idaf);
            }
            this.listenerMap.put(nn, set);
        }
        return id;
    }

    public void removeNotificationListener(ObjectName name, Integer[] listenerIDs) throws Exception {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove some listeners from " + name);
        }
        this.checkState();
        this.checkMBeanPermission(name, "removeNotificationListener");
        if (this.notificationAccessController != null) {
            this.notificationAccessController.removeNotificationListener(this.connectionId, name, this.getSubject());
        }
        Exception re = null;
        for (int i = 0; i < listenerIDs.length; ++i) {
            try {
                this.removeNotificationListener(name, listenerIDs[i]);
                continue;
            }
            catch (Exception e) {
                if (re == null) continue;
                re = e;
            }
        }
        if (re != null) {
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(ObjectName name, Integer listenerID) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
        if (logger.traceOn()) {
            logger.trace("removeNotificationListener", "Remove the listener " + listenerID + " from " + name);
        }
        this.checkState();
        if (name != null && !name.isPattern() && !this.mbeanServer.isRegistered(name)) {
            throw new InstanceNotFoundException("The MBean " + name + " is not registered.");
        }
        Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
        synchronized (map) {
            Set<IdAndFilter> set = this.listenerMap.get(name);
            IdAndFilter idaf = new IdAndFilter(listenerID, null);
            if (set == null || !set.contains(idaf)) {
                throw new ListenerNotFoundException("Listener not found");
            }
            if (set.size() == 1) {
                this.listenerMap.remove(name);
            } else {
                set.remove(idaf);
            }
        }
    }

    public NotificationResult fetchNotifs(long startSequenceNumber, long timeout, int maxNotifications) {
        NotificationResult nr;
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Fetching notifications, the startSequenceNumber is " + startSequenceNumber + ", the timeout is " + timeout + ", the maxNotifications is " + maxNotifications);
        }
        long t = Math.min(this.connectionTimeout, timeout);
        try {
            nr = this.notifBuffer.fetchNotifications(this.bufferFilter, startSequenceNumber, t, maxNotifications);
            this.snoopOnUnregister(nr);
        }
        catch (InterruptedException ire) {
            nr = new NotificationResult(0L, 0L, new TargetedNotification[0]);
        }
        if (logger.traceOn()) {
            logger.trace("fetchNotifs", "Forwarding the notifs: " + nr);
        }
        return nr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snoopOnUnregister(NotificationResult nr) {
        ArrayList<IdAndFilter> copy = null;
        TargetedNotification[] targetedNotificationArray = this.listenerMap;
        synchronized (this.listenerMap) {
            Set<IdAndFilter> delegateSet = this.listenerMap.get(MBeanServerDelegate.DELEGATE_NAME);
            if (delegateSet == null || delegateSet.isEmpty()) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            copy = new ArrayList<IdAndFilter>(delegateSet);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (TargetedNotification tn : nr.getTargetedNotifications()) {
                Integer id = tn.getListenerID();
                for (IdAndFilter idaf : copy) {
                    Notification n;
                    if (idaf.id != id || !((n = tn.getNotification()) instanceof MBeanServerNotification) || !n.getType().equals("JMX.mbean.unregistered")) continue;
                    MBeanServerNotification mbsn = (MBeanServerNotification)n;
                    ObjectName gone = mbsn.getMBeanName();
                    Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
                    synchronized (map) {
                        this.listenerMap.remove(gone);
                    }
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (logger.traceOn()) {
            logger.trace("terminate", "Be called.");
        }
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            Map<ObjectName, Set<IdAndFilter>> map = this.listenerMap;
            synchronized (map) {
                this.listenerMap.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (logger.traceOn()) {
                logger.trace("terminate", "Terminated.");
            }
            return;
        }
    }

    private Subject getSubject() {
        return Subject.getSubject(AccessController.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.terminationLock;
        synchronized (this.terminationLock) {
            if (this.terminated) {
                throw new IOException("The connection has been terminated.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getListenerID() {
        int[] nArray = listenerCounterLock;
        synchronized (listenerCounterLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return listenerCounter++;
        }
    }

    public final void checkMBeanPermission(ObjectName name, String actions) throws InstanceNotFoundException, SecurityException {
        ServerNotifForwarder.checkMBeanPermission(this.mbeanServer, name, actions);
    }

    static void checkMBeanPermission(final MBeanServer mbs, final ObjectName name, String actions) throws InstanceNotFoundException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            ObjectInstance oi;
            AccessControlContext acc = AccessController.getContext();
            try {
                oi = AccessController.doPrivileged(new PrivilegedExceptionAction<ObjectInstance>(){

                    @Override
                    public ObjectInstance run() throws InstanceNotFoundException {
                        return mbs.getObjectInstance(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (InstanceNotFoundException)ServerNotifForwarder.extractException(e);
            }
            String classname = oi.getClassName();
            MBeanPermission perm = new MBeanPermission(classname, null, name, actions);
            sm.checkPermission(perm, acc);
        }
    }

    private boolean allowNotificationEmission(ObjectName name, TargetedNotification tn) {
        try {
            if (this.checkNotificationEmission) {
                this.checkMBeanPermission(name, "addNotificationListener");
            }
            if (this.notificationAccessController != null) {
                this.notificationAccessController.fetchNotification(this.connectionId, name, tn.getNotification(), this.getSubject());
            }
            return true;
        }
        catch (SecurityException e) {
            if (logger.debugOn()) {
                logger.debug("fetchNotifs", "Notification " + tn.getNotification() + " not forwarded: the caller didn't have the required access rights");
            }
            return false;
        }
        catch (Exception e) {
            if (logger.debugOn()) {
                logger.debug("fetchNotifs", "Notification " + tn.getNotification() + " not forwarded: got an unexpected exception: " + e);
            }
            return false;
        }
    }

    private static Exception extractException(Exception e) {
        while (e instanceof PrivilegedActionException) {
            e = ((PrivilegedActionException)e).getException();
        }
        return e;
    }

    private static class IdAndFilter {
        private Integer id;
        private NotificationFilter filter;

        IdAndFilter(Integer id, NotificationFilter filter) {
            this.id = id;
            this.filter = filter;
        }

        Integer getId() {
            return this.id;
        }

        NotificationFilter getFilter() {
            return this.filter;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof IdAndFilter && ((IdAndFilter)o).getId().equals(this.getId());
        }
    }

    final class NotifForwarderBufferFilter
    implements NotificationBufferFilter {
        NotifForwarderBufferFilter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void apply(List<TargetedNotification> targetedNotifs, ObjectName source, Notification notif) {
            IdAndFilter[] candidates;
            IdAndFilter[] idAndFilterArray = ServerNotifForwarder.this.listenerMap;
            synchronized (idAndFilterArray) {
                Set set = (Set)ServerNotifForwarder.this.listenerMap.get(source);
                if (set == null) {
                    logger.debug("bufferFilter", "no listeners for this name");
                    return;
                }
                candidates = new IdAndFilter[set.size()];
                set.toArray(candidates);
            }
            for (IdAndFilter idaf : candidates) {
                NotificationFilter nf = idaf.getFilter();
                if (nf != null && !nf.isNotificationEnabled(notif)) continue;
                logger.debug("bufferFilter", "filter matches");
                TargetedNotification tn = new TargetedNotification(notif, idaf.getId());
                if (!ServerNotifForwarder.this.allowNotificationEmission(source, tn)) continue;
                targetedNotifs.add(tn);
            }
        }
    }
}

