/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class SaslOutputStream
extends FilterOutputStream {
    private static final boolean debug = false;
    private byte[] lenBuf = new byte[4];
    private int rawSendSize = 65536;
    private SaslClient sc;

    SaslOutputStream(SaslClient sc, OutputStream out) throws SaslException {
        super(out);
        this.sc = sc;
        String str = (String)sc.getNegotiatedProperty("javax.security.sasl.rawsendsize");
        if (str != null) {
            try {
                this.rawSendSize = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                throw new SaslException("javax.security.sasl.rawsendsize property must be numeric string: " + str);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.write(buffer, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int offset, int total) throws IOException {
        for (int i = 0; i < total; i += this.rawSendSize) {
            int count = total - i < this.rawSendSize ? total - i : this.rawSendSize;
            byte[] wrappedToken = this.sc.wrap(buffer, offset + i, count);
            SaslOutputStream.intToNetworkByteOrder(wrappedToken.length, this.lenBuf, 0, 4);
            this.out.write(this.lenBuf, 0, 4);
            this.out.write(wrappedToken, 0, wrappedToken.length);
        }
    }

    @Override
    public void close() throws IOException {
        SaslException save = null;
        try {
            this.sc.dispose();
        }
        catch (SaslException e) {
            save = e;
        }
        super.close();
        if (save != null) {
            throw save;
        }
    }

    private static void intToNetworkByteOrder(int num, byte[] buf, int start, int count) {
        if (count > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = count - 1; i >= 0; --i) {
            buf[start + i] = (byte)(num & 0xFF);
            num >>>= 8;
        }
    }
}

